# coding: utf-8

"""
    Clash Royale API

    Unofficial Swagger docs for the official Clash Royale API  # noqa: E501

    OpenAPI spec version: 1.0

    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import unittest
from unittest.mock import patch

import pyroyale
from pyroyale.api.clans_api import ClansApi  # noqa: E501
from pyroyale.rest import ApiException
from pyroyale.exceptions import ApiTypeError, ApiValueError

class TestClansApi(unittest.TestCase):

    def setUp(self):
        self.api = ClansApi()  # noqa: E501

    @patch('urllib3.PoolManager.request')
    def test_get_clan(self, mock_get):
        mock_get.return_value.status=200
        mock_get.return_value.data = """
            {
              "tag": "#JY8YVV",
              "name": "Agrassar",
              "type": "open",
              "description": "fake description",
              "badgeId": 16000010,
              "clanScore": 49658,
              "clanWarTrophies": 2620,
              "location": {
                "id": 57000248,
                "name": "United Kingdom",
                "isCountry": true,
                "countryCode": "GB"
              },
              "requiredTrophies": 4000,
              "donationsPerWeek": 12415,
              "clanChestStatus": "inactive",
              "clanChestPoints": 1471,
              "clanChestLevel": 9,
              "clanChestMaxLevel": 10,
              "members": 1,
              "memberList": [
                {
                  "tag": "#9ULGLRCL",
                  "name": "AaronTraas",
                  "role": "leader",
                  "lastSeen": "20190719T175902.000Z",
                  "expLevel": 13,
                  "trophies": 5600,
                  "arena": {
                    "id": 54000015,
                    "name": "Master III"
                  },
                  "clanRank": 1,
                  "previousClanRank": 2,
                  "donations": 786,
                  "donationsReceived": 480,
                  "clanChestPoints": 72
                }
              ]
            }
        """.encode('utf-8')

        clan = self.api.get_clan('#JY8YVV')
        assert type(clan.member_list) == list
        assert clan.tag=='#JY8YVV'
        assert clan.name=='Agrassar'
        assert clan.type=='open'
        assert clan.description=='fake description'
        assert clan.badge_id==16000010
        assert clan.clan_score==49658
        assert clan.clan_war_trophies==2620
        assert clan.location.id==57000248
        assert clan.location.name=='United Kingdom'
        assert clan.location.country_code=='GB'
        assert clan.location.is_country==True
        assert clan.required_trophies==4000
        assert clan.donations_per_week==12415
        assert clan.clan_chest_status=='inactive'
        assert clan.clan_chest_points==1471
        assert clan.clan_chest_level==9
        assert clan.clan_chest_max_level==10
        assert clan.members==1

        assert type(clan.member_list) == list
        assert len(clan.member_list) == clan.members

        member = clan.member_list[0]
        assert member.tag=='#9ULGLRCL'
        assert member.name=='AaronTraas'
        assert member.role=='leader'
        assert member.last_seen=='20190719T175902.000Z'
        assert member.exp_level==13
        assert member.trophies==5600
        assert member.arena.id==54000015
        assert member.arena.name=='Master III'
        assert member.clan_rank==1
        assert member.previous_clan_rank==2
        assert member.donations==786
        assert member.donations_received==480
        assert member.clan_chest_points==72

    @patch('urllib3.PoolManager.request')
    def test_get_clan_fail(self, mock_get):

        mock_get.return_value.status=500

        try:
            clan = self.api.get_clan('#JY8YVV')
            assert False

        except ApiException as e:
            print("Exception when calling ClansApi->get_clan: %s\n" % e)
            assert True

    def test_get_clan_bad_param(self):
        try:
            cardList = self.api.get_clan('#JY8YVV', garbage='garbage')
            assert False

        except ApiTypeError as e:
            assert True

    @patch('urllib3.PoolManager.request')
    def test_get_clan_members(self, mock_get):
        mock_get.return_value.status=200
        mock_get.return_value.data = """
            {
              "items": [
                {
                  "tag": "#9ULGLRCL",
                  "name": "AaronTraas",
                  "role": "leader",
                  "lastSeen": "20190719T175902.000Z",
                  "expLevel": 13,
                  "trophies": 5600,
                  "arena": {
                    "id": 54000015,
                    "name": "Master III"
                  },
                  "clanRank": 1,
                  "previousClanRank": 2,
                  "donations": 786,
                  "donationsReceived": 480,
                  "clanChestPoints": 72
                }
              ],
              "paging": {
                "cursors": {}
              }
            }
        """.encode('utf-8')

        members = self.api.get_clan_members('#JY8YVV', limit=1, before='a', after='b')

        assert type(members.items) == list
        member = members.items[0]
        assert member.tag=='#9ULGLRCL'
        assert member.name=='AaronTraas'
        assert member.role=='leader'
        assert member.last_seen=='20190719T175902.000Z'
        assert member.exp_level==13
        assert member.trophies==5600
        assert member.arena.id==54000015
        assert member.arena.name=='Master III'
        assert member.clan_rank==1
        assert member.previous_clan_rank==2
        assert member.donations==786
        assert member.donations_received==480
        assert member.clan_chest_points==72

    @patch('urllib3.PoolManager.request')
    def test_get_clan_members_fail(self, mock_get):

        mock_get.return_value.status=500

        try:
            clan = self.api.get_clan_members('#JY8YVV')
            assert False

        except ApiException as e:
            print("Exception when calling ClansApi->get_clan_members: %s\n" % e)
            assert True

    def test_get_clan_members_fail_bad_param(self):
        try:
            cardList = self.api.get_clan_members('#JY8YVV', garbage='garbage')
            assert False

        except ApiTypeError as e:
            assert True

    @patch('urllib3.PoolManager.request')
    def test_get_clan_war_log(self, mock_get):
        mock_get.return_value.status=200
        mock_get.return_value.data = """
          {
            "items": [
              {
                "seasonId": 33,
                "createdDate": "20190719T140952.000Z",
                "participants": [
                  {
                    "tag": "#9ULGLRCL",
                    "name": "AaronTraas",
                    "cardsEarned": 1000,
                    "battlesPlayed": 1,
                    "wins": 1,
                    "collectionDayBattlesPlayed": 3,
                    "numberOfBattles": 1
                  }
                ],
                "standings": [
                  {
                    "clan": {
                      "tag": "#JY8YVV",
                      "name": "Agrassar",
                      "badgeId": 16000010,
                      "clanScore": 2620,
                      "participants": 28,
                      "battlesPlayed": 29,
                      "wins": 17,
                      "crowns": 34
                    },
                    "trophyChange": 117
                  }
                ]
              }
            ],
            "paging": {
              "cursors": {}
            }
          }
        """.encode('utf-8')

        warlog = self.api.get_clan_war_log('#JY8YVV', limit=1, before='a', after='b')
        assert type(warlog.items) == list
        war = warlog.items[0]

        assert type(war.participants) == list
        member = war.participants[0]
        assert member.tag=='#9ULGLRCL'
        assert member.name=='AaronTraas'
        assert member.cards_earned==1000
        assert member.battles_played==1
        assert member.wins==1
        assert member.collection_day_battles_played==3
        assert member.number_of_battles==1

        assert type(war.standings) == list
        clan = war.standings[0]
        assert clan.clan.tag=='#JY8YVV'
        assert clan.clan.name=='Agrassar'
        assert clan.clan.badge_id==16000010
        assert clan.clan.clan_score==2620
        assert clan.clan.participants==28
        assert clan.clan.battles_played==29
        assert clan.clan.wins==17
        assert clan.clan.crowns==34
        assert clan.trophy_change==117

    @patch('urllib3.PoolManager.request')
    def test_get_clan_war_log_fail(self, mock_get):

        mock_get.return_value.status=500

        try:
            clan = self.api.get_clan_war_log('#JY8YVV')
            assert False

        except ApiException as e:
            print("Exception when calling ClansApi->get_clan_war_log: %s\n" % e)
            assert True

    def test_get_clan_war_log_bad_param(self):
        try:
            cardList = self.api.get_clan_war_log('#JY8YVV', garbage='garbage')
            assert False

        except ApiTypeError as e:
            assert True

    @patch('urllib3.PoolManager.request')
    def test_get_current_war(self, mock_get):
        mock_get.return_value.status=200
        mock_get.return_value.data = """
          {
            "state": "collectionDay",
            "collectionEndTime": "20190722T160826.958Z",
            "clan": {
              "tag": "#JY8YVV",
              "name": "Agrassar",
              "badgeId": 16000010,
              "clanScore": 2620,
              "participants": 2,
              "battlesPlayed": 2,
              "wins": 1,
              "crowns": 0
            },
            "participants": [
              {
                "tag": "#9ULGLRCL",
                "name": "AaronTraas",
                "cardsEarned": 1000,
                "battlesPlayed": 1,
                "wins": 1,
                "collectionDayBattlesPlayed": 1,
                "numberOfBattles": 3
              },
              {
                "tag": "#8JV8Y2R8C",
                "name": "kyoshiro",
                "cardsEarned": 560,
                "battlesPlayed": 1,
                "wins": 1,
                "collectionDayBattlesPlayed": 1,
                "numberOfBattles": 3
              }
            ]
          }
        """.encode('utf-8')

        war = self.api.get_current_war('#JY8YVV')

        assert war.state == 'collectionDay'
        assert war.collection_end_time == '20190722T160826.958Z'

        clan = war.clan
        assert clan.tag=='#JY8YVV'
        assert clan.name=='Agrassar'
        assert clan.badge_id==16000010
        assert clan.clan_score==2620
        assert clan.participants==2
        assert clan.battles_played==2
        assert clan.wins==1
        assert clan.crowns==0

        assert type(war.participants) == list
        member = war.participants[0]
        assert member.tag=='#9ULGLRCL'
        assert member.name=='AaronTraas'
        assert member.cards_earned==1000
        assert member.battles_played==1
        assert member.wins==1
        assert member.collection_day_battles_played==1
        assert member.number_of_battles==3

    @patch('urllib3.PoolManager.request')
    def test_get_current_war_fail(self, mock_get):

        mock_get.return_value.status=500

        try:
            clan = self.api.get_current_war('#JY8YVV')
            assert False

        except ApiException as e:
            print("Exception when calling ClansApi->get_current_war: %s\n" % e)
            assert True

    def test_get_clan_current_war_bad_param(self):
        try:
            cardList = self.api.get_current_war('#JY8YVV', garbage='garbage')
            assert False

        except ApiTypeError as e:
            assert True

    @patch('urllib3.PoolManager.request')
    def test_search_clans(self, mock_get):
        mock_get.return_value.status=200
        mock_get.return_value.data = """
          {
            "items": [
              {
                "tag": "#JY8YVV",
                "name": "Agrassar",
                "type": "open",
                "badgeId": 16000010,
                "clanScore": 2620,
                "clanWarTrophies": 2573,
                "location": {
                  "id": 57000122,
                  "name": "Japan",
                  "isCountry": true,
                  "countryCode": "JP"
                },
                "requiredTrophies": 5000,
                "donationsPerWeek": 18880,
                "clanChestLevel": 1,
                "clanChestMaxLevel": 0,
                "members": 47
              }
            ],
            "paging": {
              "cursors": {
                "after": "AAA"
              }
            }
          }
        """.encode('utf-8')

        clans = self.api.search_clans(
            name='aaa',
            location_id='aaa',
            min_members='aaa',
            max_members='aaa',
            min_score='aaa',
            limit='aaa',
            after='aaa',
            before='aaa'
        )

        assert type(clans.items) == list

        clan = clans.items[0]
        assert clan.tag=='#JY8YVV'
        assert clan.name=='Agrassar'
        assert clan.badge_id==16000010
        assert clan.clan_score==2620

        assert clans.paging.cursors.after=='AAA'


    @patch('urllib3.PoolManager.request')
    def test_search_clans_fail(self, mock_get):

        mock_get.return_value.status=500

        try:
            clan = self.api.search_clans(name='aaa')
            assert False

        except ApiException as e:
            print("Exception when calling ClansApi->get_current_war: %s\n" % e)
            assert True

    def test_search_clans_param(self):
        try:
            cardList = self.api.search_clans(garbage='garbage')
            assert False

        except ApiTypeError as e:
            assert True

if __name__ == '__main__':
    unittest.main()
