# coding: utf-8

"""
    Clash Royale API

    Unofficial Swagger definition for the official Clash Royale API  # noqa: E501

    OpenAPI spec version: 1.0

    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import io
import sys
import unittest

import pyroyale
from pyroyale.models.clan_ranked import ClanRanked  # noqa: E501
from pyroyale.rest import ApiException


class TestClanRanked(unittest.TestCase):
    """ClanRanked unit test stubs"""

    def setUp(self):
        pass

    def tearDown(self):
        pass

    def testDefaults(self):
        model = ClanRanked()
        pass

    def testConstructorInitializers(self):
        model = ClanRanked(
            tag='tag',
            name='name',
            badge_id='badge_id',
            rank='rank',
            previous_rank='previous_rank',
            members='members',
            location='location',
            clan_score='clan_score'
        )

        assert model.tag=='tag'
        assert model.name=='name'
        assert model.badge_id=='badge_id'
        assert model.rank=='rank'
        assert model.previous_rank=='previous_rank'
        assert model.members=='members'
        assert model.location=='location'
        assert model.clan_score=='clan_score'

    def testToDict(self):
        model = ClanRanked(
            tag={'foo':'bar'},
            clan_score=ClanRanked(tag=123),
            members=[ClanRanked(name='clanname')]
        )

        modelDict = model.to_dict()

        assert modelDict['tag']['foo']=='bar'
        assert modelDict['clan_score']['tag']==123
        assert modelDict['members'][0]['name']=='clanname'

    def testToString(self):
        model = ClanRanked('TestStringSequence')

        modelString = model.to_str()
        assert len(modelString) > 1
        assert 'TestStringSequence' in modelString

    def testPrint(self):
        model = ClanRanked('TestStringSequence')

        capturedOutput = io.StringIO()
        sys.stdout = capturedOutput
        print(model)
        sys.stdout = sys.__stdout__

        testString = capturedOutput.getvalue()

        assert len(testString) > 1
        assert 'TestStringSequence' in testString


    def testEqual(self):
        model_a  = ClanRanked('A')
        model_a2 = ClanRanked('A')
        model_b  = ClanRanked('B')

        assert model_a == model_a
        assert model_a == model_a2
        assert model_a != model_b
        assert model_a != 'not a'

if __name__ == '__main__':
    unittest.main()
