# coding: utf-8

"""
    Clash Royale API

    Unofficial Swagger docs for the official Clash Royale API  # noqa: E501

    OpenAPI spec version: 1.0

    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import io
import sys
import unittest

import pyroyale
from pyroyale.models.clan import Clan  # noqa: E501
from pyroyale.rest import ApiException


class TestClan(unittest.TestCase):
    """Clan unit test stubs"""

    def setUp(self):
        pass

    def tearDown(self):
        pass

    def testDefaults(self):
        model = Clan()
        pass

    def testConstructorInitializers(self):
        model = Clan(
            tag='tag',
            name='name',
            badge_id='badge_id',
            type='type',
            clan_score='clan_score',
            required_trophies='required_trophies',
            donations_per_week='donations_per_week',
            clan_war_trophies='clan_war_trophies',
            clan_chest_level='clan_chest_level',
            clan_chest_max_level='clan_chest_max_level',
            members='members',
            location='location',
            description='description',
            clan_chest_status='clan_chest_status',
            clan_chest_points='clan_chest_points',
            member_list='member_list'
        )

        assert model.tag=='tag'
        assert model.name=='name'
        assert model.badge_id=='badge_id'
        assert model.type=='type'
        assert model.clan_score=='clan_score'
        assert model.required_trophies=='required_trophies'
        assert model.donations_per_week=='donations_per_week'
        assert model.clan_war_trophies=='clan_war_trophies'
        assert model.clan_chest_level=='clan_chest_level'
        assert model.clan_chest_max_level=='clan_chest_max_level'
        assert model.members=='members'
        assert model.location=='location'
        assert model.description=='description'
        assert model.clan_chest_status=='clan_chest_status'
        assert model.clan_chest_points=='clan_chest_points'
        assert model.member_list=='member_list'

    def testToDict(self):
        model = Clan(
            tag={'foo':'bar'},
            clan_score=123,
            clan_chest_status=Clan(name='clanname'),
            member_list=[Clan(name='clanname')]
        )

        modelDict = model.to_dict()

        assert modelDict['tag']['foo']=='bar'
        assert modelDict['clan_score']==123
        assert modelDict['clan_chest_status']['name']=='clanname'
        assert modelDict['member_list'][0]['name']=='clanname'

    def testToString(self):
        model = Clan('TestStringSequence')

        modelString = model.to_str()
        assert len(modelString) > 1
        assert 'TestStringSequence' in modelString

    def testPrint(self):
        model = Clan('TestStringSequence')

        capturedOutput = io.StringIO()
        sys.stdout = capturedOutput
        print(model)
        sys.stdout = sys.__stdout__

        testString = capturedOutput.getvalue()

        assert len(testString) > 1
        assert 'TestStringSequence' in testString


    def testEqual(self):
        model_a  = Clan('A')
        model_a2 = Clan('A')
        model_b  = Clan('B')

        assert model_a == model_a
        assert model_a == model_a2
        assert model_a != model_b
        assert model_a != 'not a'


if __name__ == '__main__':
    unittest.main()
