# coding: utf-8

"""
    Clash Royale API

    Unofficial Swagger docs for the official Clash Royale API  # noqa: E501

    OpenAPI spec version: 1.0

    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import unittest
from unittest.mock import patch

import pyroyale
from pyroyale.api.cards_api import CardsApi  # noqa: E501
from pyroyale.rest import ApiException
from pyroyale.exceptions import ApiTypeError

CARDS_API_URL = 'https://api.clashroyale.com/v1/cards'

class TestCardsApi(unittest.TestCase):
    """CardsApi unit test stubs"""

    def setUp(self):
        self.api = CardsApi()

    @patch('urllib3.PoolManager.request')
    def test_get_cards(self, mock_get):

        mock_get.return_value.status=200
        mock_get.return_value.data = """
            {
              "items": [
                {
                  "name": "Knight",
                  "id": 26000000,
                  "maxLevel": 13,
                  "iconUrls": {
                    "medium": "https://api-assets.clashroyale.com/cards/300/jAj1Q5rclXxU9kVImGqSJxa4wEMfEhvwNQ_4jiGUuqg.png"
                  }
                },
                {
                  "name": "Archers",
                  "id": 26000001,
                  "maxLevel": 13,
                  "iconUrls": {
                    "medium": "https://api-assets.clashroyale.com/cards/300/W4Hmp8MTSdXANN8KdblbtHwtsbt0o749BbxNqmJYfA8.png"
                  }
                }
              ]
            }
        """.encode('utf-8')

        # Get list of available cards
        cardList = self.api.get_cards()
        assert type(cardList.items) == list

        assert cardList.items[0].name == 'Knight'
        assert cardList.items[0].max_level == 13

        assert cardList.items[1].name == 'Archers'
        assert cardList.items[1].max_level == 13

    @patch('urllib3.PoolManager.request')
    def test_get_cards_fail(self, mock_get):

        mock_get.return_value.status=500

        try:
            cardList = self.api.get_cards()
            assert False

        except ApiException as e:
            assert True

    def test_get_cards_bad_param(self):
        try:
            cardList = self.api.get_cards(garbage='garbage')
            assert False

        except ApiTypeError as e:
            assert True

if __name__ == '__main__':
    unittest.main()
