
import sys
if sys.version_info >= (3, 8):
    from typing import Protocol
else:
    from typing_extensions import Protocol

import java.lang
import java.util
import jpype
import org.hipparchus.geometry.euclidean.threed
import org.orekit.bodies
import org.orekit.data
import org.orekit.frames
import org.orekit.time
import org.orekit.utils
import typing



class OceanLoadingCoefficients:
    """
    public class OceanLoadingCoefficients extends :class:`~org.orekit.models.earth.displacement.https:.docs.oracle.com.javase.8.docs.api.java.lang.Object?is`
    
        Site specific coefficients for ocean loading.
    
        Instances of this class are typically created by
        :class:`~org.orekit.models.earth.displacement.OceanLoadingCoefficientsBLQFactory` that parses files from Onsala Space
        Observatory files in BLQ format found in the Orekit data configuration.
    
        Instances of this class are guaranteed to be immutable
    
        Since:
            9.1
    
        Also see:
            :class:`~org.orekit.estimation.measurements.GroundStation`,
            :class:`~org.orekit.models.earth.displacement.OceanLoadingCoefficientsBLQFactory`,
            :class:`~org.orekit.models.earth.displacement.OceanLoading`
    """
    def __init__(self, string: str, geodeticPoint: org.orekit.bodies.GeodeticPoint, tideArray: typing.Union[typing.List[typing.MutableSequence['Tide']], jpype.JArray], doubleArray: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray2: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray3: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray4: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray5: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray], doubleArray6: typing.Union[typing.List[typing.MutableSequence[float]], jpype.JArray]): ...
    def getNbSpecies(self) -> int:
        """
            Get the number of species.
        
            Returns:
                number of species
        
        
        """
        ...
    def getNbTides(self, int: int) -> int:
        """
            Get the number of tides for one species.
        
            Parameters:
                species (int): species index
        
            Returns:
                number of tides for one species
        
        
        """
        ...
    def getSiteLocation(self) -> org.orekit.bodies.GeodeticPoint:
        """
            Get the site location.
        
            Returns:
                site location
        
        
        """
        ...
    def getSiteName(self) -> str:
        """
            Get the site name.
        
            Returns:
                site name
        
        
        """
        ...
    def getSouthAmplitude(self, int: int, int2: int) -> float:
        """
            Get the amplitude along South axis.
        
            Parameters:
                i (int): species
                j (int): tide in the species
        
            Returns:
                amplitude along South axis
        
        
        """
        ...
    def getSouthPhase(self, int: int, int2: int) -> float:
        """
            Get the phase along South axis.
        
            Parameters:
                i (int): species
                j (int): tide in the species
        
            Returns:
                phase along South axis
        
        
        """
        ...
    def getTide(self, int: int, int2: int) -> 'Tide':
        """
            Get the tide.
        
            Parameters:
                i (int): species
                j (int): tide in the species
        
            Returns:
                tide
        
        
        """
        ...
    def getWestAmplitude(self, int: int, int2: int) -> float:
        """
            Get the amplitude along west axis.
        
            Parameters:
                i (int): species
                j (int): tide in the species
        
            Returns:
                amplitude along west axis
        
        
        """
        ...
    def getWestPhase(self, int: int, int2: int) -> float:
        """
            Get the phase along West axis.
        
            Parameters:
                i (int): species
                j (int): tide in the species
        
            Returns:
                phase along West axis
        
        
        """
        ...
    def getZenithAmplitude(self, int: int, int2: int) -> float:
        """
            Get the amplitude along zenith axis.
        
            Parameters:
                i (int): species
                j (int): tide in the species
        
            Returns:
                amplitude along zenith axis
        
        
        """
        ...
    def getZenithPhase(self, int: int, int2: int) -> float:
        """
            Get the phase along zenith axis.
        
            Parameters:
                i (int): species
                j (int): tide in the species
        
            Returns:
                phase along zenith axis
        
        
        """
        ...

class OceanLoadingCoefficientsBLQFactory(org.orekit.data.AbstractSelfFeedingLoader):
    """
    public class OceanLoadingCoefficientsBLQFactory extends :class:`~org.orekit.data.AbstractSelfFeedingLoader`
    
        Factory for ocean loading coefficients, using Onsala Space Observatory files in BLQ format.
    
        Files in BLQ format can be generated using the form at the `Bos-Scherneck web site
        <http://holt.oso.chalmers.se/loading/>`, selecting BLQ as the output format.
    
        The sites names are extracted from the file content, not the file name, because the file can contain more than one
        station. As we expect existing files may have been stripped from headers and footers, we do not attempt to parse them.
        We only parse the series of 7 lines blocks starting with the lines with the station names and their coordinates and the
        6 data lines that follows. Several such blocks may appear in the file. Copy-pasting the entire mail received from OSO
        after completing the web site form works, as intermediate lines between the 7 lines blocks are simply ignored.
    
        Since:
            9.1
    
        Also see:
            :class:`~org.orekit.models.earth.displacement.OceanLoadingCoefficients`,
            :class:`~org.orekit.models.earth.displacement.OceanLoading`
    """
    DEFAULT_BLQ_SUPPORTED_NAMES: typing.ClassVar[str] = ...
    """
    public static final :class:`~org.orekit.models.earth.displacement.https:.docs.oracle.com.javase.8.docs.api.java.lang.String?is` DEFAULT_BLQ_SUPPORTED_NAMES
    
        Default supported files name pattern for Onsala Space Observatory files in BLQ format.
    
        Also see:
            :meth:`~constant`
    
    
    """
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def __init__(self, string: str, dataProvidersManager: org.orekit.data.DataProvidersManager): ...
    def getCoefficients(self, string: str) -> OceanLoadingCoefficients:
        """
            Get the coefficients for a given site.
        
            Parameters:
                site (:class:`~org.orekit.models.earth.displacement.https:.docs.oracle.com.javase.8.docs.api.java.lang.String?is`): site name (as it appears in the Onsala Space Observatory files in BLQ format), ignoring case
        
            Returns:
                coefficients for the site
        
        
        """
        ...
    def getSites(self) -> java.util.List[str]: ...

class OceanLoadingCoefficientsBlqParser:
    """
    public class OceanLoadingCoefficientsBlqParser extends :class:`~org.orekit.models.earth.displacement.https:.docs.oracle.com.javase.8.docs.api.java.lang.Object?is`
    
        Parser for ocean loading coefficients, using Onsala Space Observatory files in BLQ format.
    
        Files in BLQ format can be generated using the form at the `Bos-Scherneck web site
        <http://holt.oso.chalmers.se/loading/>`, selecting BLQ as the output format.
    
        The sites names are extracted from the file content, not the file name, because the file can contain more than one
        station. As we expect existing files may have been stripped from headers and footers, we do not attempt to parse them.
        We only parse the series of 7 lines blocks starting with the lines with the station names and their coordinates and the
        6 data lines that follows. Several such blocks may appear in the file. Copy-pasting the entire mail received from OSO
        after completing the web site form works, as intermediate lines between the 7 lines blocks are simply ignored.
    
        Since:
            9.1
    
        Also see:
            :class:`~org.orekit.models.earth.displacement.OceanLoadingCoefficients`,
            :class:`~org.orekit.models.earth.displacement.OceanLoading`
    """
    def __init__(self): ...
    def parse(self, dataSource: org.orekit.data.DataSource) -> java.util.List[OceanLoadingCoefficients]: ...

class PsdCorrection:
    """
    public class PsdCorrection extends :class:`~org.orekit.models.earth.displacement.https:.docs.oracle.com.javase.8.docs.api.java.lang.Object?is`
    
        Model for post-seismic deformation corrections.
    
        Since:
            12.1
    """
    def __init__(self, axis: 'PsdCorrection.Axis', timeEvolution: 'PsdCorrection.TimeEvolution', absoluteDate: org.orekit.time.AbsoluteDate, double: float, double2: float): ...
    def displacement(self, absoluteDate: org.orekit.time.AbsoluteDate, geodeticPoint: org.orekit.bodies.GeodeticPoint) -> org.hipparchus.geometry.euclidean.threed.Vector3D:
        """
            Compute displacement.
        
            Parameters:
                date (:class:`~org.orekit.time.AbsoluteDate`): date
                base (:class:`~org.orekit.bodies.GeodeticPoint`): base point
        
            Returns:
                displacement vector in Earth frame
        
        
        """
        ...
    def getAmplitude(self) -> float:
        """
            Get amplitude.
        
            Returns:
                amplitude
        
        
        """
        ...
    def getAxis(self) -> 'PsdCorrection.Axis':
        """
            Get correction axis.
        
            Returns:
                correction axis
        
        
        """
        ...
    def getEarthquakeDate(self) -> org.orekit.time.AbsoluteDate:
        """
            Get earthquake date.
        
            Returns:
                earthquake date
        
        
        """
        ...
    def getEvolution(self) -> 'PsdCorrection.TimeEvolution':
        """
            Get time evolution.
        
            Returns:
                time evolution
        
        
        """
        ...
    def getRelaxationTime(self) -> float:
        """
            Get relaxation time.
        
            Returns:
                relaxation time
        
        
        """
        ...
    class Axis(java.lang.Enum['PsdCorrection.Axis']):
        EAST: typing.ClassVar['PsdCorrection.Axis'] = ...
        NORTH: typing.ClassVar['PsdCorrection.Axis'] = ...
        UP: typing.ClassVar['PsdCorrection.Axis'] = ...
        _valueOf_0__T = typing.TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
        @typing.overload
        @staticmethod
        def valueOf(class_: typing.Type[_valueOf_0__T], string: str) -> _valueOf_0__T: ...
        @typing.overload
        @staticmethod
        def valueOf(string: str) -> 'PsdCorrection.Axis': ...
        @staticmethod
        def values() -> typing.MutableSequence['PsdCorrection.Axis']: ...
        def vector(self, geodeticPoint: org.orekit.bodies.GeodeticPoint) -> org.hipparchus.geometry.euclidean.threed.Vector3D: ...
    class TimeEvolution(java.lang.Enum['PsdCorrection.TimeEvolution']):
        EXP: typing.ClassVar['PsdCorrection.TimeEvolution'] = ...
        LOG: typing.ClassVar['PsdCorrection.TimeEvolution'] = ...
        def timeFactor(self, double: float) -> float: ...
        _valueOf_0__T = typing.TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
        @typing.overload
        @staticmethod
        def valueOf(class_: typing.Type[_valueOf_0__T], string: str) -> _valueOf_0__T: ...
        @typing.overload
        @staticmethod
        def valueOf(string: str) -> 'PsdCorrection.TimeEvolution': ...
        @staticmethod
        def values() -> typing.MutableSequence['PsdCorrection.TimeEvolution']: ...

class StationDisplacement:
    """
    public interface StationDisplacement
    
        Interface for computing reference points displacement.
    
        Since:
            9.1
    """
    def displacement(self, bodiesElements: org.orekit.data.BodiesElements, frame: org.orekit.frames.Frame, vector3D: org.hipparchus.geometry.euclidean.threed.Vector3D) -> org.hipparchus.geometry.euclidean.threed.Vector3D:
        """
            Compute displacement of a ground reference point.
        
            Parameters:
                elements (:class:`~org.orekit.data.BodiesElements`): elements affecting Earth orientation
                earthFrame (:class:`~org.orekit.frames.Frame`): Earth frame in which reference point is defined
                referencePoint (:class:`~org.orekit.models.earth.displacement.https:.www.hipparchus.org.apidocs.org.hipparchus.geometry.euclidean.threed.Vector3D?is`): reference point position in :code:`earthFrame`
        
            Returns:
                displacement vector to be *added* to :code:`referencePoint`
        
        
        """
        ...

class Tide:
    """
    public class Tide extends :class:`~org.orekit.models.earth.displacement.https:.docs.oracle.com.javase.8.docs.api.java.lang.Object?is`
    
        Class representing a tide.
    
        Since:
            9.1
    """
    M2: typing.ClassVar['Tide'] = ...
    """
    public static final :class:`~org.orekit.models.earth.displacement.Tide` M2
    
        M₂ tide.
    
    """
    S2: typing.ClassVar['Tide'] = ...
    """
    public static final :class:`~org.orekit.models.earth.displacement.Tide` S2
    
        S₂ tide.
    
    """
    N2: typing.ClassVar['Tide'] = ...
    """
    public static final :class:`~org.orekit.models.earth.displacement.Tide` N2
    
        N₂ tide.
    
    """
    K2: typing.ClassVar['Tide'] = ...
    """
    public static final :class:`~org.orekit.models.earth.displacement.Tide` K2
    
        K₂ tide.
    
    """
    K1: typing.ClassVar['Tide'] = ...
    """
    public static final :class:`~org.orekit.models.earth.displacement.Tide` K1
    
        K₁ tide.
    
    """
    O1: typing.ClassVar['Tide'] = ...
    """
    public static final :class:`~org.orekit.models.earth.displacement.Tide` O1
    
        O₁ tide.
    
    """
    P1: typing.ClassVar['Tide'] = ...
    """
    public static final :class:`~org.orekit.models.earth.displacement.Tide` P1
    
        P₁ tide.
    
    """
    Q1: typing.ClassVar['Tide'] = ...
    """
    public static final :class:`~org.orekit.models.earth.displacement.Tide` Q1
    
        Q₁ tide.
    
    """
    MF: typing.ClassVar['Tide'] = ...
    """
    public static final :class:`~org.orekit.models.earth.displacement.Tide` MF
    
        Mf tide.
    
    """
    MM: typing.ClassVar['Tide'] = ...
    """
    public static final :class:`~org.orekit.models.earth.displacement.Tide` MM
    
        Mm tide.
    
    """
    SSA: typing.ClassVar['Tide'] = ...
    """
    public static final :class:`~org.orekit.models.earth.displacement.Tide` SSA
    
        Ssa tide.
    
    """
    @typing.overload
    def __init__(self, int: int): ...
    @typing.overload
    def __init__(self, int: int, int2: int, int3: int, int4: int, int5: int, int6: int): ...
    def equals(self, object: typing.Any) -> bool:
        """
        
            Overrides:
                :meth:`~org.orekit.models.earth.displacement.https:.docs.oracle.com.javase.8.docs.api.java.lang.Object.html?is` in
                class :class:`~org.orekit.models.earth.displacement.https:.docs.oracle.com.javase.8.docs.api.java.lang.Object?is`
        
        
        """
        ...
    def getDelaunayMultipliers(self) -> typing.MutableSequence[int]:
        """
            Get the multipliers for Delaunay arguments (l, l', F, D, Ω).
        
            Beware that for tides the multipliers for Delaunay arguments have an opposite sign with respect to the convention used
            for nutation computation! Here, we obey the tides convention.
        
            Returns:
                multipliers for Delaunay arguments (l, l', F, D, Ω)
        
        
        """
        ...
    def getDoodsonMultipliers(self) -> typing.MutableSequence[int]:
        """
            Get the multipliers for Doodson arguments (τ, s, h, p, N', ps).
        
            Returns:
                multipliers for Doodson arguments (τ, s, h, p, N', ps)
        
        
        """
        ...
    def getDoodsonNumber(self) -> int:
        """
            Get the Doodson number.
        
            Returns:
                Doodson number
        
        
        """
        ...
    def getPhase(self, bodiesElements: org.orekit.data.BodiesElements) -> float:
        """
            Get the phase of the tide.
        
            Parameters:
                elements (:class:`~org.orekit.data.BodiesElements`): elements to use
        
            Returns:
                phase of the tide (radians)
        
        
        """
        ...
    def getRate(self, bodiesElements: org.orekit.data.BodiesElements) -> float:
        """
            Get the angular rate of the tide.
        
            Parameters:
                elements (:class:`~org.orekit.data.BodiesElements`): elements to use
        
            Returns:
                angular rate of the tide (radians/second)
        
        
        """
        ...
    def getTauMultiplier(self) -> int:
        """
            Get the multiplier for the τ Doodson argument.
        
            This multiplier identifies semi-diurnal tides (2), diurnal tides (1) and long period tides (0)
        
            Returns:
                multiplier for the τ Doodson argument
        
        
        """
        ...
    def hashCode(self) -> int:
        """
        
            Overrides:
                :meth:`~org.orekit.models.earth.displacement.https:.docs.oracle.com.javase.8.docs.api.java.lang.Object.html?is` in
                class :class:`~org.orekit.models.earth.displacement.https:.docs.oracle.com.javase.8.docs.api.java.lang.Object?is`
        
        
        """
        ...

class OceanLoading(StationDisplacement):
    """
    public class OceanLoading extends :class:`~org.orekit.models.earth.displacement.https:.docs.oracle.com.javase.8.docs.api.java.lang.Object?is` implements :class:`~org.orekit.models.earth.displacement.StationDisplacement`
    
        Modeling of displacement of reference points due to ocean loading.
    
        This class implements the same model as IERS HARDIP.F program. For a given site, this model uses a set of amplitudes and
        phases for the 11 main tides (M₂, S₂, N₂, K₂, K₁, O₁, P₁, Q₁, Mf, Mm, and Ssa) in BLQ format as provided
        by the `Bos-Scherneck web site <http://holt.oso.chalmers.se/loading/>` at Onsala Space Observatory. From these elements,
        additional admittances are derived using spline interpolation based on tides frequencies for a total of 342 tides,
        including the 11 main tides.
    
        This implementation is a complete rewrite of the original HARDISP.F program developed by Duncan Agnew and copyright 2008
        IERS Conventions center. This derived work is not endorsed by the IERS conventions center. What remains from the
        original program is the model (spline interpolation and coefficients). The code by itself is completely different, using
        the underlying mathematical library for spline interpolation and the existing Orekit features for nutation arguments,
        time and time scales handling, tides modeling...
    
        Instances of this class are guaranteed to be immutable
    
        The original HARDISP.F program is distributed with the following notice:
    
        .. code-block: java
        
          Copyright (C) 2008
          IERS Conventions Center
        
          ==================================
          IERS Conventions Software License
          ==================================
        
          NOTICE TO USER:
        
          BY USING THIS SOFTWARE YOU ACCEPT THE FOLLOWING TERMS AND CONDITIONS
          WHICH APPLY TO ITS USE.
        
          1. The Software is provided by the IERS Conventions Center ("the
             Center").
        
          2. Permission is granted to anyone to use the Software for any
             purpose, including commercial applications, free of charge,
             subject to the conditions and restrictions listed below.
        
          3. You (the user) may adapt the Software and its algorithms for your
             own purposes and you may distribute the resulting "derived work"
             to others, provided that the derived work complies with the
             following requirements:
        
             a) Your work shall be clearly identified so that it cannot be
                mistaken for IERS Conventions software and that it has been
                neither distributed by nor endorsed by the Center.
        
             b) Your work (including source code) must contain descriptions of
                how the derived work is based upon and/or differs from the
                original Software.
        
             c) The name(s) of all modified routine(s) that you distribute
                shall be changed.
        
             d) The origin of the IERS Conventions components of your derived
                work must not be misrepresented; you must not claim that you
                wrote the original Software.
        
             e) The source code must be included for all routine(s) that you
                distribute.  This notice must be reproduced intact in any
                source distribution.
        
          4. In any published work produced by the user and which includes
             results achieved by using the Software, you shall acknowledge
             that the Software was used in obtaining those results.
        
          5. The Software is provided to the user "as is" and the Center makes
             no warranty as to its use or performance.   The Center does not
             and cannot warrant the performance or results which the user may
             obtain by using the Software.  The Center makes no warranties,
             express or implied, as to non-infringement of third party rights,
             merchantability, or fitness for any particular purpose.  In no
             event will the Center be liable to the user for any consequential,
             incidental, or special damages, including any lost profits or lost
             savings, even if a Center representative has been advised of such
             damages, or for any claim by any third party.
        
          Correspondence concerning IERS Conventions software should be
          addressed as follows:
        
                             Gerard Petit
             Internet email: gpetit[at]bipm.org
             Postal address: IERS Conventions Center
                             Time, frequency and gravimetry section, BIPM
                             Pavillon de Breteuil
                             92312 Sevres  FRANCE
        
             or
        
                             Brian Luzum
             Internet email: brian.luzum[at]usno.navy.mil
             Postal address: IERS Conventions Center
                             Earth Orientation Department
                             3450 Massachusetts Ave, NW
                             Washington, DC 20392
         
    
        Since:
            9.1
    
        Also see:
            :class:`~org.orekit.estimation.measurements.GroundStation`
    """
    def __init__(self, oneAxisEllipsoid: org.orekit.bodies.OneAxisEllipsoid, oceanLoadingCoefficients: OceanLoadingCoefficients): ...
    def displacement(self, bodiesElements: org.orekit.data.BodiesElements, frame: org.orekit.frames.Frame, vector3D: org.hipparchus.geometry.euclidean.threed.Vector3D) -> org.hipparchus.geometry.euclidean.threed.Vector3D:
        """
            Compute displacement of a ground reference point.
        
            Specified by:
                :meth:`~org.orekit.models.earth.displacement.StationDisplacement.displacement` in
                interface :class:`~org.orekit.models.earth.displacement.StationDisplacement`
        
            Parameters:
                elements (:class:`~org.orekit.data.BodiesElements`): elements affecting Earth orientation
                earthFrame (:class:`~org.orekit.frames.Frame`): Earth frame in which reference point is defined
                referencePoint (:class:`~org.orekit.models.earth.displacement.https:.www.hipparchus.org.apidocs.org.hipparchus.geometry.euclidean.threed.Vector3D?is`): reference point position in :code:`earthFrame`
        
            Returns:
                displacement vector to be *added* to :code:`referencePoint`
        
        
        """
        ...

class PostSeismicDeformation(StationDisplacement):
    """
    public class PostSeismicDeformation extends :class:`~org.orekit.models.earth.displacement.https:.docs.oracle.com.javase.8.docs.api.java.lang.Object?is` implements :class:`~org.orekit.models.earth.displacement.StationDisplacement`
    
        Modeling of displacement of one reference point due to post-seismic effects.
    
        Since:
            12.1
    
        Also see:
            :class:`~org.orekit.models.earth.displacement.https:.itrf.ign.fr.ftp.pub.itrf.itrf2020.ITRF2020`
    """
    def __init__(self, geodeticPoint: org.orekit.bodies.GeodeticPoint, timeSpanMap: org.orekit.utils.TimeSpanMap[java.util.List[PsdCorrection]]): ...
    def displacement(self, bodiesElements: org.orekit.data.BodiesElements, frame: org.orekit.frames.Frame, vector3D: org.hipparchus.geometry.euclidean.threed.Vector3D) -> org.hipparchus.geometry.euclidean.threed.Vector3D:
        """
            Compute displacement of a ground reference point.
        
            Specified by:
                :meth:`~org.orekit.models.earth.displacement.StationDisplacement.displacement` in
                interface :class:`~org.orekit.models.earth.displacement.StationDisplacement`
        
            Parameters:
                elements (:class:`~org.orekit.data.BodiesElements`): elements affecting Earth orientation
                earthFrame (:class:`~org.orekit.frames.Frame`): Earth frame in which reference point is defined
                referencePoint (:class:`~org.orekit.models.earth.displacement.https:.www.hipparchus.org.apidocs.org.hipparchus.geometry.euclidean.threed.Vector3D?is`): reference point position in :code:`earthFrame`
        
            Returns:
                displacement vector to be *added* to :code:`referencePoint`
        
        
        """
        ...

class TectonicsDisplacement(StationDisplacement):
    """
    public class TectonicsDisplacement extends :class:`~org.orekit.models.earth.displacement.https:.docs.oracle.com.javase.8.docs.api.java.lang.Object?is` implements :class:`~org.orekit.models.earth.displacement.StationDisplacement`
    
        Modeling of displacement of reference points due to plate tectonics.
    
        Instances of this class are guaranteed to be immutable
    
        Since:
            12.0
    
        Also see:
            :class:`~org.orekit.estimation.measurements.GroundStation`, :class:`~org.orekit.files.sinex.package`
    """
    def __init__(self, absoluteDate: org.orekit.time.AbsoluteDate, vector3D: org.hipparchus.geometry.euclidean.threed.Vector3D): ...
    def displacement(self, bodiesElements: org.orekit.data.BodiesElements, frame: org.orekit.frames.Frame, vector3D: org.hipparchus.geometry.euclidean.threed.Vector3D) -> org.hipparchus.geometry.euclidean.threed.Vector3D:
        """
            Compute displacement of a ground reference point.
        
            Specified by:
                :meth:`~org.orekit.models.earth.displacement.StationDisplacement.displacement` in
                interface :class:`~org.orekit.models.earth.displacement.StationDisplacement`
        
            Parameters:
                elements (:class:`~org.orekit.data.BodiesElements`): elements affecting Earth orientation
                earthFrame (:class:`~org.orekit.frames.Frame`): Earth frame in which reference point is defined
                referencePoint (:class:`~org.orekit.models.earth.displacement.https:.www.hipparchus.org.apidocs.org.hipparchus.geometry.euclidean.threed.Vector3D?is`): reference point position in :code:`earthFrame`
        
            Returns:
                displacement vector to be *added* to :code:`referencePoint`
        
        
        """
        ...

class TidalDisplacement(StationDisplacement):
    """
    public class TidalDisplacement extends :class:`~org.orekit.models.earth.displacement.https:.docs.oracle.com.javase.8.docs.api.java.lang.Object?is` implements :class:`~org.orekit.models.earth.displacement.StationDisplacement`
    
        Modeling of displacement of reference points due to tidal effects.
    
        This class implements displacement of reference point (i.e. :class:`~org.orekit.estimation.measurements.GroundStation`)
        due to tidal effects, as per IERS conventions.
    
        Displacement can be computed with respect to either *conventional tide free* or *mean tide* coordinates. The difference
        between the two systems is about -12cm at poles and +6cm at equator. Selecting one system or the other depends on how
        the station coordinates have been computed (i.e. it depends whether the coordinates already include the permanent
        deformation or not).
    
        Instances of this class are guaranteed to be immutable
    
        Since:
            9.1
    
        Also see:
            :class:`~org.orekit.estimation.measurements.GroundStation`
    """
    def __init__(self, double: float, double2: float, double3: float, pVCoordinatesProvider: typing.Union[org.orekit.utils.PVCoordinatesProvider, typing.Callable], pVCoordinatesProvider2: typing.Union[org.orekit.utils.PVCoordinatesProvider, typing.Callable], iERSConventions: org.orekit.utils.IERSConventions, boolean: bool): ...
    def displacement(self, bodiesElements: org.orekit.data.BodiesElements, frame: org.orekit.frames.Frame, vector3D: org.hipparchus.geometry.euclidean.threed.Vector3D) -> org.hipparchus.geometry.euclidean.threed.Vector3D:
        """
            Compute displacement of a ground reference point.
        
            Specified by:
                :meth:`~org.orekit.models.earth.displacement.StationDisplacement.displacement` in
                interface :class:`~org.orekit.models.earth.displacement.StationDisplacement`
        
            Parameters:
                elements (:class:`~org.orekit.data.BodiesElements`): elements affecting Earth orientation
                earthFrame (:class:`~org.orekit.frames.Frame`): Earth frame in which reference point is defined
                referencePoint (:class:`~org.orekit.models.earth.displacement.https:.www.hipparchus.org.apidocs.org.hipparchus.geometry.euclidean.threed.Vector3D?is`): reference point position in :code:`earthFrame`
        
            Returns:
                displacement vector to be *added* to :code:`referencePoint`
        
        
        """
        ...


class __module_protocol__(Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("org.orekit.models.earth.displacement")``.

    OceanLoading: typing.Type[OceanLoading]
    OceanLoadingCoefficients: typing.Type[OceanLoadingCoefficients]
    OceanLoadingCoefficientsBLQFactory: typing.Type[OceanLoadingCoefficientsBLQFactory]
    OceanLoadingCoefficientsBlqParser: typing.Type[OceanLoadingCoefficientsBlqParser]
    PostSeismicDeformation: typing.Type[PostSeismicDeformation]
    PsdCorrection: typing.Type[PsdCorrection]
    StationDisplacement: typing.Type[StationDisplacement]
    TectonicsDisplacement: typing.Type[TectonicsDisplacement]
    TidalDisplacement: typing.Type[TidalDisplacement]
    Tide: typing.Type[Tide]
