
import sys
if sys.version_info >= (3, 8):
    from typing import Protocol
else:
    from typing_extensions import Protocol

import java.io
import java.lang
import java.util
import java.util.regex
import jpype
import org.orekit.gnss
import org.orekit.gnss.metric.messages
import org.orekit.utils.units
import typing



class DataField:
    """
    public interface DataField
    
        Interface for data fields used to parsed encoded messages.
    
        Since:
            11.0
    """
    def booleanValue(self, encodedMessage: typing.Union['EncodedMessage', typing.Callable]) -> bool:
        """
            Get the value of the field as a boolean.
        
            Parameters:
                message (:class:`~org.orekit.gnss.metric.parser.EncodedMessage`): message containing the data
        
            Returns:
                boolean value of the field
        
        
        """
        ...
    def doubleValue(self, encodedMessage: typing.Union['EncodedMessage', typing.Callable]) -> float:
        """
            Get the value of the field as a double.
        
            Parameters:
                message (:class:`~org.orekit.gnss.metric.parser.EncodedMessage`): message containing the data
        
            Returns:
                double value of the field
        
        
        """
        ...
    def intValue(self, encodedMessage: typing.Union['EncodedMessage', typing.Callable]) -> int:
        """
            Get the value of the field as an integer.
        
            Parameters:
                message (:class:`~org.orekit.gnss.metric.parser.EncodedMessage`): message containing the data
        
            Returns:
                integer value of the field
        
        
        """
        ...
    def stringValue(self, encodedMessage: typing.Union['EncodedMessage', typing.Callable], int: int) -> str:
        """
            Get the value of the field as a String.
        
            Parameters:
                message (:class:`~org.orekit.gnss.metric.parser.EncodedMessage`): message containing the data
                n (int): number of UTF8 characters
        
            Returns:
                String value of the field
        
        
        """
        ...

class DataType(java.lang.Enum['DataType']):
    """
    public enum DataType extends :class:`~org.orekit.gnss.metric.parser.https:.docs.oracle.com.javase.8.docs.api.java.lang.Enum?is`<:class:`~org.orekit.gnss.metric.parser.DataType`>
    
        Enum containing all low level data types that can be parsed to build a message.
    
        Since:
            11.0
    """
    BIT_1: typing.ClassVar['DataType'] = ...
    BIT_2: typing.ClassVar['DataType'] = ...
    BIT_3: typing.ClassVar['DataType'] = ...
    BIT_4: typing.ClassVar['DataType'] = ...
    BIT_6: typing.ClassVar['DataType'] = ...
    BIT_7: typing.ClassVar['DataType'] = ...
    BIT_8: typing.ClassVar['DataType'] = ...
    BIT_10: typing.ClassVar['DataType'] = ...
    BIT_12: typing.ClassVar['DataType'] = ...
    BIT_24: typing.ClassVar['DataType'] = ...
    BIT_32: typing.ClassVar['DataType'] = ...
    INT_6: typing.ClassVar['DataType'] = ...
    INT_8: typing.ClassVar['DataType'] = ...
    INT_9: typing.ClassVar['DataType'] = ...
    INT_10: typing.ClassVar['DataType'] = ...
    INT_11: typing.ClassVar['DataType'] = ...
    INT_14: typing.ClassVar['DataType'] = ...
    INT_15: typing.ClassVar['DataType'] = ...
    INT_16: typing.ClassVar['DataType'] = ...
    INT_17: typing.ClassVar['DataType'] = ...
    INT_18: typing.ClassVar['DataType'] = ...
    INT_19: typing.ClassVar['DataType'] = ...
    INT_20: typing.ClassVar['DataType'] = ...
    INT_21: typing.ClassVar['DataType'] = ...
    INT_22: typing.ClassVar['DataType'] = ...
    INT_23: typing.ClassVar['DataType'] = ...
    INT_24: typing.ClassVar['DataType'] = ...
    INT_25: typing.ClassVar['DataType'] = ...
    INT_26: typing.ClassVar['DataType'] = ...
    INT_27: typing.ClassVar['DataType'] = ...
    INT_30: typing.ClassVar['DataType'] = ...
    INT_31: typing.ClassVar['DataType'] = ...
    INT_32: typing.ClassVar['DataType'] = ...
    INT_34: typing.ClassVar['DataType'] = ...
    INT_35: typing.ClassVar['DataType'] = ...
    INT_38: typing.ClassVar['DataType'] = ...
    U_INT_2: typing.ClassVar['DataType'] = ...
    U_INT_3: typing.ClassVar['DataType'] = ...
    U_INT_4: typing.ClassVar['DataType'] = ...
    U_INT_5: typing.ClassVar['DataType'] = ...
    U_INT_6: typing.ClassVar['DataType'] = ...
    U_INT_7: typing.ClassVar['DataType'] = ...
    U_INT_8: typing.ClassVar['DataType'] = ...
    U_INT_9: typing.ClassVar['DataType'] = ...
    U_INT_10: typing.ClassVar['DataType'] = ...
    U_INT_11: typing.ClassVar['DataType'] = ...
    U_INT_12: typing.ClassVar['DataType'] = ...
    U_INT_13: typing.ClassVar['DataType'] = ...
    U_INT_14: typing.ClassVar['DataType'] = ...
    U_INT_16: typing.ClassVar['DataType'] = ...
    U_INT_17: typing.ClassVar['DataType'] = ...
    U_INT_18: typing.ClassVar['DataType'] = ...
    U_INT_20: typing.ClassVar['DataType'] = ...
    U_INT_23: typing.ClassVar['DataType'] = ...
    U_INT_24: typing.ClassVar['DataType'] = ...
    U_INT_25: typing.ClassVar['DataType'] = ...
    U_INT_26: typing.ClassVar['DataType'] = ...
    U_INT_27: typing.ClassVar['DataType'] = ...
    U_INT_30: typing.ClassVar['DataType'] = ...
    U_INT_32: typing.ClassVar['DataType'] = ...
    U_INT_35: typing.ClassVar['DataType'] = ...
    U_INT_36: typing.ClassVar['DataType'] = ...
    INT_S_5: typing.ClassVar['DataType'] = ...
    INT_S_11: typing.ClassVar['DataType'] = ...
    INT_S_22: typing.ClassVar['DataType'] = ...
    INT_S_24: typing.ClassVar['DataType'] = ...
    INT_S_27: typing.ClassVar['DataType'] = ...
    INT_S_32: typing.ClassVar['DataType'] = ...
    def decode(self, encodedMessage: typing.Union['EncodedMessage', typing.Callable]) -> int:
        """
            Decode a piece of data extracted from an encoded message.
        
            Parameters:
                message (:class:`~org.orekit.gnss.metric.parser.EncodedMessage`): encoded message providing the bits to decode
        
            Returns:
                data decoded as a Long object, or null if data not available
        
        
        """
        ...
    _valueOf_0__T = typing.TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
    @typing.overload
    @staticmethod
    def valueOf(class_: typing.Type[_valueOf_0__T], string: str) -> _valueOf_0__T: ...
    @typing.overload
    @staticmethod
    def valueOf(string: str) -> 'DataType':
        """
            Returns the enum constant of this type with the specified name. The string must match *exactly* an identifier used to
            declare an enum constant in this type. (Extraneous whitespace characters are not permitted.)
        
            Parameters:
                name (:class:`~org.orekit.gnss.metric.parser.https:.docs.oracle.com.javase.8.docs.api.java.lang.String?is`): the name of the enum constant to be returned.
        
            Returns:
                the enum constant with the specified name
        
            Raises:
                :class:`~org.orekit.gnss.metric.parser.https:.docs.oracle.com.javase.8.docs.api.java.lang.IllegalArgumentException?is`: if this enum type has no constant with the specified name
                :class:`~org.orekit.gnss.metric.parser.https:.docs.oracle.com.javase.8.docs.api.java.lang.NullPointerException?is`: if the argument is null
        
        
        """
        ...
    @staticmethod
    def values() -> typing.MutableSequence['DataType']:
        """
            Returns an array containing the constants of this enum type, in the order they are declared. This method may be used to
            iterate over the constants as follows:
        
            .. code-block: java
            
            for (DataType c : DataType.values())
                System.out.println(c);
            
        
            Returns:
                an array containing the constants of this enum type, in the order they are declared
        
        
        """
        ...

class EncodedMessage:
    """
    public interface EncodedMessage
    
        Interface for getting bits forming encoded messages.
    
        Classes implementing this interface must contain exactly one complete message.
    
        Since:
            11.0
    """
    def extractBits(self, int: int) -> int:
        """
            Extract the next n bits from the encoded message.
        
            Parameters:
                n (int): number of bits to extract (cannot exceed 32 bits)
        
            Returns:
                bits packed as the LSB of a 64 bits primitive long
        
        
        """
        ...
    def start(self) -> None:
        """
            Start message extraction.
        
        """
        ...

class MessageType:
    """
    public interface MessageType
    
        Interface for encoded message types.
    
        Since:
            11.0
    """
    def parse(self, encodedMessage: typing.Union[EncodedMessage, typing.Callable], int: int) -> org.orekit.gnss.metric.messages.ParsedMessage:
        """
            Parse an encoded message.
        
            Parameters:
                encodedMessage (:class:`~org.orekit.gnss.metric.parser.EncodedMessage`): encoded message to parse
                messageNumber (int): message number
        
            Returns:
                parsed message
        
        
        """
        ...

class MessagesParser:
    """
    public abstract class MessagesParser extends :class:`~org.orekit.gnss.metric.parser.https:.docs.oracle.com.javase.8.docs.api.java.lang.Object?is`
    
        Parser for IGS encoded messages.
    
        Since:
            11.0
    """
    def __init__(self, list: java.util.List[int]): ...
    def parse(self, encodedMessage: typing.Union[EncodedMessage, typing.Callable], boolean: bool) -> org.orekit.gnss.metric.messages.ParsedMessage:
        """
            Parse one message.
        
            Parameters:
                message (:class:`~org.orekit.gnss.metric.parser.EncodedMessage`): encoded message to parse
                ignoreUnknownMessageTypes (boolean): if true, unknown messages types are silently ignored
        
            Returns:
                parsed message, or null if parse not possible and :code:`ignoreUnknownMessageTypes` is true
        
        
        """
        ...

class Units:
    """
    public class Units extends :class:`~org.orekit.gnss.metric.parser.https:.docs.oracle.com.javase.8.docs.api.java.lang.Object?is`
    
        Units used in RTCM and IGS SSR messages.
    
        Since:
            11.0
    """
    SEMI_CIRCLE: typing.ClassVar[org.orekit.utils.units.Unit] = ...
    """
    public static final :class:`~org.orekit.utils.units.Unit` SEMI_CIRCLE
    
        Semi-circles units.
    
    """
    NS: typing.ClassVar[org.orekit.utils.units.Unit] = ...
    """
    public static final :class:`~org.orekit.utils.units.Unit` NS
    
        Nanoseconds units.
    
    """
    MM: typing.ClassVar[org.orekit.utils.units.Unit] = ...
    """
    public static final :class:`~org.orekit.utils.units.Unit` MM
    
        Millimetres units.
    
    """
    MM_PER_S: typing.ClassVar[org.orekit.utils.units.Unit] = ...
    """
    public static final :class:`~org.orekit.utils.units.Unit` MM_PER_S
    
        Millimetres per second units.
    
    """
    MM_PER_S2: typing.ClassVar[org.orekit.utils.units.Unit] = ...
    """
    public static final :class:`~org.orekit.utils.units.Unit` MM_PER_S2
    
        Millimetres per square second units.
    
    """
    KM_PER_S: typing.ClassVar[org.orekit.utils.units.Unit] = ...
    """
    public static final :class:`~org.orekit.utils.units.Unit` KM_PER_S
    
        Kilometers par second units.
    
    """
    KM_PER_S2: typing.ClassVar[org.orekit.utils.units.Unit] = ...
    """
    public static final :class:`~org.orekit.utils.units.Unit` KM_PER_S2
    
        Kilometers par square second units.
    
    """

class AbstractEncodedMessage(EncodedMessage):
    """
    public abstract class AbstractEncodedMessage extends :class:`~org.orekit.gnss.metric.parser.https:.docs.oracle.com.javase.8.docs.api.java.lang.Object?is` implements :class:`~org.orekit.gnss.metric.parser.EncodedMessage`
    
        Encoded messages as a sequence of bytes.
    
        Note that only full bytes are supported. This means that for example the 300 bits message from GPS sub-frames must be
        completed with 4 zero bits to reach 304 bits = 38 bytes, even if only the first 300 bits will be decoded and the 4 extra
        bits in the last byte will be ignored.
    
        Since:
            11.0
    """
    def __init__(self): ...
    def extractBits(self, int: int) -> int:
        """
            Extract the next n bits from the encoded message.
        
            Specified by:
                :meth:`~org.orekit.gnss.metric.parser.EncodedMessage.extractBits` in
                interface :class:`~org.orekit.gnss.metric.parser.EncodedMessage`
        
            Parameters:
                n (int): number of bits to extract (cannot exceed 32 bits)
        
            Returns:
                bits packed as the LSB of a 64 bits primitive long
        
        
        """
        ...
    def start(self) -> None:
        """
            Start message extraction.
        
            Specified by:
                :meth:`~org.orekit.gnss.metric.parser.EncodedMessage.start` in
                interface :class:`~org.orekit.gnss.metric.parser.EncodedMessage`
        
        
        """
        ...

class IgsSsrDataField(java.lang.Enum['IgsSsrDataField'], DataField):
    """
    public enum IgsSsrDataField extends :class:`~org.orekit.gnss.metric.parser.https:.docs.oracle.com.javase.8.docs.api.java.lang.Enum?is`<:class:`~org.orekit.gnss.metric.parser.IgsSsrDataField`> implements :class:`~org.orekit.gnss.metric.parser.DataField`
    
        Enum containing all intermediate level data fields that can be parsed to build an IGS SSR message.
    
        Since:
            11.0
    """
    IDF001: typing.ClassVar['IgsSsrDataField'] = ...
    IDF002: typing.ClassVar['IgsSsrDataField'] = ...
    IDF003: typing.ClassVar['IgsSsrDataField'] = ...
    IDF004: typing.ClassVar['IgsSsrDataField'] = ...
    IDF005: typing.ClassVar['IgsSsrDataField'] = ...
    IDF006: typing.ClassVar['IgsSsrDataField'] = ...
    IDF007: typing.ClassVar['IgsSsrDataField'] = ...
    IDF008: typing.ClassVar['IgsSsrDataField'] = ...
    IDF009: typing.ClassVar['IgsSsrDataField'] = ...
    IDF010: typing.ClassVar['IgsSsrDataField'] = ...
    IDF011: typing.ClassVar['IgsSsrDataField'] = ...
    IDF012: typing.ClassVar['IgsSsrDataField'] = ...
    IDF013: typing.ClassVar['IgsSsrDataField'] = ...
    IDF014: typing.ClassVar['IgsSsrDataField'] = ...
    IDF015: typing.ClassVar['IgsSsrDataField'] = ...
    IDF016: typing.ClassVar['IgsSsrDataField'] = ...
    IDF017: typing.ClassVar['IgsSsrDataField'] = ...
    IDF018: typing.ClassVar['IgsSsrDataField'] = ...
    IDF019: typing.ClassVar['IgsSsrDataField'] = ...
    IDF020: typing.ClassVar['IgsSsrDataField'] = ...
    IDF021: typing.ClassVar['IgsSsrDataField'] = ...
    IDF022: typing.ClassVar['IgsSsrDataField'] = ...
    IDF023: typing.ClassVar['IgsSsrDataField'] = ...
    IDF024: typing.ClassVar['IgsSsrDataField'] = ...
    IDF025: typing.ClassVar['IgsSsrDataField'] = ...
    IDF026: typing.ClassVar['IgsSsrDataField'] = ...
    IDF027: typing.ClassVar['IgsSsrDataField'] = ...
    IDF028: typing.ClassVar['IgsSsrDataField'] = ...
    IDF029: typing.ClassVar['IgsSsrDataField'] = ...
    IDF030: typing.ClassVar['IgsSsrDataField'] = ...
    IDF031: typing.ClassVar['IgsSsrDataField'] = ...
    IDF032: typing.ClassVar['IgsSsrDataField'] = ...
    IDF033: typing.ClassVar['IgsSsrDataField'] = ...
    IDF034: typing.ClassVar['IgsSsrDataField'] = ...
    IDF035: typing.ClassVar['IgsSsrDataField'] = ...
    IDF036: typing.ClassVar['IgsSsrDataField'] = ...
    IDF037: typing.ClassVar['IgsSsrDataField'] = ...
    IDF038: typing.ClassVar['IgsSsrDataField'] = ...
    IDF039: typing.ClassVar['IgsSsrDataField'] = ...
    IDF040: typing.ClassVar['IgsSsrDataField'] = ...
    IDF041: typing.ClassVar['IgsSsrDataField'] = ...
    _valueOf_0__T = typing.TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
    @typing.overload
    @staticmethod
    def valueOf(class_: typing.Type[_valueOf_0__T], string: str) -> _valueOf_0__T: ...
    @typing.overload
    @staticmethod
    def valueOf(string: str) -> 'IgsSsrDataField':
        """
            Returns the enum constant of this type with the specified name. The string must match *exactly* an identifier used to
            declare an enum constant in this type. (Extraneous whitespace characters are not permitted.)
        
            Parameters:
                name (:class:`~org.orekit.gnss.metric.parser.https:.docs.oracle.com.javase.8.docs.api.java.lang.String?is`): the name of the enum constant to be returned.
        
            Returns:
                the enum constant with the specified name
        
            Raises:
                :class:`~org.orekit.gnss.metric.parser.https:.docs.oracle.com.javase.8.docs.api.java.lang.IllegalArgumentException?is`: if this enum type has no constant with the specified name
                :class:`~org.orekit.gnss.metric.parser.https:.docs.oracle.com.javase.8.docs.api.java.lang.NullPointerException?is`: if the argument is null
        
        
        """
        ...
    @staticmethod
    def values() -> typing.MutableSequence['IgsSsrDataField']:
        """
            Returns an array containing the constants of this enum type, in the order they are declared. This method may be used to
            iterate over the constants as follows:
        
            .. code-block: java
            
            for (IgsSsrDataField c : IgsSsrDataField.values())
                System.out.println(c);
            
        
            Returns:
                an array containing the constants of this enum type, in the order they are declared
        
        
        """
        ...

class IgsSsrMessageType(java.lang.Enum['IgsSsrMessageType'], MessageType):
    """
    public enum IgsSsrMessageType extends :class:`~org.orekit.gnss.metric.parser.https:.docs.oracle.com.javase.8.docs.api.java.lang.Enum?is`<:class:`~org.orekit.gnss.metric.parser.IgsSsrMessageType`> implements :class:`~org.orekit.gnss.metric.parser.MessageType`
    
        Enum containing the supported IGS SSR messages types.
    
        Since:
            11.0
    
        Also see:
            "IGS State Space Representation (SSR) Format, Version 1.00, October 2020."
    """
    IGM_01: typing.ClassVar['IgsSsrMessageType'] = ...
    IGM_02: typing.ClassVar['IgsSsrMessageType'] = ...
    IGM_03: typing.ClassVar['IgsSsrMessageType'] = ...
    IGM_04: typing.ClassVar['IgsSsrMessageType'] = ...
    IGM_05: typing.ClassVar['IgsSsrMessageType'] = ...
    IGM_06: typing.ClassVar['IgsSsrMessageType'] = ...
    IGM_07: typing.ClassVar['IgsSsrMessageType'] = ...
    IM_201: typing.ClassVar['IgsSsrMessageType'] = ...
    @staticmethod
    def getMessageType(string: str) -> 'IgsSsrMessageType':
        """
            Get the message type corresponding to a message number.
        
            Parameters:
                number (:class:`~org.orekit.gnss.metric.parser.https:.docs.oracle.com.javase.8.docs.api.java.lang.String?is`): message number
        
            Returns:
                the message type corresponding to the message number
        
        
        """
        ...
    def getPattern(self) -> java.util.regex.Pattern:
        """
            Get the message number.
        
            Returns:
                message number
        
        
        """
        ...
    @staticmethod
    def getSatelliteId(satelliteSystem: org.orekit.gnss.SatelliteSystem, int: int) -> int:
        """
            Transform the satellite ID parsed from the IGS SSR message to the real ID.
        
            Parameters:
                system (:class:`~org.orekit.gnss.SatelliteSystem`): the satellite system of the parsed message
                id (int): the parsed satellite ID
        
            Returns:
                the real satellite ID
        
        
        """
        ...
    @staticmethod
    def messageNumberToSatelliteSystem(int: int) -> org.orekit.gnss.SatelliteSystem:
        """
            Find the satellite system corresponding to the sub-type message number.
        
            See Table 5 of reference
        
            Parameters:
                subTypeMessage (int): message umber
        
            Returns:
                the corresponding satellite system
        
        
        """
        ...
    _valueOf_0__T = typing.TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
    @typing.overload
    @staticmethod
    def valueOf(class_: typing.Type[_valueOf_0__T], string: str) -> _valueOf_0__T: ...
    @typing.overload
    @staticmethod
    def valueOf(string: str) -> 'IgsSsrMessageType':
        """
            Returns the enum constant of this type with the specified name. The string must match *exactly* an identifier used to
            declare an enum constant in this type. (Extraneous whitespace characters are not permitted.)
        
            Parameters:
                name (:class:`~org.orekit.gnss.metric.parser.https:.docs.oracle.com.javase.8.docs.api.java.lang.String?is`): the name of the enum constant to be returned.
        
            Returns:
                the enum constant with the specified name
        
            Raises:
                :class:`~org.orekit.gnss.metric.parser.https:.docs.oracle.com.javase.8.docs.api.java.lang.IllegalArgumentException?is`: if this enum type has no constant with the specified name
                :class:`~org.orekit.gnss.metric.parser.https:.docs.oracle.com.javase.8.docs.api.java.lang.NullPointerException?is`: if the argument is null
        
        
        """
        ...
    @staticmethod
    def values() -> typing.MutableSequence['IgsSsrMessageType']:
        """
            Returns an array containing the constants of this enum type, in the order they are declared. This method may be used to
            iterate over the constants as follows:
        
            .. code-block: java
            
            for (IgsSsrMessageType c : IgsSsrMessageType.values())
                System.out.println(c);
            
        
            Returns:
                an array containing the constants of this enum type, in the order they are declared
        
        
        """
        ...

class IgsSsrMessagesParser(MessagesParser):
    """
    public class IgsSsrMessagesParser extends :class:`~org.orekit.gnss.metric.parser.MessagesParser`
    
        Parser for SSR encoded messages.
    
        Since:
            11.0
    """
    def __init__(self, list: java.util.List[int]): ...

class RtcmDataField(java.lang.Enum['RtcmDataField'], DataField):
    """
    public enum RtcmDataField extends :class:`~org.orekit.gnss.metric.parser.https:.docs.oracle.com.javase.8.docs.api.java.lang.Enum?is`<:class:`~org.orekit.gnss.metric.parser.RtcmDataField`> implements :class:`~org.orekit.gnss.metric.parser.DataField`
    
        Enum containing all intermediate level data fields that can be parsed to build a RTCM message.
    
        Since:
            11.0
    """
    DF002: typing.ClassVar['RtcmDataField'] = ...
    DF009: typing.ClassVar['RtcmDataField'] = ...
    DF038: typing.ClassVar['RtcmDataField'] = ...
    DF040: typing.ClassVar['RtcmDataField'] = ...
    DF068: typing.ClassVar['RtcmDataField'] = ...
    DF071: typing.ClassVar['RtcmDataField'] = ...
    DF076: typing.ClassVar['RtcmDataField'] = ...
    DF077: typing.ClassVar['RtcmDataField'] = ...
    DF078: typing.ClassVar['RtcmDataField'] = ...
    DF079: typing.ClassVar['RtcmDataField'] = ...
    DF081: typing.ClassVar['RtcmDataField'] = ...
    DF082: typing.ClassVar['RtcmDataField'] = ...
    DF083: typing.ClassVar['RtcmDataField'] = ...
    DF084: typing.ClassVar['RtcmDataField'] = ...
    DF085: typing.ClassVar['RtcmDataField'] = ...
    DF086: typing.ClassVar['RtcmDataField'] = ...
    DF087: typing.ClassVar['RtcmDataField'] = ...
    DF088: typing.ClassVar['RtcmDataField'] = ...
    DF089: typing.ClassVar['RtcmDataField'] = ...
    DF090: typing.ClassVar['RtcmDataField'] = ...
    DF091: typing.ClassVar['RtcmDataField'] = ...
    DF092: typing.ClassVar['RtcmDataField'] = ...
    DF093: typing.ClassVar['RtcmDataField'] = ...
    DF094: typing.ClassVar['RtcmDataField'] = ...
    DF095: typing.ClassVar['RtcmDataField'] = ...
    DF096: typing.ClassVar['RtcmDataField'] = ...
    DF097: typing.ClassVar['RtcmDataField'] = ...
    DF098: typing.ClassVar['RtcmDataField'] = ...
    DF099: typing.ClassVar['RtcmDataField'] = ...
    DF100: typing.ClassVar['RtcmDataField'] = ...
    DF101: typing.ClassVar['RtcmDataField'] = ...
    DF102: typing.ClassVar['RtcmDataField'] = ...
    DF103: typing.ClassVar['RtcmDataField'] = ...
    DF104: typing.ClassVar['RtcmDataField'] = ...
    DF105: typing.ClassVar['RtcmDataField'] = ...
    DF106: typing.ClassVar['RtcmDataField'] = ...
    DF107: typing.ClassVar['RtcmDataField'] = ...
    DF108: typing.ClassVar['RtcmDataField'] = ...
    DF109: typing.ClassVar['RtcmDataField'] = ...
    DF110: typing.ClassVar['RtcmDataField'] = ...
    DF111: typing.ClassVar['RtcmDataField'] = ...
    DF112: typing.ClassVar['RtcmDataField'] = ...
    DF113: typing.ClassVar['RtcmDataField'] = ...
    DF114: typing.ClassVar['RtcmDataField'] = ...
    DF115: typing.ClassVar['RtcmDataField'] = ...
    DF116: typing.ClassVar['RtcmDataField'] = ...
    DF117: typing.ClassVar['RtcmDataField'] = ...
    DF118: typing.ClassVar['RtcmDataField'] = ...
    DF119: typing.ClassVar['RtcmDataField'] = ...
    DF120: typing.ClassVar['RtcmDataField'] = ...
    DF121: typing.ClassVar['RtcmDataField'] = ...
    DF122: typing.ClassVar['RtcmDataField'] = ...
    DF123: typing.ClassVar['RtcmDataField'] = ...
    DF124: typing.ClassVar['RtcmDataField'] = ...
    DF125: typing.ClassVar['RtcmDataField'] = ...
    DF126: typing.ClassVar['RtcmDataField'] = ...
    DF127: typing.ClassVar['RtcmDataField'] = ...
    DF128: typing.ClassVar['RtcmDataField'] = ...
    DF129: typing.ClassVar['RtcmDataField'] = ...
    DF130: typing.ClassVar['RtcmDataField'] = ...
    DF131: typing.ClassVar['RtcmDataField'] = ...
    DF132: typing.ClassVar['RtcmDataField'] = ...
    DF133: typing.ClassVar['RtcmDataField'] = ...
    DF134: typing.ClassVar['RtcmDataField'] = ...
    DF135: typing.ClassVar['RtcmDataField'] = ...
    DF136: typing.ClassVar['RtcmDataField'] = ...
    DF137: typing.ClassVar['RtcmDataField'] = ...
    DF252: typing.ClassVar['RtcmDataField'] = ...
    DF289: typing.ClassVar['RtcmDataField'] = ...
    DF290: typing.ClassVar['RtcmDataField'] = ...
    DF291: typing.ClassVar['RtcmDataField'] = ...
    DF292: typing.ClassVar['RtcmDataField'] = ...
    DF293: typing.ClassVar['RtcmDataField'] = ...
    DF294: typing.ClassVar['RtcmDataField'] = ...
    DF295: typing.ClassVar['RtcmDataField'] = ...
    DF296: typing.ClassVar['RtcmDataField'] = ...
    DF297: typing.ClassVar['RtcmDataField'] = ...
    DF298: typing.ClassVar['RtcmDataField'] = ...
    DF299: typing.ClassVar['RtcmDataField'] = ...
    DF300: typing.ClassVar['RtcmDataField'] = ...
    DF301: typing.ClassVar['RtcmDataField'] = ...
    DF302: typing.ClassVar['RtcmDataField'] = ...
    DF303: typing.ClassVar['RtcmDataField'] = ...
    DF304: typing.ClassVar['RtcmDataField'] = ...
    DF305: typing.ClassVar['RtcmDataField'] = ...
    DF306: typing.ClassVar['RtcmDataField'] = ...
    DF307: typing.ClassVar['RtcmDataField'] = ...
    DF308: typing.ClassVar['RtcmDataField'] = ...
    DF309: typing.ClassVar['RtcmDataField'] = ...
    DF310: typing.ClassVar['RtcmDataField'] = ...
    DF311: typing.ClassVar['RtcmDataField'] = ...
    DF312: typing.ClassVar['RtcmDataField'] = ...
    DF313: typing.ClassVar['RtcmDataField'] = ...
    DF314: typing.ClassVar['RtcmDataField'] = ...
    DF315: typing.ClassVar['RtcmDataField'] = ...
    DF316: typing.ClassVar['RtcmDataField'] = ...
    DF317: typing.ClassVar['RtcmDataField'] = ...
    DF365: typing.ClassVar['RtcmDataField'] = ...
    DF366: typing.ClassVar['RtcmDataField'] = ...
    DF367: typing.ClassVar['RtcmDataField'] = ...
    DF368: typing.ClassVar['RtcmDataField'] = ...
    DF369: typing.ClassVar['RtcmDataField'] = ...
    DF370: typing.ClassVar['RtcmDataField'] = ...
    DF375: typing.ClassVar['RtcmDataField'] = ...
    DF376: typing.ClassVar['RtcmDataField'] = ...
    DF377: typing.ClassVar['RtcmDataField'] = ...
    DF378: typing.ClassVar['RtcmDataField'] = ...
    DF384: typing.ClassVar['RtcmDataField'] = ...
    DF385: typing.ClassVar['RtcmDataField'] = ...
    DF386: typing.ClassVar['RtcmDataField'] = ...
    DF387: typing.ClassVar['RtcmDataField'] = ...
    DF388: typing.ClassVar['RtcmDataField'] = ...
    DF391: typing.ClassVar['RtcmDataField'] = ...
    DF392: typing.ClassVar['RtcmDataField'] = ...
    DF413: typing.ClassVar['RtcmDataField'] = ...
    DF414: typing.ClassVar['RtcmDataField'] = ...
    DF415: typing.ClassVar['RtcmDataField'] = ...
    DF429: typing.ClassVar['RtcmDataField'] = ...
    DF430: typing.ClassVar['RtcmDataField'] = ...
    DF431: typing.ClassVar['RtcmDataField'] = ...
    DF432: typing.ClassVar['RtcmDataField'] = ...
    DF433: typing.ClassVar['RtcmDataField'] = ...
    DF434: typing.ClassVar['RtcmDataField'] = ...
    DF435: typing.ClassVar['RtcmDataField'] = ...
    DF436: typing.ClassVar['RtcmDataField'] = ...
    DF437: typing.ClassVar['RtcmDataField'] = ...
    DF438: typing.ClassVar['RtcmDataField'] = ...
    DF439: typing.ClassVar['RtcmDataField'] = ...
    DF440: typing.ClassVar['RtcmDataField'] = ...
    DF441: typing.ClassVar['RtcmDataField'] = ...
    DF442: typing.ClassVar['RtcmDataField'] = ...
    DF443: typing.ClassVar['RtcmDataField'] = ...
    DF444: typing.ClassVar['RtcmDataField'] = ...
    DF445: typing.ClassVar['RtcmDataField'] = ...
    DF446: typing.ClassVar['RtcmDataField'] = ...
    DF447: typing.ClassVar['RtcmDataField'] = ...
    DF448: typing.ClassVar['RtcmDataField'] = ...
    DF449: typing.ClassVar['RtcmDataField'] = ...
    DF450: typing.ClassVar['RtcmDataField'] = ...
    DF451: typing.ClassVar['RtcmDataField'] = ...
    DF452: typing.ClassVar['RtcmDataField'] = ...
    DF453: typing.ClassVar['RtcmDataField'] = ...
    DF454: typing.ClassVar['RtcmDataField'] = ...
    DF455: typing.ClassVar['RtcmDataField'] = ...
    DF456: typing.ClassVar['RtcmDataField'] = ...
    DF457: typing.ClassVar['RtcmDataField'] = ...
    DF458: typing.ClassVar['RtcmDataField'] = ...
    DF488: typing.ClassVar['RtcmDataField'] = ...
    DF489: typing.ClassVar['RtcmDataField'] = ...
    DF490: typing.ClassVar['RtcmDataField'] = ...
    DF491: typing.ClassVar['RtcmDataField'] = ...
    DF492: typing.ClassVar['RtcmDataField'] = ...
    DF493: typing.ClassVar['RtcmDataField'] = ...
    DF494: typing.ClassVar['RtcmDataField'] = ...
    DF495: typing.ClassVar['RtcmDataField'] = ...
    DF496: typing.ClassVar['RtcmDataField'] = ...
    DF497: typing.ClassVar['RtcmDataField'] = ...
    DF498: typing.ClassVar['RtcmDataField'] = ...
    DF499: typing.ClassVar['RtcmDataField'] = ...
    DF500: typing.ClassVar['RtcmDataField'] = ...
    DF501: typing.ClassVar['RtcmDataField'] = ...
    DF502: typing.ClassVar['RtcmDataField'] = ...
    DF503: typing.ClassVar['RtcmDataField'] = ...
    DF504: typing.ClassVar['RtcmDataField'] = ...
    DF505: typing.ClassVar['RtcmDataField'] = ...
    DF506: typing.ClassVar['RtcmDataField'] = ...
    DF507: typing.ClassVar['RtcmDataField'] = ...
    DF508: typing.ClassVar['RtcmDataField'] = ...
    DF509: typing.ClassVar['RtcmDataField'] = ...
    DF510: typing.ClassVar['RtcmDataField'] = ...
    DF511: typing.ClassVar['RtcmDataField'] = ...
    DF512: typing.ClassVar['RtcmDataField'] = ...
    DF513: typing.ClassVar['RtcmDataField'] = ...
    DF514: typing.ClassVar['RtcmDataField'] = ...
    DF515: typing.ClassVar['RtcmDataField'] = ...
    _valueOf_0__T = typing.TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
    @typing.overload
    @staticmethod
    def valueOf(class_: typing.Type[_valueOf_0__T], string: str) -> _valueOf_0__T: ...
    @typing.overload
    @staticmethod
    def valueOf(string: str) -> 'RtcmDataField':
        """
            Returns the enum constant of this type with the specified name. The string must match *exactly* an identifier used to
            declare an enum constant in this type. (Extraneous whitespace characters are not permitted.)
        
            Parameters:
                name (:class:`~org.orekit.gnss.metric.parser.https:.docs.oracle.com.javase.8.docs.api.java.lang.String?is`): the name of the enum constant to be returned.
        
            Returns:
                the enum constant with the specified name
        
            Raises:
                :class:`~org.orekit.gnss.metric.parser.https:.docs.oracle.com.javase.8.docs.api.java.lang.IllegalArgumentException?is`: if this enum type has no constant with the specified name
                :class:`~org.orekit.gnss.metric.parser.https:.docs.oracle.com.javase.8.docs.api.java.lang.NullPointerException?is`: if the argument is null
        
        
        """
        ...
    @staticmethod
    def values() -> typing.MutableSequence['RtcmDataField']:
        """
            Returns an array containing the constants of this enum type, in the order they are declared. This method may be used to
            iterate over the constants as follows:
        
            .. code-block: java
            
            for (RtcmDataField c : RtcmDataField.values())
                System.out.println(c);
            
        
            Returns:
                an array containing the constants of this enum type, in the order they are declared
        
        
        """
        ...

class RtcmMessageType(java.lang.Enum['RtcmMessageType'], MessageType):
    """
    public enum RtcmMessageType extends :class:`~org.orekit.gnss.metric.parser.https:.docs.oracle.com.javase.8.docs.api.java.lang.Enum?is`<:class:`~org.orekit.gnss.metric.parser.RtcmMessageType`> implements :class:`~org.orekit.gnss.metric.parser.MessageType`
    
        Enum containing the supported RTCM messages types.
    
        Since:
            11.0
    
        Also see:
            "RTCM STANDARD 10403.3, DIFFERENTIAL GNSS (GLOBAL NAVIGATION SATELLITE SYSTEMS) SERVICES – VERSION 3, October 2016."
    """
    RTCM_1019: typing.ClassVar['RtcmMessageType'] = ...
    RTCM_1020: typing.ClassVar['RtcmMessageType'] = ...
    RTCM_1042: typing.ClassVar['RtcmMessageType'] = ...
    RTCM_1044: typing.ClassVar['RtcmMessageType'] = ...
    RTCM_1045: typing.ClassVar['RtcmMessageType'] = ...
    RTCM_1057: typing.ClassVar['RtcmMessageType'] = ...
    RTCM_1058: typing.ClassVar['RtcmMessageType'] = ...
    RTCM_1060: typing.ClassVar['RtcmMessageType'] = ...
    RTCM_1063: typing.ClassVar['RtcmMessageType'] = ...
    RTCM_1064: typing.ClassVar['RtcmMessageType'] = ...
    RTCM_1066: typing.ClassVar['RtcmMessageType'] = ...
    RTCM_1240: typing.ClassVar['RtcmMessageType'] = ...
    RTCM_1241: typing.ClassVar['RtcmMessageType'] = ...
    RTCM_1243: typing.ClassVar['RtcmMessageType'] = ...
    @staticmethod
    def getMessageType(string: str) -> 'RtcmMessageType':
        """
            Get the message type corresponding to a message number.
        
            Parameters:
                rtcmNumber (:class:`~org.orekit.gnss.metric.parser.https:.docs.oracle.com.javase.8.docs.api.java.lang.String?is`): message number
        
            Returns:
                the message type corresponding to the message number
        
        
        """
        ...
    def getPattern(self) -> java.util.regex.Pattern:
        """
            Get the message number.
        
            Returns:
                message number
        
        
        """
        ...
    _valueOf_0__T = typing.TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
    @typing.overload
    @staticmethod
    def valueOf(class_: typing.Type[_valueOf_0__T], string: str) -> _valueOf_0__T: ...
    @typing.overload
    @staticmethod
    def valueOf(string: str) -> 'RtcmMessageType':
        """
            Returns the enum constant of this type with the specified name. The string must match *exactly* an identifier used to
            declare an enum constant in this type. (Extraneous whitespace characters are not permitted.)
        
            Parameters:
                name (:class:`~org.orekit.gnss.metric.parser.https:.docs.oracle.com.javase.8.docs.api.java.lang.String?is`): the name of the enum constant to be returned.
        
            Returns:
                the enum constant with the specified name
        
            Raises:
                :class:`~org.orekit.gnss.metric.parser.https:.docs.oracle.com.javase.8.docs.api.java.lang.IllegalArgumentException?is`: if this enum type has no constant with the specified name
                :class:`~org.orekit.gnss.metric.parser.https:.docs.oracle.com.javase.8.docs.api.java.lang.NullPointerException?is`: if the argument is null
        
        
        """
        ...
    @staticmethod
    def values() -> typing.MutableSequence['RtcmMessageType']:
        """
            Returns an array containing the constants of this enum type, in the order they are declared. This method may be used to
            iterate over the constants as follows:
        
            .. code-block: java
            
            for (RtcmMessageType c : RtcmMessageType.values())
                System.out.println(c);
            
        
            Returns:
                an array containing the constants of this enum type, in the order they are declared
        
        
        """
        ...

class RtcmMessagesParser(MessagesParser):
    """
    public class RtcmMessagesParser extends :class:`~org.orekit.gnss.metric.parser.MessagesParser`
    
        Parser for RTCM encoded messages.
    
        Since:
            11.0
    """
    def __init__(self, list: java.util.List[int]): ...

class ByteArrayEncodedMessage(AbstractEncodedMessage):
    """
    public class ByteArrayEncodedMessage extends :class:`~org.orekit.gnss.metric.parser.AbstractEncodedMessage`
    
        Encoded message as a byte array.
    
        Since:
            11.0
    """
    def __init__(self, byteArray: typing.Union[typing.List[int], jpype.JArray, bytes]): ...
    def start(self) -> None:
        """
            Start message extraction.
        
            Specified by:
                :meth:`~org.orekit.gnss.metric.parser.EncodedMessage.start` in
                interface :class:`~org.orekit.gnss.metric.parser.EncodedMessage`
        
            Overrides:
                :meth:`~org.orekit.gnss.metric.parser.AbstractEncodedMessage.start` in
                class :class:`~org.orekit.gnss.metric.parser.AbstractEncodedMessage`
        
        
        """
        ...

class HexadecimalSequenceEncodedMessage(AbstractEncodedMessage):
    """
    public class HexadecimalSequenceEncodedMessage extends :class:`~org.orekit.gnss.metric.parser.AbstractEncodedMessage`
    
        Encoded message as an hexadecimal characters sequence.
    
        Since:
            11.0
    """
    def __init__(self, charSequence: typing.Union[java.lang.CharSequence, str]): ...
    def start(self) -> None:
        """
            Start message extraction.
        
            Specified by:
                :meth:`~org.orekit.gnss.metric.parser.EncodedMessage.start` in
                interface :class:`~org.orekit.gnss.metric.parser.EncodedMessage`
        
            Overrides:
                :meth:`~org.orekit.gnss.metric.parser.AbstractEncodedMessage.start` in
                class :class:`~org.orekit.gnss.metric.parser.AbstractEncodedMessage`
        
        
        """
        ...

class InputStreamEncodedMessage(AbstractEncodedMessage):
    """
    public class InputStreamEncodedMessage extends :class:`~org.orekit.gnss.metric.parser.AbstractEncodedMessage`
    
        Encoded message from an input stream.
    
        Since:
            11.0
    """
    def __init__(self, inputStream: java.io.InputStream): ...


class __module_protocol__(Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("org.orekit.gnss.metric.parser")``.

    AbstractEncodedMessage: typing.Type[AbstractEncodedMessage]
    ByteArrayEncodedMessage: typing.Type[ByteArrayEncodedMessage]
    DataField: typing.Type[DataField]
    DataType: typing.Type[DataType]
    EncodedMessage: typing.Type[EncodedMessage]
    HexadecimalSequenceEncodedMessage: typing.Type[HexadecimalSequenceEncodedMessage]
    IgsSsrDataField: typing.Type[IgsSsrDataField]
    IgsSsrMessageType: typing.Type[IgsSsrMessageType]
    IgsSsrMessagesParser: typing.Type[IgsSsrMessagesParser]
    InputStreamEncodedMessage: typing.Type[InputStreamEncodedMessage]
    MessageType: typing.Type[MessageType]
    MessagesParser: typing.Type[MessagesParser]
    RtcmDataField: typing.Type[RtcmDataField]
    RtcmMessageType: typing.Type[RtcmMessageType]
    RtcmMessagesParser: typing.Type[RtcmMessagesParser]
    Units: typing.Type[Units]
