
import sys
if sys.version_info >= (3, 8):
    from typing import Protocol
else:
    from typing_extensions import Protocol

import java
import java.math
import java.util.stream
import jpype
import typing



_RandomGeneratorFactory__T = typing.TypeVar('_RandomGeneratorFactory__T', bound='RandomGenerator')  # <T>
class RandomGeneratorFactory(typing.Generic[_RandomGeneratorFactory__T]):
    @staticmethod
    def all() -> java.util.stream.Stream['RandomGeneratorFactory'['RandomGenerator']]: ...
    @typing.overload
    def create(self) -> _RandomGeneratorFactory__T: ...
    @typing.overload
    def create(self, byteArray: typing.Union[typing.List[int], jpype.JArray, bytes]) -> _RandomGeneratorFactory__T: ...
    @typing.overload
    def create(self, long: int) -> _RandomGeneratorFactory__T: ...
    def equidistribution(self) -> int: ...
    @staticmethod
    def getDefault() -> 'RandomGeneratorFactory'['RandomGenerator']: ...
    def group(self) -> str: ...
    def isArbitrarilyJumpable(self) -> bool: ...
    def isDeprecated(self) -> bool: ...
    def isHardware(self) -> bool: ...
    def isJumpable(self) -> bool: ...
    def isLeapable(self) -> bool: ...
    def isSplittable(self) -> bool: ...
    def isStatistical(self) -> bool: ...
    def isStochastic(self) -> bool: ...
    def isStreamable(self) -> bool: ...
    def name(self) -> str: ...
    _of__T = typing.TypeVar('_of__T', bound='RandomGenerator')  # <T>
    @staticmethod
    def of(string: str) -> 'RandomGeneratorFactory'[_of__T]: ...
    def period(self) -> java.math.BigInteger: ...
    def stateBits(self) -> int: ...

class RandomGenerator:
    @typing.overload
    def doubles(self) -> java.util.stream.DoubleStream: ...
    @typing.overload
    def doubles(self, double: float, double2: float) -> java.util.stream.DoubleStream: ...
    @typing.overload
    def doubles(self, long: int) -> java.util.stream.DoubleStream: ...
    @typing.overload
    def doubles(self, long: int, double: float, double2: float) -> java.util.stream.DoubleStream: ...
    @staticmethod
    def getDefault() -> 'RandomGenerator': ...
    @typing.overload
    def ints(self) -> java.util.stream.IntStream: ...
    @typing.overload
    def ints(self, int: int, int2: int) -> java.util.stream.IntStream: ...
    @typing.overload
    def ints(self, long: int) -> java.util.stream.IntStream: ...
    @typing.overload
    def ints(self, long: int, int: int, int2: int) -> java.util.stream.IntStream: ...
    def isDeprecated(self) -> bool: ...
    @typing.overload
    def longs(self) -> java.util.stream.LongStream: ...
    @typing.overload
    def longs(self, long: int) -> java.util.stream.LongStream: ...
    @typing.overload
    def longs(self, long: int, long2: int) -> java.util.stream.LongStream: ...
    @typing.overload
    def longs(self, long: int, long2: int, long3: int) -> java.util.stream.LongStream: ...
    def nextBoolean(self) -> bool: ...
    def nextBytes(self, byteArray: typing.Union[typing.List[int], jpype.JArray, bytes]) -> None: ...
    @typing.overload
    def nextDouble(self) -> float: ...
    @typing.overload
    def nextDouble(self, double: float) -> float: ...
    @typing.overload
    def nextDouble(self, double: float, double2: float) -> float: ...
    def nextExponential(self) -> float: ...
    @typing.overload
    def nextFloat(self) -> float: ...
    @typing.overload
    def nextFloat(self, float: float) -> float: ...
    @typing.overload
    def nextFloat(self, float: float, float2: float) -> float: ...
    @typing.overload
    def nextGaussian(self) -> float: ...
    @typing.overload
    def nextGaussian(self, double: float, double2: float) -> float: ...
    @typing.overload
    def nextInt(self) -> int: ...
    @typing.overload
    def nextInt(self, int: int) -> int: ...
    @typing.overload
    def nextInt(self, int: int, int2: int) -> int: ...
    @typing.overload
    def nextLong(self) -> int: ...
    @typing.overload
    def nextLong(self, long: int) -> int: ...
    @typing.overload
    def nextLong(self, long: int, long2: int) -> int: ...
    @staticmethod
    def of(string: str) -> 'RandomGenerator': ...
    class ArbitrarilyJumpableGenerator(java.util.random.RandomGenerator.LeapableGenerator):
        def copy(self) -> 'RandomGenerator.ArbitrarilyJumpableGenerator': ...
        @typing.overload
        def copyAndJump(self) -> 'RandomGenerator': ...
        @typing.overload
        def copyAndJump(self, double: float) -> 'RandomGenerator.ArbitrarilyJumpableGenerator': ...
        @typing.overload
        def jump(self, double: float) -> None: ...
        @typing.overload
        def jump(self) -> None: ...
        def jumpPowerOfTwo(self, int: int) -> None: ...
        @typing.overload
        def jumps(self, double: float) -> java.util.stream.Stream['RandomGenerator.ArbitrarilyJumpableGenerator']: ...
        @typing.overload
        def jumps(self, long: int, double: float) -> java.util.stream.Stream['RandomGenerator.ArbitrarilyJumpableGenerator']: ...
        @typing.overload
        def jumps(self) -> java.util.stream.Stream['RandomGenerator']: ...
        @typing.overload
        def jumps(self, long: int) -> java.util.stream.Stream['RandomGenerator']: ...
        def leap(self) -> None: ...
        @staticmethod
        def of(string: str) -> 'RandomGenerator.ArbitrarilyJumpableGenerator': ...
    class JumpableGenerator(java.util.random.RandomGenerator.StreamableGenerator):
        def copy(self) -> 'RandomGenerator.JumpableGenerator': ...
        def copyAndJump(self) -> 'RandomGenerator': ...
        def jump(self) -> None: ...
        def jumpDistance(self) -> float: ...
        @typing.overload
        def jumps(self) -> java.util.stream.Stream['RandomGenerator']: ...
        @typing.overload
        def jumps(self, long: int) -> java.util.stream.Stream['RandomGenerator']: ...
        @staticmethod
        def of(string: str) -> 'RandomGenerator.JumpableGenerator': ...
        @typing.overload
        def rngs(self) -> java.util.stream.Stream['RandomGenerator']: ...
        @typing.overload
        def rngs(self, long: int) -> java.util.stream.Stream['RandomGenerator']: ...
    class LeapableGenerator(java.util.random.RandomGenerator.JumpableGenerator):
        def copy(self) -> 'RandomGenerator.LeapableGenerator': ...
        def copyAndLeap(self) -> 'RandomGenerator.JumpableGenerator': ...
        def leap(self) -> None: ...
        def leapDistance(self) -> float: ...
        @typing.overload
        def leaps(self) -> java.util.stream.Stream['RandomGenerator.JumpableGenerator']: ...
        @typing.overload
        def leaps(self, long: int) -> java.util.stream.Stream['RandomGenerator.JumpableGenerator']: ...
        @staticmethod
        def of(string: str) -> 'RandomGenerator.LeapableGenerator': ...
    class SplittableGenerator(java.util.random.RandomGenerator.StreamableGenerator):
        @staticmethod
        def of(string: str) -> 'RandomGenerator.SplittableGenerator': ...
        @typing.overload
        def rngs(self) -> java.util.stream.Stream['RandomGenerator']: ...
        @typing.overload
        def rngs(self, long: int) -> java.util.stream.Stream['RandomGenerator']: ...
        @typing.overload
        def split(self) -> 'RandomGenerator.SplittableGenerator': ...
        @typing.overload
        def split(self, splittableGenerator: 'RandomGenerator.SplittableGenerator') -> 'RandomGenerator.SplittableGenerator': ...
        @typing.overload
        def splits(self, splittableGenerator: 'RandomGenerator.SplittableGenerator') -> java.util.stream.Stream['RandomGenerator.SplittableGenerator']: ...
        @typing.overload
        def splits(self, long: int) -> java.util.stream.Stream['RandomGenerator.SplittableGenerator']: ...
        @typing.overload
        def splits(self, long: int, splittableGenerator: 'RandomGenerator.SplittableGenerator') -> java.util.stream.Stream['RandomGenerator.SplittableGenerator']: ...
        @typing.overload
        def splits(self) -> java.util.stream.Stream['RandomGenerator.SplittableGenerator']: ...
    class StreamableGenerator(java.util.random.RandomGenerator):
        @staticmethod
        def of(string: str) -> 'RandomGenerator.StreamableGenerator': ...
        @typing.overload
        def rngs(self) -> java.util.stream.Stream['RandomGenerator']: ...
        @typing.overload
        def rngs(self, long: int) -> java.util.stream.Stream['RandomGenerator']: ...


class __module_protocol__(Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("java.util.random")``.

    RandomGenerator: typing.Type[RandomGenerator]
    RandomGeneratorFactory: typing.Type[RandomGeneratorFactory]
