
import sys
if sys.version_info >= (3, 8):
    from typing import Protocol
else:
    from typing_extensions import Protocol

from jpype.protocol import _JDate
from jpype.protocol import _JSQLDate
from jpype.protocol import _JSQLTime
import datetime
import decimal
import java.io
import java.lang
import java.math
import java.net
import java.security
import java.time
import java.util
import java.util.concurrent
import java.util.logging
import java.util.stream
import javax.xml.transform
import jpype
import typing



class Array:
    def free(self) -> None: ...
    @typing.overload
    def getArray(self) -> typing.Any: ...
    @typing.overload
    def getArray(self, map: typing.Union[java.util.Map[str, typing.Type[typing.Any]], typing.Mapping[str, typing.Type[typing.Any]]]) -> typing.Any: ...
    @typing.overload
    def getArray(self, long: int, int: int) -> typing.Any: ...
    @typing.overload
    def getArray(self, long: int, int: int, map: typing.Union[java.util.Map[str, typing.Type[typing.Any]], typing.Mapping[str, typing.Type[typing.Any]]]) -> typing.Any: ...
    def getBaseType(self) -> int: ...
    def getBaseTypeName(self) -> str: ...
    @typing.overload
    def getResultSet(self) -> 'ResultSet': ...
    @typing.overload
    def getResultSet(self, map: typing.Union[java.util.Map[str, typing.Type[typing.Any]], typing.Mapping[str, typing.Type[typing.Any]]]) -> 'ResultSet': ...
    @typing.overload
    def getResultSet(self, long: int, int: int) -> 'ResultSet': ...
    @typing.overload
    def getResultSet(self, long: int, int: int, map: typing.Union[java.util.Map[str, typing.Type[typing.Any]], typing.Mapping[str, typing.Type[typing.Any]]]) -> 'ResultSet': ...

class Blob:
    def free(self) -> None: ...
    @typing.overload
    def getBinaryStream(self) -> java.io.InputStream: ...
    @typing.overload
    def getBinaryStream(self, long: int, long2: int) -> java.io.InputStream: ...
    def getBytes(self, long: int, int: int) -> typing.MutableSequence[int]: ...
    def length(self) -> int: ...
    @typing.overload
    def position(self, byteArray: typing.Union[typing.List[int], jpype.JArray, bytes], long: int) -> int: ...
    @typing.overload
    def position(self, blob: 'Blob', long: int) -> int: ...
    def setBinaryStream(self, long: int) -> java.io.OutputStream: ...
    @typing.overload
    def setBytes(self, long: int, byteArray: typing.Union[typing.List[int], jpype.JArray, bytes]) -> int: ...
    @typing.overload
    def setBytes(self, long: int, byteArray: typing.Union[typing.List[int], jpype.JArray, bytes], int: int, int2: int) -> int: ...
    def truncate(self, long: int) -> None: ...

class ClientInfoStatus(java.lang.Enum['ClientInfoStatus']):
    REASON_UNKNOWN: typing.ClassVar['ClientInfoStatus'] = ...
    REASON_UNKNOWN_PROPERTY: typing.ClassVar['ClientInfoStatus'] = ...
    REASON_VALUE_INVALID: typing.ClassVar['ClientInfoStatus'] = ...
    REASON_VALUE_TRUNCATED: typing.ClassVar['ClientInfoStatus'] = ...
    _valueOf_0__T = typing.TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
    @typing.overload
    @staticmethod
    def valueOf(class_: typing.Type[_valueOf_0__T], string: str) -> _valueOf_0__T: ...
    @typing.overload
    @staticmethod
    def valueOf(string: str) -> 'ClientInfoStatus': ...
    @staticmethod
    def values() -> typing.MutableSequence['ClientInfoStatus']: ...

class Clob:
    def free(self) -> None: ...
    def getAsciiStream(self) -> java.io.InputStream: ...
    @typing.overload
    def getCharacterStream(self) -> java.io.Reader: ...
    @typing.overload
    def getCharacterStream(self, long: int, long2: int) -> java.io.Reader: ...
    def getSubString(self, long: int, int: int) -> str: ...
    def length(self) -> int: ...
    @typing.overload
    def position(self, string: str, long: int) -> int: ...
    @typing.overload
    def position(self, clob: 'Clob', long: int) -> int: ...
    def setAsciiStream(self, long: int) -> java.io.OutputStream: ...
    def setCharacterStream(self, long: int) -> java.io.Writer: ...
    @typing.overload
    def setString(self, long: int, string: str) -> int: ...
    @typing.overload
    def setString(self, long: int, string: str, int: int, int2: int) -> int: ...
    def truncate(self, long: int) -> None: ...

class ConnectionBuilder:
    def build(self) -> 'Connection': ...
    def password(self, string: str) -> 'ConnectionBuilder': ...
    def shardingKey(self, shardingKey: 'ShardingKey') -> 'ConnectionBuilder': ...
    def superShardingKey(self, shardingKey: 'ShardingKey') -> 'ConnectionBuilder': ...
    def user(self, string: str) -> 'ConnectionBuilder': ...

class Date(java.util.Date, _JSQLDate):
    @typing.overload
    def __init__(self, int: int, int2: int, int3: int): ...
    @typing.overload
    def __init__(self, long: int): ...
    def getHours(self) -> int: ...
    def getMinutes(self) -> int: ...
    def getSeconds(self) -> int: ...
    def setHours(self, int: int) -> None: ...
    def setMinutes(self, int: int) -> None: ...
    def setSeconds(self, int: int) -> None: ...
    def setTime(self, long: int) -> None: ...
    def toInstant(self) -> java.time.Instant: ...
    def toLocalDate(self) -> java.time.LocalDate: ...
    def toString(self) -> str: ...
    @typing.overload
    @staticmethod
    def valueOf(string: str) -> 'Date': ...
    @typing.overload
    @staticmethod
    def valueOf(localDate: java.time.LocalDate) -> 'Date': ...

class Driver:
    def acceptsURL(self, string: str) -> bool: ...
    def connect(self, string: str, properties: java.util.Properties) -> 'Connection': ...
    def getMajorVersion(self) -> int: ...
    def getMinorVersion(self) -> int: ...
    def getParentLogger(self) -> java.util.logging.Logger: ...
    def getPropertyInfo(self, string: str, properties: java.util.Properties) -> typing.MutableSequence['DriverPropertyInfo']: ...
    def jdbcCompliant(self) -> bool: ...

class DriverAction:
    def deregister(self) -> None: ...

class DriverManager:
    @staticmethod
    def deregisterDriver(driver: Driver) -> None: ...
    @staticmethod
    def drivers() -> java.util.stream.Stream[Driver]: ...
    @typing.overload
    @staticmethod
    def getConnection(string: str) -> 'Connection': ...
    @typing.overload
    @staticmethod
    def getConnection(string: str, string2: str, string3: str) -> 'Connection': ...
    @typing.overload
    @staticmethod
    def getConnection(string: str, properties: java.util.Properties) -> 'Connection': ...
    @staticmethod
    def getDriver(string: str) -> Driver: ...
    @staticmethod
    def getDrivers() -> java.util.Enumeration[Driver]: ...
    @staticmethod
    def getLogStream() -> java.io.PrintStream: ...
    @staticmethod
    def getLogWriter() -> java.io.PrintWriter: ...
    @staticmethod
    def getLoginTimeout() -> int: ...
    @staticmethod
    def println(string: str) -> None: ...
    @typing.overload
    @staticmethod
    def registerDriver(driver: Driver) -> None: ...
    @typing.overload
    @staticmethod
    def registerDriver(driver: Driver, driverAction: typing.Union[DriverAction, typing.Callable]) -> None: ...
    @staticmethod
    def setLogStream(printStream: java.io.PrintStream) -> None: ...
    @staticmethod
    def setLogWriter(printWriter: java.io.PrintWriter) -> None: ...
    @staticmethod
    def setLoginTimeout(int: int) -> None: ...

class DriverPropertyInfo:
    name: str = ...
    description: str = ...
    required: bool = ...
    value: str = ...
    choices: typing.MutableSequence[str] = ...
    def __init__(self, string: str, string2: str): ...

class PseudoColumnUsage(java.lang.Enum['PseudoColumnUsage']):
    SELECT_LIST_ONLY: typing.ClassVar['PseudoColumnUsage'] = ...
    WHERE_CLAUSE_ONLY: typing.ClassVar['PseudoColumnUsage'] = ...
    NO_USAGE_RESTRICTIONS: typing.ClassVar['PseudoColumnUsage'] = ...
    USAGE_UNKNOWN: typing.ClassVar['PseudoColumnUsage'] = ...
    _valueOf_0__T = typing.TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
    @typing.overload
    @staticmethod
    def valueOf(class_: typing.Type[_valueOf_0__T], string: str) -> _valueOf_0__T: ...
    @typing.overload
    @staticmethod
    def valueOf(string: str) -> 'PseudoColumnUsage': ...
    @staticmethod
    def values() -> typing.MutableSequence['PseudoColumnUsage']: ...

class Ref:
    def getBaseTypeName(self) -> str: ...
    @typing.overload
    def getObject(self) -> typing.Any: ...
    @typing.overload
    def getObject(self, map: typing.Union[java.util.Map[str, typing.Type[typing.Any]], typing.Mapping[str, typing.Type[typing.Any]]]) -> typing.Any: ...
    def setObject(self, object: typing.Any) -> None: ...

class RowId:
    def equals(self, object: typing.Any) -> bool: ...
    def getBytes(self) -> typing.MutableSequence[int]: ...
    def hashCode(self) -> int: ...
    def toString(self) -> str: ...

class RowIdLifetime(java.lang.Enum['RowIdLifetime']):
    ROWID_UNSUPPORTED: typing.ClassVar['RowIdLifetime'] = ...
    ROWID_VALID_OTHER: typing.ClassVar['RowIdLifetime'] = ...
    ROWID_VALID_SESSION: typing.ClassVar['RowIdLifetime'] = ...
    ROWID_VALID_TRANSACTION: typing.ClassVar['RowIdLifetime'] = ...
    ROWID_VALID_FOREVER: typing.ClassVar['RowIdLifetime'] = ...
    _valueOf_0__T = typing.TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
    @typing.overload
    @staticmethod
    def valueOf(class_: typing.Type[_valueOf_0__T], string: str) -> _valueOf_0__T: ...
    @typing.overload
    @staticmethod
    def valueOf(string: str) -> 'RowIdLifetime': ...
    @staticmethod
    def values() -> typing.MutableSequence['RowIdLifetime']: ...

class SQLData:
    def getSQLTypeName(self) -> str: ...
    def readSQL(self, sQLInput: 'SQLInput', string: str) -> None: ...
    def writeSQL(self, sQLOutput: 'SQLOutput') -> None: ...

class SQLException(java.lang.Exception, java.lang.Iterable[java.lang.Throwable]):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str, int: int): ...
    @typing.overload
    def __init__(self, string: str, string2: str, int: int, throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, string: str, string2: str, throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, string: str, throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, throwable: java.lang.Throwable): ...
    def getErrorCode(self) -> int: ...
    def getNextException(self) -> 'SQLException': ...
    def getSQLState(self) -> str: ...
    def iterator(self) -> java.util.Iterator[java.lang.Throwable]: ...
    def setNextException(self, sQLException: 'SQLException') -> None: ...

class SQLInput:
    def readArray(self) -> Array: ...
    def readAsciiStream(self) -> java.io.InputStream: ...
    def readBigDecimal(self) -> java.math.BigDecimal: ...
    def readBinaryStream(self) -> java.io.InputStream: ...
    def readBlob(self) -> Blob: ...
    def readBoolean(self) -> bool: ...
    def readByte(self) -> int: ...
    def readBytes(self) -> typing.MutableSequence[int]: ...
    def readCharacterStream(self) -> java.io.Reader: ...
    def readClob(self) -> Clob: ...
    def readDate(self) -> Date: ...
    def readDouble(self) -> float: ...
    def readFloat(self) -> float: ...
    def readInt(self) -> int: ...
    def readLong(self) -> int: ...
    def readNClob(self) -> 'NClob': ...
    def readNString(self) -> str: ...
    _readObject_1__T = typing.TypeVar('_readObject_1__T')  # <T>
    @typing.overload
    def readObject(self) -> typing.Any: ...
    @typing.overload
    def readObject(self, class_: typing.Type[_readObject_1__T]) -> _readObject_1__T: ...
    def readRef(self) -> Ref: ...
    def readRowId(self) -> RowId: ...
    def readSQLXML(self) -> 'SQLXML': ...
    def readShort(self) -> int: ...
    def readString(self) -> str: ...
    def readTime(self) -> 'Time': ...
    def readTimestamp(self) -> 'Timestamp': ...
    def readURL(self) -> java.net.URL: ...
    def wasNull(self) -> bool: ...

class SQLOutput:
    def writeArray(self, array: Array) -> None: ...
    def writeAsciiStream(self, inputStream: java.io.InputStream) -> None: ...
    def writeBigDecimal(self, bigDecimal: typing.Union[java.math.BigDecimal, decimal.Decimal]) -> None: ...
    def writeBinaryStream(self, inputStream: java.io.InputStream) -> None: ...
    def writeBlob(self, blob: Blob) -> None: ...
    def writeBoolean(self, boolean: bool) -> None: ...
    def writeByte(self, byte: int) -> None: ...
    def writeBytes(self, byteArray: typing.Union[typing.List[int], jpype.JArray, bytes]) -> None: ...
    def writeCharacterStream(self, reader: java.io.Reader) -> None: ...
    def writeClob(self, clob: Clob) -> None: ...
    def writeDate(self, date: typing.Union[Date, datetime.date]) -> None: ...
    def writeDouble(self, double: float) -> None: ...
    def writeFloat(self, float: float) -> None: ...
    def writeInt(self, int: int) -> None: ...
    def writeLong(self, long: int) -> None: ...
    def writeNClob(self, nClob: 'NClob') -> None: ...
    def writeNString(self, string: str) -> None: ...
    @typing.overload
    def writeObject(self, sQLData: SQLData) -> None: ...
    @typing.overload
    def writeObject(self, object: typing.Any, sQLType: 'SQLType') -> None: ...
    def writeRef(self, ref: Ref) -> None: ...
    def writeRowId(self, rowId: typing.Union[RowId, typing.Callable]) -> None: ...
    def writeSQLXML(self, sQLXML: 'SQLXML') -> None: ...
    def writeShort(self, short: int) -> None: ...
    def writeString(self, string: str) -> None: ...
    def writeStruct(self, struct: 'Struct') -> None: ...
    def writeTime(self, time: typing.Union['Time', datetime.time]) -> None: ...
    def writeTimestamp(self, timestamp: typing.Union['Timestamp', datetime.datetime]) -> None: ...
    def writeURL(self, uRL: java.net.URL) -> None: ...

class SQLPermission(java.security.BasicPermission):
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str): ...

class SQLType:
    def getName(self) -> str: ...
    def getVendor(self) -> str: ...
    def getVendorTypeNumber(self) -> int: ...

class SQLXML:
    def free(self) -> None: ...
    def getBinaryStream(self) -> java.io.InputStream: ...
    def getCharacterStream(self) -> java.io.Reader: ...
    _getSource__T = typing.TypeVar('_getSource__T', bound=javax.xml.transform.Source)  # <T>
    def getSource(self, class_: typing.Type[_getSource__T]) -> _getSource__T: ...
    def getString(self) -> str: ...
    def setBinaryStream(self) -> java.io.OutputStream: ...
    def setCharacterStream(self) -> java.io.Writer: ...
    _setResult__T = typing.TypeVar('_setResult__T', bound=javax.xml.transform.Result)  # <T>
    def setResult(self, class_: typing.Type[_setResult__T]) -> _setResult__T: ...
    def setString(self, string: str) -> None: ...

class Savepoint:
    def getSavepointId(self) -> int: ...
    def getSavepointName(self) -> str: ...

class ShardingKey: ...

class ShardingKeyBuilder:
    def build(self) -> ShardingKey: ...
    def subkey(self, object: typing.Any, sQLType: SQLType) -> 'ShardingKeyBuilder': ...

class Struct:
    @typing.overload
    def getAttributes(self) -> typing.MutableSequence[typing.Any]: ...
    @typing.overload
    def getAttributes(self, map: typing.Union[java.util.Map[str, typing.Type[typing.Any]], typing.Mapping[str, typing.Type[typing.Any]]]) -> typing.MutableSequence[typing.Any]: ...
    def getSQLTypeName(self) -> str: ...

class Time(java.util.Date, _JSQLTime):
    @typing.overload
    def __init__(self, int: int, int2: int, int3: int): ...
    @typing.overload
    def __init__(self, long: int): ...
    def getDate(self) -> int: ...
    def getDay(self) -> int: ...
    def getMonth(self) -> int: ...
    def getYear(self) -> int: ...
    def setDate(self, int: int) -> None: ...
    def setMonth(self, int: int) -> None: ...
    def setTime(self, long: int) -> None: ...
    def setYear(self, int: int) -> None: ...
    def toInstant(self) -> java.time.Instant: ...
    def toLocalTime(self) -> java.time.LocalTime: ...
    def toString(self) -> str: ...
    @typing.overload
    @staticmethod
    def valueOf(string: str) -> 'Time': ...
    @typing.overload
    @staticmethod
    def valueOf(localTime: java.time.LocalTime) -> 'Time': ...

class Timestamp(java.util.Date, _JDate):
    @typing.overload
    def __init__(self, int: int, int2: int, int3: int, int4: int, int5: int, int6: int, int7: int): ...
    @typing.overload
    def __init__(self, long: int): ...
    @typing.overload
    def after(self, timestamp: typing.Union['Timestamp', datetime.datetime]) -> bool: ...
    @typing.overload
    def after(self, date: java.util.Date) -> bool: ...
    @typing.overload
    def before(self, timestamp: typing.Union['Timestamp', datetime.datetime]) -> bool: ...
    @typing.overload
    def before(self, date: java.util.Date) -> bool: ...
    @typing.overload
    def compareTo(self, timestamp: typing.Union['Timestamp', datetime.datetime]) -> int: ...
    @typing.overload
    def compareTo(self, date: java.util.Date) -> int: ...
    @typing.overload
    def equals(self, object: typing.Any) -> bool: ...
    @typing.overload
    def equals(self, timestamp: typing.Union['Timestamp', datetime.datetime]) -> bool: ...
    @typing.overload
    @staticmethod
    def from_(instant: typing.Union[java.time.Instant, datetime.datetime]) -> 'Timestamp': ...
    @typing.overload
    @staticmethod
    def from_(instant: typing.Union[java.time.Instant, datetime.datetime]) -> java.util.Date: ...
    def getNanos(self) -> int: ...
    def getTime(self) -> int: ...
    def hashCode(self) -> int: ...
    def setNanos(self, int: int) -> None: ...
    def setTime(self, long: int) -> None: ...
    def toInstant(self) -> java.time.Instant: ...
    def toLocalDateTime(self) -> java.time.LocalDateTime: ...
    def toString(self) -> str: ...
    @typing.overload
    @staticmethod
    def valueOf(string: str) -> 'Timestamp': ...
    @typing.overload
    @staticmethod
    def valueOf(localDateTime: java.time.LocalDateTime) -> 'Timestamp': ...

class Types:
    BIT: typing.ClassVar[int] = ...
    TINYINT: typing.ClassVar[int] = ...
    SMALLINT: typing.ClassVar[int] = ...
    INTEGER: typing.ClassVar[int] = ...
    BIGINT: typing.ClassVar[int] = ...
    FLOAT: typing.ClassVar[int] = ...
    REAL: typing.ClassVar[int] = ...
    DOUBLE: typing.ClassVar[int] = ...
    NUMERIC: typing.ClassVar[int] = ...
    DECIMAL: typing.ClassVar[int] = ...
    CHAR: typing.ClassVar[int] = ...
    VARCHAR: typing.ClassVar[int] = ...
    LONGVARCHAR: typing.ClassVar[int] = ...
    DATE: typing.ClassVar[int] = ...
    TIME: typing.ClassVar[int] = ...
    TIMESTAMP: typing.ClassVar[int] = ...
    BINARY: typing.ClassVar[int] = ...
    VARBINARY: typing.ClassVar[int] = ...
    LONGVARBINARY: typing.ClassVar[int] = ...
    NULL: typing.ClassVar[int] = ...
    OTHER: typing.ClassVar[int] = ...
    JAVA_OBJECT: typing.ClassVar[int] = ...
    DISTINCT: typing.ClassVar[int] = ...
    STRUCT: typing.ClassVar[int] = ...
    ARRAY: typing.ClassVar[int] = ...
    BLOB: typing.ClassVar[int] = ...
    CLOB: typing.ClassVar[int] = ...
    REF: typing.ClassVar[int] = ...
    DATALINK: typing.ClassVar[int] = ...
    BOOLEAN: typing.ClassVar[int] = ...
    ROWID: typing.ClassVar[int] = ...
    NCHAR: typing.ClassVar[int] = ...
    NVARCHAR: typing.ClassVar[int] = ...
    LONGNVARCHAR: typing.ClassVar[int] = ...
    NCLOB: typing.ClassVar[int] = ...
    SQLXML: typing.ClassVar[int] = ...
    REF_CURSOR: typing.ClassVar[int] = ...
    TIME_WITH_TIMEZONE: typing.ClassVar[int] = ...
    TIMESTAMP_WITH_TIMEZONE: typing.ClassVar[int] = ...

class Wrapper:
    def isWrapperFor(self, class_: typing.Type[typing.Any]) -> bool: ...
    _unwrap__T = typing.TypeVar('_unwrap__T')  # <T>
    def unwrap(self, class_: typing.Type[_unwrap__T]) -> _unwrap__T: ...

class BatchUpdateException(SQLException):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, intArray: typing.Union[typing.List[int], jpype.JArray]): ...
    @typing.overload
    def __init__(self, intArray: typing.Union[typing.List[int], jpype.JArray], throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, string: str, intArray: typing.Union[typing.List[int], jpype.JArray]): ...
    @typing.overload
    def __init__(self, string: str, intArray: typing.Union[typing.List[int], jpype.JArray], throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, string: str, string2: str, int: int, intArray: typing.Union[typing.List[int], jpype.JArray]): ...
    @typing.overload
    def __init__(self, string: str, string2: str, int: int, intArray: typing.Union[typing.List[int], jpype.JArray], throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, string: str, string2: str, int: int, longArray: typing.Union[typing.List[int], jpype.JArray], throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, string: str, string2: str, intArray: typing.Union[typing.List[int], jpype.JArray]): ...
    @typing.overload
    def __init__(self, string: str, string2: str, intArray: typing.Union[typing.List[int], jpype.JArray], throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, throwable: java.lang.Throwable): ...
    def getLargeUpdateCounts(self) -> typing.MutableSequence[int]: ...
    def getUpdateCounts(self) -> typing.MutableSequence[int]: ...

class Connection(Wrapper, java.lang.AutoCloseable):
    TRANSACTION_NONE: typing.ClassVar[int] = ...
    TRANSACTION_READ_UNCOMMITTED: typing.ClassVar[int] = ...
    TRANSACTION_READ_COMMITTED: typing.ClassVar[int] = ...
    TRANSACTION_REPEATABLE_READ: typing.ClassVar[int] = ...
    TRANSACTION_SERIALIZABLE: typing.ClassVar[int] = ...
    def abort(self, executor: typing.Union[java.util.concurrent.Executor, typing.Callable]) -> None: ...
    def beginRequest(self) -> None: ...
    def clearWarnings(self) -> None: ...
    def close(self) -> None: ...
    def commit(self) -> None: ...
    def createArrayOf(self, string: str, objectArray: typing.Union[typing.List[typing.Any], jpype.JArray]) -> Array: ...
    def createBlob(self) -> Blob: ...
    def createClob(self) -> Clob: ...
    def createNClob(self) -> 'NClob': ...
    def createSQLXML(self) -> SQLXML: ...
    @typing.overload
    def createStatement(self) -> 'Statement': ...
    @typing.overload
    def createStatement(self, int: int, int2: int) -> 'Statement': ...
    @typing.overload
    def createStatement(self, int: int, int2: int, int3: int) -> 'Statement': ...
    def createStruct(self, string: str, objectArray: typing.Union[typing.List[typing.Any], jpype.JArray]) -> Struct: ...
    def endRequest(self) -> None: ...
    def getAutoCommit(self) -> bool: ...
    def getCatalog(self) -> str: ...
    @typing.overload
    def getClientInfo(self, string: str) -> str: ...
    @typing.overload
    def getClientInfo(self) -> java.util.Properties: ...
    def getHoldability(self) -> int: ...
    def getMetaData(self) -> 'DatabaseMetaData': ...
    def getNetworkTimeout(self) -> int: ...
    def getSchema(self) -> str: ...
    def getTransactionIsolation(self) -> int: ...
    def getTypeMap(self) -> java.util.Map[str, typing.Type[typing.Any]]: ...
    def getWarnings(self) -> 'SQLWarning': ...
    def isClosed(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def isValid(self, int: int) -> bool: ...
    def nativeSQL(self, string: str) -> str: ...
    @typing.overload
    def prepareCall(self, string: str) -> 'CallableStatement': ...
    @typing.overload
    def prepareCall(self, string: str, int: int, int2: int) -> 'CallableStatement': ...
    @typing.overload
    def prepareCall(self, string: str, int: int, int2: int, int3: int) -> 'CallableStatement': ...
    @typing.overload
    def prepareStatement(self, string: str) -> 'PreparedStatement': ...
    @typing.overload
    def prepareStatement(self, string: str, int: int) -> 'PreparedStatement': ...
    @typing.overload
    def prepareStatement(self, string: str, int: int, int2: int) -> 'PreparedStatement': ...
    @typing.overload
    def prepareStatement(self, string: str, int: int, int2: int, int3: int) -> 'PreparedStatement': ...
    @typing.overload
    def prepareStatement(self, string: str, intArray: typing.Union[typing.List[int], jpype.JArray]) -> 'PreparedStatement': ...
    @typing.overload
    def prepareStatement(self, string: str, stringArray: typing.Union[typing.List[str], jpype.JArray]) -> 'PreparedStatement': ...
    def releaseSavepoint(self, savepoint: Savepoint) -> None: ...
    @typing.overload
    def rollback(self) -> None: ...
    @typing.overload
    def rollback(self, savepoint: Savepoint) -> None: ...
    def setAutoCommit(self, boolean: bool) -> None: ...
    def setCatalog(self, string: str) -> None: ...
    @typing.overload
    def setClientInfo(self, string: str, string2: str) -> None: ...
    @typing.overload
    def setClientInfo(self, properties: java.util.Properties) -> None: ...
    def setHoldability(self, int: int) -> None: ...
    def setNetworkTimeout(self, executor: typing.Union[java.util.concurrent.Executor, typing.Callable], int: int) -> None: ...
    def setReadOnly(self, boolean: bool) -> None: ...
    @typing.overload
    def setSavepoint(self) -> Savepoint: ...
    @typing.overload
    def setSavepoint(self, string: str) -> Savepoint: ...
    def setSchema(self, string: str) -> None: ...
    @typing.overload
    def setShardingKey(self, shardingKey: ShardingKey) -> None: ...
    @typing.overload
    def setShardingKey(self, shardingKey: ShardingKey, shardingKey2: ShardingKey) -> None: ...
    @typing.overload
    def setShardingKeyIfValid(self, shardingKey: ShardingKey, int: int) -> bool: ...
    @typing.overload
    def setShardingKeyIfValid(self, shardingKey: ShardingKey, shardingKey2: ShardingKey, int: int) -> bool: ...
    def setTransactionIsolation(self, int: int) -> None: ...
    def setTypeMap(self, map: typing.Union[java.util.Map[str, typing.Type[typing.Any]], typing.Mapping[str, typing.Type[typing.Any]]]) -> None: ...

class DatabaseMetaData(Wrapper):
    procedureResultUnknown: typing.ClassVar[int] = ...
    procedureNoResult: typing.ClassVar[int] = ...
    procedureReturnsResult: typing.ClassVar[int] = ...
    procedureColumnUnknown: typing.ClassVar[int] = ...
    procedureColumnIn: typing.ClassVar[int] = ...
    procedureColumnInOut: typing.ClassVar[int] = ...
    procedureColumnOut: typing.ClassVar[int] = ...
    procedureColumnReturn: typing.ClassVar[int] = ...
    procedureColumnResult: typing.ClassVar[int] = ...
    procedureNoNulls: typing.ClassVar[int] = ...
    procedureNullable: typing.ClassVar[int] = ...
    procedureNullableUnknown: typing.ClassVar[int] = ...
    columnNoNulls: typing.ClassVar[int] = ...
    columnNullable: typing.ClassVar[int] = ...
    columnNullableUnknown: typing.ClassVar[int] = ...
    bestRowTemporary: typing.ClassVar[int] = ...
    bestRowTransaction: typing.ClassVar[int] = ...
    bestRowSession: typing.ClassVar[int] = ...
    bestRowUnknown: typing.ClassVar[int] = ...
    bestRowNotPseudo: typing.ClassVar[int] = ...
    bestRowPseudo: typing.ClassVar[int] = ...
    versionColumnUnknown: typing.ClassVar[int] = ...
    versionColumnNotPseudo: typing.ClassVar[int] = ...
    versionColumnPseudo: typing.ClassVar[int] = ...
    importedKeyCascade: typing.ClassVar[int] = ...
    importedKeyRestrict: typing.ClassVar[int] = ...
    importedKeySetNull: typing.ClassVar[int] = ...
    importedKeyNoAction: typing.ClassVar[int] = ...
    importedKeySetDefault: typing.ClassVar[int] = ...
    importedKeyInitiallyDeferred: typing.ClassVar[int] = ...
    importedKeyInitiallyImmediate: typing.ClassVar[int] = ...
    importedKeyNotDeferrable: typing.ClassVar[int] = ...
    typeNoNulls: typing.ClassVar[int] = ...
    typeNullable: typing.ClassVar[int] = ...
    typeNullableUnknown: typing.ClassVar[int] = ...
    typePredNone: typing.ClassVar[int] = ...
    typePredChar: typing.ClassVar[int] = ...
    typePredBasic: typing.ClassVar[int] = ...
    typeSearchable: typing.ClassVar[int] = ...
    tableIndexStatistic: typing.ClassVar[int] = ...
    tableIndexClustered: typing.ClassVar[int] = ...
    tableIndexHashed: typing.ClassVar[int] = ...
    tableIndexOther: typing.ClassVar[int] = ...
    attributeNoNulls: typing.ClassVar[int] = ...
    attributeNullable: typing.ClassVar[int] = ...
    attributeNullableUnknown: typing.ClassVar[int] = ...
    sqlStateXOpen: typing.ClassVar[int] = ...
    sqlStateSQL: typing.ClassVar[int] = ...
    sqlStateSQL99: typing.ClassVar[int] = ...
    functionColumnUnknown: typing.ClassVar[int] = ...
    functionColumnIn: typing.ClassVar[int] = ...
    functionColumnInOut: typing.ClassVar[int] = ...
    functionColumnOut: typing.ClassVar[int] = ...
    functionReturn: typing.ClassVar[int] = ...
    functionColumnResult: typing.ClassVar[int] = ...
    functionNoNulls: typing.ClassVar[int] = ...
    functionNullable: typing.ClassVar[int] = ...
    functionNullableUnknown: typing.ClassVar[int] = ...
    functionResultUnknown: typing.ClassVar[int] = ...
    functionNoTable: typing.ClassVar[int] = ...
    functionReturnsTable: typing.ClassVar[int] = ...
    def allProceduresAreCallable(self) -> bool: ...
    def allTablesAreSelectable(self) -> bool: ...
    def autoCommitFailureClosesAllResultSets(self) -> bool: ...
    def dataDefinitionCausesTransactionCommit(self) -> bool: ...
    def dataDefinitionIgnoredInTransactions(self) -> bool: ...
    def deletesAreDetected(self, int: int) -> bool: ...
    def doesMaxRowSizeIncludeBlobs(self) -> bool: ...
    def generatedKeyAlwaysReturned(self) -> bool: ...
    def getAttributes(self, string: str, string2: str, string3: str, string4: str) -> 'ResultSet': ...
    def getBestRowIdentifier(self, string: str, string2: str, string3: str, int: int, boolean: bool) -> 'ResultSet': ...
    def getCatalogSeparator(self) -> str: ...
    def getCatalogTerm(self) -> str: ...
    def getCatalogs(self) -> 'ResultSet': ...
    def getClientInfoProperties(self) -> 'ResultSet': ...
    def getColumnPrivileges(self, string: str, string2: str, string3: str, string4: str) -> 'ResultSet': ...
    def getColumns(self, string: str, string2: str, string3: str, string4: str) -> 'ResultSet': ...
    def getConnection(self) -> Connection: ...
    def getCrossReference(self, string: str, string2: str, string3: str, string4: str, string5: str, string6: str) -> 'ResultSet': ...
    def getDatabaseMajorVersion(self) -> int: ...
    def getDatabaseMinorVersion(self) -> int: ...
    def getDatabaseProductName(self) -> str: ...
    def getDatabaseProductVersion(self) -> str: ...
    def getDefaultTransactionIsolation(self) -> int: ...
    def getDriverMajorVersion(self) -> int: ...
    def getDriverMinorVersion(self) -> int: ...
    def getDriverName(self) -> str: ...
    def getDriverVersion(self) -> str: ...
    def getExportedKeys(self, string: str, string2: str, string3: str) -> 'ResultSet': ...
    def getExtraNameCharacters(self) -> str: ...
    def getFunctionColumns(self, string: str, string2: str, string3: str, string4: str) -> 'ResultSet': ...
    def getFunctions(self, string: str, string2: str, string3: str) -> 'ResultSet': ...
    def getIdentifierQuoteString(self) -> str: ...
    def getImportedKeys(self, string: str, string2: str, string3: str) -> 'ResultSet': ...
    def getIndexInfo(self, string: str, string2: str, string3: str, boolean: bool, boolean2: bool) -> 'ResultSet': ...
    def getJDBCMajorVersion(self) -> int: ...
    def getJDBCMinorVersion(self) -> int: ...
    def getMaxBinaryLiteralLength(self) -> int: ...
    def getMaxCatalogNameLength(self) -> int: ...
    def getMaxCharLiteralLength(self) -> int: ...
    def getMaxColumnNameLength(self) -> int: ...
    def getMaxColumnsInGroupBy(self) -> int: ...
    def getMaxColumnsInIndex(self) -> int: ...
    def getMaxColumnsInOrderBy(self) -> int: ...
    def getMaxColumnsInSelect(self) -> int: ...
    def getMaxColumnsInTable(self) -> int: ...
    def getMaxConnections(self) -> int: ...
    def getMaxCursorNameLength(self) -> int: ...
    def getMaxIndexLength(self) -> int: ...
    def getMaxLogicalLobSize(self) -> int: ...
    def getMaxProcedureNameLength(self) -> int: ...
    def getMaxRowSize(self) -> int: ...
    def getMaxSchemaNameLength(self) -> int: ...
    def getMaxStatementLength(self) -> int: ...
    def getMaxStatements(self) -> int: ...
    def getMaxTableNameLength(self) -> int: ...
    def getMaxTablesInSelect(self) -> int: ...
    def getMaxUserNameLength(self) -> int: ...
    def getNumericFunctions(self) -> str: ...
    def getPrimaryKeys(self, string: str, string2: str, string3: str) -> 'ResultSet': ...
    def getProcedureColumns(self, string: str, string2: str, string3: str, string4: str) -> 'ResultSet': ...
    def getProcedureTerm(self) -> str: ...
    def getProcedures(self, string: str, string2: str, string3: str) -> 'ResultSet': ...
    def getPseudoColumns(self, string: str, string2: str, string3: str, string4: str) -> 'ResultSet': ...
    def getResultSetHoldability(self) -> int: ...
    def getRowIdLifetime(self) -> RowIdLifetime: ...
    def getSQLKeywords(self) -> str: ...
    def getSQLStateType(self) -> int: ...
    def getSchemaTerm(self) -> str: ...
    @typing.overload
    def getSchemas(self) -> 'ResultSet': ...
    @typing.overload
    def getSchemas(self, string: str, string2: str) -> 'ResultSet': ...
    def getSearchStringEscape(self) -> str: ...
    def getStringFunctions(self) -> str: ...
    def getSuperTables(self, string: str, string2: str, string3: str) -> 'ResultSet': ...
    def getSuperTypes(self, string: str, string2: str, string3: str) -> 'ResultSet': ...
    def getSystemFunctions(self) -> str: ...
    def getTablePrivileges(self, string: str, string2: str, string3: str) -> 'ResultSet': ...
    def getTableTypes(self) -> 'ResultSet': ...
    def getTables(self, string: str, string2: str, string3: str, stringArray: typing.Union[typing.List[str], jpype.JArray]) -> 'ResultSet': ...
    def getTimeDateFunctions(self) -> str: ...
    def getTypeInfo(self) -> 'ResultSet': ...
    def getUDTs(self, string: str, string2: str, string3: str, intArray: typing.Union[typing.List[int], jpype.JArray]) -> 'ResultSet': ...
    def getURL(self) -> str: ...
    def getUserName(self) -> str: ...
    def getVersionColumns(self, string: str, string2: str, string3: str) -> 'ResultSet': ...
    def insertsAreDetected(self, int: int) -> bool: ...
    def isCatalogAtStart(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def locatorsUpdateCopy(self) -> bool: ...
    def nullPlusNonNullIsNull(self) -> bool: ...
    def nullsAreSortedAtEnd(self) -> bool: ...
    def nullsAreSortedAtStart(self) -> bool: ...
    def nullsAreSortedHigh(self) -> bool: ...
    def nullsAreSortedLow(self) -> bool: ...
    def othersDeletesAreVisible(self, int: int) -> bool: ...
    def othersInsertsAreVisible(self, int: int) -> bool: ...
    def othersUpdatesAreVisible(self, int: int) -> bool: ...
    def ownDeletesAreVisible(self, int: int) -> bool: ...
    def ownInsertsAreVisible(self, int: int) -> bool: ...
    def ownUpdatesAreVisible(self, int: int) -> bool: ...
    def storesLowerCaseIdentifiers(self) -> bool: ...
    def storesLowerCaseQuotedIdentifiers(self) -> bool: ...
    def storesMixedCaseIdentifiers(self) -> bool: ...
    def storesMixedCaseQuotedIdentifiers(self) -> bool: ...
    def storesUpperCaseIdentifiers(self) -> bool: ...
    def storesUpperCaseQuotedIdentifiers(self) -> bool: ...
    def supportsANSI92EntryLevelSQL(self) -> bool: ...
    def supportsANSI92FullSQL(self) -> bool: ...
    def supportsANSI92IntermediateSQL(self) -> bool: ...
    def supportsAlterTableWithAddColumn(self) -> bool: ...
    def supportsAlterTableWithDropColumn(self) -> bool: ...
    def supportsBatchUpdates(self) -> bool: ...
    def supportsCatalogsInDataManipulation(self) -> bool: ...
    def supportsCatalogsInIndexDefinitions(self) -> bool: ...
    def supportsCatalogsInPrivilegeDefinitions(self) -> bool: ...
    def supportsCatalogsInProcedureCalls(self) -> bool: ...
    def supportsCatalogsInTableDefinitions(self) -> bool: ...
    def supportsColumnAliasing(self) -> bool: ...
    @typing.overload
    def supportsConvert(self) -> bool: ...
    @typing.overload
    def supportsConvert(self, int: int, int2: int) -> bool: ...
    def supportsCoreSQLGrammar(self) -> bool: ...
    def supportsCorrelatedSubqueries(self) -> bool: ...
    def supportsDataDefinitionAndDataManipulationTransactions(self) -> bool: ...
    def supportsDataManipulationTransactionsOnly(self) -> bool: ...
    def supportsDifferentTableCorrelationNames(self) -> bool: ...
    def supportsExpressionsInOrderBy(self) -> bool: ...
    def supportsExtendedSQLGrammar(self) -> bool: ...
    def supportsFullOuterJoins(self) -> bool: ...
    def supportsGetGeneratedKeys(self) -> bool: ...
    def supportsGroupBy(self) -> bool: ...
    def supportsGroupByBeyondSelect(self) -> bool: ...
    def supportsGroupByUnrelated(self) -> bool: ...
    def supportsIntegrityEnhancementFacility(self) -> bool: ...
    def supportsLikeEscapeClause(self) -> bool: ...
    def supportsLimitedOuterJoins(self) -> bool: ...
    def supportsMinimumSQLGrammar(self) -> bool: ...
    def supportsMixedCaseIdentifiers(self) -> bool: ...
    def supportsMixedCaseQuotedIdentifiers(self) -> bool: ...
    def supportsMultipleOpenResults(self) -> bool: ...
    def supportsMultipleResultSets(self) -> bool: ...
    def supportsMultipleTransactions(self) -> bool: ...
    def supportsNamedParameters(self) -> bool: ...
    def supportsNonNullableColumns(self) -> bool: ...
    def supportsOpenCursorsAcrossCommit(self) -> bool: ...
    def supportsOpenCursorsAcrossRollback(self) -> bool: ...
    def supportsOpenStatementsAcrossCommit(self) -> bool: ...
    def supportsOpenStatementsAcrossRollback(self) -> bool: ...
    def supportsOrderByUnrelated(self) -> bool: ...
    def supportsOuterJoins(self) -> bool: ...
    def supportsPositionedDelete(self) -> bool: ...
    def supportsPositionedUpdate(self) -> bool: ...
    def supportsRefCursors(self) -> bool: ...
    def supportsResultSetConcurrency(self, int: int, int2: int) -> bool: ...
    def supportsResultSetHoldability(self, int: int) -> bool: ...
    def supportsResultSetType(self, int: int) -> bool: ...
    def supportsSavepoints(self) -> bool: ...
    def supportsSchemasInDataManipulation(self) -> bool: ...
    def supportsSchemasInIndexDefinitions(self) -> bool: ...
    def supportsSchemasInPrivilegeDefinitions(self) -> bool: ...
    def supportsSchemasInProcedureCalls(self) -> bool: ...
    def supportsSchemasInTableDefinitions(self) -> bool: ...
    def supportsSelectForUpdate(self) -> bool: ...
    def supportsSharding(self) -> bool: ...
    def supportsStatementPooling(self) -> bool: ...
    def supportsStoredFunctionsUsingCallSyntax(self) -> bool: ...
    def supportsStoredProcedures(self) -> bool: ...
    def supportsSubqueriesInComparisons(self) -> bool: ...
    def supportsSubqueriesInExists(self) -> bool: ...
    def supportsSubqueriesInIns(self) -> bool: ...
    def supportsSubqueriesInQuantifieds(self) -> bool: ...
    def supportsTableCorrelationNames(self) -> bool: ...
    def supportsTransactionIsolationLevel(self, int: int) -> bool: ...
    def supportsTransactions(self) -> bool: ...
    def supportsUnion(self) -> bool: ...
    def supportsUnionAll(self) -> bool: ...
    def updatesAreDetected(self, int: int) -> bool: ...
    def usesLocalFilePerTable(self) -> bool: ...
    def usesLocalFiles(self) -> bool: ...

class JDBCType(java.lang.Enum['JDBCType'], SQLType):
    BIT: typing.ClassVar['JDBCType'] = ...
    TINYINT: typing.ClassVar['JDBCType'] = ...
    SMALLINT: typing.ClassVar['JDBCType'] = ...
    INTEGER: typing.ClassVar['JDBCType'] = ...
    BIGINT: typing.ClassVar['JDBCType'] = ...
    FLOAT: typing.ClassVar['JDBCType'] = ...
    REAL: typing.ClassVar['JDBCType'] = ...
    DOUBLE: typing.ClassVar['JDBCType'] = ...
    NUMERIC: typing.ClassVar['JDBCType'] = ...
    DECIMAL: typing.ClassVar['JDBCType'] = ...
    CHAR: typing.ClassVar['JDBCType'] = ...
    VARCHAR: typing.ClassVar['JDBCType'] = ...
    LONGVARCHAR: typing.ClassVar['JDBCType'] = ...
    DATE: typing.ClassVar['JDBCType'] = ...
    TIME: typing.ClassVar['JDBCType'] = ...
    TIMESTAMP: typing.ClassVar['JDBCType'] = ...
    BINARY: typing.ClassVar['JDBCType'] = ...
    VARBINARY: typing.ClassVar['JDBCType'] = ...
    LONGVARBINARY: typing.ClassVar['JDBCType'] = ...
    NULL: typing.ClassVar['JDBCType'] = ...
    OTHER: typing.ClassVar['JDBCType'] = ...
    JAVA_OBJECT: typing.ClassVar['JDBCType'] = ...
    DISTINCT: typing.ClassVar['JDBCType'] = ...
    STRUCT: typing.ClassVar['JDBCType'] = ...
    ARRAY: typing.ClassVar['JDBCType'] = ...
    BLOB: typing.ClassVar['JDBCType'] = ...
    CLOB: typing.ClassVar['JDBCType'] = ...
    REF: typing.ClassVar['JDBCType'] = ...
    DATALINK: typing.ClassVar['JDBCType'] = ...
    BOOLEAN: typing.ClassVar['JDBCType'] = ...
    ROWID: typing.ClassVar['JDBCType'] = ...
    NCHAR: typing.ClassVar['JDBCType'] = ...
    NVARCHAR: typing.ClassVar['JDBCType'] = ...
    LONGNVARCHAR: typing.ClassVar['JDBCType'] = ...
    NCLOB: typing.ClassVar['JDBCType'] = ...
    SQLXML: typing.ClassVar['JDBCType'] = ...
    REF_CURSOR: typing.ClassVar['JDBCType'] = ...
    TIME_WITH_TIMEZONE: typing.ClassVar['JDBCType'] = ...
    TIMESTAMP_WITH_TIMEZONE: typing.ClassVar['JDBCType'] = ...
    def getName(self) -> str: ...
    def getVendor(self) -> str: ...
    def getVendorTypeNumber(self) -> int: ...
    _valueOf_0__T = typing.TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
    @typing.overload
    @staticmethod
    def valueOf(class_: typing.Type[_valueOf_0__T], string: str) -> _valueOf_0__T: ...
    @typing.overload
    @staticmethod
    def valueOf(int: int) -> 'JDBCType': ...
    @typing.overload
    @staticmethod
    def valueOf(string: str) -> 'JDBCType': ...
    @staticmethod
    def values() -> typing.MutableSequence['JDBCType']: ...

class NClob(Clob): ...

class ParameterMetaData(Wrapper):
    parameterNoNulls: typing.ClassVar[int] = ...
    parameterNullable: typing.ClassVar[int] = ...
    parameterNullableUnknown: typing.ClassVar[int] = ...
    parameterModeUnknown: typing.ClassVar[int] = ...
    parameterModeIn: typing.ClassVar[int] = ...
    parameterModeInOut: typing.ClassVar[int] = ...
    parameterModeOut: typing.ClassVar[int] = ...
    def getParameterClassName(self, int: int) -> str: ...
    def getParameterCount(self) -> int: ...
    def getParameterMode(self, int: int) -> int: ...
    def getParameterType(self, int: int) -> int: ...
    def getParameterTypeName(self, int: int) -> str: ...
    def getPrecision(self, int: int) -> int: ...
    def getScale(self, int: int) -> int: ...
    def isNullable(self, int: int) -> int: ...
    def isSigned(self, int: int) -> bool: ...

class ResultSet(Wrapper, java.lang.AutoCloseable):
    FETCH_FORWARD: typing.ClassVar[int] = ...
    FETCH_REVERSE: typing.ClassVar[int] = ...
    FETCH_UNKNOWN: typing.ClassVar[int] = ...
    TYPE_FORWARD_ONLY: typing.ClassVar[int] = ...
    TYPE_SCROLL_INSENSITIVE: typing.ClassVar[int] = ...
    TYPE_SCROLL_SENSITIVE: typing.ClassVar[int] = ...
    CONCUR_READ_ONLY: typing.ClassVar[int] = ...
    CONCUR_UPDATABLE: typing.ClassVar[int] = ...
    HOLD_CURSORS_OVER_COMMIT: typing.ClassVar[int] = ...
    CLOSE_CURSORS_AT_COMMIT: typing.ClassVar[int] = ...
    def absolute(self, int: int) -> bool: ...
    def afterLast(self) -> None: ...
    def beforeFirst(self) -> None: ...
    def cancelRowUpdates(self) -> None: ...
    def clearWarnings(self) -> None: ...
    def close(self) -> None: ...
    def deleteRow(self) -> None: ...
    def findColumn(self, string: str) -> int: ...
    def first(self) -> bool: ...
    @typing.overload
    def getArray(self, int: int) -> Array: ...
    @typing.overload
    def getArray(self, string: str) -> Array: ...
    @typing.overload
    def getAsciiStream(self, int: int) -> java.io.InputStream: ...
    @typing.overload
    def getAsciiStream(self, string: str) -> java.io.InputStream: ...
    @typing.overload
    def getBigDecimal(self, int: int) -> java.math.BigDecimal: ...
    @typing.overload
    def getBigDecimal(self, int: int, int2: int) -> java.math.BigDecimal: ...
    @typing.overload
    def getBigDecimal(self, string: str) -> java.math.BigDecimal: ...
    @typing.overload
    def getBigDecimal(self, string: str, int: int) -> java.math.BigDecimal: ...
    @typing.overload
    def getBinaryStream(self, int: int) -> java.io.InputStream: ...
    @typing.overload
    def getBinaryStream(self, string: str) -> java.io.InputStream: ...
    @typing.overload
    def getBlob(self, int: int) -> Blob: ...
    @typing.overload
    def getBlob(self, string: str) -> Blob: ...
    @typing.overload
    def getBoolean(self, int: int) -> bool: ...
    @typing.overload
    def getBoolean(self, string: str) -> bool: ...
    @typing.overload
    def getByte(self, int: int) -> int: ...
    @typing.overload
    def getByte(self, string: str) -> int: ...
    @typing.overload
    def getBytes(self, int: int) -> typing.MutableSequence[int]: ...
    @typing.overload
    def getBytes(self, string: str) -> typing.MutableSequence[int]: ...
    @typing.overload
    def getCharacterStream(self, int: int) -> java.io.Reader: ...
    @typing.overload
    def getCharacterStream(self, string: str) -> java.io.Reader: ...
    @typing.overload
    def getClob(self, int: int) -> Clob: ...
    @typing.overload
    def getClob(self, string: str) -> Clob: ...
    def getConcurrency(self) -> int: ...
    def getCursorName(self) -> str: ...
    @typing.overload
    def getDate(self, int: int) -> Date: ...
    @typing.overload
    def getDate(self, int: int, calendar: java.util.Calendar) -> Date: ...
    @typing.overload
    def getDate(self, string: str) -> Date: ...
    @typing.overload
    def getDate(self, string: str, calendar: java.util.Calendar) -> Date: ...
    @typing.overload
    def getDouble(self, int: int) -> float: ...
    @typing.overload
    def getDouble(self, string: str) -> float: ...
    def getFetchDirection(self) -> int: ...
    def getFetchSize(self) -> int: ...
    @typing.overload
    def getFloat(self, int: int) -> float: ...
    @typing.overload
    def getFloat(self, string: str) -> float: ...
    def getHoldability(self) -> int: ...
    @typing.overload
    def getInt(self, int: int) -> int: ...
    @typing.overload
    def getInt(self, string: str) -> int: ...
    @typing.overload
    def getLong(self, int: int) -> int: ...
    @typing.overload
    def getLong(self, string: str) -> int: ...
    def getMetaData(self) -> 'ResultSetMetaData': ...
    @typing.overload
    def getNCharacterStream(self, int: int) -> java.io.Reader: ...
    @typing.overload
    def getNCharacterStream(self, string: str) -> java.io.Reader: ...
    @typing.overload
    def getNClob(self, int: int) -> NClob: ...
    @typing.overload
    def getNClob(self, string: str) -> NClob: ...
    @typing.overload
    def getNString(self, int: int) -> str: ...
    @typing.overload
    def getNString(self, string: str) -> str: ...
    _getObject_1__T = typing.TypeVar('_getObject_1__T')  # <T>
    _getObject_4__T = typing.TypeVar('_getObject_4__T')  # <T>
    @typing.overload
    def getObject(self, int: int) -> typing.Any: ...
    @typing.overload
    def getObject(self, int: int, class_: typing.Type[_getObject_1__T]) -> _getObject_1__T: ...
    @typing.overload
    def getObject(self, int: int, map: typing.Union[java.util.Map[str, typing.Type[typing.Any]], typing.Mapping[str, typing.Type[typing.Any]]]) -> typing.Any: ...
    @typing.overload
    def getObject(self, string: str) -> typing.Any: ...
    @typing.overload
    def getObject(self, string: str, class_: typing.Type[_getObject_4__T]) -> _getObject_4__T: ...
    @typing.overload
    def getObject(self, string: str, map: typing.Union[java.util.Map[str, typing.Type[typing.Any]], typing.Mapping[str, typing.Type[typing.Any]]]) -> typing.Any: ...
    @typing.overload
    def getRef(self, int: int) -> Ref: ...
    @typing.overload
    def getRef(self, string: str) -> Ref: ...
    def getRow(self) -> int: ...
    @typing.overload
    def getRowId(self, int: int) -> RowId: ...
    @typing.overload
    def getRowId(self, string: str) -> RowId: ...
    @typing.overload
    def getSQLXML(self, int: int) -> SQLXML: ...
    @typing.overload
    def getSQLXML(self, string: str) -> SQLXML: ...
    @typing.overload
    def getShort(self, int: int) -> int: ...
    @typing.overload
    def getShort(self, string: str) -> int: ...
    def getStatement(self) -> 'Statement': ...
    @typing.overload
    def getString(self, int: int) -> str: ...
    @typing.overload
    def getString(self, string: str) -> str: ...
    @typing.overload
    def getTime(self, int: int) -> Time: ...
    @typing.overload
    def getTime(self, int: int, calendar: java.util.Calendar) -> Time: ...
    @typing.overload
    def getTime(self, string: str) -> Time: ...
    @typing.overload
    def getTime(self, string: str, calendar: java.util.Calendar) -> Time: ...
    @typing.overload
    def getTimestamp(self, int: int) -> Timestamp: ...
    @typing.overload
    def getTimestamp(self, int: int, calendar: java.util.Calendar) -> Timestamp: ...
    @typing.overload
    def getTimestamp(self, string: str) -> Timestamp: ...
    @typing.overload
    def getTimestamp(self, string: str, calendar: java.util.Calendar) -> Timestamp: ...
    def getType(self) -> int: ...
    @typing.overload
    def getURL(self, int: int) -> java.net.URL: ...
    @typing.overload
    def getURL(self, string: str) -> java.net.URL: ...
    @typing.overload
    def getUnicodeStream(self, int: int) -> java.io.InputStream: ...
    @typing.overload
    def getUnicodeStream(self, string: str) -> java.io.InputStream: ...
    def getWarnings(self) -> 'SQLWarning': ...
    def insertRow(self) -> None: ...
    def isAfterLast(self) -> bool: ...
    def isBeforeFirst(self) -> bool: ...
    def isClosed(self) -> bool: ...
    def isFirst(self) -> bool: ...
    def isLast(self) -> bool: ...
    def last(self) -> bool: ...
    def moveToCurrentRow(self) -> None: ...
    def moveToInsertRow(self) -> None: ...
    def next(self) -> bool: ...
    def previous(self) -> bool: ...
    def refreshRow(self) -> None: ...
    def relative(self, int: int) -> bool: ...
    def rowDeleted(self) -> bool: ...
    def rowInserted(self) -> bool: ...
    def rowUpdated(self) -> bool: ...
    def setFetchDirection(self, int: int) -> None: ...
    def setFetchSize(self, int: int) -> None: ...
    @typing.overload
    def updateArray(self, int: int, array: Array) -> None: ...
    @typing.overload
    def updateArray(self, string: str, array: Array) -> None: ...
    @typing.overload
    def updateAsciiStream(self, int: int, inputStream: java.io.InputStream) -> None: ...
    @typing.overload
    def updateAsciiStream(self, int: int, inputStream: java.io.InputStream, int2: int) -> None: ...
    @typing.overload
    def updateAsciiStream(self, int: int, inputStream: java.io.InputStream, long: int) -> None: ...
    @typing.overload
    def updateAsciiStream(self, string: str, inputStream: java.io.InputStream) -> None: ...
    @typing.overload
    def updateAsciiStream(self, string: str, inputStream: java.io.InputStream, int: int) -> None: ...
    @typing.overload
    def updateAsciiStream(self, string: str, inputStream: java.io.InputStream, long: int) -> None: ...
    @typing.overload
    def updateBigDecimal(self, int: int, bigDecimal: typing.Union[java.math.BigDecimal, decimal.Decimal]) -> None: ...
    @typing.overload
    def updateBigDecimal(self, string: str, bigDecimal: typing.Union[java.math.BigDecimal, decimal.Decimal]) -> None: ...
    @typing.overload
    def updateBinaryStream(self, int: int, inputStream: java.io.InputStream) -> None: ...
    @typing.overload
    def updateBinaryStream(self, int: int, inputStream: java.io.InputStream, int2: int) -> None: ...
    @typing.overload
    def updateBinaryStream(self, int: int, inputStream: java.io.InputStream, long: int) -> None: ...
    @typing.overload
    def updateBinaryStream(self, string: str, inputStream: java.io.InputStream) -> None: ...
    @typing.overload
    def updateBinaryStream(self, string: str, inputStream: java.io.InputStream, int: int) -> None: ...
    @typing.overload
    def updateBinaryStream(self, string: str, inputStream: java.io.InputStream, long: int) -> None: ...
    @typing.overload
    def updateBlob(self, int: int, inputStream: java.io.InputStream) -> None: ...
    @typing.overload
    def updateBlob(self, int: int, inputStream: java.io.InputStream, long: int) -> None: ...
    @typing.overload
    def updateBlob(self, int: int, blob: Blob) -> None: ...
    @typing.overload
    def updateBlob(self, string: str, inputStream: java.io.InputStream) -> None: ...
    @typing.overload
    def updateBlob(self, string: str, inputStream: java.io.InputStream, long: int) -> None: ...
    @typing.overload
    def updateBlob(self, string: str, blob: Blob) -> None: ...
    @typing.overload
    def updateBoolean(self, int: int, boolean: bool) -> None: ...
    @typing.overload
    def updateBoolean(self, string: str, boolean: bool) -> None: ...
    @typing.overload
    def updateByte(self, int: int, byte: int) -> None: ...
    @typing.overload
    def updateByte(self, string: str, byte: int) -> None: ...
    @typing.overload
    def updateBytes(self, int: int, byteArray: typing.Union[typing.List[int], jpype.JArray, bytes]) -> None: ...
    @typing.overload
    def updateBytes(self, string: str, byteArray: typing.Union[typing.List[int], jpype.JArray, bytes]) -> None: ...
    @typing.overload
    def updateCharacterStream(self, int: int, reader: java.io.Reader) -> None: ...
    @typing.overload
    def updateCharacterStream(self, int: int, reader: java.io.Reader, int2: int) -> None: ...
    @typing.overload
    def updateCharacterStream(self, int: int, reader: java.io.Reader, long: int) -> None: ...
    @typing.overload
    def updateCharacterStream(self, string: str, reader: java.io.Reader) -> None: ...
    @typing.overload
    def updateCharacterStream(self, string: str, reader: java.io.Reader, int: int) -> None: ...
    @typing.overload
    def updateCharacterStream(self, string: str, reader: java.io.Reader, long: int) -> None: ...
    @typing.overload
    def updateClob(self, int: int, reader: java.io.Reader) -> None: ...
    @typing.overload
    def updateClob(self, int: int, reader: java.io.Reader, long: int) -> None: ...
    @typing.overload
    def updateClob(self, int: int, clob: Clob) -> None: ...
    @typing.overload
    def updateClob(self, string: str, reader: java.io.Reader) -> None: ...
    @typing.overload
    def updateClob(self, string: str, reader: java.io.Reader, long: int) -> None: ...
    @typing.overload
    def updateClob(self, string: str, clob: Clob) -> None: ...
    @typing.overload
    def updateDate(self, int: int, date: typing.Union[Date, datetime.date]) -> None: ...
    @typing.overload
    def updateDate(self, string: str, date: typing.Union[Date, datetime.date]) -> None: ...
    @typing.overload
    def updateDouble(self, int: int, double: float) -> None: ...
    @typing.overload
    def updateDouble(self, string: str, double: float) -> None: ...
    @typing.overload
    def updateFloat(self, int: int, float: float) -> None: ...
    @typing.overload
    def updateFloat(self, string: str, float: float) -> None: ...
    @typing.overload
    def updateInt(self, int: int, int2: int) -> None: ...
    @typing.overload
    def updateInt(self, string: str, int: int) -> None: ...
    @typing.overload
    def updateLong(self, int: int, long: int) -> None: ...
    @typing.overload
    def updateLong(self, string: str, long: int) -> None: ...
    @typing.overload
    def updateNCharacterStream(self, int: int, reader: java.io.Reader) -> None: ...
    @typing.overload
    def updateNCharacterStream(self, int: int, reader: java.io.Reader, long: int) -> None: ...
    @typing.overload
    def updateNCharacterStream(self, string: str, reader: java.io.Reader) -> None: ...
    @typing.overload
    def updateNCharacterStream(self, string: str, reader: java.io.Reader, long: int) -> None: ...
    @typing.overload
    def updateNClob(self, int: int, reader: java.io.Reader) -> None: ...
    @typing.overload
    def updateNClob(self, int: int, reader: java.io.Reader, long: int) -> None: ...
    @typing.overload
    def updateNClob(self, int: int, nClob: NClob) -> None: ...
    @typing.overload
    def updateNClob(self, string: str, reader: java.io.Reader) -> None: ...
    @typing.overload
    def updateNClob(self, string: str, reader: java.io.Reader, long: int) -> None: ...
    @typing.overload
    def updateNClob(self, string: str, nClob: NClob) -> None: ...
    @typing.overload
    def updateNString(self, int: int, string: str) -> None: ...
    @typing.overload
    def updateNString(self, string: str, string2: str) -> None: ...
    @typing.overload
    def updateNull(self, int: int) -> None: ...
    @typing.overload
    def updateNull(self, string: str) -> None: ...
    @typing.overload
    def updateObject(self, int: int, object: typing.Any) -> None: ...
    @typing.overload
    def updateObject(self, int: int, object: typing.Any, int2: int) -> None: ...
    @typing.overload
    def updateObject(self, string: str, object: typing.Any) -> None: ...
    @typing.overload
    def updateObject(self, string: str, object: typing.Any, int: int) -> None: ...
    @typing.overload
    def updateObject(self, int: int, object: typing.Any, sQLType: SQLType) -> None: ...
    @typing.overload
    def updateObject(self, int: int, object: typing.Any, sQLType: SQLType, int2: int) -> None: ...
    @typing.overload
    def updateObject(self, string: str, object: typing.Any, sQLType: SQLType) -> None: ...
    @typing.overload
    def updateObject(self, string: str, object: typing.Any, sQLType: SQLType, int: int) -> None: ...
    @typing.overload
    def updateRef(self, int: int, ref: Ref) -> None: ...
    @typing.overload
    def updateRef(self, string: str, ref: Ref) -> None: ...
    def updateRow(self) -> None: ...
    @typing.overload
    def updateRowId(self, int: int, rowId: typing.Union[RowId, typing.Callable]) -> None: ...
    @typing.overload
    def updateRowId(self, string: str, rowId: typing.Union[RowId, typing.Callable]) -> None: ...
    @typing.overload
    def updateSQLXML(self, int: int, sQLXML: SQLXML) -> None: ...
    @typing.overload
    def updateSQLXML(self, string: str, sQLXML: SQLXML) -> None: ...
    @typing.overload
    def updateShort(self, int: int, short: int) -> None: ...
    @typing.overload
    def updateShort(self, string: str, short: int) -> None: ...
    @typing.overload
    def updateString(self, int: int, string: str) -> None: ...
    @typing.overload
    def updateString(self, string: str, string2: str) -> None: ...
    @typing.overload
    def updateTime(self, int: int, time: typing.Union[Time, datetime.time]) -> None: ...
    @typing.overload
    def updateTime(self, string: str, time: typing.Union[Time, datetime.time]) -> None: ...
    @typing.overload
    def updateTimestamp(self, int: int, timestamp: typing.Union[Timestamp, datetime.datetime]) -> None: ...
    @typing.overload
    def updateTimestamp(self, string: str, timestamp: typing.Union[Timestamp, datetime.datetime]) -> None: ...
    def wasNull(self) -> bool: ...

class ResultSetMetaData(Wrapper):
    columnNoNulls: typing.ClassVar[int] = ...
    columnNullable: typing.ClassVar[int] = ...
    columnNullableUnknown: typing.ClassVar[int] = ...
    def getCatalogName(self, int: int) -> str: ...
    def getColumnClassName(self, int: int) -> str: ...
    def getColumnCount(self) -> int: ...
    def getColumnDisplaySize(self, int: int) -> int: ...
    def getColumnLabel(self, int: int) -> str: ...
    def getColumnName(self, int: int) -> str: ...
    def getColumnType(self, int: int) -> int: ...
    def getColumnTypeName(self, int: int) -> str: ...
    def getPrecision(self, int: int) -> int: ...
    def getScale(self, int: int) -> int: ...
    def getSchemaName(self, int: int) -> str: ...
    def getTableName(self, int: int) -> str: ...
    def isAutoIncrement(self, int: int) -> bool: ...
    def isCaseSensitive(self, int: int) -> bool: ...
    def isCurrency(self, int: int) -> bool: ...
    def isDefinitelyWritable(self, int: int) -> bool: ...
    def isNullable(self, int: int) -> int: ...
    def isReadOnly(self, int: int) -> bool: ...
    def isSearchable(self, int: int) -> bool: ...
    def isSigned(self, int: int) -> bool: ...
    def isWritable(self, int: int) -> bool: ...

class SQLClientInfoException(SQLException):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str, string2: str, int: int, map: typing.Union[java.util.Map[str, ClientInfoStatus], typing.Mapping[str, ClientInfoStatus]]): ...
    @typing.overload
    def __init__(self, string: str, string2: str, int: int, map: typing.Union[java.util.Map[str, ClientInfoStatus], typing.Mapping[str, ClientInfoStatus]], throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, string: str, string2: str, map: typing.Union[java.util.Map[str, ClientInfoStatus], typing.Mapping[str, ClientInfoStatus]]): ...
    @typing.overload
    def __init__(self, string: str, string2: str, map: typing.Union[java.util.Map[str, ClientInfoStatus], typing.Mapping[str, ClientInfoStatus]], throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, string: str, map: typing.Union[java.util.Map[str, ClientInfoStatus], typing.Mapping[str, ClientInfoStatus]]): ...
    @typing.overload
    def __init__(self, string: str, map: typing.Union[java.util.Map[str, ClientInfoStatus], typing.Mapping[str, ClientInfoStatus]], throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, map: typing.Union[java.util.Map[str, ClientInfoStatus], typing.Mapping[str, ClientInfoStatus]]): ...
    @typing.overload
    def __init__(self, map: typing.Union[java.util.Map[str, ClientInfoStatus], typing.Mapping[str, ClientInfoStatus]], throwable: java.lang.Throwable): ...
    def getFailedProperties(self) -> java.util.Map[str, ClientInfoStatus]: ...

class SQLNonTransientException(SQLException):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str, int: int): ...
    @typing.overload
    def __init__(self, string: str, string2: str, int: int, throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, string: str, string2: str, throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, string: str, throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, throwable: java.lang.Throwable): ...

class SQLRecoverableException(SQLException):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str, int: int): ...
    @typing.overload
    def __init__(self, string: str, string2: str, int: int, throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, string: str, string2: str, throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, string: str, throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, throwable: java.lang.Throwable): ...

class SQLTransientException(SQLException):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str, int: int): ...
    @typing.overload
    def __init__(self, string: str, string2: str, int: int, throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, string: str, string2: str, throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, string: str, throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, throwable: java.lang.Throwable): ...

class SQLWarning(SQLException):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str, int: int): ...
    @typing.overload
    def __init__(self, string: str, string2: str, int: int, throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, string: str, string2: str, throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, string: str, throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, throwable: java.lang.Throwable): ...
    def getNextWarning(self) -> 'SQLWarning': ...
    def setNextWarning(self, sQLWarning: 'SQLWarning') -> None: ...

class Statement(Wrapper, java.lang.AutoCloseable):
    CLOSE_CURRENT_RESULT: typing.ClassVar[int] = ...
    KEEP_CURRENT_RESULT: typing.ClassVar[int] = ...
    CLOSE_ALL_RESULTS: typing.ClassVar[int] = ...
    SUCCESS_NO_INFO: typing.ClassVar[int] = ...
    EXECUTE_FAILED: typing.ClassVar[int] = ...
    RETURN_GENERATED_KEYS: typing.ClassVar[int] = ...
    NO_GENERATED_KEYS: typing.ClassVar[int] = ...
    def addBatch(self, string: str) -> None: ...
    def cancel(self) -> None: ...
    def clearBatch(self) -> None: ...
    def clearWarnings(self) -> None: ...
    def close(self) -> None: ...
    def closeOnCompletion(self) -> None: ...
    def enquoteIdentifier(self, string: str, boolean: bool) -> str: ...
    def enquoteLiteral(self, string: str) -> str: ...
    def enquoteNCharLiteral(self, string: str) -> str: ...
    @typing.overload
    def execute(self, string: str) -> bool: ...
    @typing.overload
    def execute(self, string: str, int: int) -> bool: ...
    @typing.overload
    def execute(self, string: str, intArray: typing.Union[typing.List[int], jpype.JArray]) -> bool: ...
    @typing.overload
    def execute(self, string: str, stringArray: typing.Union[typing.List[str], jpype.JArray]) -> bool: ...
    def executeBatch(self) -> typing.MutableSequence[int]: ...
    def executeLargeBatch(self) -> typing.MutableSequence[int]: ...
    @typing.overload
    def executeLargeUpdate(self, string: str) -> int: ...
    @typing.overload
    def executeLargeUpdate(self, string: str, int: int) -> int: ...
    @typing.overload
    def executeLargeUpdate(self, string: str, intArray: typing.Union[typing.List[int], jpype.JArray]) -> int: ...
    @typing.overload
    def executeLargeUpdate(self, string: str, stringArray: typing.Union[typing.List[str], jpype.JArray]) -> int: ...
    def executeQuery(self, string: str) -> ResultSet: ...
    @typing.overload
    def executeUpdate(self, string: str) -> int: ...
    @typing.overload
    def executeUpdate(self, string: str, int: int) -> int: ...
    @typing.overload
    def executeUpdate(self, string: str, intArray: typing.Union[typing.List[int], jpype.JArray]) -> int: ...
    @typing.overload
    def executeUpdate(self, string: str, stringArray: typing.Union[typing.List[str], jpype.JArray]) -> int: ...
    def getConnection(self) -> Connection: ...
    def getFetchDirection(self) -> int: ...
    def getFetchSize(self) -> int: ...
    def getGeneratedKeys(self) -> ResultSet: ...
    def getLargeMaxRows(self) -> int: ...
    def getLargeUpdateCount(self) -> int: ...
    def getMaxFieldSize(self) -> int: ...
    def getMaxRows(self) -> int: ...
    @typing.overload
    def getMoreResults(self) -> bool: ...
    @typing.overload
    def getMoreResults(self, int: int) -> bool: ...
    def getQueryTimeout(self) -> int: ...
    def getResultSet(self) -> ResultSet: ...
    def getResultSetConcurrency(self) -> int: ...
    def getResultSetHoldability(self) -> int: ...
    def getResultSetType(self) -> int: ...
    def getUpdateCount(self) -> int: ...
    def getWarnings(self) -> SQLWarning: ...
    def isCloseOnCompletion(self) -> bool: ...
    def isClosed(self) -> bool: ...
    def isPoolable(self) -> bool: ...
    def isSimpleIdentifier(self, string: str) -> bool: ...
    def setCursorName(self, string: str) -> None: ...
    def setEscapeProcessing(self, boolean: bool) -> None: ...
    def setFetchDirection(self, int: int) -> None: ...
    def setFetchSize(self, int: int) -> None: ...
    def setLargeMaxRows(self, long: int) -> None: ...
    def setMaxFieldSize(self, int: int) -> None: ...
    def setMaxRows(self, int: int) -> None: ...
    def setPoolable(self, boolean: bool) -> None: ...
    def setQueryTimeout(self, int: int) -> None: ...

class DataTruncation(SQLWarning):
    @typing.overload
    def __init__(self, int: int, boolean: bool, boolean2: bool, int2: int, int3: int): ...
    @typing.overload
    def __init__(self, int: int, boolean: bool, boolean2: bool, int2: int, int3: int, throwable: java.lang.Throwable): ...
    def getDataSize(self) -> int: ...
    def getIndex(self) -> int: ...
    def getParameter(self) -> bool: ...
    def getRead(self) -> bool: ...
    def getTransferSize(self) -> int: ...

class PreparedStatement(Statement):
    @typing.overload
    def addBatch(self) -> None: ...
    @typing.overload
    def addBatch(self, string: str) -> None: ...
    def clearParameters(self) -> None: ...
    @typing.overload
    def execute(self) -> bool: ...
    @typing.overload
    def execute(self, string: str) -> bool: ...
    @typing.overload
    def execute(self, string: str, int: int) -> bool: ...
    @typing.overload
    def execute(self, string: str, intArray: typing.Union[typing.List[int], jpype.JArray]) -> bool: ...
    @typing.overload
    def execute(self, string: str, stringArray: typing.Union[typing.List[str], jpype.JArray]) -> bool: ...
    @typing.overload
    def executeLargeUpdate(self) -> int: ...
    @typing.overload
    def executeLargeUpdate(self, string: str) -> int: ...
    @typing.overload
    def executeLargeUpdate(self, string: str, int: int) -> int: ...
    @typing.overload
    def executeLargeUpdate(self, string: str, intArray: typing.Union[typing.List[int], jpype.JArray]) -> int: ...
    @typing.overload
    def executeLargeUpdate(self, string: str, stringArray: typing.Union[typing.List[str], jpype.JArray]) -> int: ...
    @typing.overload
    def executeQuery(self) -> ResultSet: ...
    @typing.overload
    def executeQuery(self, string: str) -> ResultSet: ...
    @typing.overload
    def executeUpdate(self) -> int: ...
    @typing.overload
    def executeUpdate(self, string: str) -> int: ...
    @typing.overload
    def executeUpdate(self, string: str, int: int) -> int: ...
    @typing.overload
    def executeUpdate(self, string: str, intArray: typing.Union[typing.List[int], jpype.JArray]) -> int: ...
    @typing.overload
    def executeUpdate(self, string: str, stringArray: typing.Union[typing.List[str], jpype.JArray]) -> int: ...
    def getMetaData(self) -> ResultSetMetaData: ...
    def getParameterMetaData(self) -> ParameterMetaData: ...
    def setArray(self, int: int, array: Array) -> None: ...
    @typing.overload
    def setAsciiStream(self, int: int, inputStream: java.io.InputStream) -> None: ...
    @typing.overload
    def setAsciiStream(self, int: int, inputStream: java.io.InputStream, int2: int) -> None: ...
    @typing.overload
    def setAsciiStream(self, int: int, inputStream: java.io.InputStream, long: int) -> None: ...
    def setBigDecimal(self, int: int, bigDecimal: typing.Union[java.math.BigDecimal, decimal.Decimal]) -> None: ...
    @typing.overload
    def setBinaryStream(self, int: int, inputStream: java.io.InputStream) -> None: ...
    @typing.overload
    def setBinaryStream(self, int: int, inputStream: java.io.InputStream, int2: int) -> None: ...
    @typing.overload
    def setBinaryStream(self, int: int, inputStream: java.io.InputStream, long: int) -> None: ...
    @typing.overload
    def setBlob(self, int: int, inputStream: java.io.InputStream) -> None: ...
    @typing.overload
    def setBlob(self, int: int, inputStream: java.io.InputStream, long: int) -> None: ...
    @typing.overload
    def setBlob(self, int: int, blob: Blob) -> None: ...
    def setBoolean(self, int: int, boolean: bool) -> None: ...
    def setByte(self, int: int, byte: int) -> None: ...
    def setBytes(self, int: int, byteArray: typing.Union[typing.List[int], jpype.JArray, bytes]) -> None: ...
    @typing.overload
    def setCharacterStream(self, int: int, reader: java.io.Reader) -> None: ...
    @typing.overload
    def setCharacterStream(self, int: int, reader: java.io.Reader, int2: int) -> None: ...
    @typing.overload
    def setCharacterStream(self, int: int, reader: java.io.Reader, long: int) -> None: ...
    @typing.overload
    def setClob(self, int: int, reader: java.io.Reader) -> None: ...
    @typing.overload
    def setClob(self, int: int, reader: java.io.Reader, long: int) -> None: ...
    @typing.overload
    def setClob(self, int: int, clob: Clob) -> None: ...
    @typing.overload
    def setDate(self, int: int, date: typing.Union[Date, datetime.date]) -> None: ...
    @typing.overload
    def setDate(self, int: int, date: typing.Union[Date, datetime.date], calendar: java.util.Calendar) -> None: ...
    def setDouble(self, int: int, double: float) -> None: ...
    def setFloat(self, int: int, float: float) -> None: ...
    def setInt(self, int: int, int2: int) -> None: ...
    def setLong(self, int: int, long: int) -> None: ...
    @typing.overload
    def setNCharacterStream(self, int: int, reader: java.io.Reader) -> None: ...
    @typing.overload
    def setNCharacterStream(self, int: int, reader: java.io.Reader, long: int) -> None: ...
    @typing.overload
    def setNClob(self, int: int, reader: java.io.Reader) -> None: ...
    @typing.overload
    def setNClob(self, int: int, reader: java.io.Reader, long: int) -> None: ...
    @typing.overload
    def setNClob(self, int: int, nClob: NClob) -> None: ...
    def setNString(self, int: int, string: str) -> None: ...
    @typing.overload
    def setNull(self, int: int, int2: int) -> None: ...
    @typing.overload
    def setNull(self, int: int, int2: int, string: str) -> None: ...
    @typing.overload
    def setObject(self, int: int, object: typing.Any) -> None: ...
    @typing.overload
    def setObject(self, int: int, object: typing.Any, int2: int) -> None: ...
    @typing.overload
    def setObject(self, int: int, object: typing.Any, int2: int, int3: int) -> None: ...
    @typing.overload
    def setObject(self, int: int, object: typing.Any, sQLType: SQLType) -> None: ...
    @typing.overload
    def setObject(self, int: int, object: typing.Any, sQLType: SQLType, int2: int) -> None: ...
    def setRef(self, int: int, ref: Ref) -> None: ...
    def setRowId(self, int: int, rowId: typing.Union[RowId, typing.Callable]) -> None: ...
    def setSQLXML(self, int: int, sQLXML: SQLXML) -> None: ...
    def setShort(self, int: int, short: int) -> None: ...
    def setString(self, int: int, string: str) -> None: ...
    @typing.overload
    def setTime(self, int: int, time: typing.Union[Time, datetime.time]) -> None: ...
    @typing.overload
    def setTime(self, int: int, time: typing.Union[Time, datetime.time], calendar: java.util.Calendar) -> None: ...
    @typing.overload
    def setTimestamp(self, int: int, timestamp: typing.Union[Timestamp, datetime.datetime]) -> None: ...
    @typing.overload
    def setTimestamp(self, int: int, timestamp: typing.Union[Timestamp, datetime.datetime], calendar: java.util.Calendar) -> None: ...
    def setURL(self, int: int, uRL: java.net.URL) -> None: ...
    def setUnicodeStream(self, int: int, inputStream: java.io.InputStream, int2: int) -> None: ...

class SQLDataException(SQLNonTransientException):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str, int: int): ...
    @typing.overload
    def __init__(self, string: str, string2: str, int: int, throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, string: str, string2: str, throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, string: str, throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, throwable: java.lang.Throwable): ...

class SQLFeatureNotSupportedException(SQLNonTransientException):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str, int: int): ...
    @typing.overload
    def __init__(self, string: str, string2: str, int: int, throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, string: str, string2: str, throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, string: str, throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, throwable: java.lang.Throwable): ...

class SQLIntegrityConstraintViolationException(SQLNonTransientException):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str, int: int): ...
    @typing.overload
    def __init__(self, string: str, string2: str, int: int, throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, string: str, string2: str, throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, string: str, throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, throwable: java.lang.Throwable): ...

class SQLInvalidAuthorizationSpecException(SQLNonTransientException):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str, int: int): ...
    @typing.overload
    def __init__(self, string: str, string2: str, int: int, throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, string: str, string2: str, throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, string: str, throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, throwable: java.lang.Throwable): ...

class SQLNonTransientConnectionException(SQLNonTransientException):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str, int: int): ...
    @typing.overload
    def __init__(self, string: str, string2: str, int: int, throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, string: str, string2: str, throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, string: str, throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, throwable: java.lang.Throwable): ...

class SQLSyntaxErrorException(SQLNonTransientException):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str, int: int): ...
    @typing.overload
    def __init__(self, string: str, string2: str, int: int, throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, string: str, string2: str, throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, string: str, throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, throwable: java.lang.Throwable): ...

class SQLTimeoutException(SQLTransientException):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str, int: int): ...
    @typing.overload
    def __init__(self, string: str, string2: str, int: int, throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, string: str, string2: str, throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, string: str, throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, throwable: java.lang.Throwable): ...

class SQLTransactionRollbackException(SQLTransientException):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str, int: int): ...
    @typing.overload
    def __init__(self, string: str, string2: str, int: int, throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, string: str, string2: str, throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, string: str, throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, throwable: java.lang.Throwable): ...

class SQLTransientConnectionException(SQLTransientException):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str, int: int): ...
    @typing.overload
    def __init__(self, string: str, string2: str, int: int, throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, string: str, string2: str, throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, string: str, throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, throwable: java.lang.Throwable): ...

class CallableStatement(PreparedStatement):
    @typing.overload
    def getArray(self, int: int) -> Array: ...
    @typing.overload
    def getArray(self, string: str) -> Array: ...
    @typing.overload
    def getBigDecimal(self, int: int) -> java.math.BigDecimal: ...
    @typing.overload
    def getBigDecimal(self, int: int, int2: int) -> java.math.BigDecimal: ...
    @typing.overload
    def getBigDecimal(self, string: str) -> java.math.BigDecimal: ...
    @typing.overload
    def getBlob(self, int: int) -> Blob: ...
    @typing.overload
    def getBlob(self, string: str) -> Blob: ...
    @typing.overload
    def getBoolean(self, int: int) -> bool: ...
    @typing.overload
    def getBoolean(self, string: str) -> bool: ...
    @typing.overload
    def getByte(self, int: int) -> int: ...
    @typing.overload
    def getByte(self, string: str) -> int: ...
    @typing.overload
    def getBytes(self, int: int) -> typing.MutableSequence[int]: ...
    @typing.overload
    def getBytes(self, string: str) -> typing.MutableSequence[int]: ...
    @typing.overload
    def getCharacterStream(self, int: int) -> java.io.Reader: ...
    @typing.overload
    def getCharacterStream(self, string: str) -> java.io.Reader: ...
    @typing.overload
    def getClob(self, int: int) -> Clob: ...
    @typing.overload
    def getClob(self, string: str) -> Clob: ...
    @typing.overload
    def getDate(self, int: int) -> Date: ...
    @typing.overload
    def getDate(self, int: int, calendar: java.util.Calendar) -> Date: ...
    @typing.overload
    def getDate(self, string: str) -> Date: ...
    @typing.overload
    def getDate(self, string: str, calendar: java.util.Calendar) -> Date: ...
    @typing.overload
    def getDouble(self, int: int) -> float: ...
    @typing.overload
    def getDouble(self, string: str) -> float: ...
    @typing.overload
    def getFloat(self, int: int) -> float: ...
    @typing.overload
    def getFloat(self, string: str) -> float: ...
    @typing.overload
    def getInt(self, int: int) -> int: ...
    @typing.overload
    def getInt(self, string: str) -> int: ...
    @typing.overload
    def getLong(self, int: int) -> int: ...
    @typing.overload
    def getLong(self, string: str) -> int: ...
    @typing.overload
    def getNCharacterStream(self, int: int) -> java.io.Reader: ...
    @typing.overload
    def getNCharacterStream(self, string: str) -> java.io.Reader: ...
    @typing.overload
    def getNClob(self, int: int) -> NClob: ...
    @typing.overload
    def getNClob(self, string: str) -> NClob: ...
    @typing.overload
    def getNString(self, int: int) -> str: ...
    @typing.overload
    def getNString(self, string: str) -> str: ...
    _getObject_1__T = typing.TypeVar('_getObject_1__T')  # <T>
    _getObject_4__T = typing.TypeVar('_getObject_4__T')  # <T>
    @typing.overload
    def getObject(self, int: int) -> typing.Any: ...
    @typing.overload
    def getObject(self, int: int, class_: typing.Type[_getObject_1__T]) -> _getObject_1__T: ...
    @typing.overload
    def getObject(self, int: int, map: typing.Union[java.util.Map[str, typing.Type[typing.Any]], typing.Mapping[str, typing.Type[typing.Any]]]) -> typing.Any: ...
    @typing.overload
    def getObject(self, string: str) -> typing.Any: ...
    @typing.overload
    def getObject(self, string: str, class_: typing.Type[_getObject_4__T]) -> _getObject_4__T: ...
    @typing.overload
    def getObject(self, string: str, map: typing.Union[java.util.Map[str, typing.Type[typing.Any]], typing.Mapping[str, typing.Type[typing.Any]]]) -> typing.Any: ...
    @typing.overload
    def getRef(self, int: int) -> Ref: ...
    @typing.overload
    def getRef(self, string: str) -> Ref: ...
    @typing.overload
    def getRowId(self, int: int) -> RowId: ...
    @typing.overload
    def getRowId(self, string: str) -> RowId: ...
    @typing.overload
    def getSQLXML(self, int: int) -> SQLXML: ...
    @typing.overload
    def getSQLXML(self, string: str) -> SQLXML: ...
    @typing.overload
    def getShort(self, int: int) -> int: ...
    @typing.overload
    def getShort(self, string: str) -> int: ...
    @typing.overload
    def getString(self, int: int) -> str: ...
    @typing.overload
    def getString(self, string: str) -> str: ...
    @typing.overload
    def getTime(self, int: int) -> Time: ...
    @typing.overload
    def getTime(self, int: int, calendar: java.util.Calendar) -> Time: ...
    @typing.overload
    def getTime(self, string: str) -> Time: ...
    @typing.overload
    def getTime(self, string: str, calendar: java.util.Calendar) -> Time: ...
    @typing.overload
    def getTimestamp(self, int: int) -> Timestamp: ...
    @typing.overload
    def getTimestamp(self, int: int, calendar: java.util.Calendar) -> Timestamp: ...
    @typing.overload
    def getTimestamp(self, string: str) -> Timestamp: ...
    @typing.overload
    def getTimestamp(self, string: str, calendar: java.util.Calendar) -> Timestamp: ...
    @typing.overload
    def getURL(self, int: int) -> java.net.URL: ...
    @typing.overload
    def getURL(self, string: str) -> java.net.URL: ...
    @typing.overload
    def registerOutParameter(self, int: int, int2: int) -> None: ...
    @typing.overload
    def registerOutParameter(self, int: int, int2: int, int3: int) -> None: ...
    @typing.overload
    def registerOutParameter(self, int: int, int2: int, string: str) -> None: ...
    @typing.overload
    def registerOutParameter(self, string: str, int: int) -> None: ...
    @typing.overload
    def registerOutParameter(self, string: str, int: int, int2: int) -> None: ...
    @typing.overload
    def registerOutParameter(self, string: str, int: int, string2: str) -> None: ...
    @typing.overload
    def registerOutParameter(self, int: int, sQLType: SQLType) -> None: ...
    @typing.overload
    def registerOutParameter(self, int: int, sQLType: SQLType, int2: int) -> None: ...
    @typing.overload
    def registerOutParameter(self, int: int, sQLType: SQLType, string: str) -> None: ...
    @typing.overload
    def registerOutParameter(self, string: str, sQLType: SQLType) -> None: ...
    @typing.overload
    def registerOutParameter(self, string: str, sQLType: SQLType, int: int) -> None: ...
    @typing.overload
    def registerOutParameter(self, string: str, sQLType: SQLType, string2: str) -> None: ...
    @typing.overload
    def setAsciiStream(self, string: str, inputStream: java.io.InputStream) -> None: ...
    @typing.overload
    def setAsciiStream(self, string: str, inputStream: java.io.InputStream, int: int) -> None: ...
    @typing.overload
    def setAsciiStream(self, string: str, inputStream: java.io.InputStream, long: int) -> None: ...
    @typing.overload
    def setAsciiStream(self, int: int, inputStream: java.io.InputStream) -> None: ...
    @typing.overload
    def setAsciiStream(self, int: int, inputStream: java.io.InputStream, int2: int) -> None: ...
    @typing.overload
    def setAsciiStream(self, int: int, inputStream: java.io.InputStream, long: int) -> None: ...
    @typing.overload
    def setBigDecimal(self, string: str, bigDecimal: typing.Union[java.math.BigDecimal, decimal.Decimal]) -> None: ...
    @typing.overload
    def setBigDecimal(self, int: int, bigDecimal: typing.Union[java.math.BigDecimal, decimal.Decimal]) -> None: ...
    @typing.overload
    def setBinaryStream(self, string: str, inputStream: java.io.InputStream) -> None: ...
    @typing.overload
    def setBinaryStream(self, string: str, inputStream: java.io.InputStream, int: int) -> None: ...
    @typing.overload
    def setBinaryStream(self, string: str, inputStream: java.io.InputStream, long: int) -> None: ...
    @typing.overload
    def setBinaryStream(self, int: int, inputStream: java.io.InputStream) -> None: ...
    @typing.overload
    def setBinaryStream(self, int: int, inputStream: java.io.InputStream, int2: int) -> None: ...
    @typing.overload
    def setBinaryStream(self, int: int, inputStream: java.io.InputStream, long: int) -> None: ...
    @typing.overload
    def setBlob(self, string: str, inputStream: java.io.InputStream) -> None: ...
    @typing.overload
    def setBlob(self, string: str, inputStream: java.io.InputStream, long: int) -> None: ...
    @typing.overload
    def setBlob(self, string: str, blob: Blob) -> None: ...
    @typing.overload
    def setBlob(self, int: int, inputStream: java.io.InputStream) -> None: ...
    @typing.overload
    def setBlob(self, int: int, inputStream: java.io.InputStream, long: int) -> None: ...
    @typing.overload
    def setBlob(self, int: int, blob: Blob) -> None: ...
    @typing.overload
    def setBoolean(self, string: str, boolean: bool) -> None: ...
    @typing.overload
    def setBoolean(self, int: int, boolean: bool) -> None: ...
    @typing.overload
    def setByte(self, string: str, byte: int) -> None: ...
    @typing.overload
    def setByte(self, int: int, byte: int) -> None: ...
    @typing.overload
    def setBytes(self, string: str, byteArray: typing.Union[typing.List[int], jpype.JArray, bytes]) -> None: ...
    @typing.overload
    def setBytes(self, int: int, byteArray: typing.Union[typing.List[int], jpype.JArray, bytes]) -> None: ...
    @typing.overload
    def setCharacterStream(self, string: str, reader: java.io.Reader) -> None: ...
    @typing.overload
    def setCharacterStream(self, string: str, reader: java.io.Reader, int: int) -> None: ...
    @typing.overload
    def setCharacterStream(self, string: str, reader: java.io.Reader, long: int) -> None: ...
    @typing.overload
    def setCharacterStream(self, int: int, reader: java.io.Reader) -> None: ...
    @typing.overload
    def setCharacterStream(self, int: int, reader: java.io.Reader, int2: int) -> None: ...
    @typing.overload
    def setCharacterStream(self, int: int, reader: java.io.Reader, long: int) -> None: ...
    @typing.overload
    def setClob(self, string: str, reader: java.io.Reader) -> None: ...
    @typing.overload
    def setClob(self, string: str, reader: java.io.Reader, long: int) -> None: ...
    @typing.overload
    def setClob(self, string: str, clob: Clob) -> None: ...
    @typing.overload
    def setClob(self, int: int, reader: java.io.Reader) -> None: ...
    @typing.overload
    def setClob(self, int: int, reader: java.io.Reader, long: int) -> None: ...
    @typing.overload
    def setClob(self, int: int, clob: Clob) -> None: ...
    @typing.overload
    def setDate(self, string: str, date: typing.Union[Date, datetime.date]) -> None: ...
    @typing.overload
    def setDate(self, string: str, date: typing.Union[Date, datetime.date], calendar: java.util.Calendar) -> None: ...
    @typing.overload
    def setDate(self, int: int, date: typing.Union[Date, datetime.date]) -> None: ...
    @typing.overload
    def setDate(self, int: int, date: typing.Union[Date, datetime.date], calendar: java.util.Calendar) -> None: ...
    @typing.overload
    def setDouble(self, string: str, double: float) -> None: ...
    @typing.overload
    def setDouble(self, int: int, double: float) -> None: ...
    @typing.overload
    def setFloat(self, string: str, float: float) -> None: ...
    @typing.overload
    def setFloat(self, int: int, float: float) -> None: ...
    @typing.overload
    def setInt(self, string: str, int: int) -> None: ...
    @typing.overload
    def setInt(self, int: int, int2: int) -> None: ...
    @typing.overload
    def setLong(self, string: str, long: int) -> None: ...
    @typing.overload
    def setLong(self, int: int, long: int) -> None: ...
    @typing.overload
    def setNCharacterStream(self, string: str, reader: java.io.Reader) -> None: ...
    @typing.overload
    def setNCharacterStream(self, string: str, reader: java.io.Reader, long: int) -> None: ...
    @typing.overload
    def setNCharacterStream(self, int: int, reader: java.io.Reader) -> None: ...
    @typing.overload
    def setNCharacterStream(self, int: int, reader: java.io.Reader, long: int) -> None: ...
    @typing.overload
    def setNClob(self, string: str, reader: java.io.Reader) -> None: ...
    @typing.overload
    def setNClob(self, string: str, reader: java.io.Reader, long: int) -> None: ...
    @typing.overload
    def setNClob(self, string: str, nClob: NClob) -> None: ...
    @typing.overload
    def setNClob(self, int: int, reader: java.io.Reader) -> None: ...
    @typing.overload
    def setNClob(self, int: int, reader: java.io.Reader, long: int) -> None: ...
    @typing.overload
    def setNClob(self, int: int, nClob: NClob) -> None: ...
    @typing.overload
    def setNString(self, string: str, string2: str) -> None: ...
    @typing.overload
    def setNString(self, int: int, string: str) -> None: ...
    @typing.overload
    def setNull(self, string: str, int: int) -> None: ...
    @typing.overload
    def setNull(self, string: str, int: int, string2: str) -> None: ...
    @typing.overload
    def setNull(self, int: int, int2: int) -> None: ...
    @typing.overload
    def setNull(self, int: int, int2: int, string: str) -> None: ...
    @typing.overload
    def setObject(self, string: str, object: typing.Any) -> None: ...
    @typing.overload
    def setObject(self, string: str, object: typing.Any, int: int) -> None: ...
    @typing.overload
    def setObject(self, string: str, object: typing.Any, int: int, int2: int) -> None: ...
    @typing.overload
    def setObject(self, int: int, object: typing.Any) -> None: ...
    @typing.overload
    def setObject(self, int: int, object: typing.Any, int2: int) -> None: ...
    @typing.overload
    def setObject(self, int: int, object: typing.Any, int2: int, int3: int) -> None: ...
    @typing.overload
    def setObject(self, string: str, object: typing.Any, sQLType: SQLType) -> None: ...
    @typing.overload
    def setObject(self, string: str, object: typing.Any, sQLType: SQLType, int: int) -> None: ...
    @typing.overload
    def setObject(self, int: int, object: typing.Any, sQLType: SQLType) -> None: ...
    @typing.overload
    def setObject(self, int: int, object: typing.Any, sQLType: SQLType, int2: int) -> None: ...
    @typing.overload
    def setRowId(self, string: str, rowId: typing.Union[RowId, typing.Callable]) -> None: ...
    @typing.overload
    def setRowId(self, int: int, rowId: typing.Union[RowId, typing.Callable]) -> None: ...
    @typing.overload
    def setSQLXML(self, string: str, sQLXML: SQLXML) -> None: ...
    @typing.overload
    def setSQLXML(self, int: int, sQLXML: SQLXML) -> None: ...
    @typing.overload
    def setShort(self, string: str, short: int) -> None: ...
    @typing.overload
    def setShort(self, int: int, short: int) -> None: ...
    @typing.overload
    def setString(self, string: str, string2: str) -> None: ...
    @typing.overload
    def setString(self, int: int, string: str) -> None: ...
    @typing.overload
    def setTime(self, string: str, time: typing.Union[Time, datetime.time]) -> None: ...
    @typing.overload
    def setTime(self, string: str, time: typing.Union[Time, datetime.time], calendar: java.util.Calendar) -> None: ...
    @typing.overload
    def setTime(self, int: int, time: typing.Union[Time, datetime.time]) -> None: ...
    @typing.overload
    def setTime(self, int: int, time: typing.Union[Time, datetime.time], calendar: java.util.Calendar) -> None: ...
    @typing.overload
    def setTimestamp(self, string: str, timestamp: typing.Union[Timestamp, datetime.datetime]) -> None: ...
    @typing.overload
    def setTimestamp(self, string: str, timestamp: typing.Union[Timestamp, datetime.datetime], calendar: java.util.Calendar) -> None: ...
    @typing.overload
    def setTimestamp(self, int: int, timestamp: typing.Union[Timestamp, datetime.datetime]) -> None: ...
    @typing.overload
    def setTimestamp(self, int: int, timestamp: typing.Union[Timestamp, datetime.datetime], calendar: java.util.Calendar) -> None: ...
    @typing.overload
    def setURL(self, string: str, uRL: java.net.URL) -> None: ...
    @typing.overload
    def setURL(self, int: int, uRL: java.net.URL) -> None: ...
    def wasNull(self) -> bool: ...


class __module_protocol__(Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("java.sql")``.

    Array: typing.Type[Array]
    BatchUpdateException: typing.Type[BatchUpdateException]
    Blob: typing.Type[Blob]
    CallableStatement: typing.Type[CallableStatement]
    ClientInfoStatus: typing.Type[ClientInfoStatus]
    Clob: typing.Type[Clob]
    Connection: typing.Type[Connection]
    ConnectionBuilder: typing.Type[ConnectionBuilder]
    DataTruncation: typing.Type[DataTruncation]
    DatabaseMetaData: typing.Type[DatabaseMetaData]
    Date: typing.Type[Date]
    Driver: typing.Type[Driver]
    DriverAction: typing.Type[DriverAction]
    DriverManager: typing.Type[DriverManager]
    DriverPropertyInfo: typing.Type[DriverPropertyInfo]
    JDBCType: typing.Type[JDBCType]
    NClob: typing.Type[NClob]
    ParameterMetaData: typing.Type[ParameterMetaData]
    PreparedStatement: typing.Type[PreparedStatement]
    PseudoColumnUsage: typing.Type[PseudoColumnUsage]
    Ref: typing.Type[Ref]
    ResultSet: typing.Type[ResultSet]
    ResultSetMetaData: typing.Type[ResultSetMetaData]
    RowId: typing.Type[RowId]
    RowIdLifetime: typing.Type[RowIdLifetime]
    SQLClientInfoException: typing.Type[SQLClientInfoException]
    SQLData: typing.Type[SQLData]
    SQLDataException: typing.Type[SQLDataException]
    SQLException: typing.Type[SQLException]
    SQLFeatureNotSupportedException: typing.Type[SQLFeatureNotSupportedException]
    SQLInput: typing.Type[SQLInput]
    SQLIntegrityConstraintViolationException: typing.Type[SQLIntegrityConstraintViolationException]
    SQLInvalidAuthorizationSpecException: typing.Type[SQLInvalidAuthorizationSpecException]
    SQLNonTransientConnectionException: typing.Type[SQLNonTransientConnectionException]
    SQLNonTransientException: typing.Type[SQLNonTransientException]
    SQLOutput: typing.Type[SQLOutput]
    SQLPermission: typing.Type[SQLPermission]
    SQLRecoverableException: typing.Type[SQLRecoverableException]
    SQLSyntaxErrorException: typing.Type[SQLSyntaxErrorException]
    SQLTimeoutException: typing.Type[SQLTimeoutException]
    SQLTransactionRollbackException: typing.Type[SQLTransactionRollbackException]
    SQLTransientConnectionException: typing.Type[SQLTransientConnectionException]
    SQLTransientException: typing.Type[SQLTransientException]
    SQLType: typing.Type[SQLType]
    SQLWarning: typing.Type[SQLWarning]
    SQLXML: typing.Type[SQLXML]
    Savepoint: typing.Type[Savepoint]
    ShardingKey: typing.Type[ShardingKey]
    ShardingKeyBuilder: typing.Type[ShardingKeyBuilder]
    Statement: typing.Type[Statement]
    Struct: typing.Type[Struct]
    Time: typing.Type[Time]
    Timestamp: typing.Type[Timestamp]
    Types: typing.Type[Types]
    Wrapper: typing.Type[Wrapper]
