
import sys
if sys.version_info >= (3, 8):
    from typing import Protocol
else:
    from typing_extensions import Protocol

import java.net
import java.util.stream
import jpype
import typing



class InetAddressResolver:
    def lookupByAddress(self, byteArray: typing.Union[typing.List[int], jpype.JArray, bytes]) -> str: ...
    def lookupByName(self, string: str, lookupPolicy: 'InetAddressResolver.LookupPolicy') -> java.util.stream.Stream[java.net.InetAddress]: ...
    class LookupPolicy:
        IPV4: typing.ClassVar[int] = ...
        IPV6: typing.ClassVar[int] = ...
        IPV4_FIRST: typing.ClassVar[int] = ...
        IPV6_FIRST: typing.ClassVar[int] = ...
        def characteristics(self) -> int: ...
        @staticmethod
        def of(int: int) -> 'InetAddressResolver.LookupPolicy': ...

class InetAddressResolverProvider:
    def get(self, configuration: 'InetAddressResolverProvider.Configuration') -> InetAddressResolver: ...
    def name(self) -> str: ...
    class Configuration:
        def builtinResolver(self) -> InetAddressResolver: ...
        def lookupLocalHostName(self) -> str: ...

class URLStreamHandlerProvider(java.net.URLStreamHandlerFactory): ...


class __module_protocol__(Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("java.net.spi")``.

    InetAddressResolver: typing.Type[InetAddressResolver]
    InetAddressResolverProvider: typing.Type[InetAddressResolverProvider]
    URLStreamHandlerProvider: typing.Type[URLStreamHandlerProvider]
