
import sys
if sys.version_info >= (3, 8):
    from typing import Protocol
else:
    from typing_extensions import Protocol

import java
import java.io
import java.lang
import java.lang.constant
import java.lang.foreign
import java.lang.reflect
import java.nio
import java.util
import jpype
import typing



class CallSite:
    def dynamicInvoker(self) -> 'MethodHandle': ...
    def getTarget(self) -> 'MethodHandle': ...
    def setTarget(self, methodHandle: 'MethodHandle') -> None: ...
    def type(self) -> 'MethodType': ...

class ConstantBootstraps:
    @staticmethod
    def arrayVarHandle(lookup: 'MethodHandles.Lookup', string: str, class_: typing.Type['VarHandle'], class2: typing.Type[typing.Any]) -> 'VarHandle': ...
    _enumConstant__E = typing.TypeVar('_enumConstant__E', bound=java.lang.Enum)  # <E>
    @staticmethod
    def enumConstant(lookup: 'MethodHandles.Lookup', string: str, class_: typing.Type[_enumConstant__E]) -> _enumConstant__E: ...
    @staticmethod
    def explicitCast(lookup: 'MethodHandles.Lookup', string: str, class_: typing.Type[typing.Any], object: typing.Any) -> typing.Any: ...
    @staticmethod
    def fieldVarHandle(lookup: 'MethodHandles.Lookup', string: str, class_: typing.Type['VarHandle'], class2: typing.Type[typing.Any], class3: typing.Type[typing.Any]) -> 'VarHandle': ...
    @typing.overload
    @staticmethod
    def getStaticFinal(lookup: 'MethodHandles.Lookup', string: str, class_: typing.Type[typing.Any]) -> typing.Any: ...
    @typing.overload
    @staticmethod
    def getStaticFinal(lookup: 'MethodHandles.Lookup', string: str, class_: typing.Type[typing.Any], class2: typing.Type[typing.Any]) -> typing.Any: ...
    @staticmethod
    def invoke(lookup: 'MethodHandles.Lookup', string: str, class_: typing.Type[typing.Any], methodHandle: 'MethodHandle', *object: typing.Any) -> typing.Any: ...
    @staticmethod
    def nullConstant(lookup: 'MethodHandles.Lookup', string: str, class_: typing.Type[typing.Any]) -> typing.Any: ...
    @staticmethod
    def primitiveClass(lookup: 'MethodHandles.Lookup', string: str, class_: typing.Type[typing.Any]) -> typing.Type[typing.Any]: ...
    @staticmethod
    def staticFieldVarHandle(lookup: 'MethodHandles.Lookup', string: str, class_: typing.Type['VarHandle'], class2: typing.Type[typing.Any], class3: typing.Type[typing.Any]) -> 'VarHandle': ...

class LambdaConversionException(java.lang.Exception):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def __init__(self, string: str, throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, string: str, throwable: java.lang.Throwable, boolean: bool, boolean2: bool): ...
    @typing.overload
    def __init__(self, throwable: java.lang.Throwable): ...

class LambdaMetafactory:
    FLAG_SERIALIZABLE: typing.ClassVar[int] = ...
    FLAG_MARKERS: typing.ClassVar[int] = ...
    FLAG_BRIDGES: typing.ClassVar[int] = ...
    @staticmethod
    def altMetafactory(lookup: 'MethodHandles.Lookup', string: str, methodType: 'MethodType', *object: typing.Any) -> CallSite: ...
    @staticmethod
    def metafactory(lookup: 'MethodHandles.Lookup', string: str, methodType: 'MethodType', methodType2: 'MethodType', methodHandle: 'MethodHandle', methodType3: 'MethodType') -> CallSite: ...

class MethodHandle(java.lang.constant.Constable):
    @typing.overload
    def asCollector(self, int: int, class_: typing.Type[typing.Any], int2: int) -> 'MethodHandle': ...
    @typing.overload
    def asCollector(self, class_: typing.Type[typing.Any], int: int) -> 'MethodHandle': ...
    def asFixedArity(self) -> 'MethodHandle': ...
    @typing.overload
    def asSpreader(self, int: int, class_: typing.Type[typing.Any], int2: int) -> 'MethodHandle': ...
    @typing.overload
    def asSpreader(self, class_: typing.Type[typing.Any], int: int) -> 'MethodHandle': ...
    def asType(self, methodType: 'MethodType') -> 'MethodHandle': ...
    def asVarargsCollector(self, class_: typing.Type[typing.Any]) -> 'MethodHandle': ...
    def bindTo(self, object: typing.Any) -> 'MethodHandle': ...
    def describeConstable(self) -> java.util.Optional[java.lang.constant.MethodHandleDesc]: ...
    def invoke(self, *object: typing.Any) -> typing.Any: ...
    def invokeExact(self, *object: typing.Any) -> typing.Any: ...
    @typing.overload
    def invokeWithArguments(self, *object: typing.Any) -> typing.Any: ...
    @typing.overload
    def invokeWithArguments(self, list: java.util.List[typing.Any]) -> typing.Any: ...
    def isVarargsCollector(self) -> bool: ...
    def toString(self) -> str: ...
    def type(self) -> 'MethodType': ...
    def withVarargs(self, boolean: bool) -> 'MethodHandle': ...

class MethodHandleInfo:
    REF_getField: typing.ClassVar[int] = ...
    REF_getStatic: typing.ClassVar[int] = ...
    REF_putField: typing.ClassVar[int] = ...
    REF_putStatic: typing.ClassVar[int] = ...
    REF_invokeVirtual: typing.ClassVar[int] = ...
    REF_invokeStatic: typing.ClassVar[int] = ...
    REF_invokeSpecial: typing.ClassVar[int] = ...
    REF_newInvokeSpecial: typing.ClassVar[int] = ...
    REF_invokeInterface: typing.ClassVar[int] = ...
    def getDeclaringClass(self) -> typing.Type[typing.Any]: ...
    def getMethodType(self) -> 'MethodType': ...
    def getModifiers(self) -> int: ...
    def getName(self) -> str: ...
    def getReferenceKind(self) -> int: ...
    def isVarArgs(self) -> bool: ...
    @staticmethod
    def referenceKindToString(int: int) -> str: ...
    _reflectAs__T = typing.TypeVar('_reflectAs__T', bound=java.lang.reflect.Member)  # <T>
    def reflectAs(self, class_: typing.Type[_reflectAs__T], lookup: 'MethodHandles.Lookup') -> _reflectAs__T: ...
    @staticmethod
    def toString(int: int, class_: typing.Type[typing.Any], string: str, methodType: 'MethodType') -> str: ...

class MethodHandleProxies:
    _asInterfaceInstance__T = typing.TypeVar('_asInterfaceInstance__T')  # <T>
    @staticmethod
    def asInterfaceInstance(class_: typing.Type[_asInterfaceInstance__T], methodHandle: MethodHandle) -> _asInterfaceInstance__T: ...
    @staticmethod
    def isWrapperInstance(object: typing.Any) -> bool: ...
    @staticmethod
    def wrapperInstanceTarget(object: typing.Any) -> MethodHandle: ...
    @staticmethod
    def wrapperInstanceType(object: typing.Any) -> typing.Type[typing.Any]: ...

class MethodHandles:
    @staticmethod
    def arrayConstructor(class_: typing.Type[typing.Any]) -> MethodHandle: ...
    @staticmethod
    def arrayElementGetter(class_: typing.Type[typing.Any]) -> MethodHandle: ...
    @staticmethod
    def arrayElementSetter(class_: typing.Type[typing.Any]) -> MethodHandle: ...
    @staticmethod
    def arrayElementVarHandle(class_: typing.Type[typing.Any]) -> 'VarHandle': ...
    @staticmethod
    def arrayLength(class_: typing.Type[typing.Any]) -> MethodHandle: ...
    @staticmethod
    def byteArrayViewVarHandle(class_: typing.Type[typing.Any], byteOrder: java.nio.ByteOrder) -> 'VarHandle': ...
    @staticmethod
    def byteBufferViewVarHandle(class_: typing.Type[typing.Any], byteOrder: java.nio.ByteOrder) -> 'VarHandle': ...
    @staticmethod
    def catchException(methodHandle: MethodHandle, class_: typing.Type[java.lang.Throwable], methodHandle2: MethodHandle) -> MethodHandle: ...
    _classData__T = typing.TypeVar('_classData__T')  # <T>
    @staticmethod
    def classData(lookup: 'MethodHandles.Lookup', string: str, class_: typing.Type[_classData__T]) -> _classData__T: ...
    _classDataAt__T = typing.TypeVar('_classDataAt__T')  # <T>
    @staticmethod
    def classDataAt(lookup: 'MethodHandles.Lookup', string: str, class_: typing.Type[_classDataAt__T], int: int) -> _classDataAt__T: ...
    @staticmethod
    def collectArguments(methodHandle: MethodHandle, int: int, methodHandle2: MethodHandle) -> MethodHandle: ...
    @staticmethod
    def collectCoordinates(varHandle: 'VarHandle', int: int, methodHandle: MethodHandle) -> 'VarHandle': ...
    @staticmethod
    def constant(class_: typing.Type[typing.Any], object: typing.Any) -> MethodHandle: ...
    @typing.overload
    @staticmethod
    def countedLoop(methodHandle: MethodHandle, methodHandle2: MethodHandle, methodHandle3: MethodHandle) -> MethodHandle: ...
    @typing.overload
    @staticmethod
    def countedLoop(methodHandle: MethodHandle, methodHandle2: MethodHandle, methodHandle3: MethodHandle, methodHandle4: MethodHandle) -> MethodHandle: ...
    @staticmethod
    def doWhileLoop(methodHandle: MethodHandle, methodHandle2: MethodHandle, methodHandle3: MethodHandle) -> MethodHandle: ...
    @typing.overload
    @staticmethod
    def dropArguments(methodHandle: MethodHandle, int: int, *class_: typing.Type[typing.Any]) -> MethodHandle: ...
    @typing.overload
    @staticmethod
    def dropArguments(methodHandle: MethodHandle, int: int, list: java.util.List[typing.Type[typing.Any]]) -> MethodHandle: ...
    @staticmethod
    def dropArgumentsToMatch(methodHandle: MethodHandle, int: int, list: java.util.List[typing.Type[typing.Any]], int2: int) -> MethodHandle: ...
    @staticmethod
    def dropCoordinates(varHandle: 'VarHandle', int: int, *class_: typing.Type[typing.Any]) -> 'VarHandle': ...
    @staticmethod
    def dropReturn(methodHandle: MethodHandle) -> MethodHandle: ...
    @staticmethod
    def empty(methodType: 'MethodType') -> MethodHandle: ...
    @staticmethod
    def exactInvoker(methodType: 'MethodType') -> MethodHandle: ...
    @staticmethod
    def explicitCastArguments(methodHandle: MethodHandle, methodType: 'MethodType') -> MethodHandle: ...
    @staticmethod
    def filterArguments(methodHandle: MethodHandle, int: int, *methodHandle2: MethodHandle) -> MethodHandle: ...
    @staticmethod
    def filterCoordinates(varHandle: 'VarHandle', int: int, *methodHandle: MethodHandle) -> 'VarHandle': ...
    @staticmethod
    def filterReturnValue(methodHandle: MethodHandle, methodHandle2: MethodHandle) -> MethodHandle: ...
    @staticmethod
    def filterValue(varHandle: 'VarHandle', methodHandle: MethodHandle, methodHandle2: MethodHandle) -> 'VarHandle': ...
    @typing.overload
    @staticmethod
    def foldArguments(methodHandle: MethodHandle, int: int, methodHandle2: MethodHandle) -> MethodHandle: ...
    @typing.overload
    @staticmethod
    def foldArguments(methodHandle: MethodHandle, methodHandle2: MethodHandle) -> MethodHandle: ...
    @staticmethod
    def guardWithTest(methodHandle: MethodHandle, methodHandle2: MethodHandle, methodHandle3: MethodHandle) -> MethodHandle: ...
    @staticmethod
    def identity(class_: typing.Type[typing.Any]) -> MethodHandle: ...
    @staticmethod
    def insertArguments(methodHandle: MethodHandle, int: int, *object: typing.Any) -> MethodHandle: ...
    @staticmethod
    def insertCoordinates(varHandle: 'VarHandle', int: int, *object: typing.Any) -> 'VarHandle': ...
    @staticmethod
    def invoker(methodType: 'MethodType') -> MethodHandle: ...
    @staticmethod
    def iteratedLoop(methodHandle: MethodHandle, methodHandle2: MethodHandle, methodHandle3: MethodHandle) -> MethodHandle: ...
    @staticmethod
    def lookup() -> 'MethodHandles.Lookup': ...
    @staticmethod
    def loop(*methodHandleArray: typing.Union[typing.List[MethodHandle], jpype.JArray]) -> MethodHandle: ...
    @staticmethod
    def memorySegmentViewVarHandle(valueLayout: java.lang.foreign.ValueLayout) -> 'VarHandle': ...
    @staticmethod
    def permuteArguments(methodHandle: MethodHandle, methodType: 'MethodType', *int: int) -> MethodHandle: ...
    @staticmethod
    def permuteCoordinates(varHandle: 'VarHandle', list: java.util.List[typing.Type[typing.Any]], *int: int) -> 'VarHandle': ...
    @staticmethod
    def privateLookupIn(class_: typing.Type[typing.Any], lookup: 'MethodHandles.Lookup') -> 'MethodHandles.Lookup': ...
    @staticmethod
    def publicLookup() -> 'MethodHandles.Lookup': ...
    _reflectAs__T = typing.TypeVar('_reflectAs__T', bound=java.lang.reflect.Member)  # <T>
    @staticmethod
    def reflectAs(class_: typing.Type[_reflectAs__T], methodHandle: MethodHandle) -> _reflectAs__T: ...
    @staticmethod
    def spreadInvoker(methodType: 'MethodType', int: int) -> MethodHandle: ...
    @staticmethod
    def tableSwitch(methodHandle: MethodHandle, *methodHandle2: MethodHandle) -> MethodHandle: ...
    @staticmethod
    def throwException(class_: typing.Type[typing.Any], class2: typing.Type[java.lang.Throwable]) -> MethodHandle: ...
    @staticmethod
    def tryFinally(methodHandle: MethodHandle, methodHandle2: MethodHandle) -> MethodHandle: ...
    @staticmethod
    def varHandleExactInvoker(accessMode: 'VarHandle.AccessMode', methodType: 'MethodType') -> MethodHandle: ...
    @staticmethod
    def varHandleInvoker(accessMode: 'VarHandle.AccessMode', methodType: 'MethodType') -> MethodHandle: ...
    @staticmethod
    def whileLoop(methodHandle: MethodHandle, methodHandle2: MethodHandle, methodHandle3: MethodHandle) -> MethodHandle: ...
    @staticmethod
    def zero(class_: typing.Type[typing.Any]) -> MethodHandle: ...
    class Lookup:
        PUBLIC: typing.ClassVar[int] = ...
        PRIVATE: typing.ClassVar[int] = ...
        PROTECTED: typing.ClassVar[int] = ...
        PACKAGE: typing.ClassVar[int] = ...
        MODULE: typing.ClassVar[int] = ...
        UNCONDITIONAL: typing.ClassVar[int] = ...
        ORIGINAL: typing.ClassVar[int] = ...
        _accessClass__T = typing.TypeVar('_accessClass__T')  # <T>
        def accessClass(self, class_: typing.Type[_accessClass__T]) -> typing.Type[_accessClass__T]: ...
        def bind(self, object: typing.Any, string: str, methodType: 'MethodType') -> MethodHandle: ...
        def defineClass(self, byteArray: typing.Union[typing.List[int], jpype.JArray, bytes]) -> typing.Type[typing.Any]: ...
        def defineHiddenClass(self, byteArray: typing.Union[typing.List[int], jpype.JArray, bytes], boolean: bool, *classOption: 'MethodHandles.Lookup.ClassOption') -> 'MethodHandles.Lookup': ...
        def defineHiddenClassWithClassData(self, byteArray: typing.Union[typing.List[int], jpype.JArray, bytes], object: typing.Any, boolean: bool, *classOption: 'MethodHandles.Lookup.ClassOption') -> 'MethodHandles.Lookup': ...
        def dropLookupMode(self, int: int) -> 'MethodHandles.Lookup': ...
        _ensureInitialized__T = typing.TypeVar('_ensureInitialized__T')  # <T>
        def ensureInitialized(self, class_: typing.Type[_ensureInitialized__T]) -> typing.Type[_ensureInitialized__T]: ...
        def findClass(self, string: str) -> typing.Type[typing.Any]: ...
        def findConstructor(self, class_: typing.Type[typing.Any], methodType: 'MethodType') -> MethodHandle: ...
        def findGetter(self, class_: typing.Type[typing.Any], string: str, class2: typing.Type[typing.Any]) -> MethodHandle: ...
        def findSetter(self, class_: typing.Type[typing.Any], string: str, class2: typing.Type[typing.Any]) -> MethodHandle: ...
        def findSpecial(self, class_: typing.Type[typing.Any], string: str, methodType: 'MethodType', class2: typing.Type[typing.Any]) -> MethodHandle: ...
        def findStatic(self, class_: typing.Type[typing.Any], string: str, methodType: 'MethodType') -> MethodHandle: ...
        def findStaticGetter(self, class_: typing.Type[typing.Any], string: str, class2: typing.Type[typing.Any]) -> MethodHandle: ...
        def findStaticSetter(self, class_: typing.Type[typing.Any], string: str, class2: typing.Type[typing.Any]) -> MethodHandle: ...
        def findStaticVarHandle(self, class_: typing.Type[typing.Any], string: str, class2: typing.Type[typing.Any]) -> 'VarHandle': ...
        def findVarHandle(self, class_: typing.Type[typing.Any], string: str, class2: typing.Type[typing.Any]) -> 'VarHandle': ...
        def findVirtual(self, class_: typing.Type[typing.Any], string: str, methodType: 'MethodType') -> MethodHandle: ...
        def hasFullPrivilegeAccess(self) -> bool: ...
        def hasPrivateAccess(self) -> bool: ...
        def in_(self, class_: typing.Type[typing.Any]) -> 'MethodHandles.Lookup': ...
        def lookupClass(self) -> typing.Type[typing.Any]: ...
        def lookupModes(self) -> int: ...
        def previousLookupClass(self) -> typing.Type[typing.Any]: ...
        def revealDirect(self, methodHandle: MethodHandle) -> MethodHandleInfo: ...
        def toString(self) -> str: ...
        def unreflect(self, method: java.lang.reflect.Method) -> MethodHandle: ...
        def unreflectConstructor(self, constructor: java.lang.reflect.Constructor[typing.Any]) -> MethodHandle: ...
        def unreflectGetter(self, field: java.lang.reflect.Field) -> MethodHandle: ...
        def unreflectSetter(self, field: java.lang.reflect.Field) -> MethodHandle: ...
        def unreflectSpecial(self, method: java.lang.reflect.Method, class_: typing.Type[typing.Any]) -> MethodHandle: ...
        def unreflectVarHandle(self, field: java.lang.reflect.Field) -> 'VarHandle': ...
        class ClassOption(java.lang.Enum['MethodHandles.Lookup.ClassOption']):
            NESTMATE: typing.ClassVar['MethodHandles.Lookup.ClassOption'] = ...
            STRONG: typing.ClassVar['MethodHandles.Lookup.ClassOption'] = ...
            _valueOf_0__T = typing.TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
            @typing.overload
            @staticmethod
            def valueOf(class_: typing.Type[_valueOf_0__T], string: str) -> _valueOf_0__T: ...
            @typing.overload
            @staticmethod
            def valueOf(string: str) -> 'MethodHandles.Lookup.ClassOption': ...
            @staticmethod
            def values() -> typing.MutableSequence['MethodHandles.Lookup.ClassOption']: ...

class SerializedLambda(java.io.Serializable):
    def __init__(self, class_: typing.Type[typing.Any], string: str, string2: str, string3: str, int: int, string4: str, string5: str, string6: str, string7: str, objectArray: typing.Union[typing.List[typing.Any], jpype.JArray]): ...
    def getCapturedArg(self, int: int) -> typing.Any: ...
    def getCapturedArgCount(self) -> int: ...
    def getCapturingClass(self) -> str: ...
    def getFunctionalInterfaceClass(self) -> str: ...
    def getFunctionalInterfaceMethodName(self) -> str: ...
    def getFunctionalInterfaceMethodSignature(self) -> str: ...
    def getImplClass(self) -> str: ...
    def getImplMethodKind(self) -> int: ...
    def getImplMethodName(self) -> str: ...
    def getImplMethodSignature(self) -> str: ...
    def getInstantiatedMethodType(self) -> str: ...
    def toString(self) -> str: ...

class StringConcatException(java.lang.Exception):
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def __init__(self, string: str, throwable: java.lang.Throwable): ...

class StringConcatFactory:
    MAX_INDY_CONCAT_ARG_SLOTS: typing.ClassVar[int] = ...
    @staticmethod
    def makeConcat(lookup: MethodHandles.Lookup, string: str, methodType: 'MethodType') -> CallSite: ...
    @staticmethod
    def makeConcatWithConstants(lookup: MethodHandles.Lookup, string: str, methodType: 'MethodType', string2: str, *object: typing.Any) -> CallSite: ...
    @staticmethod
    def makeConcatWithTemplate(list: java.util.List[str], list2: java.util.List[typing.Type[typing.Any]]) -> MethodHandle: ...
    @staticmethod
    def makeConcatWithTemplateCluster(list: java.util.List[str], list2: java.util.List[typing.Type[typing.Any]], int: int) -> java.util.List[MethodHandle]: ...
    @staticmethod
    def makeConcatWithTemplateGetters(list: java.util.List[str], list2: java.util.List[MethodHandle], int: int) -> MethodHandle: ...

class SwitchPoint:
    def __init__(self): ...
    def guardWithTest(self, methodHandle: MethodHandle, methodHandle2: MethodHandle) -> MethodHandle: ...
    def hasBeenInvalidated(self) -> bool: ...
    @staticmethod
    def invalidateAll(switchPointArray: typing.Union[typing.List['SwitchPoint'], jpype.JArray]) -> None: ...

class TypeDescriptor:
    def descriptorString(self) -> str: ...

class VarHandle(java.lang.constant.Constable):
    def accessModeType(self, accessMode: 'VarHandle.AccessMode') -> 'MethodType': ...
    @staticmethod
    def acquireFence() -> None: ...
    def compareAndExchange(self, *object: typing.Any) -> typing.Any: ...
    def compareAndExchangeAcquire(self, *object: typing.Any) -> typing.Any: ...
    def compareAndExchangeRelease(self, *object: typing.Any) -> typing.Any: ...
    def compareAndSet(self, *object: typing.Any) -> bool: ...
    def coordinateTypes(self) -> java.util.List[typing.Type[typing.Any]]: ...
    def describeConstable(self) -> java.util.Optional['VarHandle.VarHandleDesc']: ...
    @staticmethod
    def fullFence() -> None: ...
    def get(self, *object: typing.Any) -> typing.Any: ...
    def getAcquire(self, *object: typing.Any) -> typing.Any: ...
    def getAndAdd(self, *object: typing.Any) -> typing.Any: ...
    def getAndAddAcquire(self, *object: typing.Any) -> typing.Any: ...
    def getAndAddRelease(self, *object: typing.Any) -> typing.Any: ...
    def getAndBitwiseAnd(self, *object: typing.Any) -> typing.Any: ...
    def getAndBitwiseAndAcquire(self, *object: typing.Any) -> typing.Any: ...
    def getAndBitwiseAndRelease(self, *object: typing.Any) -> typing.Any: ...
    def getAndBitwiseOr(self, *object: typing.Any) -> typing.Any: ...
    def getAndBitwiseOrAcquire(self, *object: typing.Any) -> typing.Any: ...
    def getAndBitwiseOrRelease(self, *object: typing.Any) -> typing.Any: ...
    def getAndBitwiseXor(self, *object: typing.Any) -> typing.Any: ...
    def getAndBitwiseXorAcquire(self, *object: typing.Any) -> typing.Any: ...
    def getAndBitwiseXorRelease(self, *object: typing.Any) -> typing.Any: ...
    def getAndSet(self, *object: typing.Any) -> typing.Any: ...
    def getAndSetAcquire(self, *object: typing.Any) -> typing.Any: ...
    def getAndSetRelease(self, *object: typing.Any) -> typing.Any: ...
    def getOpaque(self, *object: typing.Any) -> typing.Any: ...
    def getVolatile(self, *object: typing.Any) -> typing.Any: ...
    def hasInvokeExactBehavior(self) -> bool: ...
    def isAccessModeSupported(self, accessMode: 'VarHandle.AccessMode') -> bool: ...
    @staticmethod
    def loadLoadFence() -> None: ...
    @staticmethod
    def releaseFence() -> None: ...
    def set(self, *object: typing.Any) -> None: ...
    def setOpaque(self, *object: typing.Any) -> None: ...
    def setRelease(self, *object: typing.Any) -> None: ...
    def setVolatile(self, *object: typing.Any) -> None: ...
    @staticmethod
    def storeStoreFence() -> None: ...
    def toMethodHandle(self, accessMode: 'VarHandle.AccessMode') -> MethodHandle: ...
    def toString(self) -> str: ...
    def varType(self) -> typing.Type[typing.Any]: ...
    def weakCompareAndSet(self, *object: typing.Any) -> bool: ...
    def weakCompareAndSetAcquire(self, *object: typing.Any) -> bool: ...
    def weakCompareAndSetPlain(self, *object: typing.Any) -> bool: ...
    def weakCompareAndSetRelease(self, *object: typing.Any) -> bool: ...
    def withInvokeBehavior(self) -> 'VarHandle': ...
    def withInvokeExactBehavior(self) -> 'VarHandle': ...
    class AccessMode(java.lang.Enum['VarHandle.AccessMode']):
        GET: typing.ClassVar['VarHandle.AccessMode'] = ...
        SET: typing.ClassVar['VarHandle.AccessMode'] = ...
        GET_VOLATILE: typing.ClassVar['VarHandle.AccessMode'] = ...
        SET_VOLATILE: typing.ClassVar['VarHandle.AccessMode'] = ...
        GET_ACQUIRE: typing.ClassVar['VarHandle.AccessMode'] = ...
        SET_RELEASE: typing.ClassVar['VarHandle.AccessMode'] = ...
        GET_OPAQUE: typing.ClassVar['VarHandle.AccessMode'] = ...
        SET_OPAQUE: typing.ClassVar['VarHandle.AccessMode'] = ...
        COMPARE_AND_SET: typing.ClassVar['VarHandle.AccessMode'] = ...
        COMPARE_AND_EXCHANGE: typing.ClassVar['VarHandle.AccessMode'] = ...
        COMPARE_AND_EXCHANGE_ACQUIRE: typing.ClassVar['VarHandle.AccessMode'] = ...
        COMPARE_AND_EXCHANGE_RELEASE: typing.ClassVar['VarHandle.AccessMode'] = ...
        WEAK_COMPARE_AND_SET_PLAIN: typing.ClassVar['VarHandle.AccessMode'] = ...
        WEAK_COMPARE_AND_SET: typing.ClassVar['VarHandle.AccessMode'] = ...
        WEAK_COMPARE_AND_SET_ACQUIRE: typing.ClassVar['VarHandle.AccessMode'] = ...
        WEAK_COMPARE_AND_SET_RELEASE: typing.ClassVar['VarHandle.AccessMode'] = ...
        GET_AND_SET: typing.ClassVar['VarHandle.AccessMode'] = ...
        GET_AND_SET_ACQUIRE: typing.ClassVar['VarHandle.AccessMode'] = ...
        GET_AND_SET_RELEASE: typing.ClassVar['VarHandle.AccessMode'] = ...
        GET_AND_ADD: typing.ClassVar['VarHandle.AccessMode'] = ...
        GET_AND_ADD_ACQUIRE: typing.ClassVar['VarHandle.AccessMode'] = ...
        GET_AND_ADD_RELEASE: typing.ClassVar['VarHandle.AccessMode'] = ...
        GET_AND_BITWISE_OR: typing.ClassVar['VarHandle.AccessMode'] = ...
        GET_AND_BITWISE_OR_RELEASE: typing.ClassVar['VarHandle.AccessMode'] = ...
        GET_AND_BITWISE_OR_ACQUIRE: typing.ClassVar['VarHandle.AccessMode'] = ...
        GET_AND_BITWISE_AND: typing.ClassVar['VarHandle.AccessMode'] = ...
        GET_AND_BITWISE_AND_RELEASE: typing.ClassVar['VarHandle.AccessMode'] = ...
        GET_AND_BITWISE_AND_ACQUIRE: typing.ClassVar['VarHandle.AccessMode'] = ...
        GET_AND_BITWISE_XOR: typing.ClassVar['VarHandle.AccessMode'] = ...
        GET_AND_BITWISE_XOR_RELEASE: typing.ClassVar['VarHandle.AccessMode'] = ...
        GET_AND_BITWISE_XOR_ACQUIRE: typing.ClassVar['VarHandle.AccessMode'] = ...
        def methodName(self) -> str: ...
        @staticmethod
        def valueFromMethodName(string: str) -> 'VarHandle.AccessMode': ...
        _valueOf_0__T = typing.TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
        @typing.overload
        @staticmethod
        def valueOf(class_: typing.Type[_valueOf_0__T], string: str) -> _valueOf_0__T: ...
        @typing.overload
        @staticmethod
        def valueOf(string: str) -> 'VarHandle.AccessMode': ...
        @staticmethod
        def values() -> typing.MutableSequence['VarHandle.AccessMode']: ...
    class VarHandleDesc(java.lang.constant.DynamicConstantDesc['VarHandle']):
        @staticmethod
        def ofArray(classDesc: java.lang.constant.ClassDesc) -> 'VarHandle.VarHandleDesc': ...
        @staticmethod
        def ofField(classDesc: java.lang.constant.ClassDesc, string: str, classDesc2: java.lang.constant.ClassDesc) -> 'VarHandle.VarHandleDesc': ...
        @staticmethod
        def ofStaticField(classDesc: java.lang.constant.ClassDesc, string: str, classDesc2: java.lang.constant.ClassDesc) -> 'VarHandle.VarHandleDesc': ...
        def resolveConstantDesc(self, lookup: MethodHandles.Lookup) -> 'VarHandle': ...
        def toString(self) -> str: ...
        def varType(self) -> java.lang.constant.ClassDesc: ...

class WrongMethodTypeException(java.lang.RuntimeException):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...

class ConstantCallSite(CallSite):
    def __init__(self, methodHandle: MethodHandle): ...
    def dynamicInvoker(self) -> MethodHandle: ...
    def getTarget(self) -> MethodHandle: ...
    def setTarget(self, methodHandle: MethodHandle) -> None: ...

class MutableCallSite(CallSite):
    @typing.overload
    def __init__(self, methodHandle: MethodHandle): ...
    @typing.overload
    def __init__(self, methodType: 'MethodType'): ...
    def dynamicInvoker(self) -> MethodHandle: ...
    def getTarget(self) -> MethodHandle: ...
    def setTarget(self, methodHandle: MethodHandle) -> None: ...
    @staticmethod
    def syncAll(mutableCallSiteArray: typing.Union[typing.List['MutableCallSite'], jpype.JArray]) -> None: ...

class VolatileCallSite(CallSite):
    @typing.overload
    def __init__(self, methodHandle: MethodHandle): ...
    @typing.overload
    def __init__(self, methodType: 'MethodType'): ...
    def dynamicInvoker(self) -> MethodHandle: ...
    def getTarget(self) -> MethodHandle: ...
    def setTarget(self, methodHandle: MethodHandle) -> None: ...

class MethodType(java.lang.constant.Constable, java.lang.invoke.TypeDescriptor.OfMethod[typing.Type[typing.Any], 'MethodType'], java.io.Serializable):
    @typing.overload
    def appendParameterTypes(self, *class_: typing.Type[typing.Any]) -> 'MethodType': ...
    @typing.overload
    def appendParameterTypes(self, list: java.util.List[typing.Type[typing.Any]]) -> 'MethodType': ...
    def changeParameterType(self, int: int, class_: typing.Type[typing.Any]) -> 'MethodType': ...
    def changeReturnType(self, class_: typing.Type[typing.Any]) -> 'MethodType': ...
    def describeConstable(self) -> java.util.Optional[java.lang.constant.MethodTypeDesc]: ...
    def descriptorString(self) -> str: ...
    def dropParameterTypes(self, int: int, int2: int) -> 'MethodType': ...
    def equals(self, object: typing.Any) -> bool: ...
    def erase(self) -> 'MethodType': ...
    @staticmethod
    def fromMethodDescriptorString(string: str, classLoader: java.lang.ClassLoader) -> 'MethodType': ...
    def generic(self) -> 'MethodType': ...
    @typing.overload
    @staticmethod
    def genericMethodType(int: int) -> 'MethodType': ...
    @typing.overload
    @staticmethod
    def genericMethodType(int: int, boolean: bool) -> 'MethodType': ...
    def hasPrimitives(self) -> bool: ...
    def hasWrappers(self) -> bool: ...
    def hashCode(self) -> int: ...
    @typing.overload
    def insertParameterTypes(self, int: int, *class_: typing.Type[typing.Any]) -> 'MethodType': ...
    @typing.overload
    def insertParameterTypes(self, int: int, list: java.util.List[typing.Type[typing.Any]]) -> 'MethodType': ...
    def lastParameterType(self) -> typing.Type[typing.Any]: ...
    @typing.overload
    @staticmethod
    def methodType(class_: typing.Type[typing.Any]) -> 'MethodType': ...
    @typing.overload
    @staticmethod
    def methodType(class_: typing.Type[typing.Any], class2: typing.Type[typing.Any]) -> 'MethodType': ...
    @typing.overload
    @staticmethod
    def methodType(class_: typing.Type[typing.Any], class2: typing.Type[typing.Any], *class3: typing.Type[typing.Any]) -> 'MethodType': ...
    @typing.overload
    @staticmethod
    def methodType(class_: typing.Type[typing.Any], classArray: typing.Union[typing.List[typing.Type[typing.Any]], jpype.JArray]) -> 'MethodType': ...
    @typing.overload
    @staticmethod
    def methodType(class_: typing.Type[typing.Any], methodType: 'MethodType') -> 'MethodType': ...
    @typing.overload
    @staticmethod
    def methodType(class_: typing.Type[typing.Any], list: java.util.List[typing.Type[typing.Any]]) -> 'MethodType': ...
    def parameterArray(self) -> typing.MutableSequence[typing.Type[typing.Any]]: ...
    def parameterCount(self) -> int: ...
    def parameterList(self) -> java.util.List[typing.Type[typing.Any]]: ...
    def parameterType(self, int: int) -> typing.Type[typing.Any]: ...
    def returnType(self) -> typing.Type[typing.Any]: ...
    def toMethodDescriptorString(self) -> str: ...
    def toString(self) -> str: ...
    def unwrap(self) -> 'MethodType': ...
    def wrap(self) -> 'MethodType': ...


class __module_protocol__(Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("java.lang.invoke")``.

    CallSite: typing.Type[CallSite]
    ConstantBootstraps: typing.Type[ConstantBootstraps]
    ConstantCallSite: typing.Type[ConstantCallSite]
    LambdaConversionException: typing.Type[LambdaConversionException]
    LambdaMetafactory: typing.Type[LambdaMetafactory]
    MethodHandle: typing.Type[MethodHandle]
    MethodHandleInfo: typing.Type[MethodHandleInfo]
    MethodHandleProxies: typing.Type[MethodHandleProxies]
    MethodHandles: typing.Type[MethodHandles]
    MethodType: typing.Type[MethodType]
    MutableCallSite: typing.Type[MutableCallSite]
    SerializedLambda: typing.Type[SerializedLambda]
    StringConcatException: typing.Type[StringConcatException]
    StringConcatFactory: typing.Type[StringConcatFactory]
    SwitchPoint: typing.Type[SwitchPoint]
    TypeDescriptor: typing.Type[TypeDescriptor]
    VarHandle: typing.Type[VarHandle]
    VolatileCallSite: typing.Type[VolatileCallSite]
    WrongMethodTypeException: typing.Type[WrongMethodTypeException]
