
import sys
if sys.version_info >= (3, 8):
    from typing import Protocol
else:
    from typing_extensions import Protocol

import java
import java.lang
import java.lang.invoke
import java.nio
import java.nio.file
import java.util
import java.util.function
import java.util.stream
import jpype
import jpype.protocol
import typing



class FunctionDescriptor:
    def appendArgumentLayouts(self, *memoryLayout: 'MemoryLayout') -> 'FunctionDescriptor': ...
    def argumentLayouts(self) -> java.util.List['MemoryLayout']: ...
    def changeReturnLayout(self, memoryLayout: 'MemoryLayout') -> 'FunctionDescriptor': ...
    def dropReturnLayout(self) -> 'FunctionDescriptor': ...
    def insertArgumentLayouts(self, int: int, *memoryLayout: 'MemoryLayout') -> 'FunctionDescriptor': ...
    @staticmethod
    def of(memoryLayout: 'MemoryLayout', *memoryLayout2: 'MemoryLayout') -> 'FunctionDescriptor': ...
    @staticmethod
    def ofVoid(*memoryLayout: 'MemoryLayout') -> 'FunctionDescriptor': ...
    def returnLayout(self) -> java.util.Optional['MemoryLayout']: ...
    def toMethodType(self) -> java.lang.invoke.MethodType: ...

class Linker:
    def defaultLookup(self) -> 'SymbolLookup': ...
    @typing.overload
    def downcallHandle(self, functionDescriptor: FunctionDescriptor, *option: 'Linker.Option') -> java.lang.invoke.MethodHandle: ...
    @typing.overload
    def downcallHandle(self, memorySegment: 'MemorySegment', functionDescriptor: FunctionDescriptor, *option: 'Linker.Option') -> java.lang.invoke.MethodHandle: ...
    @staticmethod
    def nativeLinker() -> 'Linker': ...
    def upcallStub(self, methodHandle: java.lang.invoke.MethodHandle, functionDescriptor: FunctionDescriptor, arena: 'Arena', *option: 'Linker.Option') -> 'MemorySegment': ...
    class Option:
        @staticmethod
        def captureCallState(*string: str) -> 'Linker.Option': ...
        @staticmethod
        def captureStateLayout() -> 'StructLayout': ...
        @staticmethod
        def firstVariadicArg(int: int) -> 'Linker.Option': ...
        @staticmethod
        def isTrivial() -> 'Linker.Option': ...

class MemoryLayout:
    def byteAlignment(self) -> int: ...
    def byteOffset(self, *pathElement: 'MemoryLayout.PathElement') -> int: ...
    def byteOffsetHandle(self, *pathElement: 'MemoryLayout.PathElement') -> java.lang.invoke.MethodHandle: ...
    def byteSize(self) -> int: ...
    def equals(self, object: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def name(self) -> java.util.Optional[str]: ...
    @staticmethod
    def paddingLayout(long: int) -> 'PaddingLayout': ...
    def select(self, *pathElement: 'MemoryLayout.PathElement') -> 'MemoryLayout': ...
    @typing.overload
    @staticmethod
    def sequenceLayout(memoryLayout: 'MemoryLayout') -> 'SequenceLayout': ...
    @typing.overload
    @staticmethod
    def sequenceLayout(long: int, memoryLayout: 'MemoryLayout') -> 'SequenceLayout': ...
    def sliceHandle(self, *pathElement: 'MemoryLayout.PathElement') -> java.lang.invoke.MethodHandle: ...
    @staticmethod
    def structLayout(*memoryLayout: 'MemoryLayout') -> 'StructLayout': ...
    def toString(self) -> str: ...
    @staticmethod
    def unionLayout(*memoryLayout: 'MemoryLayout') -> 'UnionLayout': ...
    def varHandle(self, *pathElement: 'MemoryLayout.PathElement') -> java.lang.invoke.VarHandle: ...
    def withByteAlignment(self, long: int) -> 'MemoryLayout': ...
    def withName(self, string: str) -> 'MemoryLayout': ...
    def withoutName(self) -> 'MemoryLayout': ...
    class PathElement:
        @staticmethod
        def dereferenceElement() -> 'MemoryLayout.PathElement': ...
        @typing.overload
        @staticmethod
        def groupElement(string: str) -> 'MemoryLayout.PathElement': ...
        @typing.overload
        @staticmethod
        def groupElement(long: int) -> 'MemoryLayout.PathElement': ...
        @typing.overload
        @staticmethod
        def sequenceElement() -> 'MemoryLayout.PathElement': ...
        @typing.overload
        @staticmethod
        def sequenceElement(long: int) -> 'MemoryLayout.PathElement': ...
        @typing.overload
        @staticmethod
        def sequenceElement(long: int, long2: int) -> 'MemoryLayout.PathElement': ...

class MemorySegment:
    NULL: typing.ClassVar['MemorySegment'] = ...
    def address(self) -> int: ...
    def asByteBuffer(self) -> java.nio.ByteBuffer: ...
    def asOverlappingSlice(self, memorySegment: 'MemorySegment') -> java.util.Optional['MemorySegment']: ...
    def asReadOnly(self) -> 'MemorySegment': ...
    @typing.overload
    def asSlice(self, long: int) -> 'MemorySegment': ...
    @typing.overload
    def asSlice(self, long: int, long2: int) -> 'MemorySegment': ...
    @typing.overload
    def asSlice(self, long: int, long2: int, long3: int) -> 'MemorySegment': ...
    @typing.overload
    def asSlice(self, long: int, memoryLayout: MemoryLayout) -> 'MemorySegment': ...
    def byteSize(self) -> int: ...
    @typing.overload
    @staticmethod
    def copy(object: typing.Any, int: int, memorySegment: 'MemorySegment', valueLayout: 'ValueLayout', long: int, int2: int) -> None: ...
    @typing.overload
    @staticmethod
    def copy(memorySegment: 'MemorySegment', valueLayout: 'ValueLayout', long: int, object: typing.Any, int: int, int2: int) -> None: ...
    @typing.overload
    @staticmethod
    def copy(memorySegment: 'MemorySegment', valueLayout: 'ValueLayout', long: int, memorySegment2: 'MemorySegment', valueLayout2: 'ValueLayout', long2: int, long3: int) -> None: ...
    @typing.overload
    @staticmethod
    def copy(memorySegment: 'MemorySegment', long: int, memorySegment2: 'MemorySegment', long2: int, long3: int) -> None: ...
    def copyFrom(self, memorySegment: 'MemorySegment') -> 'MemorySegment': ...
    def elements(self, memoryLayout: MemoryLayout) -> java.util.stream.Stream['MemorySegment']: ...
    def equals(self, object: typing.Any) -> bool: ...
    def fill(self, byte: int) -> 'MemorySegment': ...
    def force(self) -> None: ...
    @typing.overload
    def get(self, ofBoolean: 'ValueLayout.OfBoolean', long: int) -> bool: ...
    @typing.overload
    def get(self, ofByte: 'ValueLayout.OfByte', long: int) -> int: ...
    @typing.overload
    def get(self, ofChar: 'ValueLayout.OfChar', long: int) -> str: ...
    @typing.overload
    def get(self, ofDouble: 'ValueLayout.OfDouble', long: int) -> float: ...
    @typing.overload
    def get(self, ofFloat: 'ValueLayout.OfFloat', long: int) -> float: ...
    @typing.overload
    def get(self, ofInt: 'ValueLayout.OfInt', long: int) -> int: ...
    @typing.overload
    def get(self, addressLayout: 'AddressLayout', long: int) -> 'MemorySegment': ...
    @typing.overload
    def get(self, ofLong: 'ValueLayout.OfLong', long: int) -> int: ...
    @typing.overload
    def get(self, ofShort: 'ValueLayout.OfShort', long: int) -> int: ...
    @typing.overload
    def getAtIndex(self, ofBoolean: 'ValueLayout.OfBoolean', long: int) -> bool: ...
    @typing.overload
    def getAtIndex(self, ofByte: 'ValueLayout.OfByte', long: int) -> int: ...
    @typing.overload
    def getAtIndex(self, ofChar: 'ValueLayout.OfChar', long: int) -> str: ...
    @typing.overload
    def getAtIndex(self, ofDouble: 'ValueLayout.OfDouble', long: int) -> float: ...
    @typing.overload
    def getAtIndex(self, ofFloat: 'ValueLayout.OfFloat', long: int) -> float: ...
    @typing.overload
    def getAtIndex(self, ofInt: 'ValueLayout.OfInt', long: int) -> int: ...
    @typing.overload
    def getAtIndex(self, addressLayout: 'AddressLayout', long: int) -> 'MemorySegment': ...
    @typing.overload
    def getAtIndex(self, ofLong: 'ValueLayout.OfLong', long: int) -> int: ...
    @typing.overload
    def getAtIndex(self, ofShort: 'ValueLayout.OfShort', long: int) -> int: ...
    def getUtf8String(self, long: int) -> str: ...
    def hashCode(self) -> int: ...
    def heapBase(self) -> java.util.Optional[typing.Any]: ...
    def isAccessibleBy(self, thread: java.lang.Thread) -> bool: ...
    def isLoaded(self) -> bool: ...
    def isMapped(self) -> bool: ...
    def isNative(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def load(self) -> None: ...
    @typing.overload
    def mismatch(self, memorySegment: 'MemorySegment') -> int: ...
    @typing.overload
    @staticmethod
    def mismatch(memorySegment: 'MemorySegment', long: int, long2: int, memorySegment2: 'MemorySegment', long3: int, long4: int) -> int: ...
    @staticmethod
    def ofAddress(long: int) -> 'MemorySegment': ...
    @typing.overload
    @staticmethod
    def ofArray(byteArray: typing.Union[typing.List[int], jpype.JArray, bytes]) -> 'MemorySegment': ...
    @typing.overload
    @staticmethod
    def ofArray(charArray: typing.Union[typing.List[str], jpype.JArray]) -> 'MemorySegment': ...
    @typing.overload
    @staticmethod
    def ofArray(doubleArray: typing.Union[typing.List[float], jpype.JArray]) -> 'MemorySegment': ...
    @typing.overload
    @staticmethod
    def ofArray(floatArray: typing.Union[typing.List[float], jpype.JArray]) -> 'MemorySegment': ...
    @typing.overload
    @staticmethod
    def ofArray(intArray: typing.Union[typing.List[int], jpype.JArray]) -> 'MemorySegment': ...
    @typing.overload
    @staticmethod
    def ofArray(longArray: typing.Union[typing.List[int], jpype.JArray]) -> 'MemorySegment': ...
    @typing.overload
    @staticmethod
    def ofArray(shortArray: typing.Union[typing.List[int], jpype.JArray]) -> 'MemorySegment': ...
    @staticmethod
    def ofBuffer(buffer: java.nio.Buffer) -> 'MemorySegment': ...
    @typing.overload
    def reinterpret(self, arena: 'Arena', consumer: typing.Union[java.util.function.Consumer['MemorySegment'], typing.Callable[['MemorySegment'], None]]) -> 'MemorySegment': ...
    @typing.overload
    def reinterpret(self, long: int) -> 'MemorySegment': ...
    @typing.overload
    def reinterpret(self, long: int, arena: 'Arena', consumer: typing.Union[java.util.function.Consumer['MemorySegment'], typing.Callable[['MemorySegment'], None]]) -> 'MemorySegment': ...
    def scope(self) -> 'MemorySegment.Scope': ...
    def segmentOffset(self, memorySegment: 'MemorySegment') -> int: ...
    @typing.overload
    def set(self, addressLayout: 'AddressLayout', long: int, memorySegment: 'MemorySegment') -> None: ...
    @typing.overload
    def set(self, ofBoolean: 'ValueLayout.OfBoolean', long: int, boolean: bool) -> None: ...
    @typing.overload
    def set(self, ofByte: 'ValueLayout.OfByte', long: int, byte: int) -> None: ...
    @typing.overload
    def set(self, ofChar: 'ValueLayout.OfChar', long: int, char: str) -> None: ...
    @typing.overload
    def set(self, ofDouble: 'ValueLayout.OfDouble', long: int, double: float) -> None: ...
    @typing.overload
    def set(self, ofFloat: 'ValueLayout.OfFloat', long: int, float: float) -> None: ...
    @typing.overload
    def set(self, ofInt: 'ValueLayout.OfInt', long: int, int: int) -> None: ...
    @typing.overload
    def set(self, ofLong: 'ValueLayout.OfLong', long: int, long2: int) -> None: ...
    @typing.overload
    def set(self, ofShort: 'ValueLayout.OfShort', long: int, short: int) -> None: ...
    @typing.overload
    def setAtIndex(self, addressLayout: 'AddressLayout', long: int, memorySegment: 'MemorySegment') -> None: ...
    @typing.overload
    def setAtIndex(self, ofBoolean: 'ValueLayout.OfBoolean', long: int, boolean: bool) -> None: ...
    @typing.overload
    def setAtIndex(self, ofByte: 'ValueLayout.OfByte', long: int, byte: int) -> None: ...
    @typing.overload
    def setAtIndex(self, ofChar: 'ValueLayout.OfChar', long: int, char: str) -> None: ...
    @typing.overload
    def setAtIndex(self, ofDouble: 'ValueLayout.OfDouble', long: int, double: float) -> None: ...
    @typing.overload
    def setAtIndex(self, ofFloat: 'ValueLayout.OfFloat', long: int, float: float) -> None: ...
    @typing.overload
    def setAtIndex(self, ofInt: 'ValueLayout.OfInt', long: int, int: int) -> None: ...
    @typing.overload
    def setAtIndex(self, ofLong: 'ValueLayout.OfLong', long: int, long2: int) -> None: ...
    @typing.overload
    def setAtIndex(self, ofShort: 'ValueLayout.OfShort', long: int, short: int) -> None: ...
    def setUtf8String(self, long: int, string: str) -> None: ...
    def spliterator(self, memoryLayout: MemoryLayout) -> java.util.Spliterator['MemorySegment']: ...
    @typing.overload
    def toArray(self, ofByte: 'ValueLayout.OfByte') -> typing.MutableSequence[int]: ...
    @typing.overload
    def toArray(self, ofChar: 'ValueLayout.OfChar') -> typing.MutableSequence[str]: ...
    @typing.overload
    def toArray(self, ofDouble: 'ValueLayout.OfDouble') -> typing.MutableSequence[float]: ...
    @typing.overload
    def toArray(self, ofFloat: 'ValueLayout.OfFloat') -> typing.MutableSequence[float]: ...
    @typing.overload
    def toArray(self, ofInt: 'ValueLayout.OfInt') -> typing.MutableSequence[int]: ...
    @typing.overload
    def toArray(self, ofLong: 'ValueLayout.OfLong') -> typing.MutableSequence[int]: ...
    @typing.overload
    def toArray(self, ofShort: 'ValueLayout.OfShort') -> typing.MutableSequence[int]: ...
    def unload(self) -> None: ...
    class Scope:
        def equals(self, object: typing.Any) -> bool: ...
        def hashCode(self) -> int: ...
        def isAlive(self) -> bool: ...

class SegmentAllocator:
    @typing.overload
    def allocate(self, long: int, long2: int) -> MemorySegment: ...
    @typing.overload
    def allocate(self, addressLayout: 'AddressLayout', memorySegment: MemorySegment) -> MemorySegment: ...
    @typing.overload
    def allocate(self, memoryLayout: MemoryLayout) -> MemorySegment: ...
    @typing.overload
    def allocate(self, ofByte: 'ValueLayout.OfByte', byte: int) -> MemorySegment: ...
    @typing.overload
    def allocate(self, ofChar: 'ValueLayout.OfChar', char: str) -> MemorySegment: ...
    @typing.overload
    def allocate(self, ofDouble: 'ValueLayout.OfDouble', double: float) -> MemorySegment: ...
    @typing.overload
    def allocate(self, ofFloat: 'ValueLayout.OfFloat', float: float) -> MemorySegment: ...
    @typing.overload
    def allocate(self, ofInt: 'ValueLayout.OfInt', int: int) -> MemorySegment: ...
    @typing.overload
    def allocate(self, ofLong: 'ValueLayout.OfLong', long: int) -> MemorySegment: ...
    @typing.overload
    def allocate(self, ofShort: 'ValueLayout.OfShort', short: int) -> MemorySegment: ...
    @typing.overload
    def allocate(self, long: int) -> MemorySegment: ...
    @typing.overload
    def allocateArray(self, memoryLayout: MemoryLayout, long: int) -> MemorySegment: ...
    @typing.overload
    def allocateArray(self, ofByte: 'ValueLayout.OfByte', *byte: int) -> MemorySegment: ...
    @typing.overload
    def allocateArray(self, ofChar: 'ValueLayout.OfChar', *char: str) -> MemorySegment: ...
    @typing.overload
    def allocateArray(self, ofDouble: 'ValueLayout.OfDouble', *double: float) -> MemorySegment: ...
    @typing.overload
    def allocateArray(self, ofFloat: 'ValueLayout.OfFloat', *float: float) -> MemorySegment: ...
    @typing.overload
    def allocateArray(self, ofInt: 'ValueLayout.OfInt', *int: int) -> MemorySegment: ...
    @typing.overload
    def allocateArray(self, ofLong: 'ValueLayout.OfLong', *long: int) -> MemorySegment: ...
    @typing.overload
    def allocateArray(self, ofShort: 'ValueLayout.OfShort', *short: int) -> MemorySegment: ...
    def allocateUtf8String(self, string: str) -> MemorySegment: ...
    @staticmethod
    def prefixAllocator(memorySegment: MemorySegment) -> 'SegmentAllocator': ...
    @staticmethod
    def slicingAllocator(memorySegment: MemorySegment) -> 'SegmentAllocator': ...

class SymbolLookup:
    def find(self, string: str) -> java.util.Optional[MemorySegment]: ...
    @typing.overload
    @staticmethod
    def libraryLookup(string: str, arena: 'Arena') -> 'SymbolLookup': ...
    @typing.overload
    @staticmethod
    def libraryLookup(path: typing.Union[java.nio.file.Path, jpype.protocol.SupportsPath], arena: 'Arena') -> 'SymbolLookup': ...
    @staticmethod
    def loaderLookup() -> 'SymbolLookup': ...
    def or_(self, symbolLookup: typing.Union['SymbolLookup', typing.Callable]) -> 'SymbolLookup': ...

class Arena(SegmentAllocator, java.lang.AutoCloseable):
    @typing.overload
    def allocate(self, long: int, long2: int) -> MemorySegment: ...
    @typing.overload
    def allocate(self, addressLayout: 'AddressLayout', memorySegment: MemorySegment) -> MemorySegment: ...
    @typing.overload
    def allocate(self, memoryLayout: MemoryLayout) -> MemorySegment: ...
    @typing.overload
    def allocate(self, ofByte: 'ValueLayout.OfByte', byte: int) -> MemorySegment: ...
    @typing.overload
    def allocate(self, ofChar: 'ValueLayout.OfChar', char: str) -> MemorySegment: ...
    @typing.overload
    def allocate(self, ofDouble: 'ValueLayout.OfDouble', double: float) -> MemorySegment: ...
    @typing.overload
    def allocate(self, ofFloat: 'ValueLayout.OfFloat', float: float) -> MemorySegment: ...
    @typing.overload
    def allocate(self, ofInt: 'ValueLayout.OfInt', int: int) -> MemorySegment: ...
    @typing.overload
    def allocate(self, ofLong: 'ValueLayout.OfLong', long: int) -> MemorySegment: ...
    @typing.overload
    def allocate(self, ofShort: 'ValueLayout.OfShort', short: int) -> MemorySegment: ...
    @typing.overload
    def allocate(self, long: int) -> MemorySegment: ...
    def close(self) -> None: ...
    @staticmethod
    def global_() -> 'Arena': ...
    @staticmethod
    def ofAuto() -> 'Arena': ...
    @staticmethod
    def ofConfined() -> 'Arena': ...
    @staticmethod
    def ofShared() -> 'Arena': ...
    def scope(self) -> MemorySegment.Scope: ...

class GroupLayout(MemoryLayout):
    def equals(self, object: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def memberLayouts(self) -> java.util.List[MemoryLayout]: ...
    def toString(self) -> str: ...
    def withByteAlignment(self, long: int) -> 'GroupLayout': ...
    def withName(self, string: str) -> 'GroupLayout': ...
    def withoutName(self) -> 'GroupLayout': ...

class PaddingLayout(MemoryLayout):
    def equals(self, object: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def toString(self) -> str: ...
    def withByteAlignment(self, long: int) -> 'PaddingLayout': ...
    def withName(self, string: str) -> 'PaddingLayout': ...
    def withoutName(self) -> 'PaddingLayout': ...

class SequenceLayout(MemoryLayout):
    def elementCount(self) -> int: ...
    def elementLayout(self) -> MemoryLayout: ...
    def equals(self, object: typing.Any) -> bool: ...
    def flatten(self) -> 'SequenceLayout': ...
    def hashCode(self) -> int: ...
    def reshape(self, *long: int) -> 'SequenceLayout': ...
    def toString(self) -> str: ...
    def withByteAlignment(self, long: int) -> 'SequenceLayout': ...
    def withElementCount(self, long: int) -> 'SequenceLayout': ...
    def withName(self, string: str) -> 'SequenceLayout': ...
    def withoutName(self) -> MemoryLayout: ...

class StructLayout(GroupLayout):
    def equals(self, object: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def toString(self) -> str: ...
    def withByteAlignment(self, long: int) -> 'StructLayout': ...
    def withName(self, string: str) -> 'StructLayout': ...
    def withoutName(self) -> 'StructLayout': ...

class UnionLayout(GroupLayout):
    def equals(self, object: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def toString(self) -> str: ...
    def withByteAlignment(self, long: int) -> 'UnionLayout': ...
    def withName(self, string: str) -> 'UnionLayout': ...
    def withoutName(self) -> 'UnionLayout': ...

class AddressLayout(java.lang.foreign.ValueLayout):
    def equals(self, object: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def targetLayout(self) -> java.util.Optional[MemoryLayout]: ...
    def toString(self) -> str: ...
    def withByteAlignment(self, long: int) -> 'AddressLayout': ...
    def withName(self, string: str) -> 'AddressLayout': ...
    def withOrder(self, byteOrder: java.nio.ByteOrder) -> 'AddressLayout': ...
    def withTargetLayout(self, memoryLayout: MemoryLayout) -> 'AddressLayout': ...
    def withoutName(self) -> 'AddressLayout': ...
    def withoutTargetLayout(self) -> 'AddressLayout': ...

class ValueLayout(MemoryLayout):
    ADDRESS: typing.ClassVar[AddressLayout] = ...
    JAVA_BYTE: typing.ClassVar['ValueLayout.OfByte'] = ...
    JAVA_BOOLEAN: typing.ClassVar['ValueLayout.OfBoolean'] = ...
    JAVA_CHAR: typing.ClassVar['ValueLayout.OfChar'] = ...
    JAVA_SHORT: typing.ClassVar['ValueLayout.OfShort'] = ...
    JAVA_INT: typing.ClassVar['ValueLayout.OfInt'] = ...
    JAVA_LONG: typing.ClassVar['ValueLayout.OfLong'] = ...
    JAVA_FLOAT: typing.ClassVar['ValueLayout.OfFloat'] = ...
    JAVA_DOUBLE: typing.ClassVar['ValueLayout.OfDouble'] = ...
    ADDRESS_UNALIGNED: typing.ClassVar[AddressLayout] = ...
    JAVA_CHAR_UNALIGNED: typing.ClassVar['ValueLayout.OfChar'] = ...
    JAVA_SHORT_UNALIGNED: typing.ClassVar['ValueLayout.OfShort'] = ...
    JAVA_INT_UNALIGNED: typing.ClassVar['ValueLayout.OfInt'] = ...
    JAVA_LONG_UNALIGNED: typing.ClassVar['ValueLayout.OfLong'] = ...
    JAVA_FLOAT_UNALIGNED: typing.ClassVar['ValueLayout.OfFloat'] = ...
    JAVA_DOUBLE_UNALIGNED: typing.ClassVar['ValueLayout.OfDouble'] = ...
    def arrayElementVarHandle(self, *int: int) -> java.lang.invoke.VarHandle: ...
    def carrier(self) -> typing.Type[typing.Any]: ...
    def equals(self, object: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def order(self) -> java.nio.ByteOrder: ...
    def toString(self) -> str: ...
    def withByteAlignment(self, long: int) -> 'ValueLayout': ...
    def withName(self, string: str) -> 'ValueLayout': ...
    def withOrder(self, byteOrder: java.nio.ByteOrder) -> 'ValueLayout': ...
    def withoutName(self) -> 'ValueLayout': ...
    class OfBoolean(java.lang.foreign.ValueLayout):
        def equals(self, object: typing.Any) -> bool: ...
        def hashCode(self) -> int: ...
        def toString(self) -> str: ...
        def withByteAlignment(self, long: int) -> 'ValueLayout.OfBoolean': ...
        def withName(self, string: str) -> 'ValueLayout.OfBoolean': ...
        def withOrder(self, byteOrder: java.nio.ByteOrder) -> 'ValueLayout.OfBoolean': ...
        def withoutName(self) -> 'ValueLayout.OfBoolean': ...
    class OfByte(java.lang.foreign.ValueLayout):
        def equals(self, object: typing.Any) -> bool: ...
        def hashCode(self) -> int: ...
        def toString(self) -> str: ...
        def withByteAlignment(self, long: int) -> 'ValueLayout.OfByte': ...
        def withName(self, string: str) -> 'ValueLayout.OfByte': ...
        def withOrder(self, byteOrder: java.nio.ByteOrder) -> 'ValueLayout.OfByte': ...
        def withoutName(self) -> 'ValueLayout.OfByte': ...
    class OfChar(java.lang.foreign.ValueLayout):
        def equals(self, object: typing.Any) -> bool: ...
        def hashCode(self) -> int: ...
        def toString(self) -> str: ...
        def withByteAlignment(self, long: int) -> 'ValueLayout.OfChar': ...
        def withName(self, string: str) -> 'ValueLayout.OfChar': ...
        def withOrder(self, byteOrder: java.nio.ByteOrder) -> 'ValueLayout.OfChar': ...
        def withoutName(self) -> 'ValueLayout.OfChar': ...
    class OfDouble(java.lang.foreign.ValueLayout):
        def equals(self, object: typing.Any) -> bool: ...
        def hashCode(self) -> int: ...
        def toString(self) -> str: ...
        def withByteAlignment(self, long: int) -> 'ValueLayout.OfDouble': ...
        def withName(self, string: str) -> 'ValueLayout.OfDouble': ...
        def withOrder(self, byteOrder: java.nio.ByteOrder) -> 'ValueLayout.OfDouble': ...
        def withoutName(self) -> 'ValueLayout.OfDouble': ...
    class OfFloat(java.lang.foreign.ValueLayout):
        def equals(self, object: typing.Any) -> bool: ...
        def hashCode(self) -> int: ...
        def toString(self) -> str: ...
        def withByteAlignment(self, long: int) -> 'ValueLayout.OfFloat': ...
        def withName(self, string: str) -> 'ValueLayout.OfFloat': ...
        def withOrder(self, byteOrder: java.nio.ByteOrder) -> 'ValueLayout.OfFloat': ...
        def withoutName(self) -> 'ValueLayout.OfFloat': ...
    class OfInt(java.lang.foreign.ValueLayout):
        def equals(self, object: typing.Any) -> bool: ...
        def hashCode(self) -> int: ...
        def toString(self) -> str: ...
        def withByteAlignment(self, long: int) -> 'ValueLayout.OfInt': ...
        def withName(self, string: str) -> 'ValueLayout.OfInt': ...
        def withOrder(self, byteOrder: java.nio.ByteOrder) -> 'ValueLayout.OfInt': ...
        def withoutName(self) -> 'ValueLayout.OfInt': ...
    class OfLong(java.lang.foreign.ValueLayout):
        def equals(self, object: typing.Any) -> bool: ...
        def hashCode(self) -> int: ...
        def toString(self) -> str: ...
        def withByteAlignment(self, long: int) -> 'ValueLayout.OfLong': ...
        def withName(self, string: str) -> 'ValueLayout.OfLong': ...
        def withOrder(self, byteOrder: java.nio.ByteOrder) -> 'ValueLayout.OfLong': ...
        def withoutName(self) -> 'ValueLayout.OfLong': ...
    class OfShort(java.lang.foreign.ValueLayout):
        def equals(self, object: typing.Any) -> bool: ...
        def hashCode(self) -> int: ...
        def toString(self) -> str: ...
        def withByteAlignment(self, long: int) -> 'ValueLayout.OfShort': ...
        def withName(self, string: str) -> 'ValueLayout.OfShort': ...
        def withOrder(self, byteOrder: java.nio.ByteOrder) -> 'ValueLayout.OfShort': ...
        def withoutName(self) -> 'ValueLayout.OfShort': ...


class __module_protocol__(Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("java.lang.foreign")``.

    AddressLayout: typing.Type[AddressLayout]
    Arena: typing.Type[Arena]
    FunctionDescriptor: typing.Type[FunctionDescriptor]
    GroupLayout: typing.Type[GroupLayout]
    Linker: typing.Type[Linker]
    MemoryLayout: typing.Type[MemoryLayout]
    MemorySegment: typing.Type[MemorySegment]
    PaddingLayout: typing.Type[PaddingLayout]
    SegmentAllocator: typing.Type[SegmentAllocator]
    SequenceLayout: typing.Type[SequenceLayout]
    StructLayout: typing.Type[StructLayout]
    SymbolLookup: typing.Type[SymbolLookup]
    UnionLayout: typing.Type[UnionLayout]
    ValueLayout: typing.Type[ValueLayout]
