/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.optim.nonlinear.vector.leastsquares;

import org.hipparchus.analysis.MultivariateMatrixFunction;
import org.hipparchus.analysis.MultivariateVectorFunction;
import org.hipparchus.linear.ArrayRealVector;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.linear.RealVector;
import org.hipparchus.optim.ConvergenceChecker;
import org.hipparchus.optim.PointVectorValuePair;
import org.hipparchus.optim.nonlinear.vector.leastsquares.LeastSquaresFactory;
import org.hipparchus.optim.nonlinear.vector.leastsquares.LeastSquaresProblem;
import org.hipparchus.optim.nonlinear.vector.leastsquares.MultivariateJacobianFunction;
import org.hipparchus.optim.nonlinear.vector.leastsquares.ParameterValidator;

public class LeastSquaresBuilder {
    private int maxEvaluations;
    private int maxIterations;
    private ConvergenceChecker<LeastSquaresProblem.Evaluation> checker;
    private MultivariateJacobianFunction model;
    private RealVector target;
    private RealVector start;
    private RealMatrix weight;
    private boolean lazyEvaluation;
    private ParameterValidator paramValidator;

    public LeastSquaresProblem build() {
        return LeastSquaresFactory.create(this.model, this.target, this.start, this.weight, this.checker, this.maxEvaluations, this.maxIterations, this.lazyEvaluation, this.paramValidator);
    }

    public LeastSquaresBuilder maxEvaluations(int newMaxEvaluations) {
        this.maxEvaluations = newMaxEvaluations;
        return this;
    }

    public LeastSquaresBuilder maxIterations(int newMaxIterations) {
        this.maxIterations = newMaxIterations;
        return this;
    }

    public LeastSquaresBuilder checker(ConvergenceChecker<LeastSquaresProblem.Evaluation> newChecker) {
        this.checker = newChecker;
        return this;
    }

    public LeastSquaresBuilder checkerPair(ConvergenceChecker<PointVectorValuePair> newChecker) {
        return this.checker(LeastSquaresFactory.evaluationChecker(newChecker));
    }

    public LeastSquaresBuilder model(MultivariateVectorFunction value, MultivariateMatrixFunction jacobian) {
        return this.model(LeastSquaresFactory.model(value, jacobian));
    }

    public LeastSquaresBuilder model(MultivariateJacobianFunction newModel) {
        this.model = newModel;
        return this;
    }

    public LeastSquaresBuilder target(RealVector newTarget) {
        this.target = newTarget;
        return this;
    }

    public LeastSquaresBuilder target(double[] newTarget) {
        return this.target((RealVector)new ArrayRealVector(newTarget, false));
    }

    public LeastSquaresBuilder start(RealVector newStart) {
        this.start = newStart;
        return this;
    }

    public LeastSquaresBuilder start(double[] newStart) {
        return this.start((RealVector)new ArrayRealVector(newStart, false));
    }

    public LeastSquaresBuilder weight(RealMatrix newWeight) {
        this.weight = newWeight;
        return this;
    }

    public LeastSquaresBuilder lazyEvaluation(boolean newValue) {
        this.lazyEvaluation = newValue;
        return this;
    }

    public LeastSquaresBuilder parameterValidator(ParameterValidator newValidator) {
        this.paramValidator = newValidator;
        return this;
    }
}

