/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.geometry.euclidean.twod;

import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.geometry.LocalizedGeometryFormats;
import org.hipparchus.geometry.Point;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.oned.Euclidean1D;
import org.hipparchus.geometry.euclidean.oned.IntervalsSet;
import org.hipparchus.geometry.euclidean.oned.OrientedPoint;
import org.hipparchus.geometry.euclidean.oned.Vector1D;
import org.hipparchus.geometry.euclidean.twod.Euclidean2D;
import org.hipparchus.geometry.euclidean.twod.PolygonsSet;
import org.hipparchus.geometry.euclidean.twod.SubLine;
import org.hipparchus.geometry.euclidean.twod.Vector2D;
import org.hipparchus.geometry.partitioning.Embedding;
import org.hipparchus.geometry.partitioning.Hyperplane;
import org.hipparchus.geometry.partitioning.RegionFactory;
import org.hipparchus.geometry.partitioning.SubHyperplane;
import org.hipparchus.geometry.partitioning.Transform;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.MathUtils;
import org.hipparchus.util.SinCos;

public class Line
implements Hyperplane<Euclidean2D>,
Embedding<Euclidean2D, Euclidean1D> {
    private double angle;
    private double cos;
    private double sin;
    private double originOffset;
    private final double tolerance;
    private Line reverse;

    public Line(Vector2D p1, Vector2D p2, double tolerance) {
        this.reset(p1, p2);
        this.tolerance = tolerance;
    }

    public Line(Vector2D p, double angle, double tolerance) {
        this.reset(p, angle);
        this.tolerance = tolerance;
    }

    private Line(double angle, double cos, double sin, double originOffset, double tolerance) {
        this.angle = angle;
        this.cos = cos;
        this.sin = sin;
        this.originOffset = originOffset;
        this.tolerance = tolerance;
        this.reverse = null;
    }

    public Line(Line line) {
        this.angle = MathUtils.normalizeAngle((double)line.angle, (double)Math.PI);
        this.cos = line.cos;
        this.sin = line.sin;
        this.originOffset = line.originOffset;
        this.tolerance = line.tolerance;
        this.reverse = null;
    }

    public Line copySelf() {
        return new Line(this);
    }

    public void reset(Vector2D p1, Vector2D p2) {
        this.unlinkReverse();
        double dx = p2.getX() - p1.getX();
        double dy = p2.getY() - p1.getY();
        double d = FastMath.hypot((double)dx, (double)dy);
        if (d == 0.0) {
            this.angle = 0.0;
            this.cos = 1.0;
            this.sin = 0.0;
            this.originOffset = p1.getY();
        } else {
            this.angle = Math.PI + FastMath.atan2((double)(-dy), (double)(-dx));
            this.cos = dx / d;
            this.sin = dy / d;
            this.originOffset = MathArrays.linearCombination((double)p2.getX(), (double)p1.getY(), (double)(-p1.getX()), (double)p2.getY()) / d;
        }
    }

    public void reset(Vector2D p, double alpha) {
        this.unlinkReverse();
        SinCos sinCos = FastMath.sinCos((double)alpha);
        this.angle = MathUtils.normalizeAngle((double)alpha, (double)Math.PI);
        this.cos = sinCos.cos();
        this.sin = sinCos.sin();
        this.originOffset = MathArrays.linearCombination((double)this.cos, (double)p.getY(), (double)(-this.sin), (double)p.getX());
    }

    public void revertSelf() {
        this.unlinkReverse();
        this.angle = this.angle < Math.PI ? (this.angle += Math.PI) : (this.angle -= Math.PI);
        this.cos = -this.cos;
        this.sin = -this.sin;
        this.originOffset = -this.originOffset;
    }

    private void unlinkReverse() {
        if (this.reverse != null) {
            this.reverse.reverse = null;
        }
        this.reverse = null;
    }

    public Line getReverse() {
        if (this.reverse == null) {
            this.reverse = new Line(this.angle < Math.PI ? this.angle + Math.PI : this.angle - Math.PI, -this.cos, -this.sin, -this.originOffset, this.tolerance);
            this.reverse.reverse = this;
        }
        return this.reverse;
    }

    public Vector1D toSubSpace(Vector<Euclidean2D, Vector2D> vector) {
        return this.toSubSpace((Point)vector);
    }

    public Vector2D toSpace(Vector<Euclidean1D, Vector1D> vector) {
        return this.toSpace((Point)vector);
    }

    public Vector1D toSubSpace(Point<Euclidean2D> point) {
        Vector2D p2 = (Vector2D)point;
        return new Vector1D(MathArrays.linearCombination((double)this.cos, (double)p2.getX(), (double)this.sin, (double)p2.getY()));
    }

    public Vector2D toSpace(Point<Euclidean1D> point) {
        double abscissa = ((Vector1D)point).getX();
        return new Vector2D(MathArrays.linearCombination((double)abscissa, (double)this.cos, (double)(-this.originOffset), (double)this.sin), MathArrays.linearCombination((double)abscissa, (double)this.sin, (double)this.originOffset, (double)this.cos));
    }

    public Vector2D intersection(Line other) {
        double d = MathArrays.linearCombination((double)this.sin, (double)other.cos, (double)(-other.sin), (double)this.cos);
        if (FastMath.abs((double)d) < this.tolerance) {
            return null;
        }
        return new Vector2D(MathArrays.linearCombination((double)this.cos, (double)other.originOffset, (double)(-other.cos), (double)this.originOffset) / d, MathArrays.linearCombination((double)this.sin, (double)other.originOffset, (double)(-other.sin), (double)this.originOffset) / d);
    }

    @Override
    public Point<Euclidean2D> project(Point<Euclidean2D> point) {
        return this.toSpace((Vector<Euclidean1D, Vector1D>)this.toSubSpace((Point)point));
    }

    @Override
    public double getTolerance() {
        return this.tolerance;
    }

    public SubLine wholeHyperplane() {
        return new SubLine(this, new IntervalsSet(this.tolerance));
    }

    public SubLine emptyHyperplane() {
        return new SubLine(this, new RegionFactory<Euclidean1D>().getComplement(new IntervalsSet(this.tolerance)));
    }

    public PolygonsSet wholeSpace() {
        return new PolygonsSet(this.tolerance);
    }

    public double getOffset(Line line) {
        return this.originOffset + (MathArrays.linearCombination((double)this.cos, (double)line.cos, (double)this.sin, (double)line.sin) > 0.0 ? -line.originOffset : line.originOffset);
    }

    public double getOffset(Vector<Euclidean2D, Vector2D> vector) {
        return this.getOffset((Point<Euclidean2D>)vector);
    }

    @Override
    public double getOffset(Point<Euclidean2D> point) {
        Vector2D p2 = (Vector2D)point;
        return MathArrays.linearCombination((double)this.sin, (double)p2.getX(), (double)(-this.cos), (double)p2.getY(), (double)1.0, (double)this.originOffset);
    }

    @Override
    public boolean sameOrientationAs(Hyperplane<Euclidean2D> other) {
        Line otherL = (Line)other;
        return MathArrays.linearCombination((double)this.sin, (double)otherL.sin, (double)this.cos, (double)otherL.cos) >= 0.0;
    }

    public Vector2D getPointAt(Vector1D abscissa, double offset) {
        double x = abscissa.getX();
        double dOffset = offset - this.originOffset;
        return new Vector2D(MathArrays.linearCombination((double)x, (double)this.cos, (double)dOffset, (double)this.sin), MathArrays.linearCombination((double)x, (double)this.sin, (double)(-dOffset), (double)this.cos));
    }

    public boolean contains(Vector2D p) {
        return FastMath.abs((double)this.getOffset(p)) < this.tolerance;
    }

    public double distance(Vector2D p) {
        return FastMath.abs((double)this.getOffset(p));
    }

    public boolean isParallelTo(Line line) {
        return FastMath.abs((double)MathArrays.linearCombination((double)this.sin, (double)line.cos, (double)(-this.cos), (double)line.sin)) < this.tolerance;
    }

    public void translateToPoint(Vector2D p) {
        this.originOffset = MathArrays.linearCombination((double)this.cos, (double)p.getY(), (double)(-this.sin), (double)p.getX());
    }

    public double getAngle() {
        return MathUtils.normalizeAngle((double)this.angle, (double)Math.PI);
    }

    public void setAngle(double angle) {
        this.unlinkReverse();
        this.angle = MathUtils.normalizeAngle((double)angle, (double)Math.PI);
        SinCos sinCos = FastMath.sinCos((double)this.angle);
        this.cos = sinCos.cos();
        this.sin = sinCos.sin();
    }

    public double getOriginOffset() {
        return this.originOffset;
    }

    public void setOriginOffset(double offset) {
        this.unlinkReverse();
        this.originOffset = offset;
    }

    public static Transform<Euclidean2D, Euclidean1D> getTransform(double cXX, double cYX, double cXY, double cYY, double cX1, double cY1) throws MathIllegalArgumentException {
        return new LineTransform(cXX, cYX, cXY, cYY, cX1, cY1);
    }

    private static class LineTransform
    implements Transform<Euclidean2D, Euclidean1D> {
        private final double cXX;
        private final double cYX;
        private final double cXY;
        private final double cYY;
        private final double cX1;
        private final double cY1;
        private final double c1Y;
        private final double c1X;
        private final double c11;

        LineTransform(double cXX, double cYX, double cXY, double cYY, double cX1, double cY1) throws MathIllegalArgumentException {
            this.cXX = cXX;
            this.cYX = cYX;
            this.cXY = cXY;
            this.cYY = cYY;
            this.cX1 = cX1;
            this.cY1 = cY1;
            this.c1Y = MathArrays.linearCombination((double)cXY, (double)cY1, (double)(-cYY), (double)cX1);
            this.c1X = MathArrays.linearCombination((double)cXX, (double)cY1, (double)(-cYX), (double)cX1);
            this.c11 = MathArrays.linearCombination((double)cXX, (double)cYY, (double)(-cYX), (double)cXY);
            if (FastMath.abs((double)this.c11) < 1.0E-20) {
                throw new MathIllegalArgumentException((Localizable)LocalizedGeometryFormats.NON_INVERTIBLE_TRANSFORM, new Object[0]);
            }
        }

        public Vector2D apply(Point<Euclidean2D> point) {
            Vector2D p2D = (Vector2D)point;
            double x = p2D.getX();
            double y = p2D.getY();
            return new Vector2D(MathArrays.linearCombination((double)this.cXX, (double)x, (double)this.cXY, (double)y, (double)this.cX1, (double)1.0), MathArrays.linearCombination((double)this.cYX, (double)x, (double)this.cYY, (double)y, (double)this.cY1, (double)1.0));
        }

        public Line apply(Hyperplane<Euclidean2D> hyperplane) {
            Line line = (Line)hyperplane;
            double rOffset = MathArrays.linearCombination((double)this.c1X, (double)line.cos, (double)this.c1Y, (double)line.sin, (double)this.c11, (double)line.originOffset);
            double rCos = MathArrays.linearCombination((double)this.cXX, (double)line.cos, (double)this.cXY, (double)line.sin);
            double rSin = MathArrays.linearCombination((double)this.cYX, (double)line.cos, (double)this.cYY, (double)line.sin);
            double inv = 1.0 / FastMath.sqrt((double)(rSin * rSin + rCos * rCos));
            return new Line(Math.PI + FastMath.atan2((double)(-rSin), (double)(-rCos)), inv * rCos, inv * rSin, inv * rOffset, line.tolerance);
        }

        @Override
        public SubHyperplane<Euclidean1D> apply(SubHyperplane<Euclidean1D> sub, Hyperplane<Euclidean2D> original, Hyperplane<Euclidean2D> transformed) {
            OrientedPoint op = (OrientedPoint)sub.getHyperplane();
            Line originalLine = (Line)original;
            Line transformedLine = (Line)transformed;
            Vector1D newLoc = transformedLine.toSubSpace((Vector<Euclidean2D, Vector2D>)this.apply((Point)originalLine.toSpace(op.getLocation())));
            return new OrientedPoint(newLoc, op.isDirect(), originalLine.tolerance).wholeHyperplane();
        }
    }
}

