/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.rugged.utils;

import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.Line;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.bodies.OneAxisEllipsoid;
import org.orekit.frames.Frame;
import org.orekit.rugged.errors.DumpManager;
import org.orekit.rugged.errors.RuggedException;
import org.orekit.rugged.errors.RuggedMessages;
import org.orekit.rugged.utils.NormalizedGeodeticPoint;
import org.orekit.time.AbsoluteDate;

public class ExtendedEllipsoid
extends OneAxisEllipsoid {
    private static final long serialVersionUID = 20140312L;
    private static final double ALTITUDE_CONVERGENCE = 0.001;
    private final double a2;
    private final double b2;

    public ExtendedEllipsoid(double ae, double f, Frame bodyFrame) {
        super(ae, f, bodyFrame);
        this.a2 = ae * ae;
        double b = ae * (1.0 - f);
        this.b2 = b * b;
    }

    public Vector3D transform(GeodeticPoint point) {
        DumpManager.dumpEllipsoid(this);
        return super.transform(point);
    }

    public GeodeticPoint transform(Vector3D point, Frame frame, AbsoluteDate date) {
        DumpManager.dumpEllipsoid(this);
        return super.transform(point, frame, date);
    }

    public Vector3D pointAtLatitude(Vector3D position, Vector3D los, double latitude, Vector3D closeReference) {
        double selectedK;
        boolean k2IsOK;
        DumpManager.dumpEllipsoid(this);
        double sinPhi = FastMath.sin((double)latitude);
        double sinPhi2 = sinPhi * sinPhi;
        double e2 = this.getFlattening() * (2.0 - this.getFlattening());
        double apexZ = -this.getA() * e2 * sinPhi / FastMath.sqrt((double)(1.0 - e2 * sinPhi2));
        double cosPhi = FastMath.cos((double)latitude);
        double cosPhi2 = cosPhi * cosPhi;
        double k0 = Vector3D.dotProduct((Vector3D)closeReference.subtract((Vector)position), (Vector3D)los) / los.getNormSq();
        Vector3D delta = new Vector3D(MathArrays.linearCombination((double)1.0, (double)position.getX(), (double)k0, (double)los.getX()), MathArrays.linearCombination((double)1.0, (double)position.getY(), (double)k0, (double)los.getY()), MathArrays.linearCombination((double)1.0, (double)position.getZ(), (double)k0, (double)los.getZ(), (double)-1.0, (double)apexZ));
        double a = MathArrays.linearCombination((double)sinPhi2, (double)(los.getX() * los.getX() + los.getY() * los.getY()), (double)(-cosPhi2), (double)(los.getZ() * los.getZ()));
        double b = MathArrays.linearCombination((double)sinPhi2, (double)MathArrays.linearCombination((double)delta.getX(), (double)los.getX(), (double)delta.getY(), (double)los.getY()), (double)(-cosPhi2), (double)(delta.getZ() * los.getZ()));
        double c = MathArrays.linearCombination((double)sinPhi2, (double)(delta.getX() * delta.getX() + delta.getY() * delta.getY()), (double)(-cosPhi2), (double)(delta.getZ() * delta.getZ()));
        if (b * b < a * c) {
            throw new RuggedException(RuggedMessages.LINE_OF_SIGHT_NEVER_CROSSES_LATITUDE, FastMath.toDegrees((double)latitude));
        }
        double s = FastMath.sqrt((double)MathArrays.linearCombination((double)b, (double)b, (double)(-a), (double)c));
        double k1 = b > 0.0 ? -(s + b) / a : c / (s - b);
        double k2 = c / (a * k1);
        boolean k1IsOK = (delta.getZ() + k1 * los.getZ()) * latitude >= 0.0;
        boolean bl = k2IsOK = (delta.getZ() + k2 * los.getZ()) * latitude >= 0.0;
        if (k1IsOK) {
            double kRef;
            selectedK = k2IsOK ? (FastMath.abs((double)(k1 - (kRef = Vector3D.dotProduct((Vector3D)los, (Vector3D)closeReference.subtract((Vector)position)) / los.getNormSq() - k0))) <= FastMath.abs((double)(k2 - kRef)) ? k1 : k2) : k1;
        } else if (k2IsOK) {
            selectedK = k2;
        } else {
            throw new RuggedException(RuggedMessages.LINE_OF_SIGHT_NEVER_CROSSES_LATITUDE, FastMath.toDegrees((double)latitude));
        }
        return new Vector3D(1.0, position, k0 + selectedK, los);
    }

    public Vector3D pointAtLongitude(Vector3D position, Vector3D los, double longitude) {
        DumpManager.dumpEllipsoid(this);
        Vector3D normal = new Vector3D(-FastMath.sin((double)longitude), FastMath.cos((double)longitude), 0.0);
        double d = Vector3D.dotProduct((Vector3D)los, (Vector3D)normal);
        if (FastMath.abs((double)d) < 1.0E-12) {
            throw new RuggedException(RuggedMessages.LINE_OF_SIGHT_NEVER_CROSSES_LONGITUDE, FastMath.toDegrees((double)longitude));
        }
        return new Vector3D(1.0, position, -Vector3D.dotProduct((Vector3D)position, (Vector3D)normal) / d, los);
    }

    public NormalizedGeodeticPoint pointOnGround(Vector3D position, Vector3D los, double centralLongitude) {
        DumpManager.dumpEllipsoid(this);
        GeodeticPoint gp = this.getIntersectionPoint(new Line(position, new Vector3D(1.0, position, 1000000.0, los), 1.0E-12), position, this.getBodyFrame(), null);
        if (gp == null) {
            throw new RuggedException(RuggedMessages.LINE_OF_SIGHT_DOES_NOT_REACH_GROUND, new Object[0]);
        }
        return new NormalizedGeodeticPoint(gp.getLatitude(), gp.getLongitude(), gp.getAltitude(), centralLongitude);
    }

    public Vector3D pointAtAltitude(Vector3D position, Vector3D los, double altitude) {
        DumpManager.dumpEllipsoid(this);
        double los2 = los.getNormSq();
        double dot = Vector3D.dotProduct((Vector3D)position, (Vector3D)los);
        double k0 = -dot / los2;
        Vector3D close0 = new Vector3D(1.0, position, k0, los);
        double r = this.getEquatorialRadius() + altitude;
        double delta2 = r * r - close0.getNormSq();
        if (delta2 < 0.0) {
            throw new RuggedException(RuggedMessages.LINE_OF_SIGHT_NEVER_CROSSES_ALTITUDE, altitude);
        }
        double deltaK = FastMath.sqrt((double)(delta2 / los2));
        double k1 = k0 + deltaK;
        double k2 = k0 - deltaK;
        double k = FastMath.abs((double)k1) <= FastMath.abs((double)k2) ? k1 : k2;
        for (int i = 0; i < 100; ++i) {
            Vector3D point = new Vector3D(1.0, position, k, los);
            GeodeticPoint gpK = this.transform(point, this.getBodyFrame(), null);
            double deltaH = altitude - gpK.getAltitude();
            if (FastMath.abs((double)deltaH) <= 0.001) {
                return point;
            }
            k += deltaH / Vector3D.dotProduct((Vector3D)gpK.getZenith(), (Vector3D)los);
        }
        throw new RuggedException(RuggedMessages.LINE_OF_SIGHT_NEVER_CROSSES_ALTITUDE, altitude);
    }

    public Vector3D convertLos(GeodeticPoint point, Vector3D los) {
        Vector3D p3D = this.transform(point);
        double r = FastMath.hypot((double)p3D.getX(), (double)p3D.getY());
        double b2r = this.b2 * r;
        double b4r2 = b2r * b2r;
        double a2z = this.a2 * p3D.getZ();
        double a4z2 = a2z * a2z;
        double q = a4z2 + b4r2;
        double rho = q * FastMath.sqrt((double)q) / (this.b2 * a4z2 + this.a2 * b4r2);
        double norm = los.getNorm();
        return new Vector3D(Vector3D.dotProduct((Vector3D)los, (Vector3D)point.getEast()) / (norm * r), Vector3D.dotProduct((Vector3D)los, (Vector3D)point.getNorth()) / (norm * rho), Vector3D.dotProduct((Vector3D)los, (Vector3D)point.getZenith()) / norm);
    }

    public Vector3D convertLos(Vector3D primary, Vector3D secondary) {
        GeodeticPoint point = this.transform(primary, this.getBodyFrame(), null);
        Vector3D los = secondary.subtract((Vector)primary);
        return this.convertLos(point, los);
    }

    public NormalizedGeodeticPoint transform(Vector3D point, Frame frame, AbsoluteDate date, double centralLongitude) {
        GeodeticPoint gp = this.transform(point, frame, date);
        return new NormalizedGeodeticPoint(gp.getLatitude(), gp.getLongitude(), gp.getAltitude(), centralLongitude);
    }
}

