/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.rugged.utils;

import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.orekit.errors.OrekitException;
import org.orekit.time.AbsoluteDate;

public class AbsoluteDateArrayHandling {
    private final AbsoluteDate[] dates;

    public AbsoluteDateArrayHandling(AbsoluteDate[] dates) {
        this.dates = (AbsoluteDate[])dates.clone();
    }

    public AbsoluteDate[] getDates() {
        return (AbsoluteDate[])this.dates.clone();
    }

    public AbsoluteDate[][] multipleShiftedBy(double[] dts) {
        AbsoluteDate[][] datesShifted = new AbsoluteDate[this.dates.length][dts.length];
        int index_dates = 0;
        for (AbsoluteDate date : this.dates) {
            AbsoluteDate[] dateShifted = new AbsoluteDate[dts.length];
            int index_dts = 0;
            for (double dt : dts) {
                dateShifted[index_dts] = date.shiftedBy(dt);
                ++index_dts;
            }
            datesShifted[index_dates] = dateShifted;
            ++index_dates;
        }
        return datesShifted;
    }

    public AbsoluteDate[] shiftedBy(double[] dts) {
        if (this.dates.length != dts.length) {
            throw new OrekitException((Localizable)LocalizedCoreFormats.DIMENSIONS_MISMATCH, new Object[]{this.dates.length, dts.length});
        }
        AbsoluteDate[] datesShifted = new AbsoluteDate[this.dates.length];
        int index_dates = 0;
        for (AbsoluteDate date : this.dates) {
            datesShifted[index_dates] = date.shiftedBy(dts[index_dates]);
            ++index_dates;
        }
        return datesShifted;
    }

    public double[][] multipleDurationFrom(AbsoluteDate[] datesForDuration) {
        double[][] durationsFromDates = new double[this.dates.length][datesForDuration.length];
        int index_dates = 0;
        for (AbsoluteDate date : this.dates) {
            double[] durationFromDate = new double[datesForDuration.length];
            int index_datesForDuration = 0;
            for (AbsoluteDate dateForDuration : datesForDuration) {
                durationFromDate[index_datesForDuration] = date.durationFrom(dateForDuration);
                ++index_datesForDuration;
            }
            durationsFromDates[index_dates] = durationFromDate;
            ++index_dates;
        }
        return durationsFromDates;
    }

    public double[] durationFrom(AbsoluteDate[] datesForDuration) {
        if (this.dates.length != datesForDuration.length) {
            throw new OrekitException((Localizable)LocalizedCoreFormats.DIMENSIONS_MISMATCH, new Object[]{this.dates.length, datesForDuration.length});
        }
        double[] durationsFromDates = new double[this.dates.length];
        int index_dates = 0;
        for (AbsoluteDate date : this.dates) {
            durationsFromDates[index_dates] = date.durationFrom(datesForDuration[index_dates]);
            ++index_dates;
        }
        return durationsFromDates;
    }
}

