/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.rugged.refraction;

import org.hipparchus.analysis.interpolation.BilinearInterpolatingFunction;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.rugged.errors.RuggedException;
import org.orekit.rugged.errors.RuggedMessages;
import org.orekit.rugged.intersection.IntersectionAlgorithm;
import org.orekit.rugged.linesensor.LineSensor;
import org.orekit.rugged.linesensor.SensorPixel;
import org.orekit.rugged.refraction.AtmosphericComputationParameters;
import org.orekit.rugged.utils.NormalizedGeodeticPoint;

public abstract class AtmosphericRefraction {
    private boolean mustBeComputed = true;
    private AtmosphericComputationParameters atmosphericParams = new AtmosphericComputationParameters();
    private BilinearInterpolatingFunction bifPixel = null;
    private BilinearInterpolatingFunction bifLine = null;

    protected AtmosphericRefraction() {
    }

    public abstract NormalizedGeodeticPoint applyCorrection(Vector3D var1, Vector3D var2, NormalizedGeodeticPoint var3, IntersectionAlgorithm var4);

    public void deactivateComputation() {
        this.mustBeComputed = false;
    }

    public void reactivateComputation() {
        this.mustBeComputed = true;
    }

    public boolean mustBeComputed() {
        return this.mustBeComputed;
    }

    public void configureCorrectionGrid(LineSensor sensor, int minLine, int maxLine) {
        this.atmosphericParams.configureCorrectionGrid(sensor, minLine, maxLine);
    }

    public Boolean isSameContext(String sensorName, int minLine, int maxLine) {
        return Double.compare(this.atmosphericParams.getMinLineSensor(), minLine) == 0 && Double.compare(this.atmosphericParams.getMaxLineSensor(), maxLine) == 0 && this.atmosphericParams.getSensorName().compareTo(sensorName) == 0;
    }

    public AtmosphericComputationParameters getComputationParameters() {
        return this.atmosphericParams;
    }

    public void setGridSteps(int pixelStep, int lineStep) {
        this.atmosphericParams.setGridSteps(pixelStep, lineStep);
    }

    public void setInverseLocMargin(double inverseLocMargin) {
        this.atmosphericParams.setInverseLocMargin(inverseLocMargin);
    }

    public void computeGridCorrectionFunctions(SensorPixel[][] sensorPixelGridInverseWithout) {
        int nbPixelGrid = this.atmosphericParams.getNbPixelGrid();
        int nbLineGrid = this.atmosphericParams.getNbLineGrid();
        double[] pixelGrid = this.atmosphericParams.getUgrid();
        double[] lineGrid = this.atmosphericParams.getVgrid();
        double[][] gridDiffPixel = new double[nbPixelGrid][nbLineGrid];
        double[][] gridDiffLine = new double[nbPixelGrid][nbLineGrid];
        for (int lineIndex = 0; lineIndex < nbLineGrid; ++lineIndex) {
            for (int pixelIndex = 0; pixelIndex < nbPixelGrid; ++pixelIndex) {
                double diffPixel;
                if (sensorPixelGridInverseWithout[pixelIndex][lineIndex] == null) {
                    throw new RuggedException(RuggedMessages.SENSOR_PIXEL_NOT_FOUND_IN_RANGE_LINES, this.atmosphericParams.getMinLineSensor(), this.atmosphericParams.getMaxLineSensor());
                }
                double diffLine = lineGrid[lineIndex] - sensorPixelGridInverseWithout[pixelIndex][lineIndex].getLineNumber();
                gridDiffPixel[pixelIndex][lineIndex] = diffPixel = pixelGrid[pixelIndex] - sensorPixelGridInverseWithout[pixelIndex][lineIndex].getPixelNumber();
                gridDiffLine[pixelIndex][lineIndex] = diffLine;
            }
        }
        this.bifPixel = new BilinearInterpolatingFunction(pixelGrid, lineGrid, gridDiffPixel);
        this.bifLine = new BilinearInterpolatingFunction(pixelGrid, lineGrid, gridDiffLine);
    }

    public BilinearInterpolatingFunction getBifPixel() {
        return this.bifPixel;
    }

    public BilinearInterpolatingFunction getBifLine() {
        return this.bifLine;
    }
}

