/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.rugged.refraction;

import org.orekit.rugged.errors.RuggedException;
import org.orekit.rugged.errors.RuggedMessages;
import org.orekit.rugged.linesensor.LineSensor;
import org.orekit.rugged.utils.GridCreation;

public class AtmosphericComputationParameters {
    private static final int MARGIN_LINE = 10;
    private static final int DEFAULT_STEP_PIXEL = 100;
    private static final int DEFAULT_STEP_LINE = 100;
    private static final double DEFAULT_INVLOC_MARGIN = 0.8;
    private int pixelStep = 100;
    private int lineStep = 100;
    private double invlocMargin = 0.8;
    private double[] uGrid;
    private double[] vGrid;
    private int nbPixelGrid;
    private int nbLineGrid;
    private double minLineSensor = Double.NaN;
    private double maxLineSensor = Double.NaN;
    private String sensorName = null;

    public void configureCorrectionGrid(LineSensor sensor, int minLine, int maxLine) {
        this.minLineSensor = minLine;
        this.maxLineSensor = maxLine;
        this.sensorName = sensor.getName();
        int sensorNbPxs = sensor.getNbPixels();
        this.nbPixelGrid = sensorNbPxs / this.pixelStep;
        if (maxLine - minLine + 1 - 20 < 2 * this.lineStep) {
            String info = ": (maxLine - minLine + 1 - 2*10) < 2*" + this.lineStep;
            throw new RuggedException(RuggedMessages.INVALID_RANGE_FOR_LINES, minLine, maxLine, info);
        }
        this.nbLineGrid = (maxLine - minLine + 1 - 20) / this.lineStep;
        this.uGrid = GridCreation.createLinearGrid(0.0, sensorNbPxs - 1, this.nbPixelGrid);
        this.vGrid = GridCreation.createLinearGrid(minLine + 10, maxLine - 10, this.nbLineGrid);
    }

    public void setGridSteps(int gridPixelStep, int gridLineStep) {
        if (gridPixelStep <= 0) {
            String reason = " pixelStep <= 0";
            throw new RuggedException(RuggedMessages.INVALID_STEP, gridPixelStep, " pixelStep <= 0");
        }
        if (gridLineStep <= 0) {
            String reason = " lineStep <= 0";
            throw new RuggedException(RuggedMessages.INVALID_STEP, gridLineStep, " lineStep <= 0");
        }
        this.pixelStep = gridPixelStep;
        this.lineStep = gridLineStep;
    }

    public void setInverseLocMargin(double inverseLocMargin) {
        this.invlocMargin = inverseLocMargin;
    }

    public double getInverseLocMargin() {
        return this.invlocMargin;
    }

    public double getDefaultInverseLocMargin() {
        return 0.8;
    }

    public int getNbPixelGrid() {
        return this.nbPixelGrid;
    }

    public int getNbLineGrid() {
        return this.nbLineGrid;
    }

    public double[] getUgrid() {
        return (double[])this.uGrid.clone();
    }

    public double[] getVgrid() {
        return (double[])this.vGrid.clone();
    }

    public double getMinLineSensor() {
        return this.minLineSensor;
    }

    public double getMaxLineSensor() {
        return this.maxLineSensor;
    }

    public String getSensorName() {
        return this.sensorName;
    }
}

