/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.rugged.raster;

import java.util.Arrays;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.Precision;
import org.orekit.rugged.errors.DumpManager;
import org.orekit.rugged.errors.RuggedException;
import org.orekit.rugged.errors.RuggedMessages;
import org.orekit.rugged.raster.Tile;
import org.orekit.rugged.utils.MaxSelector;
import org.orekit.rugged.utils.MinSelector;
import org.orekit.rugged.utils.NormalizedGeodeticPoint;

public class SimpleTile
implements Tile {
    private static final double TOLERANCE = 0.125;
    private double minLatitude;
    private double minLongitude;
    private double latitudeStep;
    private double longitudeStep;
    private int latitudeRows;
    private int longitudeColumns;
    private double minElevation;
    private int minElevationLatitudeIndex;
    private int minElevationLongitudeIndex;
    private double maxElevation;
    private int maxElevationLatitudeIndex;
    private int maxElevationLongitudeIndex;
    private double[] elevations;

    protected SimpleTile() {
    }

    @Override
    public void setGeometry(double newMinLatitude, double newMinLongitude, double newLatitudeStep, double newLongitudeStep, int newLatitudeRows, int newLongitudeColumns) {
        this.minLatitude = newMinLatitude;
        this.minLongitude = newMinLongitude;
        this.latitudeStep = newLatitudeStep;
        this.longitudeStep = newLongitudeStep;
        this.latitudeRows = newLatitudeRows;
        this.longitudeColumns = newLongitudeColumns;
        this.minElevation = Double.POSITIVE_INFINITY;
        this.minElevationLatitudeIndex = -1;
        this.minElevationLongitudeIndex = -1;
        this.maxElevation = Double.NEGATIVE_INFINITY;
        this.maxElevationLatitudeIndex = -1;
        this.maxElevationLongitudeIndex = -1;
        if (newLatitudeRows < 1 || newLongitudeColumns < 1) {
            throw new RuggedException(RuggedMessages.EMPTY_TILE, newLatitudeRows, newLongitudeColumns);
        }
        this.elevations = new double[newLatitudeRows * newLongitudeColumns];
        Arrays.fill(this.elevations, Double.NaN);
    }

    @Override
    public void tileUpdateCompleted() {
        this.processUpdatedElevation(this.elevations);
    }

    protected void processUpdatedElevation(double[] elevationsArray) {
    }

    @Override
    public double getMinimumLatitude() {
        return this.getLatitudeAtIndex(0);
    }

    @Override
    public double getLatitudeAtIndex(int latitudeIndex) {
        return this.minLatitude + this.latitudeStep * (double)latitudeIndex;
    }

    @Override
    public double getMaximumLatitude() {
        return this.getLatitudeAtIndex(this.latitudeRows - 1);
    }

    @Override
    public double getMinimumLongitude() {
        return this.getLongitudeAtIndex(0);
    }

    @Override
    public double getLongitudeAtIndex(int longitudeIndex) {
        return this.minLongitude + this.longitudeStep * (double)longitudeIndex;
    }

    @Override
    public double getMaximumLongitude() {
        return this.getLongitudeAtIndex(this.longitudeColumns - 1);
    }

    @Override
    public double getLatitudeStep() {
        return this.latitudeStep;
    }

    @Override
    public double getLongitudeStep() {
        return this.longitudeStep;
    }

    @Override
    public int getLatitudeRows() {
        return this.latitudeRows;
    }

    @Override
    public int getLongitudeColumns() {
        return this.longitudeColumns;
    }

    @Override
    public double getMinElevation() {
        return this.minElevation;
    }

    @Override
    public int getMinElevationLatitudeIndex() {
        return this.minElevationLatitudeIndex;
    }

    @Override
    public int getMinElevationLongitudeIndex() {
        return this.minElevationLongitudeIndex;
    }

    @Override
    public double getMaxElevation() {
        return this.maxElevation;
    }

    @Override
    public int getMaxElevationLatitudeIndex() {
        return this.maxElevationLatitudeIndex;
    }

    @Override
    public int getMaxElevationLongitudeIndex() {
        return this.maxElevationLongitudeIndex;
    }

    @Override
    public void setElevation(int latitudeIndex, int longitudeIndex, double elevation) {
        if (latitudeIndex < 0 || latitudeIndex > this.latitudeRows - 1 || longitudeIndex < 0 || longitudeIndex > this.longitudeColumns - 1) {
            throw new RuggedException(RuggedMessages.OUT_OF_TILE_INDICES, latitudeIndex, longitudeIndex, this.latitudeRows - 1, this.longitudeColumns - 1);
        }
        if (MinSelector.getInstance().selectFirst(elevation, this.minElevation)) {
            this.minElevation = elevation;
            this.minElevationLatitudeIndex = latitudeIndex;
            this.minElevationLongitudeIndex = longitudeIndex;
        }
        if (MaxSelector.getInstance().selectFirst(elevation, this.maxElevation)) {
            this.maxElevation = elevation;
            this.maxElevationLatitudeIndex = latitudeIndex;
            this.maxElevationLongitudeIndex = longitudeIndex;
        }
        this.elevations[latitudeIndex * this.getLongitudeColumns() + longitudeIndex] = elevation;
    }

    @Override
    public double getElevationAtIndices(int latitudeIndex, int longitudeIndex) {
        double elevation = this.elevations[latitudeIndex * this.getLongitudeColumns() + longitudeIndex];
        DumpManager.dumpTileCell(this, latitudeIndex, longitudeIndex, elevation);
        return elevation;
    }

    @Override
    public double interpolateElevation(double latitude, double longitude) {
        double doubleLatitudeIndex = this.getDoubleLatitudeIndex(latitude);
        double doubleLongitudeIndex = this.getDoubleLongitudeIndex(longitude);
        if (doubleLatitudeIndex < -0.125 || doubleLatitudeIndex >= (double)(this.latitudeRows - 1) + 0.125 || doubleLongitudeIndex < -0.125 || doubleLongitudeIndex >= (double)(this.longitudeColumns - 1) + 0.125) {
            throw new RuggedException(RuggedMessages.OUT_OF_TILE_ANGLES, FastMath.toDegrees((double)latitude), FastMath.toDegrees((double)longitude), FastMath.toDegrees((double)this.getMinimumLatitude()), FastMath.toDegrees((double)this.getMaximumLatitude()), FastMath.toDegrees((double)this.getMinimumLongitude()), FastMath.toDegrees((double)this.getMaximumLongitude()));
        }
        int latitudeIndex = FastMath.max((int)0, (int)FastMath.min((int)(this.latitudeRows - 2), (int)((int)FastMath.floor((double)doubleLatitudeIndex))));
        int longitudeIndex = FastMath.max((int)0, (int)FastMath.min((int)(this.longitudeColumns - 2), (int)((int)FastMath.floor((double)doubleLongitudeIndex))));
        double dLat = doubleLatitudeIndex - (double)latitudeIndex;
        double dLon = doubleLongitudeIndex - (double)longitudeIndex;
        double e00 = this.getElevationAtIndices(latitudeIndex, longitudeIndex);
        double e10 = this.getElevationAtIndices(latitudeIndex, longitudeIndex + 1);
        double e01 = this.getElevationAtIndices(latitudeIndex + 1, longitudeIndex);
        double e11 = this.getElevationAtIndices(latitudeIndex + 1, longitudeIndex + 1);
        return (e00 * (1.0 - dLon) + dLon * e10) * (1.0 - dLat) + (e01 * (1.0 - dLon) + dLon * e11) * dLat;
    }

    @Override
    public NormalizedGeodeticPoint cellIntersection(NormalizedGeodeticPoint p, Vector3D los, int latitudeIndex, int longitudeIndex) {
        double t2;
        double t1;
        int iLat = FastMath.max((int)0, (int)FastMath.min((int)(this.latitudeRows - 2), (int)latitudeIndex));
        int jLong = FastMath.max((int)0, (int)FastMath.min((int)(this.longitudeColumns - 2), (int)longitudeIndex));
        double x00 = this.getLongitudeAtIndex(jLong);
        double y00 = this.getLatitudeAtIndex(iLat);
        double z00 = this.getElevationAtIndices(iLat, jLong);
        double z01 = this.getElevationAtIndices(iLat + 1, jLong);
        double z10 = this.getElevationAtIndices(iLat, jLong + 1);
        double z11 = this.getElevationAtIndices(iLat + 1, jLong + 1);
        NormalizedGeodeticPoint tileP = new NormalizedGeodeticPoint(p.getLatitude(), p.getLongitude(), p.getAltitude(), x00);
        double dxA = (tileP.getLongitude() - x00) / this.longitudeStep;
        double dyA = (tileP.getLatitude() - y00) / this.latitudeStep;
        double dzA = tileP.getAltitude();
        double dxB = dxA + los.getX() / this.longitudeStep;
        double dyB = dyA + los.getY() / this.latitudeStep;
        double dzB = dzA + los.getZ();
        double u = (dxA - dxB) * (dyA - dyB) * (z00 - z10 - z01 + z11);
        double v = ((dxA - dxB) * (1.0 - dyA) + (dyA - dyB) * (1.0 - dxA)) * z00 + (dxA * (dyA - dyB) - (dxA - dxB) * (1.0 - dyA)) * z10 + (dyA * (dxA - dxB) - (dyA - dyB) * (1.0 - dxA)) * z01 + ((dxB - dxA) * dyA + (dyB - dyA) * dxA) * z11;
        double w = (1.0 - dxA) * ((1.0 - dyA) * z00 + dyA * z01) + dxA * ((1.0 - dyA) * z10 + dyA * z11);
        double a = u;
        double b = v + dzA - dzB;
        double c = w - dzA;
        if (FastMath.abs((double)a) <= Precision.EPSILON * FastMath.abs((double)c)) {
            double t = -c / b;
            t1 = Double.isNaN(t) ? 0.0 : t;
            t2 = Double.POSITIVE_INFINITY;
        } else {
            double b2 = b * b;
            double fac = 4.0 * a * c;
            if (b2 < fac) {
                return null;
            }
            double s = FastMath.sqrt((double)(b2 - fac));
            t1 = b < 0.0 ? (s - b) / (2.0 * a) : -2.0 * c / (b + s);
            t2 = c / (a * t1);
        }
        NormalizedGeodeticPoint p1 = this.interpolate(t1, tileP, dxA, dyA, los, x00);
        NormalizedGeodeticPoint p2 = this.interpolate(t2, tileP, dxA, dyA, los, x00);
        if (p1 == null) {
            return p2;
        }
        if (p2 == null) {
            return p1;
        }
        return t1 <= t2 ? p1 : p2;
    }

    private NormalizedGeodeticPoint interpolate(double t, NormalizedGeodeticPoint tileP, double dxP, double dyP, Vector3D los, double centralLongitude) {
        if (Double.isInfinite(t)) {
            return null;
        }
        double dx = dxP + t * los.getX() / this.longitudeStep;
        double dy = dyP + t * los.getY() / this.latitudeStep;
        if (dx >= -0.125 && dx <= 1.125 && dy >= -0.125 && dy <= 1.125) {
            return new NormalizedGeodeticPoint(tileP.getLatitude() + t * los.getY(), tileP.getLongitude() + t * los.getX(), tileP.getAltitude() + t * los.getZ(), centralLongitude);
        }
        return null;
    }

    @Override
    public int getFloorLatitudeIndex(double latitude) {
        return (int)FastMath.floor((double)this.getDoubleLatitudeIndex(latitude));
    }

    @Override
    public int getFloorLongitudeIndex(double longitude) {
        return (int)FastMath.floor((double)this.getDoubleLongitudeIndex(longitude));
    }

    protected double getDoubleLatitudeIndex(double latitude) {
        return (latitude - this.minLatitude) / this.latitudeStep;
    }

    protected double getDoubleLongitudeIndex(double longitude) {
        return (longitude - this.minLongitude) / this.longitudeStep;
    }

    @Override
    public Tile.Location getLocation(double latitude, double longitude) {
        int latitudeIndex = this.getFloorLatitudeIndex(latitude);
        int longitudeIndex = this.getFloorLongitudeIndex(longitude);
        if (longitudeIndex < 0) {
            if (latitudeIndex < 0) {
                return Tile.Location.SOUTH_WEST;
            }
            if (latitudeIndex <= this.latitudeRows - 2) {
                return Tile.Location.WEST;
            }
            return Tile.Location.NORTH_WEST;
        }
        if (longitudeIndex <= this.longitudeColumns - 2) {
            if (latitudeIndex < 0) {
                return Tile.Location.SOUTH;
            }
            if (latitudeIndex <= this.latitudeRows - 2) {
                return Tile.Location.HAS_INTERPOLATION_NEIGHBORS;
            }
            return Tile.Location.NORTH;
        }
        if (latitudeIndex < 0) {
            return Tile.Location.SOUTH_EAST;
        }
        if (latitudeIndex <= this.latitudeRows - 2) {
            return Tile.Location.EAST;
        }
        return Tile.Location.NORTH_EAST;
    }
}

