/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.rugged.los;

import java.util.stream.Stream;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.analysis.differentiation.Derivative;
import org.hipparchus.analysis.polynomials.PolynomialFunction;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.RotationConvention;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.orekit.rugged.los.LOSTransform;
import org.orekit.rugged.utils.DerivativeGenerator;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.ParameterObserver;
import org.orekit.utils.TimeSpanMap;

public class PolynomialRotation
implements LOSTransform {
    private final double SCALE = FastMath.scalb((double)1.0, (int)-20);
    private final Vector3D axis;
    private PolynomialFunction angle;
    private FieldVector3D<?> axisDS;
    private Derivative<?>[] angleDS;
    private final AbsoluteDate referenceDate;
    private final ParameterDriver[] coefficientsDrivers;

    public PolynomialRotation(String name, Vector3D axis, AbsoluteDate referenceDate, double ... angleCoeffs) {
        this.axis = axis;
        this.referenceDate = referenceDate;
        this.coefficientsDrivers = new ParameterDriver[angleCoeffs.length];
        ParameterObserver resettingObserver = new ParameterObserver(){

            public void valueChanged(double previousValue, ParameterDriver driver, AbsoluteDate date) {
                PolynomialRotation.this.angle = null;
                PolynomialRotation.this.axisDS = null;
                PolynomialRotation.access$202(PolynomialRotation.this, null);
            }

            public void valueSpanMapChanged(TimeSpanMap<Double> previousValueSpanMap, ParameterDriver driver) {
                PolynomialRotation.this.angle = null;
                PolynomialRotation.this.axisDS = null;
                PolynomialRotation.access$202(PolynomialRotation.this, null);
            }
        };
        for (int i = 0; i < angleCoeffs.length; ++i) {
            this.coefficientsDrivers[i] = new ParameterDriver(name + "[" + i + "]", angleCoeffs[i], this.SCALE, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
            this.coefficientsDrivers[i].addObserver(resettingObserver);
        }
    }

    public PolynomialRotation(String name, Vector3D axis, AbsoluteDate referenceDate, PolynomialFunction angle) {
        this(name, axis, referenceDate, angle.getCoefficients());
    }

    @Override
    public Stream<ParameterDriver> getParametersDrivers() {
        return Stream.of(this.coefficientsDrivers);
    }

    @Override
    public Vector3D transformLOS(int i, Vector3D los, AbsoluteDate date) {
        if (this.angle == null) {
            double[] coefficients = new double[this.coefficientsDrivers.length];
            for (int k = 0; k < coefficients.length; ++k) {
                coefficients[k] = this.coefficientsDrivers[k].getValue();
            }
            this.angle = new PolynomialFunction(coefficients);
        }
        return new Rotation(this.axis, this.angle.value(date.durationFrom(this.referenceDate)), RotationConvention.VECTOR_OPERATOR).applyTo(los);
    }

    @Override
    public <T extends Derivative<T>> FieldVector3D<T> transformLOS(int i, FieldVector3D<T> los, AbsoluteDate date, DerivativeGenerator<T> generator) {
        Derivative<?>[] angleD;
        FieldVector3D axisD;
        Field<T> field = generator.getField();
        if (this.axisDS == null || !this.axisDS.getX().getField().equals(field)) {
            axisD = new FieldVector3D(generator.constant(this.axis.getX()), generator.constant(this.axis.getY()), generator.constant(this.axis.getZ()));
            angleD = (Derivative[])MathArrays.buildArray(field, (int)this.coefficientsDrivers.length);
            for (int k = 0; k < angleD.length; ++k) {
                angleD[k] = generator.variable(this.coefficientsDrivers[k]);
            }
            this.axisDS = axisD;
            this.angleDS = angleD;
        } else {
            axisD = this.axisDS;
            angleD = this.angleDS;
        }
        double t = date.durationFrom(this.referenceDate);
        Derivative alpha = (Derivative)field.getZero();
        for (int k = this.angleDS.length - 1; k >= 0; --k) {
            alpha = (Derivative)((Derivative)alpha.multiply(t)).add(angleD[k]);
        }
        return new FieldRotation(axisD, (CalculusFieldElement)alpha, RotationConvention.VECTOR_OPERATOR).applyTo(los);
    }

    static /* synthetic */ Derivative[] access$202(PolynomialRotation x0, Derivative[] x1) {
        x0.angleDS = x1;
        return x1;
    }
}

