/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.rugged.linesensor;

import org.hipparchus.analysis.UnivariateFunction;
import org.hipparchus.analysis.solvers.BracketingNthOrderBrentSolver;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.rugged.errors.RuggedException;
import org.orekit.rugged.errors.RuggedInternalError;
import org.orekit.rugged.linesensor.LineSensor;
import org.orekit.time.AbsoluteDate;

public class SensorPixelCrossing {
    private static final double MARGIN = 10.0;
    private final LineSensor sensor;
    private final Vector3D cross;
    private final int maxEval;
    private final double accuracy;

    public SensorPixelCrossing(LineSensor sensor, Vector3D meanNormal, Vector3D targetDirection, int maxEval, double accuracy) {
        this.sensor = sensor;
        this.cross = (Vector3D)Vector3D.crossProduct((Vector3D)meanNormal, (Vector3D)targetDirection).normalize();
        this.maxEval = maxEval;
        this.accuracy = accuracy;
    }

    public double locatePixel(final AbsoluteDate date) {
        try {
            UnivariateFunction f = new UnivariateFunction(){

                public double value(double x) {
                    try {
                        return Vector3D.angle((Vector3D)SensorPixelCrossing.this.cross, (Vector3D)SensorPixelCrossing.this.getLOS(date, x)) - 1.5707963267948966;
                    }
                    catch (RuggedException re) {
                        throw new RuggedInternalError(re);
                    }
                }
            };
            BracketingNthOrderBrentSolver solver = new BracketingNthOrderBrentSolver(0.0, this.accuracy, 5);
            return solver.solve(this.maxEval, f, -10.0, (double)(this.sensor.getNbPixels() - 1) + 10.0);
        }
        catch (MathIllegalArgumentException nbe) {
            return Double.NaN;
        }
    }

    private Vector3D getLOS(AbsoluteDate date, double x) {
        int iInf = FastMath.max((int)0, (int)FastMath.min((int)(this.sensor.getNbPixels() - 2), (int)((int)FastMath.floor((double)x))));
        int iSup = iInf + 1;
        return (Vector3D)new Vector3D((double)iSup - x, this.sensor.getLOS(date, iInf), x - (double)iInf, this.sensor.getLOS(date, iSup)).normalize();
    }
}

