/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.rugged.intersection.duvenhage;

import org.hipparchus.util.FastMath;
import org.orekit.rugged.errors.DumpManager;
import org.orekit.rugged.raster.SimpleTile;
import org.orekit.rugged.utils.MaxSelector;
import org.orekit.rugged.utils.MinSelector;
import org.orekit.rugged.utils.Selector;

public class MinMaxTreeTile
extends SimpleTile {
    private double[] raw;
    private double[] minTree;
    private double[] maxTree;
    private int[] start;

    protected MinMaxTreeTile() {
    }

    @Override
    protected void processUpdatedElevation(double[] elevations) {
        this.raw = elevations;
        int nbRows = this.getLatitudeRows();
        int nbCols = this.getLongitudeColumns();
        int size = this.setLevels(0, nbRows, nbCols);
        this.minTree = new double[size];
        this.maxTree = new double[size];
        if (this.start.length > 0) {
            double[] preprocessed = new double[this.raw.length];
            this.preprocess(preprocessed, this.raw, nbRows, nbCols, MinSelector.getInstance());
            this.applyRecursively(this.minTree, this.start.length - 1, nbRows, nbCols, MinSelector.getInstance(), preprocessed, 0);
            this.preprocess(preprocessed, this.raw, nbRows, nbCols, MaxSelector.getInstance());
            this.applyRecursively(this.maxTree, this.start.length - 1, nbRows, nbCols, MaxSelector.getInstance(), preprocessed, 0);
        }
    }

    public int getLevels() {
        return this.start.length;
    }

    public double getMinElevation(int i, int j, int level) {
        int k = this.start.length - level;
        int rowShift = k / 2;
        int colShift = (k + 1) / 2;
        int levelI = i >> rowShift;
        int levelJ = j >> colShift;
        int levelC = 1 + (this.getLongitudeColumns() - 1 >> colShift);
        if (DumpManager.isActive()) {
            int[] min = this.locateMin(i, j, level);
            int index = min[0] * this.getLongitudeColumns() + min[1];
            DumpManager.dumpTileCell(this, min[0], min[1], this.raw[index]);
            if (index + this.getLongitudeColumns() < this.raw.length) {
                DumpManager.dumpTileCell(this, min[0] + 1, min[1], this.raw[index + this.getLongitudeColumns()]);
            }
            if (index + 1 < this.raw.length) {
                DumpManager.dumpTileCell(this, min[0], min[1] + 1, this.raw[index + 1]);
            }
            if (index + this.getLongitudeColumns() + 1 < this.raw.length) {
                DumpManager.dumpTileCell(this, min[0] + 1, min[1] + 1, this.raw[index + this.getLongitudeColumns() + 1]);
            }
        }
        return this.minTree[this.start[level] + levelI * levelC + levelJ];
    }

    public double getMaxElevation(int i, int j, int level) {
        int k = this.start.length - level;
        int rowShift = k / 2;
        int colShift = (k + 1) / 2;
        int levelI = i >> rowShift;
        int levelJ = j >> colShift;
        int levelC = 1 + (this.getLongitudeColumns() - 1 >> colShift);
        if (DumpManager.isActive()) {
            int[] max = this.locateMax(i, j, level);
            int index = max[0] * this.getLongitudeColumns() + max[1];
            DumpManager.dumpTileCell(this, max[0], max[1], this.raw[index]);
            if (index + this.getLongitudeColumns() < this.raw.length) {
                DumpManager.dumpTileCell(this, max[0] + 1, max[1], this.raw[index + this.getLongitudeColumns()]);
            }
            if (index + 1 < this.raw.length) {
                DumpManager.dumpTileCell(this, max[0], max[1] + 1, this.raw[index + 1]);
            }
            if (index + this.getLongitudeColumns() + 1 < this.raw.length) {
                DumpManager.dumpTileCell(this, max[0] + 1, max[1] + 1, this.raw[index + this.getLongitudeColumns() + 1]);
            }
        }
        return this.maxTree[this.start[level] + levelI * levelC + levelJ];
    }

    public int[] locateMin(int i, int j, int level) {
        return this.locateMinMax(i, j, level, MinSelector.getInstance(), this.minTree);
    }

    public int[] locateMax(int i, int j, int level) {
        return this.locateMinMax(i, j, level, MaxSelector.getInstance(), this.maxTree);
    }

    private int[] locateMinMax(int i, int j, int level, Selector selector, double[] tree) {
        int k = this.start.length - level;
        int rowShift = k / 2;
        int colShift = (k + 1) / 2;
        int levelI = i >> rowShift;
        int levelJ = j >> colShift;
        int levelR = 1 + (this.getLatitudeRows() - 1 >> rowShift);
        int levelC = 1 + (this.getLongitudeColumns() - 1 >> colShift);
        for (int l = level + 1; l < this.start.length; ++l) {
            if (this.isColumnMerging(l)) {
                levelC = 1 + (this.getLongitudeColumns() - 1 >> --colShift);
                if ((levelJ <<= 1) + 1 >= levelC || !selector.selectFirst(tree[this.start[l] + levelI * levelC + levelJ + 1], tree[this.start[l] + levelI * levelC + levelJ])) continue;
                ++levelJ;
                continue;
            }
            levelR = 1 + (this.getLatitudeRows() - 1 >> --rowShift);
            if ((levelI <<= 1) + 1 >= levelR || !selector.selectFirst(tree[this.start[l] + (levelI + 1) * levelC + levelJ], tree[this.start[l] + levelI * levelC + levelJ])) continue;
            ++levelI;
        }
        int selectedI = levelI;
        int selectedJ = 2 * levelJ;
        double selectedElevation = Double.NaN;
        for (int n = 2 * levelJ; n < 2 * levelJ + 3; ++n) {
            if (n >= this.getLongitudeColumns()) continue;
            for (int m = levelI; m < levelI + 2; ++m) {
                double elevation;
                if (m >= this.getLatitudeRows() || !selector.selectFirst(elevation = this.raw[m * this.getLongitudeColumns() + n], selectedElevation)) continue;
                selectedI = m;
                selectedJ = n;
                selectedElevation = elevation;
            }
        }
        return new int[]{selectedI, selectedJ};
    }

    public int getMergeLevel(int i1, int j1, int i2, int j2) {
        int largest = -1;
        int level = 0;
        while (level < this.start.length) {
            int k = this.start.length - level;
            int rowShift = k / 2;
            int colShift = (k + 1) / 2;
            int levelI1 = i1 >> rowShift;
            int levelJ1 = j1 >> colShift;
            int levelI2 = i2 >> rowShift;
            int levelJ2 = j2 >> colShift;
            if (levelI1 != levelI2 || levelJ1 != levelJ2) {
                return largest;
            }
            largest = level++;
        }
        return largest;
    }

    public int[] getCrossedBoundaryRows(int row1, int row2, int level) {
        int rows = 1 << (this.start.length - level) / 2;
        int min = FastMath.min((int)row1, (int)row2);
        int max = FastMath.max((int)row1, (int)row2) + 1;
        return this.buildCrossings(min + rows - 1 - (min + rows - 1) % rows, max, rows, row1 <= row2);
    }

    public int[] getCrossedBoundaryColumns(int column1, int column2, int level) {
        int columns = 1 << (this.start.length + 1 - level) / 2;
        int min = FastMath.min((int)column1, (int)column2);
        int max = FastMath.max((int)column1, (int)column2) + 1;
        return this.buildCrossings(min + columns - 1 - (min + columns - 1) % columns, max, columns, column1 <= column2);
    }

    private int[] buildCrossings(int begin, int end, int step, boolean ascending) {
        int n = FastMath.max((int)0, (int)((end - begin + step + (step > 0 ? -1 : 1)) / step));
        int[] crossings = new int[n];
        int crossing = begin;
        if (ascending) {
            for (int i = 0; i < crossings.length; ++i) {
                crossings[i] = crossing;
                crossing += step;
            }
        } else {
            for (int i = 0; i < crossings.length; ++i) {
                crossings[crossings.length - 1 - i] = crossing;
                crossing += step;
            }
        }
        return crossings;
    }

    public boolean isColumnMerging(int level) {
        return (level & 1) == (this.start.length & 1);
    }

    private int setLevels(int stage, int stageRows, int stageColumns) {
        if (stageRows == 1 || stageColumns == 1) {
            this.start = new int[stage];
            if (stage > 0) {
                this.start[0] = 0;
            }
            return stageRows * stageColumns;
        }
        int size = (stage & 1) == 0 ? this.setLevels(stage + 1, stageRows, (stageColumns + 1) / 2) : this.setLevels(stage + 1, (stageRows + 1) / 2, stageColumns);
        if (stage > 0) {
            this.start[this.start.length - stage] = size;
            return size + stageRows * stageColumns;
        }
        return size;
    }

    private void preprocess(double[] preprocessed, double[] elevations, int nbRows, int nbCols, Selector selector) {
        int k = 0;
        for (int i = 0; i < nbRows - 1; ++i) {
            for (int j = 0; j < nbCols - 1; ++j) {
                preprocessed[k] = selector.select(selector.select(elevations[k], elevations[k + 1]), selector.select(elevations[k + nbCols], elevations[k + nbCols + 1]));
                ++k;
            }
            preprocessed[k] = selector.select(elevations[k], elevations[k + nbCols]);
            ++k;
        }
        for (int j = 0; j < nbCols - 1; ++j) {
            preprocessed[k] = selector.select(elevations[k], elevations[k + 1]);
            ++k;
        }
        preprocessed[k] = elevations[k];
    }

    private void applyRecursively(double[] tree, int level, int levelRows, int levelColumns, Selector selector, double[] base, int first) {
        if (this.isColumnMerging(level + 1)) {
            int iTree = this.start[level];
            int iBase = first;
            int nextColumns = (levelColumns + 1) / 2;
            boolean odd = (levelColumns & 1) != 0;
            int jEnd = odd ? nextColumns - 1 : nextColumns;
            for (int i = 0; i < levelRows; ++i) {
                for (int j = 0; j < jEnd; ++j) {
                    tree[iTree++] = selector.select(base[iBase], base[iBase + 1]);
                    iBase += 2;
                }
                if (!odd) continue;
                tree[iTree++] = base[iBase++];
            }
            if (level > 0) {
                this.applyRecursively(tree, level - 1, levelRows, nextColumns, selector, tree, this.start[level]);
            }
        } else {
            int iTree = this.start[level];
            int iBase = first;
            int nextRows = (levelRows + 1) / 2;
            boolean odd = (levelRows & 1) != 0;
            int iEnd = odd ? nextRows - 1 : nextRows;
            for (int i = 0; i < iEnd; ++i) {
                for (int j = 0; j < levelColumns; ++j) {
                    tree[iTree++] = selector.select(base[iBase], base[iBase + levelColumns]);
                    ++iBase;
                }
                iBase += levelColumns;
            }
            if (odd) {
                System.arraycopy(base, iBase, tree, iTree, levelColumns);
            }
            if (level > 0) {
                this.applyRecursively(tree, level - 1, nextRows, levelColumns, selector, tree, this.start[level]);
            }
        }
    }
}

