/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.rugged.api;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.analysis.differentiation.Derivative;
import org.hipparchus.geometry.Point;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.frames.Transform;
import org.orekit.rugged.api.AlgorithmId;
import org.orekit.rugged.errors.DumpManager;
import org.orekit.rugged.errors.RuggedException;
import org.orekit.rugged.errors.RuggedInternalError;
import org.orekit.rugged.errors.RuggedMessages;
import org.orekit.rugged.intersection.IntersectionAlgorithm;
import org.orekit.rugged.linesensor.LineSensor;
import org.orekit.rugged.linesensor.SensorMeanPlaneCrossing;
import org.orekit.rugged.linesensor.SensorPixel;
import org.orekit.rugged.linesensor.SensorPixelCrossing;
import org.orekit.rugged.refraction.AtmosphericRefraction;
import org.orekit.rugged.utils.DerivativeGenerator;
import org.orekit.rugged.utils.ExtendedEllipsoid;
import org.orekit.rugged.utils.NormalizedGeodeticPoint;
import org.orekit.rugged.utils.SpacecraftToObservedBody;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.PVCoordinates;

public class Rugged {
    private static final double COARSE_INVERSE_LOCATION_ACCURACY = 0.01;
    private static final int MAX_EVAL = 50;
    private static final double PIXEL_CV_THRESHOLD = 1.0E-4;
    private static final double LINE_CV_THRESHOLD = 1.0E-4;
    private final ExtendedEllipsoid ellipsoid;
    private final SpacecraftToObservedBody scToBody;
    private final Map<String, LineSensor> sensors;
    private final Map<String, SensorMeanPlaneCrossing> finders;
    private final IntersectionAlgorithm algorithm;
    private boolean lightTimeCorrection;
    private boolean aberrationOfLightCorrection;
    private final String name;
    private AtmosphericRefraction atmosphericRefraction;

    Rugged(IntersectionAlgorithm algorithm, ExtendedEllipsoid ellipsoid, boolean lightTimeCorrection, boolean aberrationOfLightCorrection, AtmosphericRefraction atmosphericRefraction, SpacecraftToObservedBody scToBody, Collection<LineSensor> sensors, String name) {
        this.ellipsoid = ellipsoid;
        this.scToBody = scToBody;
        this.algorithm = algorithm;
        this.name = name;
        this.sensors = new HashMap<String, LineSensor>();
        for (LineSensor s : sensors) {
            this.sensors.put(s.getName(), s);
        }
        this.finders = new HashMap<String, SensorMeanPlaneCrossing>();
        this.lightTimeCorrection = lightTimeCorrection;
        this.aberrationOfLightCorrection = aberrationOfLightCorrection;
        this.atmosphericRefraction = atmosphericRefraction;
    }

    public String getName() {
        return this.name;
    }

    public IntersectionAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public AlgorithmId getAlgorithmId() {
        return this.algorithm.getAlgorithmId();
    }

    public boolean isLightTimeCorrected() {
        return this.lightTimeCorrection;
    }

    public boolean isAberrationOfLightCorrected() {
        return this.aberrationOfLightCorrection;
    }

    public AtmosphericRefraction getRefractionCorrection() {
        return this.atmosphericRefraction;
    }

    public Collection<LineSensor> getLineSensors() {
        return this.sensors.values();
    }

    public AbsoluteDate getMinDate() {
        return this.scToBody.getMinDate();
    }

    public AbsoluteDate getMaxDate() {
        return this.scToBody.getMaxDate();
    }

    public boolean isInRange(AbsoluteDate date) {
        return this.scToBody.isInRange(date);
    }

    public ExtendedEllipsoid getEllipsoid() {
        return this.ellipsoid;
    }

    public GeodeticPoint[] directLocation(String sensorName, double lineNumber) {
        LineSensor sensor = this.getLineSensor(sensorName);
        Vector3D sensorPosition = sensor.getPosition();
        AbsoluteDate date = sensor.getDate(lineNumber);
        Transform scToInert = this.scToBody.getScToInertial(date);
        Transform inertToBody = this.scToBody.getInertialToBody(date);
        Vector3D spacecraftVelocity = scToInert.transformPVCoordinates(PVCoordinates.ZERO).getVelocity();
        Vector3D pInert = scToInert.transformPosition(sensorPosition);
        GeodeticPoint[] gp = new GeodeticPoint[sensor.getNbPixels()];
        for (int i = 0; i < sensor.getNbPixels(); ++i) {
            Vector3D lBody;
            Vector3D pBody;
            Vector3D los = sensor.getLOS(date, i);
            DumpManager.dumpDirectLocation(date, sensorPosition, los, this.lightTimeCorrection, this.aberrationOfLightCorrection, this.atmosphericRefraction != null);
            Vector3D obsLInert = scToInert.transformVector(los);
            Vector3D lInert = this.aberrationOfLightCorrection ? this.applyAberrationOfLightCorrection(obsLInert, spacecraftVelocity) : obsLInert;
            if (this.lightTimeCorrection) {
                gp[i] = this.computeWithLightTimeCorrection(date, sensorPosition, los, scToInert, inertToBody, pInert, lInert);
            } else {
                pBody = inertToBody.transformPosition(pInert);
                lBody = inertToBody.transformVector(lInert);
                gp[i] = this.algorithm.refineIntersection(this.ellipsoid, pBody, lBody, this.algorithm.intersection(this.ellipsoid, pBody, lBody));
            }
            if (this.atmosphericRefraction != null && this.atmosphericRefraction.mustBeComputed()) {
                if (this.lightTimeCorrection) {
                    Vector3D sP = inertToBody.transformPosition(pInert);
                    Vector3D eP = this.ellipsoid.transform(gp[i]);
                    double deltaT = eP.distance((Point)sP) / 2.99792458E8;
                    Transform shiftedInertToBody = inertToBody.shiftedBy(-deltaT);
                    pBody = shiftedInertToBody.transformPosition(pInert);
                    lBody = shiftedInertToBody.transformVector(lInert);
                } else {
                    pBody = inertToBody.transformPosition(pInert);
                    lBody = inertToBody.transformVector(lInert);
                }
                gp[i] = this.atmosphericRefraction.applyCorrection(pBody, lBody, (NormalizedGeodeticPoint)gp[i], this.algorithm);
            }
            DumpManager.dumpDirectLocationResult(gp[i]);
        }
        return gp;
    }

    public GeodeticPoint directLocation(AbsoluteDate date, Vector3D sensorPosition, Vector3D los) {
        NormalizedGeodeticPoint gp;
        DumpManager.dumpDirectLocation(date, sensorPosition, los, this.lightTimeCorrection, this.aberrationOfLightCorrection, this.atmosphericRefraction != null);
        Transform scToInert = this.scToBody.getScToInertial(date);
        Transform inertToBody = this.scToBody.getInertialToBody(date);
        Vector3D spacecraftVelocity = scToInert.transformPVCoordinates(PVCoordinates.ZERO).getVelocity();
        Vector3D pInert = scToInert.transformPosition(sensorPosition);
        Vector3D obsLInert = scToInert.transformVector(los);
        Vector3D lInert = this.aberrationOfLightCorrection ? this.applyAberrationOfLightCorrection(obsLInert, spacecraftVelocity) : obsLInert;
        if (this.lightTimeCorrection) {
            gp = this.computeWithLightTimeCorrection(date, sensorPosition, los, scToInert, inertToBody, pInert, lInert);
        } else {
            Vector3D pBody = inertToBody.transformPosition(pInert);
            Vector3D lBody = inertToBody.transformVector(lInert);
            gp = this.algorithm.refineIntersection(this.ellipsoid, pBody, lBody, this.algorithm.intersection(this.ellipsoid, pBody, lBody));
        }
        NormalizedGeodeticPoint result = gp;
        if (this.atmosphericRefraction != null && this.atmosphericRefraction.mustBeComputed()) {
            Vector3D lBody;
            Vector3D pBody;
            if (this.lightTimeCorrection) {
                Vector3D sP = inertToBody.transformPosition(pInert);
                Vector3D eP = this.ellipsoid.transform(gp);
                double deltaT = eP.distance((Point)sP) / 2.99792458E8;
                Transform shiftedInertToBody = inertToBody.shiftedBy(-deltaT);
                pBody = shiftedInertToBody.transformPosition(pInert);
                lBody = shiftedInertToBody.transformVector(lInert);
            } else {
                pBody = inertToBody.transformPosition(pInert);
                lBody = inertToBody.transformVector(lInert);
            }
            result = this.atmosphericRefraction.applyCorrection(pBody, lBody, gp, this.algorithm);
        }
        DumpManager.dumpDirectLocationResult(result);
        return result;
    }

    public AbsoluteDate dateLocation(String sensorName, double latitude, double longitude, int minLine, int maxLine) {
        GeodeticPoint groundPoint = new GeodeticPoint(latitude, longitude, this.algorithm.getElevation(latitude, longitude));
        return this.dateLocation(sensorName, groundPoint, minLine, maxLine);
    }

    public AbsoluteDate dateLocation(String sensorName, GeodeticPoint point, int minLine, int maxLine) {
        Vector3D target;
        LineSensor sensor = this.getLineSensor(sensorName);
        SensorMeanPlaneCrossing planeCrossing = this.getPlaneCrossing(sensorName, minLine, maxLine);
        SensorMeanPlaneCrossing.CrossingResult crossingResult = planeCrossing.find(target = this.ellipsoid.transform(point));
        if (crossingResult == null) {
            return null;
        }
        return sensor.getDate(crossingResult.getLine());
    }

    public SensorPixel inverseLocation(String sensorName, double latitude, double longitude, int minLine, int maxLine) {
        GeodeticPoint groundPoint = new GeodeticPoint(latitude, longitude, this.algorithm.getElevation(latitude, longitude));
        return this.inverseLocation(sensorName, groundPoint, minLine, maxLine);
    }

    public SensorPixel inverseLocation(String sensorName, GeodeticPoint point, int minLine, int maxLine) {
        LineSensor sensor = this.getLineSensor(sensorName);
        DumpManager.dumpInverseLocation(sensor, point, this.ellipsoid, minLine, maxLine, this.lightTimeCorrection, this.aberrationOfLightCorrection, this.atmosphericRefraction != null);
        SensorMeanPlaneCrossing planeCrossing = this.getPlaneCrossing(sensorName, minLine, maxLine);
        DumpManager.dumpSensorMeanPlane(planeCrossing);
        if (this.atmosphericRefraction == null || !this.atmosphericRefraction.mustBeComputed()) {
            return this.findSensorPixelWithoutAtmosphere(point, sensor, planeCrossing);
        }
        return this.findSensorPixelWithAtmosphere(point, sensor, minLine, maxLine);
    }

    private Vector3D applyAberrationOfLightCorrection(Vector3D obsLInert, Vector3D spacecraftVelocity) {
        double a = obsLInert.getNormSq();
        double b = -Vector3D.dotProduct((Vector3D)obsLInert, (Vector3D)spacecraftVelocity);
        double c = spacecraftVelocity.getNormSq() - 8.987551787368176E16;
        double s = FastMath.sqrt((double)(b * b - a * c));
        double k = b > 0.0 ? -c / (s + b) : (s - b) / a;
        Vector3D lInert = new Vector3D(k / 2.99792458E8, obsLInert, -3.3356409519815204E-9, spacecraftVelocity);
        return lInert;
    }

    private NormalizedGeodeticPoint computeWithLightTimeCorrection(AbsoluteDate date, Vector3D sensorPosition, Vector3D los, Transform scToInert, Transform inertToBody, Vector3D pInert, Vector3D lInert) {
        Transform approximate = new Transform(date, scToInert, inertToBody);
        Vector3D sL = approximate.transformVector(los);
        Vector3D sP = approximate.transformPosition(sensorPosition);
        Vector3D eP1 = this.ellipsoid.transform(this.ellipsoid.pointOnGround(sP, sL, 0.0));
        double deltaT1 = eP1.distance((Point)sP) / 2.99792458E8;
        Transform shifted1 = inertToBody.shiftedBy(-deltaT1);
        NormalizedGeodeticPoint gp1 = this.algorithm.intersection(this.ellipsoid, shifted1.transformPosition(pInert), shifted1.transformVector(lInert));
        Vector3D eP2 = this.ellipsoid.transform(gp1);
        double deltaT2 = eP2.distance((Point)sP) / 2.99792458E8;
        Transform shifted2 = inertToBody.shiftedBy(-deltaT2);
        return this.algorithm.refineIntersection(this.ellipsoid, shifted2.transformPosition(pInert), shifted2.transformVector(lInert), gp1);
    }

    private SensorPixel findSensorPixelWithoutAtmosphere(GeodeticPoint point, LineSensor sensor, SensorMeanPlaneCrossing planeCrossing) {
        Vector3D target = this.ellipsoid.transform(point);
        SensorMeanPlaneCrossing.CrossingResult crossingResult = planeCrossing.find(target);
        if (crossingResult == null) {
            return null;
        }
        SensorPixelCrossing pixelCrossing = new SensorPixelCrossing(sensor, planeCrossing.getMeanPlaneNormal(), crossingResult.getTargetDirection(), 50, 0.01);
        double coarsePixel = pixelCrossing.locatePixel(crossingResult.getDate());
        if (Double.isNaN(coarsePixel)) {
            return null;
        }
        int lowIndex = FastMath.max((int)0, (int)FastMath.min((int)(sensor.getNbPixels() - 2), (int)((int)FastMath.floor((double)coarsePixel))));
        Vector3D lowLOS = sensor.getLOS(crossingResult.getDate(), lowIndex);
        Vector3D highLOS = sensor.getLOS(crossingResult.getDate(), lowIndex + 1);
        Vector3D localZ = (Vector3D)Vector3D.crossProduct((Vector3D)lowLOS, (Vector3D)highLOS).normalize();
        double beta = FastMath.acos((double)Vector3D.dotProduct((Vector3D)crossingResult.getTargetDirection(), (Vector3D)localZ));
        double s = Vector3D.dotProduct((Vector3D)crossingResult.getTargetDirectionDerivative(), (Vector3D)localZ);
        double betaDer = -s / FastMath.sqrt((double)(1.0 - s * s));
        double deltaL = (1.5707963267948966 - beta) / betaDer;
        double fixedLine = crossingResult.getLine() + deltaL;
        Vector3D fixedDirection = (Vector3D)new Vector3D(1.0, crossingResult.getTargetDirection(), deltaL, crossingResult.getTargetDirectionDerivative()).normalize();
        AbsoluteDate fixedDate = sensor.getDate(fixedLine);
        Vector3D fixedX = sensor.getLOS(fixedDate, lowIndex);
        Vector3D fixedZ = Vector3D.crossProduct((Vector3D)fixedX, (Vector3D)sensor.getLOS(fixedDate, lowIndex + 1));
        Vector3D fixedY = Vector3D.crossProduct((Vector3D)fixedZ, (Vector3D)fixedX);
        double pixelWidth = FastMath.atan2((double)Vector3D.dotProduct((Vector3D)highLOS, (Vector3D)fixedY), (double)Vector3D.dotProduct((Vector3D)highLOS, (Vector3D)fixedX));
        double alpha = FastMath.atan2((double)Vector3D.dotProduct((Vector3D)fixedDirection, (Vector3D)fixedY), (double)Vector3D.dotProduct((Vector3D)fixedDirection, (Vector3D)fixedX));
        double fixedPixel = (double)lowIndex + alpha / pixelWidth;
        SensorPixel result = new SensorPixel(fixedLine, fixedPixel);
        DumpManager.dumpInverseLocationResult(result);
        return result;
    }

    private SensorPixel findSensorPixelWithAtmosphere(GeodeticPoint point, LineSensor sensor, int minLine, int maxLine) {
        String sensorName = sensor.getName();
        if (this.atmosphericRefraction.getBifPixel() == null || this.atmosphericRefraction.getBifLine() == null || !this.atmosphericRefraction.isSameContext(sensorName, minLine, maxLine).booleanValue()) {
            this.atmosphericRefraction.configureCorrectionGrid(sensor, minLine, maxLine);
            int nbPixelGrid = this.atmosphericRefraction.getComputationParameters().getNbPixelGrid();
            int nbLineGrid = this.atmosphericRefraction.getComputationParameters().getNbLineGrid();
            double[] pixelGrid = this.atmosphericRefraction.getComputationParameters().getUgrid();
            double[] lineGrid = this.atmosphericRefraction.getComputationParameters().getVgrid();
            this.atmosphericRefraction.reactivateComputation();
            GeodeticPoint[][] geodeticGridWithAtmosphere = this.computeDirectLocOnGridWithAtmosphere(pixelGrid, lineGrid, sensor);
            this.atmosphericRefraction.deactivateComputation();
            SensorPixel[][] sensorPixelGridInverseWithout = this.computeInverseLocOnGridWithoutAtmosphere(geodeticGridWithAtmosphere, nbPixelGrid, nbLineGrid, sensor, minLine, maxLine);
            this.atmosphericRefraction.reactivateComputation();
            this.atmosphericRefraction.computeGridCorrectionFunctions(sensorPixelGridInverseWithout);
        }
        Boolean wasSuspended = DumpManager.suspend();
        this.atmosphericRefraction.deactivateComputation();
        SensorPixel sp0 = this.inverseLocation(sensorName, point, minLine, maxLine);
        this.atmosphericRefraction.reactivateComputation();
        DumpManager.resume(wasSuspended);
        if (sp0 == null) {
            DumpManager.endNicely();
            throw new RuggedException(RuggedMessages.SENSOR_PIXEL_NOT_FOUND_IN_RANGE_LINES, minLine, maxLine);
        }
        double pixel0 = sp0.getPixelNumber();
        double line0 = sp0.getLineNumber();
        sensor.dumpRate(line0);
        double corrPixelPrevious = pixel0 + this.atmosphericRefraction.getBifPixel().value(pixel0, line0);
        double corrLinePrevious = line0 + this.atmosphericRefraction.getBifLine().value(pixel0, line0);
        double deltaCorrPixel = Double.POSITIVE_INFINITY;
        double deltaCorrLine = Double.POSITIVE_INFINITY;
        while (deltaCorrPixel > 1.0E-4 && deltaCorrLine > 1.0E-4) {
            double corrPixelCurrent = pixel0 + this.atmosphericRefraction.getBifPixel().value(corrPixelPrevious, corrLinePrevious);
            double corrLineCurrent = line0 + this.atmosphericRefraction.getBifLine().value(corrPixelPrevious, corrLinePrevious);
            deltaCorrPixel = FastMath.abs((double)(corrPixelCurrent - corrPixelPrevious));
            deltaCorrLine = FastMath.abs((double)(corrLineCurrent - corrLinePrevious));
            corrPixelPrevious = corrPixelCurrent;
            corrLinePrevious = corrLineCurrent;
        }
        SensorPixel sensorPixelWithAtmosphere = new SensorPixel(corrLinePrevious, corrPixelPrevious);
        DumpManager.dumpInverseLocationResult(sensorPixelWithAtmosphere);
        return sensorPixelWithAtmosphere;
    }

    private SensorPixel[][] computeInverseLocOnGridWithoutAtmosphere(GeodeticPoint[][] groundGridWithAtmosphere, int nbPixelGrid, int nbLineGrid, LineSensor sensor, int minLine, int maxLine) {
        Boolean wasSuspended = DumpManager.suspend();
        SensorPixel[][] sensorPixelGrid = new SensorPixel[nbPixelGrid][nbLineGrid];
        String sensorName = sensor.getName();
        for (int uIndex = 0; uIndex < nbPixelGrid; ++uIndex) {
            for (int vIndex = 0; vIndex < nbLineGrid; ++vIndex) {
                if (groundGridWithAtmosphere[uIndex][vIndex] != null) {
                    GeodeticPoint groundPoint = groundGridWithAtmosphere[uIndex][vIndex];
                    double currentLat = groundPoint.getLatitude();
                    double currentLon = groundPoint.getLongitude();
                    try {
                        sensorPixelGrid[uIndex][vIndex] = this.inverseLocation(sensorName, currentLat, currentLon, minLine, maxLine);
                    }
                    catch (RuggedException re) {
                        DumpManager.endNicely();
                        throw new RuggedInternalError(re);
                    }
                    if (this.pixelIsInside(sensorPixelGrid[uIndex][vIndex], sensor)) continue;
                    DumpManager.endNicely();
                    if (sensorPixelGrid[uIndex][vIndex] == null) {
                        throw new RuggedException(RuggedMessages.SENSOR_PIXEL_NOT_FOUND_IN_RANGE_LINES, minLine, maxLine);
                    }
                    double invLocationMargin = this.atmosphericRefraction.getComputationParameters().getInverseLocMargin();
                    throw new RuggedException(RuggedMessages.SENSOR_PIXEL_NOT_FOUND_IN_PIXELS_LINE, sensorPixelGrid[uIndex][vIndex].getPixelNumber(), -invLocationMargin, invLocationMargin + (double)sensor.getNbPixels() - 1.0, invLocationMargin);
                }
                sensorPixelGrid[uIndex][vIndex] = null;
            }
        }
        DumpManager.resume(wasSuspended);
        return sensorPixelGrid;
    }

    private boolean pixelIsInside(SensorPixel pixel, LineSensor sensor) {
        double invLocationMargin = this.atmosphericRefraction.getComputationParameters().getInverseLocMargin();
        return pixel != null && pixel.getPixelNumber() >= -invLocationMargin && pixel.getPixelNumber() < invLocationMargin + (double)sensor.getNbPixels() - 1.0;
    }

    private GeodeticPoint[][] computeDirectLocOnGridWithAtmosphere(double[] pixelGrid, double[] lineGrid, LineSensor sensor) {
        Boolean wasSuspended = DumpManager.suspend();
        int nbPixelGrid = pixelGrid.length;
        int nbLineGrid = lineGrid.length;
        GeodeticPoint[][] groundGridWithAtmosphere = new GeodeticPoint[nbPixelGrid][nbLineGrid];
        Vector3D sensorPosition = sensor.getPosition();
        for (int uIndex = 0; uIndex < nbPixelGrid; ++uIndex) {
            double pixelNumber = pixelGrid[uIndex];
            for (int vIndex = 0; vIndex < nbLineGrid; ++vIndex) {
                double lineNumber = lineGrid[vIndex];
                AbsoluteDate date = sensor.getDate(lineNumber);
                Vector3D los = sensor.getLOS(date, pixelNumber);
                try {
                    groundGridWithAtmosphere[uIndex][vIndex] = this.directLocation(date, sensorPosition, los);
                    continue;
                }
                catch (RuggedException re) {
                    DumpManager.endNicely();
                    throw new RuggedInternalError(re);
                }
            }
        }
        DumpManager.resume(wasSuspended);
        return groundGridWithAtmosphere;
    }

    public double[] distanceBetweenLOS(LineSensor sensorA, AbsoluteDate dateA, double pixelA, SpacecraftToObservedBody scToBodyA, LineSensor sensorB, AbsoluteDate dateB, double pixelB) {
        Transform scToInertA = scToBodyA.getScToInertial(dateA);
        Transform inertToBodyA = scToBodyA.getInertialToBody(dateA);
        Transform transformScToBodyA = new Transform(dateA, scToInertA, inertToBodyA);
        Transform scToInertB = this.scToBody.getScToInertial(dateB);
        Transform inertToBodyB = this.scToBody.getInertialToBody(dateB);
        Transform transformScToBodyB = new Transform(dateB, scToInertB, inertToBodyB);
        Vector3D vALocal = sensorA.getLOS(dateA, pixelA);
        Vector3D vBLocal = sensorB.getLOS(dateB, pixelB);
        Vector3D sALocal = sensorA.getPosition();
        Vector3D sBLocal = sensorB.getPosition();
        Vector3D sA = transformScToBodyA.transformPosition(sALocal);
        Vector3D vA = transformScToBodyA.transformVector(vALocal);
        Vector3D sB = transformScToBodyB.transformPosition(sBLocal);
        Vector3D vB = transformScToBodyB.transformVector(vBLocal);
        Vector3D vBase = sB.subtract((Vector)sA);
        double svA = Vector3D.dotProduct((Vector3D)vBase, (Vector3D)vA);
        double svB = Vector3D.dotProduct((Vector3D)vBase, (Vector3D)vB);
        double vAvB = Vector3D.dotProduct((Vector3D)vA, (Vector3D)vB);
        double lambdaB = (svA * vAvB - svB) / (1.0 - vAvB * vAvB);
        double lambdaA = svA + lambdaB * vAvB;
        Vector3D mA = sA.add((Vector)vA.scalarMultiply(lambdaA));
        Vector3D mB = sB.add((Vector)vB.scalarMultiply(lambdaB));
        Vector3D vDistanceMin = mB.subtract((Vector)mA);
        Vector3D midPoint = mB.add((Vector)mA).scalarMultiply(0.5);
        double[] distances = new double[]{vDistanceMin.getNorm(), midPoint.getNorm()};
        return distances;
    }

    public <T extends Derivative<T>> T[] distanceBetweenLOSderivatives(LineSensor sensorA, AbsoluteDate dateA, double pixelA, SpacecraftToObservedBody scToBodyA, LineSensor sensorB, AbsoluteDate dateB, double pixelB, DerivativeGenerator<T> generator) {
        Transform scToInertA = scToBodyA.getScToInertial(dateA);
        Transform inertToBodyA = scToBodyA.getInertialToBody(dateA);
        Transform transformScToBodyA = new Transform(dateA, scToInertA, inertToBodyA);
        Transform scToInertB = this.scToBody.getScToInertial(dateB);
        Transform inertToBodyB = this.scToBody.getInertialToBody(dateB);
        Transform transformScToBodyB = new Transform(dateB, scToInertB, inertToBodyB);
        FieldVector3D<T> vALocal = sensorA.getLOSDerivatives(dateA, pixelA, generator);
        FieldVector3D<T> vBLocal = sensorB.getLOSDerivatives(dateB, pixelB, generator);
        FieldVector3D vA = transformScToBodyA.transformVector(vALocal);
        FieldVector3D vB = transformScToBodyB.transformVector(vBLocal);
        Vector3D sAtmp = sensorA.getPosition();
        Vector3D sBtmp = sensorB.getPosition();
        Derivative scaleFactor = (Derivative)FieldVector3D.dotProduct((FieldVector3D)vA.normalize(), (FieldVector3D)vA.normalize());
        FieldVector3D sALocal = new FieldVector3D((CalculusFieldElement)scaleFactor, sAtmp);
        FieldVector3D sBLocal = new FieldVector3D((CalculusFieldElement)scaleFactor, sBtmp);
        FieldVector3D sA = transformScToBodyA.transformPosition(sALocal);
        FieldVector3D sB = transformScToBodyB.transformPosition(sBLocal);
        FieldVector3D vBase = sB.subtract(sA);
        Derivative svA = (Derivative)FieldVector3D.dotProduct((FieldVector3D)vBase, (FieldVector3D)vA);
        Derivative svB = (Derivative)FieldVector3D.dotProduct((FieldVector3D)vBase, (FieldVector3D)vB);
        Derivative vAvB = (Derivative)FieldVector3D.dotProduct((FieldVector3D)vA, (FieldVector3D)vB);
        Derivative lambdaB = (Derivative)((Derivative)((Derivative)svA.multiply((FieldElement)vAvB)).subtract((FieldElement)svB)).divide((FieldElement)((Derivative)((Derivative)((Derivative)vAvB.multiply((FieldElement)vAvB)).subtract(1.0)).negate()));
        Derivative lambdaA = (Derivative)((Derivative)vAvB.multiply((FieldElement)lambdaB)).add((FieldElement)svA);
        FieldVector3D mA = sA.add(vA.scalarMultiply((CalculusFieldElement)lambdaA));
        FieldVector3D mB = sB.add(vB.scalarMultiply((CalculusFieldElement)lambdaB));
        FieldVector3D vDistanceMin = mB.subtract(mA);
        FieldVector3D midPoint = mB.add(mA).scalarMultiply(0.5);
        Derivative dMin = (Derivative)vDistanceMin.getNorm();
        Derivative dCentralBody = (Derivative)midPoint.getNorm();
        Derivative[] ret = (Derivative[])MathArrays.buildArray((Field)dMin.getField(), (int)2);
        ret[0] = dMin;
        ret[1] = dCentralBody;
        return ret;
    }

    private SensorMeanPlaneCrossing getPlaneCrossing(String sensorName, int minLine, int maxLine) {
        LineSensor sensor = this.getLineSensor(sensorName);
        SensorMeanPlaneCrossing planeCrossing = this.finders.get(sensorName);
        if (planeCrossing == null || planeCrossing.getMinLine() != minLine || planeCrossing.getMaxLine() != maxLine) {
            planeCrossing = new SensorMeanPlaneCrossing(sensor, this.scToBody, minLine, maxLine, this.lightTimeCorrection, this.aberrationOfLightCorrection, 50, 0.01);
            this.setPlaneCrossing(planeCrossing);
        }
        return planeCrossing;
    }

    private void setPlaneCrossing(SensorMeanPlaneCrossing planeCrossing) {
        this.finders.put(planeCrossing.getSensor().getName(), planeCrossing);
    }

    public <T extends Derivative<T>> T[] inverseLocationDerivatives(String sensorName, GeodeticPoint point, int minLine, int maxLine, DerivativeGenerator<T> generator) {
        Vector3D target;
        LineSensor sensor = this.getLineSensor(sensorName);
        SensorMeanPlaneCrossing planeCrossing = this.getPlaneCrossing(sensorName, minLine, maxLine);
        SensorMeanPlaneCrossing.CrossingResult crossingResult = planeCrossing.find(target = this.ellipsoid.transform(point));
        if (crossingResult == null) {
            return null;
        }
        SensorPixelCrossing pixelCrossing = new SensorPixelCrossing(sensor, planeCrossing.getMeanPlaneNormal(), crossingResult.getTargetDirection(), 50, 0.01);
        double coarsePixel = pixelCrossing.locatePixel(crossingResult.getDate());
        if (Double.isNaN(coarsePixel)) {
            return null;
        }
        int lowIndex = FastMath.max((int)0, (int)FastMath.min((int)(sensor.getNbPixels() - 2), (int)((int)FastMath.floor((double)coarsePixel))));
        FieldVector3D<T> lowLOS = sensor.getLOSDerivatives(crossingResult.getDate(), lowIndex, generator);
        FieldVector3D<T> highLOS = sensor.getLOSDerivatives(crossingResult.getDate(), lowIndex + 1, generator);
        FieldVector3D localZ = FieldVector3D.crossProduct(lowLOS, highLOS).normalize();
        Derivative beta = (Derivative)((Derivative)FieldVector3D.dotProduct((Vector3D)crossingResult.getTargetDirection(), (FieldVector3D)localZ)).acos();
        Derivative s = (Derivative)FieldVector3D.dotProduct((Vector3D)crossingResult.getTargetDirectionDerivative(), (FieldVector3D)localZ);
        Derivative minusBetaDer = (Derivative)s.divide((FieldElement)((Derivative)((Derivative)((Derivative)((Derivative)s.multiply((FieldElement)s)).subtract(1.0)).negate()).sqrt()));
        Derivative deltaL = (Derivative)((Derivative)beta.subtract(1.5707963267948966)).divide((FieldElement)minusBetaDer);
        Derivative fixedLine = (Derivative)deltaL.add(crossingResult.getLine());
        FieldVector3D fixedDirection = new FieldVector3D((CalculusFieldElement)((Derivative)deltaL.getField().getOne()), crossingResult.getTargetDirection(), (CalculusFieldElement)deltaL, crossingResult.getTargetDirectionDerivative()).normalize();
        AbsoluteDate fixedDate = sensor.getDate(fixedLine.getValue());
        FieldVector3D<T> fixedX = sensor.getLOSDerivatives(fixedDate, lowIndex, generator);
        FieldVector3D fixedZ = FieldVector3D.crossProduct(fixedX, sensor.getLOSDerivatives(fixedDate, lowIndex + 1, generator));
        FieldVector3D fixedY = FieldVector3D.crossProduct((FieldVector3D)fixedZ, fixedX);
        Derivative hY = (Derivative)FieldVector3D.dotProduct(highLOS, (FieldVector3D)fixedY);
        Derivative hX = (Derivative)FieldVector3D.dotProduct(highLOS, fixedX);
        Derivative pixelWidth = (Derivative)hY.atan2((FieldElement)hX);
        Derivative fY = (Derivative)FieldVector3D.dotProduct((FieldVector3D)fixedDirection, (FieldVector3D)fixedY);
        Derivative fX = (Derivative)FieldVector3D.dotProduct((FieldVector3D)fixedDirection, fixedX);
        Derivative alpha = (Derivative)fY.atan2((FieldElement)fX);
        Derivative fixedPixel = (Derivative)((Derivative)alpha.divide((FieldElement)pixelWidth)).add((double)lowIndex);
        Derivative[] ret = (Derivative[])MathArrays.buildArray((Field)fixedPixel.getField(), (int)2);
        ret[0] = fixedLine;
        ret[1] = fixedPixel;
        return ret;
    }

    public Transform getScToInertial(AbsoluteDate date) {
        return this.scToBody.getScToInertial(date);
    }

    public Transform getInertialToBody(AbsoluteDate date) {
        return this.scToBody.getInertialToBody(date);
    }

    public Transform getBodyToInertial(AbsoluteDate date) {
        return this.scToBody.getBodyToInertial(date);
    }

    public LineSensor getLineSensor(String sensorName) {
        LineSensor sensor = this.sensors.get(sensorName);
        if (sensor == null) {
            throw new RuggedException(RuggedMessages.UNKNOWN_SENSOR, sensorName);
        }
        return sensor;
    }

    public SpacecraftToObservedBody getScToBody() {
        return this.scToBody;
    }
}

