/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.rugged.adjustment.measurements;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.orekit.rugged.adjustment.measurements.SensorMapping;
import org.orekit.rugged.linesensor.SensorPixel;

public class SensorToSensorMapping {
    private static final String RUGGED = "Rugged";
    private final String sensorNameB;
    private final String ruggedNameB;
    private final SensorMapping<SensorPixel> interMapping;
    private final List<Double> losDistances;
    private final List<Double> bodyDistances;
    private double bodyConstraintWeight;

    public SensorToSensorMapping(String sensorNameA, String sensorNameB) {
        this(sensorNameA, RUGGED, sensorNameB, RUGGED, 0.0);
    }

    public SensorToSensorMapping(String sensorNameA, String ruggedNameA, String sensorNameB, String ruggedNameB, double bodyConstraintWeight) {
        this.interMapping = new SensorMapping(sensorNameA, ruggedNameA);
        this.sensorNameB = sensorNameB;
        this.ruggedNameB = ruggedNameB;
        this.losDistances = new ArrayList<Double>();
        this.bodyDistances = new ArrayList<Double>();
        this.bodyConstraintWeight = bodyConstraintWeight;
    }

    public SensorToSensorMapping(String sensorNameA, String ruggedNameA, String sensorNameB, String ruggedNameB) {
        this(sensorNameA, ruggedNameA, sensorNameB, ruggedNameB, 0.0);
    }

    public SensorToSensorMapping(String sensorNameA, String sensorNameB, double bodyConstraintWeight) {
        this(sensorNameA, RUGGED, sensorNameB, RUGGED, bodyConstraintWeight);
    }

    public String getSensorNameB() {
        return this.sensorNameB;
    }

    public String getSensorNameA() {
        return this.interMapping.getSensorName();
    }

    public String getRuggedNameB() {
        return this.ruggedNameB;
    }

    public String getRuggedNameA() {
        return this.interMapping.getRuggedName();
    }

    public Set<Map.Entry<SensorPixel, SensorPixel>> getMapping() {
        return this.interMapping.getMapping();
    }

    public List<Double> getLosDistances() {
        return this.losDistances;
    }

    public List<Double> getBodyDistances() {
        return this.bodyDistances;
    }

    public double getBodyConstraintWeight() {
        return this.bodyConstraintWeight;
    }

    public Double getBodyDistance(int idx) {
        return this.getBodyDistances().get(idx);
    }

    public Double getLosDistance(int idx) {
        return this.getLosDistances().get(idx);
    }

    public void addMapping(SensorPixel pixelA, SensorPixel pixelB, Double losDistance) {
        this.interMapping.addMapping(pixelA, pixelB);
        this.losDistances.add(losDistance);
    }

    public void addMapping(SensorPixel pixelA, SensorPixel pixelB, Double losDistance, Double bodyDistance) {
        this.interMapping.addMapping(pixelA, pixelB);
        this.losDistances.add(losDistance);
        this.bodyDistances.add(bodyDistance);
    }

    public void setBodyConstraintWeight(double bodyConstraintWeight) {
        this.bodyConstraintWeight = bodyConstraintWeight;
    }
}

