/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.rugged.adjustment.measurements;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.orekit.rugged.linesensor.SensorPixel;

public class SensorMapping<T> {
    private static final String RUGGED = "Rugged";
    private final String sensorName;
    private final String ruggedName;
    private final Map<SensorPixel, T> mapping;

    public SensorMapping(String sensorName) {
        this(sensorName, RUGGED);
    }

    public SensorMapping(String sensorName, String ruggedName) {
        this.sensorName = sensorName;
        this.ruggedName = ruggedName;
        this.mapping = new LinkedHashMap<SensorPixel, T>();
    }

    public String getSensorName() {
        return this.sensorName;
    }

    public String getRuggedName() {
        return this.ruggedName;
    }

    public void addMapping(SensorPixel pixel, T point) {
        this.mapping.put(pixel, point);
    }

    public Set<Map.Entry<SensorPixel, T>> getMapping() {
        return Collections.unmodifiableSet(this.mapping.entrySet());
    }
}

