/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.rugged.adjustment.measurements;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.orekit.rugged.adjustment.measurements.SensorToGroundMapping;
import org.orekit.rugged.adjustment.measurements.SensorToSensorMapping;

public class Observables {
    private static final String RUGGED_SENSOR_SEPARATOR = "_";
    private static final String SENSORS_SEPARATOR = "__";
    private final Map<String, SensorToGroundMapping> groundMappings = new LinkedHashMap<String, SensorToGroundMapping>();
    private final Map<String, SensorToSensorMapping> interMappings = new LinkedHashMap<String, SensorToSensorMapping>();
    private final int nbModels;

    public Observables(int nbModels) {
        this.nbModels = nbModels;
    }

    public void addInterMapping(SensorToSensorMapping interMapping) {
        this.interMappings.put(this.createKey(interMapping), interMapping);
    }

    public void addGroundMapping(SensorToGroundMapping groundMapping) {
        this.groundMappings.put(this.createKey(groundMapping), groundMapping);
    }

    public Collection<SensorToGroundMapping> getGroundMappings() {
        return this.groundMappings.values();
    }

    public SensorToGroundMapping getGroundMapping(String ruggedName, String sensorName) {
        SensorToGroundMapping mapping = this.groundMappings.get(ruggedName + RUGGED_SENSOR_SEPARATOR + sensorName);
        return mapping;
    }

    public Collection<SensorToSensorMapping> getInterMappings() {
        return this.interMappings.values();
    }

    public int getNbModels() {
        return this.nbModels;
    }

    public SensorToSensorMapping getInterMapping(String ruggedNameA, String sensorNameA, String ruggedNameB, String sensorNameB) {
        String keyA = ruggedNameA + RUGGED_SENSOR_SEPARATOR + sensorNameA;
        String keyB = ruggedNameB + RUGGED_SENSOR_SEPARATOR + sensorNameB;
        SensorToSensorMapping mapping = this.interMappings.get(keyA + SENSORS_SEPARATOR + keyB);
        return mapping;
    }

    private String createKey(SensorToGroundMapping groundMapping) {
        String key = groundMapping.getRuggedName() + RUGGED_SENSOR_SEPARATOR + groundMapping.getSensorName();
        return key;
    }

    private String createKey(SensorToSensorMapping sensorMapping) {
        String keyA = sensorMapping.getRuggedNameA() + RUGGED_SENSOR_SEPARATOR + sensorMapping.getSensorNameA();
        String keyB = sensorMapping.getRuggedNameB() + RUGGED_SENSOR_SEPARATOR + sensorMapping.getSensorNameB();
        return keyA + SENSORS_SEPARATOR + keyB;
    }
}

