/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.rugged.adjustment;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.hipparchus.optim.nonlinear.vector.leastsquares.LeastSquaresOptimizer;
import org.hipparchus.optim.nonlinear.vector.leastsquares.LeastSquaresProblem;
import org.orekit.rugged.adjustment.GroundOptimizationProblemBuilder;
import org.orekit.rugged.adjustment.InterSensorsOptimizationProblemBuilder;
import org.orekit.rugged.adjustment.LeastSquareAdjuster;
import org.orekit.rugged.adjustment.OptimizerId;
import org.orekit.rugged.adjustment.measurements.Observables;
import org.orekit.rugged.api.Rugged;
import org.orekit.rugged.errors.RuggedException;
import org.orekit.rugged.errors.RuggedMessages;
import org.orekit.rugged.linesensor.LineSensor;

public class AdjustmentContext {
    private final Map<String, Rugged> viewingModel = new HashMap<String, Rugged>();
    private final Observables measurements;
    private OptimizerId optimizerID;

    public AdjustmentContext(Collection<Rugged> viewingModel, Observables measurements) {
        for (Rugged r : viewingModel) {
            this.viewingModel.put(r.getName(), r);
        }
        this.measurements = measurements;
        this.optimizerID = OptimizerId.GAUSS_NEWTON_QR;
    }

    public void setOptimizer(OptimizerId optimizerId) {
        this.optimizerID = optimizerId;
    }

    public LeastSquaresOptimizer.Optimum estimateFreeParameters(Collection<String> ruggedNameList, int maxEvaluations, double parametersConvergenceThreshold) {
        Rugged rugged;
        ArrayList<Rugged> ruggedList = new ArrayList<Rugged>();
        ArrayList<LineSensor> selectedSensors = new ArrayList<LineSensor>();
        for (String ruggedName : ruggedNameList) {
            rugged = this.viewingModel.get(ruggedName);
            if (rugged == null) {
                throw new RuggedException(RuggedMessages.INVALID_RUGGED_NAME, new Object[0]);
            }
            ruggedList.add(rugged);
            selectedSensors.addAll(rugged.getLineSensors());
        }
        LeastSquareAdjuster adjuster = new LeastSquareAdjuster(this.optimizerID);
        LeastSquaresProblem theProblem = null;
        switch (ruggedList.size()) {
            case 1: {
                rugged = (Rugged)ruggedList.get(0);
                GroundOptimizationProblemBuilder groundOptimizationProblem = new GroundOptimizationProblemBuilder(selectedSensors, this.measurements, rugged);
                theProblem = groundOptimizationProblem.build(maxEvaluations, parametersConvergenceThreshold);
                break;
            }
            case 2: {
                InterSensorsOptimizationProblemBuilder interSensorsOptimizationProblem = new InterSensorsOptimizationProblemBuilder(selectedSensors, this.measurements, ruggedList);
                theProblem = interSensorsOptimizationProblem.build(maxEvaluations, parametersConvergenceThreshold);
                break;
            }
            default: {
                throw new RuggedException(RuggedMessages.UNSUPPORTED_REFINING_CONTEXT, ruggedList.size());
            }
        }
        return adjuster.optimize(theProblem);
    }
}

