/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.utils.units;

import java.io.Serializable;
import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.exception.Localizable;
import org.hipparchus.fraction.Fraction;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.Precision;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.utils.units.Parser;
import org.orekit.utils.units.PowerTerm;
import org.orekit.utils.units.PrefixedUnit;

public class Unit
implements Serializable {
    public static final Unit NONE = new Unit("n/a", 1.0, Fraction.ZERO, Fraction.ZERO, Fraction.ZERO, Fraction.ZERO, Fraction.ZERO);
    public static final Unit ONE = new Unit("1", 1.0, Fraction.ZERO, Fraction.ZERO, Fraction.ZERO, Fraction.ZERO, Fraction.ZERO);
    public static final Unit PERCENT = new Unit("%", 0.01, Fraction.ZERO, Fraction.ZERO, Fraction.ZERO, Fraction.ZERO, Fraction.ZERO);
    public static final Unit SECOND = new Unit("s", 1.0, Fraction.ZERO, Fraction.ZERO, Fraction.ONE, Fraction.ZERO, Fraction.ZERO);
    public static final Unit MINUTE = SECOND.scale("min", 60.0);
    public static final Unit HOUR = MINUTE.scale("h", 60.0);
    public static final Unit DAY = HOUR.scale("d", 24.0);
    public static final Unit YEAR = DAY.scale("a", 365.25);
    public static final Unit HERTZ = SECOND.power("Hz", Fraction.MINUS_ONE);
    public static final Unit METRE = new Unit("m", 1.0, Fraction.ZERO, Fraction.ONE, Fraction.ZERO, Fraction.ZERO, Fraction.ZERO);
    public static final Unit KILOMETRE = METRE.scale("km", 1000.0);
    public static final Unit KILOGRAM = new Unit("kg", 1.0, Fraction.ONE, Fraction.ZERO, Fraction.ZERO, Fraction.ZERO, Fraction.ZERO);
    public static final Unit GRAM = KILOGRAM.scale("g", 0.001);
    public static final Unit AMPERE = new Unit("A", 1.0, Fraction.ZERO, Fraction.ZERO, Fraction.ZERO, Fraction.ONE, Fraction.ZERO);
    public static final Unit RADIAN = new Unit("rad", 1.0, Fraction.ZERO, Fraction.ZERO, Fraction.ZERO, Fraction.ZERO, Fraction.ONE);
    public static final Unit DEGREE = RADIAN.scale("\u00b0", FastMath.toRadians((double)1.0));
    public static final Unit ARC_MINUTE = DEGREE.scale("\u2032", 0.016666666666666666);
    public static final Unit ARC_SECOND = ARC_MINUTE.scale("\u2033", 0.016666666666666666);
    public static final Unit REVOLUTION = RADIAN.scale("rev", Math.PI * 2);
    public static final Unit NEWTON = KILOGRAM.multiply(null, METRE).divide("N", SECOND.power(null, Fraction.TWO));
    public static final Unit PASCAL = NEWTON.divide("Pa", METRE.power(null, Fraction.TWO));
    public static final Unit BAR = PASCAL.scale("bar", 100000.0);
    public static final Unit JOULE = NEWTON.multiply("J", METRE);
    public static final Unit WATT = JOULE.divide("W", SECOND);
    public static final Unit COULOMB = SECOND.multiply("C", AMPERE);
    public static final Unit VOLT = WATT.divide("V", AMPERE);
    public static final Unit OHM = VOLT.divide("\u03a9", AMPERE);
    public static final Unit TESLA = VOLT.multiply(null, SECOND).divide("T", METRE.power(null, Fraction.TWO));
    public static final Unit SOLAR_FLUX_UNIT = WATT.divide(null, METRE.power(null, Fraction.TWO).multiply(null, HERTZ)).scale("SFU", 1.0E-22);
    public static final Unit TOTAL_ELECTRON_CONTENT_UNIT = METRE.power(null, new Fraction(-2)).scale("TECU", 1.0E16);
    public static final Unit EARTH_RADII = new Unit("ER", 1.0, Fraction.ZERO, Fraction.ZERO, Fraction.ZERO, Fraction.ONE, Fraction.ZERO);
    private static final long serialVersionUID = 20210402L;
    private final String name;
    private final double scale;
    private final Fraction mass;
    private final Fraction length;
    private final Fraction time;
    private final Fraction current;
    private final Fraction angle;

    public Unit(String name, double scale, Fraction mass, Fraction length, Fraction time, Fraction current, Fraction angle) {
        this.name = name;
        this.scale = scale;
        this.mass = mass;
        this.length = length;
        this.time = time;
        this.current = current;
        this.angle = angle;
    }

    public String getName() {
        return this.name;
    }

    public double getScale() {
        return this.scale;
    }

    public Fraction getMass() {
        return this.mass;
    }

    public Fraction getLength() {
        return this.length;
    }

    public Fraction getTime() {
        return this.time;
    }

    public Fraction getCurrent() {
        return this.current;
    }

    public Fraction getAngle() {
        return this.angle;
    }

    public boolean sameDimension(Unit other) {
        return this.time.equals((Object)other.time) && this.length.equals((Object)other.length) && this.mass.equals((Object)other.mass) && this.current.equals((Object)other.current) && this.angle.equals((Object)other.angle);
    }

    public Unit sameDimensionSI() {
        StringBuilder builder = new StringBuilder();
        this.append(builder, Unit.KILOGRAM.name, this.mass);
        this.append(builder, Unit.METRE.name, this.length);
        this.append(builder, Unit.SECOND.name, this.time);
        this.append(builder, Unit.AMPERE.name, this.current);
        this.append(builder, Unit.RADIAN.name, this.angle);
        if (builder.length() == 0) {
            builder.append('1');
        }
        return new Unit(builder.toString(), 1.0, this.mass, this.length, this.time, this.current, this.angle);
    }

    public static void ensureCompatible(String description, List<Unit> reference, boolean allowScaleDifferences, List<Unit> units) {
        if (units.size() != reference.size()) {
            throw new OrekitException((Localizable)OrekitMessages.WRONG_NB_COMPONENTS, description, reference.size(), units.size());
        }
        for (int i = 0; i < reference.size(); ++i) {
            if (!reference.get(i).sameDimension(units.get(i))) {
                throw new OrekitException((Localizable)OrekitMessages.INCOMPATIBLE_UNITS, reference.get(i).getName(), units.get(i).getName());
            }
            if (allowScaleDifferences || Precision.equals((double)reference.get(i).getScale(), (double)units.get(i).getScale(), (int)1)) continue;
            throw new OrekitException((Localizable)OrekitMessages.INCOMPATIBLE_UNITS, reference.get(i).getName(), units.get(i).getName());
        }
    }

    private void append(StringBuilder builder, String dim, Fraction exp) {
        if (!exp.isZero()) {
            if (builder.length() > 0) {
                builder.append('.');
            }
            builder.append(dim);
            if (exp.getDenominator() == 1) {
                if (exp.getNumerator() != 1) {
                    builder.append(Integer.toString(exp.getNumerator()).replace('-', '\u207b').replace('0', '\u2070').replace('1', '\u00b9').replace('2', '\u00b2').replace('3', '\u00b3').replace('4', '\u2074').replace('5', '\u2075').replace('6', '\u2076').replace('7', '\u2077').replace('8', '\u2078').replace('9', '\u2079'));
                }
            } else {
                builder.append("^(").append(exp.getNumerator()).append('/').append(exp.getDenominator()).append(')');
            }
        }
    }

    public Unit alias(String newName) {
        return new Unit(newName, this.scale, this.mass, this.length, this.time, this.current, this.angle);
    }

    public Unit scale(String newName, double factor) {
        return new Unit(newName, factor * this.scale, this.mass, this.length, this.time, this.current, this.angle);
    }

    public Unit power(String newName, Fraction exponent) {
        double s;
        int num = exponent.getNumerator();
        int den = exponent.getDenominator();
        double d = s = num == 1 ? this.scale : FastMath.pow((double)this.scale, (int)num);
        if (den > 1) {
            s = den == 2 ? FastMath.sqrt((double)s) : (den == 3 ? FastMath.cbrt((double)s) : FastMath.pow((double)s, (double)(1.0 / (double)den)));
        }
        return new Unit(newName, s, this.mass.multiply(exponent), this.length.multiply(exponent), this.time.multiply(exponent), this.current.multiply(this.current), this.angle.multiply(exponent));
    }

    public Unit sqrt(String newName) {
        return new Unit(newName, FastMath.sqrt((double)this.scale), this.mass.divide(2), this.length.divide(2), this.time.divide(2), this.current.divide(2), this.angle.divide(2));
    }

    public Unit multiply(String newName, Unit other) {
        return new Unit(newName, this.scale * other.scale, this.mass.add(other.mass), this.length.add(other.length), this.time.add(other.time), this.current.add(other.current), this.angle.add(other.angle));
    }

    public Unit divide(String newName, Unit other) {
        return new Unit(newName, this.scale / other.scale, this.mass.subtract(other.mass), this.length.subtract(other.length), this.time.subtract(other.time), this.current.subtract(other.current), this.angle.subtract(other.angle));
    }

    public double toSI(double value) {
        return value * this.scale;
    }

    public double toSI(Double value) {
        return value == null ? Double.NaN : value * this.scale;
    }

    public <T extends CalculusFieldElement<T>> T toSI(T value) {
        return (T)((CalculusFieldElement)value.multiply(this.scale));
    }

    public double fromSI(double value) {
        return value / this.scale;
    }

    public double fromSI(Double value) {
        return value == null ? Double.NaN : value / this.scale;
    }

    public <T extends CalculusFieldElement<T>> T fromSI(T value) {
        return (T)((CalculusFieldElement)value.divide(this.scale));
    }

    public static Unit parse(String unitSpecification) {
        List<PowerTerm> terms = Parser.buildTermsList(unitSpecification);
        if (terms == null) {
            return NONE;
        }
        Unit unit = ONE;
        for (PowerTerm term : terms) {
            try {
                Unit u = PrefixedUnit.valueOf(term.getBase().toString());
                if (!Fraction.ONE.equals((Object)term.getExponent())) {
                    u = u.power(null, term.getExponent());
                }
                u = u.scale(null, term.getScale());
                unit = unit.multiply(null, u);
            }
            catch (IllegalArgumentException iae) {
                throw new OrekitException((Localizable)OrekitMessages.UNKNOWN_UNIT, term.getBase());
            }
        }
        return unit.alias(unitSpecification);
    }

    public boolean equals(Object unit) {
        if (unit == this) {
            return true;
        }
        if (unit instanceof Unit) {
            Unit u = (Unit)unit;
            return Precision.equals((double)this.scale, (double)u.scale, (int)1) && this.mass.equals((Object)u.mass) && this.length.equals((Object)u.length) && this.time.equals((Object)u.time) && this.current.equals((Object)u.current) && this.angle.equals((Object)u.angle);
        }
        return false;
    }

    public int hashCode() {
        return 0x67E7 ^ Double.hashCode(this.scale) << 12 ^ this.mass.hashCode() << 10 ^ this.length.hashCode() << 8 ^ this.time.hashCode() << 6 ^ this.current.hashCode() << 4 ^ this.angle.hashCode() << 2;
    }

    public String toString() {
        return this.getName();
    }
}

