/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.utils;

import java.util.Map;
import java.util.TreeMap;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.geometry.spherical.twod.Circle;
import org.hipparchus.geometry.spherical.twod.S2Point;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.bodies.LoxodromeArc;
import org.orekit.bodies.OneAxisEllipsoid;
import org.orekit.frames.Frame;
import org.orekit.frames.TopocentricFrame;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.AggregatedPVCoordinatesProvider;
import org.orekit.utils.ConstantPVCoordinatesProvider;
import org.orekit.utils.PVCoordinatesProvider;
import org.orekit.utils.TimeStampedPVCoordinates;

public class WaypointPVBuilder {
    private final InterpolationFactory factory;
    private final OneAxisEllipsoid body;
    private final TreeMap<AbsoluteDate, GeodeticPoint> waypoints;
    private boolean invalidBefore;
    private boolean invalidAfter;

    public WaypointPVBuilder(InterpolationFactory factory, OneAxisEllipsoid body) {
        this.factory = factory;
        this.body = body;
        this.waypoints = new TreeMap();
        this.invalidBefore = true;
        this.invalidAfter = true;
    }

    public static WaypointPVBuilder cartesianBuilder(OneAxisEllipsoid body) {
        return new WaypointPVBuilder(CartesianWaypointPVProv::new, body);
    }

    public static WaypointPVBuilder loxodromeBuilder(OneAxisEllipsoid body) {
        return new WaypointPVBuilder(LoxodromeWaypointPVProv::new, body);
    }

    public static WaypointPVBuilder greatCircleBuilder(OneAxisEllipsoid body) {
        return new WaypointPVBuilder(GreatCircleWaypointPVProv::new, body);
    }

    public WaypointPVBuilder addWaypoint(GeodeticPoint point, AbsoluteDate date) {
        this.waypoints.put(date, point);
        return this;
    }

    public WaypointPVBuilder invalidBefore() {
        this.invalidBefore = true;
        return this;
    }

    public WaypointPVBuilder constantBefore() {
        this.invalidBefore = false;
        return this;
    }

    public WaypointPVBuilder invalidAfter() {
        this.invalidAfter = true;
        return this;
    }

    public WaypointPVBuilder constantAfter() {
        this.invalidAfter = false;
        return this;
    }

    public PVCoordinatesProvider build() {
        PVCoordinatesProvider initialProvider = this.createInitial(this.waypoints.firstKey(), this.waypoints.firstEntry().getValue());
        AggregatedPVCoordinatesProvider.Builder builder = new AggregatedPVCoordinatesProvider.Builder(initialProvider);
        Map.Entry<AbsoluteDate, GeodeticPoint> previousEntry = null;
        for (Map.Entry<AbsoluteDate, GeodeticPoint> entry : this.waypoints.entrySet()) {
            if (previousEntry != null) {
                builder.addPVProviderAfter(previousEntry.getKey(), this.factory.create(previousEntry.getKey(), previousEntry.getValue(), entry.getKey(), entry.getValue(), this.body), true);
            }
            previousEntry = entry;
        }
        builder.addPVProviderAfter((AbsoluteDate)previousEntry.getKey(), new ConstantPVCoordinatesProvider(previousEntry.getValue(), this.body), true);
        builder.addPVProviderAfter(previousEntry.getKey().shiftedBy(Double.MIN_VALUE), this.createFinal(previousEntry.getKey(), previousEntry.getValue()), true);
        return builder.build();
    }

    protected PVCoordinatesProvider createInitial(AbsoluteDate firstDate, GeodeticPoint firstPoint) {
        if (this.invalidBefore) {
            return new AggregatedPVCoordinatesProvider.InvalidPVProvider();
        }
        return new ConstantPVCoordinatesProvider(firstPoint, this.body);
    }

    protected PVCoordinatesProvider createFinal(AbsoluteDate lastDate, GeodeticPoint lastPoint) {
        if (this.invalidAfter) {
            return new AggregatedPVCoordinatesProvider.InvalidPVProvider();
        }
        return new ConstantPVCoordinatesProvider(lastPoint, this.body);
    }

    static class CartesianWaypointPVProv
    implements PVCoordinatesProvider {
        private final AbsoluteDate t0;
        private final Vector3D p0;
        private final Vector3D vel;
        private final Frame sourceFrame;

        CartesianWaypointPVProv(AbsoluteDate date1, GeodeticPoint point1, AbsoluteDate date2, GeodeticPoint point2, OneAxisEllipsoid body) {
            this.t0 = date1;
            this.p0 = body.transform(point1);
            this.vel = body.transform(point2).subtract((Vector)this.p0).scalarMultiply(1.0 / date2.durationFrom(this.t0));
            this.sourceFrame = body.getBodyFrame();
        }

        @Override
        public Vector3D getPosition(AbsoluteDate date, Frame frame) {
            double d = date.durationFrom(this.t0);
            Vector3D p = this.p0.add((Vector)this.vel.scalarMultiply(d));
            return this.sourceFrame.getStaticTransformTo(frame, date).transformPosition(p);
        }

        @Override
        public TimeStampedPVCoordinates getPVCoordinates(AbsoluteDate date, Frame frame) {
            double d = date.durationFrom(this.t0);
            Vector3D p = this.p0.add((Vector)this.vel.scalarMultiply(d));
            TimeStampedPVCoordinates pv = new TimeStampedPVCoordinates(date, p, this.vel);
            return this.sourceFrame.getTransformTo(frame, date).transformPVCoordinates(pv);
        }
    }

    static class LoxodromeWaypointPVProv
    implements PVCoordinatesProvider {
        private final LoxodromeArc arc;
        private final AbsoluteDate t0;
        private final double duration;
        private final double velocity;

        LoxodromeWaypointPVProv(AbsoluteDate date1, GeodeticPoint point1, AbsoluteDate date2, GeodeticPoint point2, OneAxisEllipsoid body) {
            this.arc = new LoxodromeArc(point1, point2, body);
            this.t0 = date1;
            this.duration = date2.durationFrom(date1);
            this.velocity = this.arc.getDistance() / this.duration;
        }

        @Override
        public Vector3D getPosition(AbsoluteDate date, Frame frame) {
            double fraction = date.durationFrom(this.t0) / this.duration;
            GeodeticPoint point = this.arc.calculatePointAlongArc(fraction);
            Vector3D p = this.arc.getBody().transform(point);
            return this.arc.getBody().getBodyFrame().getStaticTransformTo(frame, date).transformPosition(p);
        }

        @Override
        public TimeStampedPVCoordinates getPVCoordinates(AbsoluteDate date, Frame frame) {
            double fraction = date.durationFrom(this.t0) / this.duration;
            GeodeticPoint point = this.arc.calculatePointAlongArc(fraction);
            Vector3D p = this.arc.getBody().transform(point);
            Vector3D vp = this.arc.getBody().transform(new TopocentricFrame(this.arc.getBody(), point, "frame").pointAtDistance(this.arc.getAzimuth(), 0.0, this.velocity));
            TimeStampedPVCoordinates tpv = new TimeStampedPVCoordinates(date, p, vp.subtract((Vector)p));
            return this.arc.getBody().getBodyFrame().getTransformTo(frame, date).transformPVCoordinates(tpv);
        }
    }

    static class GreatCircleWaypointPVProv
    implements PVCoordinatesProvider {
        private final Circle circle;
        private final double duration;
        private final double phase0;
        private final double phaseLength;
        private final AbsoluteDate t0;
        private final OneAxisEllipsoid body;
        private double oneSecondPhase;
        private double initialAltitude;
        private double altitudeSlope;

        GreatCircleWaypointPVProv(AbsoluteDate date1, GeodeticPoint point1, AbsoluteDate date2, GeodeticPoint point2, OneAxisEllipsoid body) {
            this.t0 = date1;
            this.duration = date2.durationFrom(date1);
            this.body = body;
            S2Point s0 = GreatCircleWaypointPVProv.toSpherical(point1);
            S2Point s1 = GreatCircleWaypointPVProv.toSpherical(point2);
            this.circle = new Circle(s0, s1, 1.0E-9);
            this.phase0 = this.circle.getPhase(s0.getVector());
            this.phaseLength = this.circle.getPhase(s1.getVector()) - this.phase0;
            this.oneSecondPhase = this.phaseLength / this.duration;
            this.altitudeSlope = (point2.getAltitude() - point1.getAltitude()) / this.duration;
            this.initialAltitude = point1.getAltitude();
        }

        @Override
        public Vector3D getPosition(AbsoluteDate date, Frame frame) {
            double d = date.durationFrom(this.t0);
            double fraction = d / this.duration;
            double phase = fraction * this.phaseLength;
            S2Point sp = new S2Point(this.circle.getPointAt(this.phase0 + phase));
            GeodeticPoint point = GreatCircleWaypointPVProv.toGeodetic(sp, this.initialAltitude + d * this.altitudeSlope);
            Vector3D p = this.body.transform(point);
            return this.body.getBodyFrame().getStaticTransformTo(frame, date).transformPosition(p);
        }

        @Override
        public TimeStampedPVCoordinates getPVCoordinates(AbsoluteDate date, Frame frame) {
            double d = date.durationFrom(this.t0);
            double fraction = d / this.duration;
            double phase = fraction * this.phaseLength;
            S2Point sp = new S2Point(this.circle.getPointAt(this.phase0 + phase));
            GeodeticPoint point = GreatCircleWaypointPVProv.toGeodetic(sp, this.initialAltitude + d * this.altitudeSlope);
            Vector3D p = this.body.transform(point);
            S2Point sp2 = new S2Point(this.circle.getPointAt(this.phase0 + phase + this.oneSecondPhase));
            GeodeticPoint point2 = GreatCircleWaypointPVProv.toGeodetic(sp2, this.initialAltitude + (d + 1.0) * this.altitudeSlope);
            Vector3D p2 = this.body.transform(point2);
            Vector3D v = p2.subtract((Vector)p);
            TimeStampedPVCoordinates tpv = new TimeStampedPVCoordinates(date, p, v);
            return this.body.getBodyFrame().getTransformTo(frame, date).transformPVCoordinates(tpv);
        }

        static S2Point toSpherical(GeodeticPoint point) {
            return new S2Point(point.getLongitude(), 1.5707963267948966 - point.getLatitude());
        }

        static GeodeticPoint toGeodetic(S2Point point, double alt) {
            return new GeodeticPoint(1.5707963267948966 - point.getPhi(), point.getTheta(), alt);
        }
    }

    @FunctionalInterface
    public static interface InterpolationFactory {
        public PVCoordinatesProvider create(AbsoluteDate var1, GeodeticPoint var2, AbsoluteDate var3, GeodeticPoint var4, OneAxisEllipsoid var5);
    }
}

