/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.utils;

import java.util.stream.Stream;
import org.hipparchus.analysis.interpolation.HermiteInterpolator;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.errors.OrekitInternalError;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.AbstractTimeInterpolator;
import org.orekit.utils.CartesianDerivativesFilter;
import org.orekit.utils.TimeStampedPVCoordinates;

public class TimeStampedPVCoordinatesHermiteInterpolator
extends AbstractTimeInterpolator<TimeStampedPVCoordinates> {
    private final CartesianDerivativesFilter filter;

    public TimeStampedPVCoordinatesHermiteInterpolator() {
        this(2);
    }

    public TimeStampedPVCoordinatesHermiteInterpolator(int interpolationPoints) {
        this(interpolationPoints, CartesianDerivativesFilter.USE_PVA);
    }

    public TimeStampedPVCoordinatesHermiteInterpolator(int interpolationPoints, CartesianDerivativesFilter filter) {
        this(interpolationPoints, 0.001, filter);
    }

    public TimeStampedPVCoordinatesHermiteInterpolator(int interpolationPoints, double extrapolationThreshold, CartesianDerivativesFilter filter) {
        super(interpolationPoints, extrapolationThreshold);
        this.filter = filter;
    }

    public CartesianDerivativesFilter getFilter() {
        return this.filter;
    }

    @Override
    protected TimeStampedPVCoordinates interpolate(AbstractTimeInterpolator.InterpolationData interpolationData) {
        AbsoluteDate date = interpolationData.getInterpolationDate();
        Stream sample = interpolationData.getNeighborList().stream();
        HermiteInterpolator interpolator = new HermiteInterpolator();
        switch (this.filter) {
            case USE_P: {
                sample.forEach(pv -> {
                    Vector3D position = pv.getPosition();
                    interpolator.addSamplePoint(pv.getDate().durationFrom(date), (double[][])new double[][]{position.toArray()});
                });
                break;
            }
            case USE_PV: {
                sample.forEach(pv -> {
                    Vector3D position = pv.getPosition();
                    Vector3D velocity = pv.getVelocity();
                    interpolator.addSamplePoint(pv.getDate().durationFrom(date), (double[][])new double[][]{position.toArray(), velocity.toArray()});
                });
                break;
            }
            case USE_PVA: {
                sample.forEach(pv -> {
                    Vector3D position = pv.getPosition();
                    Vector3D velocity = pv.getVelocity();
                    Vector3D acceleration = pv.getAcceleration();
                    interpolator.addSamplePoint(pv.getDate().durationFrom(date), (double[][])new double[][]{position.toArray(), velocity.toArray(), acceleration.toArray()});
                });
                break;
            }
            default: {
                throw new OrekitInternalError(null);
            }
        }
        double[][] pva = interpolator.derivatives(0.0, 2);
        return new TimeStampedPVCoordinates(date, new Vector3D(pva[0]), new Vector3D(pva[1]), new Vector3D(pva[2]));
    }
}

