/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.utils;

import java.io.Serializable;
import org.hipparchus.analysis.differentiation.Derivative;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.data.DataContext;
import org.orekit.frames.Frame;
import org.orekit.frames.StaticTransform;
import org.orekit.frames.Transform;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeScale;
import org.orekit.time.TimeStamped;
import org.orekit.utils.PVCoordinates;
import org.orekit.utils.PVCoordinatesProvider;

public class TimeStampedPVCoordinates
extends PVCoordinates
implements TimeStamped {
    private static final long serialVersionUID = 20140723L;
    private final AbsoluteDate date;

    public TimeStampedPVCoordinates(AbsoluteDate date, Vector3D position, Vector3D velocity, Vector3D acceleration) {
        super(position, velocity, acceleration);
        this.date = date;
    }

    public TimeStampedPVCoordinates(AbsoluteDate date, Vector3D position, Vector3D velocity) {
        this(date, position, velocity, Vector3D.ZERO);
    }

    public TimeStampedPVCoordinates(AbsoluteDate date, PVCoordinates pv) {
        this(date, pv.getPosition(), pv.getVelocity(), pv.getAcceleration());
    }

    public TimeStampedPVCoordinates(AbsoluteDate date, double a, PVCoordinates pv) {
        super(new Vector3D(a, pv.getPosition()), new Vector3D(a, pv.getVelocity()), new Vector3D(a, pv.getAcceleration()));
        this.date = date;
    }

    public TimeStampedPVCoordinates(AbsoluteDate date, PVCoordinates start, PVCoordinates end) {
        super(end.getPosition().subtract((Vector)start.getPosition()), end.getVelocity().subtract((Vector)start.getVelocity()), end.getAcceleration().subtract((Vector)start.getAcceleration()));
        this.date = date;
    }

    public TimeStampedPVCoordinates(AbsoluteDate date, double a1, PVCoordinates pv1, double a2, PVCoordinates pv2) {
        super(new Vector3D(a1, pv1.getPosition(), a2, pv2.getPosition()), new Vector3D(a1, pv1.getVelocity(), a2, pv2.getVelocity()), new Vector3D(a1, pv1.getAcceleration(), a2, pv2.getAcceleration()));
        this.date = date;
    }

    public TimeStampedPVCoordinates(AbsoluteDate date, double a1, PVCoordinates pv1, double a2, PVCoordinates pv2, double a3, PVCoordinates pv3) {
        super(new Vector3D(a1, pv1.getPosition(), a2, pv2.getPosition(), a3, pv3.getPosition()), new Vector3D(a1, pv1.getVelocity(), a2, pv2.getVelocity(), a3, pv3.getVelocity()), new Vector3D(a1, pv1.getAcceleration(), a2, pv2.getAcceleration(), a3, pv3.getAcceleration()));
        this.date = date;
    }

    public TimeStampedPVCoordinates(AbsoluteDate date, double a1, PVCoordinates pv1, double a2, PVCoordinates pv2, double a3, PVCoordinates pv3, double a4, PVCoordinates pv4) {
        super(new Vector3D(a1, pv1.getPosition(), a2, pv2.getPosition(), a3, pv3.getPosition(), a4, pv4.getPosition()), new Vector3D(a1, pv1.getVelocity(), a2, pv2.getVelocity(), a3, pv3.getVelocity(), a4, pv4.getVelocity()), new Vector3D(a1, pv1.getAcceleration(), a2, pv2.getAcceleration(), a3, pv3.getAcceleration(), a4, pv4.getAcceleration()));
        this.date = date;
    }

    public <U extends Derivative<U>> TimeStampedPVCoordinates(AbsoluteDate date, FieldVector3D<U> p) {
        super(p);
        this.date = date;
    }

    @Override
    public AbsoluteDate getDate() {
        return this.date;
    }

    @Override
    public TimeStampedPVCoordinates shiftedBy(double dt) {
        PVCoordinates spv = super.shiftedBy(dt);
        return new TimeStampedPVCoordinates(this.date.shiftedBy(dt), spv.getPosition(), spv.getVelocity(), spv.getAcceleration());
    }

    public PVCoordinatesProvider toTaylorProvider(final Frame instanceFrame) {
        return new PVCoordinatesProvider(){

            @Override
            public Vector3D getPosition(AbsoluteDate d, Frame f) {
                TimeStampedPVCoordinates shifted = TimeStampedPVCoordinates.this.shiftedBy(d.durationFrom(TimeStampedPVCoordinates.this.getDate()));
                StaticTransform transform = instanceFrame.getStaticTransformTo(f, d);
                return transform.transformPosition(shifted.getPosition());
            }

            @Override
            public TimeStampedPVCoordinates getPVCoordinates(AbsoluteDate d, Frame f) {
                TimeStampedPVCoordinates shifted = TimeStampedPVCoordinates.this.shiftedBy(d.durationFrom(TimeStampedPVCoordinates.this.date));
                Transform transform = instanceFrame.getTransformTo(f, d);
                return transform.transformPVCoordinates(shifted);
            }
        };
    }

    @Override
    @DefaultDataContext
    public String toString() {
        return this.toString(DataContext.getDefault().getTimeScales().getUTC());
    }

    public String toString(TimeScale utc) {
        String comma = ", ";
        return '{' + this.date.toString(utc) + ", P(" + this.getPosition().getX() + ", " + this.getPosition().getY() + ", " + this.getPosition().getZ() + "), V(" + this.getVelocity().getX() + ", " + this.getVelocity().getY() + ", " + this.getVelocity().getZ() + "), A(" + this.getAcceleration().getX() + ", " + this.getAcceleration().getY() + ", " + this.getAcceleration().getZ() + ")}";
    }

    @DefaultDataContext
    private Object writeReplace() {
        return new DTO(this);
    }

    @DefaultDataContext
    private static class DTO
    implements Serializable {
        private static final long serialVersionUID = 20140723L;
        private double[] d;

        private DTO(TimeStampedPVCoordinates pv) {
            AbsoluteDate j2000Epoch = DataContext.getDefault().getTimeScales().getJ2000Epoch();
            double epoch = FastMath.floor((double)pv.getDate().durationFrom(j2000Epoch));
            double offset = pv.getDate().durationFrom(j2000Epoch.shiftedBy(epoch));
            this.d = new double[]{epoch, offset, pv.getPosition().getX(), pv.getPosition().getY(), pv.getPosition().getZ(), pv.getVelocity().getX(), pv.getVelocity().getY(), pv.getVelocity().getZ(), pv.getAcceleration().getX(), pv.getAcceleration().getY(), pv.getAcceleration().getZ()};
        }

        private Object readResolve() {
            AbsoluteDate j2000Epoch = DataContext.getDefault().getTimeScales().getJ2000Epoch();
            return new TimeStampedPVCoordinates(j2000Epoch.shiftedBy(this.d[0]).shiftedBy(this.d[1]), new Vector3D(this.d[2], this.d[3], this.d[4]), new Vector3D(this.d[5], this.d[6], this.d[7]), new Vector3D(this.d[8], this.d[9], this.d[10]));
        }
    }
}

