/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.utils;

import java.util.stream.Stream;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.FieldElement;
import org.hipparchus.analysis.interpolation.FieldHermiteInterpolator;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.orekit.errors.OrekitInternalError;
import org.orekit.time.AbstractFieldTimeInterpolator;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.CartesianDerivativesFilter;
import org.orekit.utils.TimeStampedFieldPVCoordinates;

public class TimeStampedFieldPVCoordinatesHermiteInterpolator<KK extends CalculusFieldElement<KK>>
extends AbstractFieldTimeInterpolator<TimeStampedFieldPVCoordinates<KK>, KK> {
    private final CartesianDerivativesFilter filter;

    public TimeStampedFieldPVCoordinatesHermiteInterpolator() {
        this(2);
    }

    public TimeStampedFieldPVCoordinatesHermiteInterpolator(int interpolationPoints) {
        this(interpolationPoints, CartesianDerivativesFilter.USE_PVA);
    }

    public TimeStampedFieldPVCoordinatesHermiteInterpolator(int interpolationPoints, CartesianDerivativesFilter filter) {
        this(interpolationPoints, 0.001, filter);
    }

    public TimeStampedFieldPVCoordinatesHermiteInterpolator(int interpolationPoints, double extrapolationThreshold, CartesianDerivativesFilter filter) {
        super(interpolationPoints, extrapolationThreshold);
        this.filter = filter;
    }

    public CartesianDerivativesFilter getFilter() {
        return this.filter;
    }

    @Override
    protected TimeStampedFieldPVCoordinates<KK> interpolate(AbstractFieldTimeInterpolator.InterpolationData interpolationData) {
        FieldAbsoluteDate interpolationDate = interpolationData.getInterpolationDate();
        Stream sample = interpolationData.getNeighborList().stream();
        FieldHermiteInterpolator interpolator = new FieldHermiteInterpolator();
        switch (this.filter) {
            case USE_P: {
                sample.forEach(pv -> {
                    FieldVector3D position = pv.getPosition();
                    interpolator.addSamplePoint(pv.getDate().durationFrom(interpolationDate), (FieldElement[][])new CalculusFieldElement[][]{position.toArray()});
                });
                break;
            }
            case USE_PV: {
                sample.forEach(pv -> {
                    FieldVector3D position = pv.getPosition();
                    FieldVector3D velocity = pv.getVelocity();
                    interpolator.addSamplePoint(pv.getDate().durationFrom(interpolationDate), (FieldElement[][])new CalculusFieldElement[][]{position.toArray(), velocity.toArray()});
                });
                break;
            }
            case USE_PVA: {
                sample.forEach(pv -> {
                    FieldVector3D position = pv.getPosition();
                    FieldVector3D velocity = pv.getVelocity();
                    FieldVector3D acceleration = pv.getAcceleration();
                    interpolator.addSamplePoint(pv.getDate().durationFrom(interpolationDate), (FieldElement[][])new CalculusFieldElement[][]{position.toArray(), velocity.toArray(), acceleration.toArray()});
                });
                break;
            }
            default: {
                throw new OrekitInternalError(null);
            }
        }
        CalculusFieldElement[][] pva = (CalculusFieldElement[][])interpolator.derivatives((FieldElement)((CalculusFieldElement)interpolationDate.getField().getZero()), 2);
        return new TimeStampedFieldPVCoordinates(interpolationDate, new FieldVector3D(pva[0]), new FieldVector3D(pva[1]), new FieldVector3D(pva[2]));
    }
}

