/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.utils;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.analysis.differentiation.FieldDerivative;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.FieldTimeShiftable;
import org.orekit.time.FieldTimeStamped;
import org.orekit.time.TimeScale;
import org.orekit.time.TimeShiftable;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.PVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public class TimeStampedFieldPVCoordinates<T extends CalculusFieldElement<T>>
extends FieldPVCoordinates<T>
implements FieldTimeStamped<T> {
    private final FieldAbsoluteDate<T> date;

    public TimeStampedFieldPVCoordinates(AbsoluteDate date, FieldVector3D<T> position, FieldVector3D<T> velocity, FieldVector3D<T> acceleration) {
        this(new FieldAbsoluteDate(position.getX().getField(), date), position, velocity, acceleration);
    }

    public TimeStampedFieldPVCoordinates(FieldAbsoluteDate<T> date, FieldVector3D<T> position, FieldVector3D<T> velocity, FieldVector3D<T> acceleration) {
        super(position, velocity, acceleration);
        this.date = date;
    }

    public TimeStampedFieldPVCoordinates(AbsoluteDate date, FieldPVCoordinates<T> pv) {
        this(new FieldAbsoluteDate(pv.getPosition().getX().getField(), date), pv);
    }

    public TimeStampedFieldPVCoordinates(FieldAbsoluteDate<T> date, FieldPVCoordinates<T> pv) {
        super(pv.getPosition(), pv.getVelocity(), pv.getAcceleration());
        this.date = date;
    }

    public TimeStampedFieldPVCoordinates(Field<T> field, TimeStampedPVCoordinates pv) {
        this(pv.getDate(), new FieldPVCoordinates<Field<T>>(field, (PVCoordinates)pv));
    }

    public TimeStampedFieldPVCoordinates(AbsoluteDate date, double a, FieldPVCoordinates<T> pv) {
        this((FieldAbsoluteDate<double>)new FieldAbsoluteDate(pv.getPosition().getX().getField(), date), a, (FieldPVCoordinates<double>)pv);
    }

    public TimeStampedFieldPVCoordinates(FieldAbsoluteDate<T> date, double a, FieldPVCoordinates<T> pv) {
        super(new FieldVector3D(a, pv.getPosition()), new FieldVector3D(a, pv.getVelocity()), new FieldVector3D(a, pv.getAcceleration()));
        this.date = date;
    }

    public TimeStampedFieldPVCoordinates(AbsoluteDate date, T a, FieldPVCoordinates<T> pv) {
        this(new FieldAbsoluteDate(a.getField(), date), a, pv);
    }

    public TimeStampedFieldPVCoordinates(FieldAbsoluteDate<T> date, T a, FieldPVCoordinates<T> pv) {
        super(new FieldVector3D(a, pv.getPosition()), new FieldVector3D(a, pv.getVelocity()), new FieldVector3D(a, pv.getAcceleration()));
        this.date = date;
    }

    public TimeStampedFieldPVCoordinates(AbsoluteDate date, T a, PVCoordinates pv) {
        this(new FieldAbsoluteDate(a.getField(), date), a, pv);
    }

    public TimeStampedFieldPVCoordinates(FieldAbsoluteDate<T> date, T a, PVCoordinates pv) {
        super(new FieldVector3D(a, pv.getPosition()), new FieldVector3D(a, pv.getVelocity()), new FieldVector3D(a, pv.getAcceleration()));
        this.date = date;
    }

    public TimeStampedFieldPVCoordinates(AbsoluteDate date, FieldPVCoordinates<T> start, FieldPVCoordinates<T> end) {
        this(new FieldAbsoluteDate(start.getPosition().getX().getField(), date), start, end);
    }

    public TimeStampedFieldPVCoordinates(FieldAbsoluteDate<T> date, FieldPVCoordinates<T> start, FieldPVCoordinates<T> end) {
        super(end.getPosition().subtract(start.getPosition()), end.getVelocity().subtract(start.getVelocity()), end.getAcceleration().subtract(start.getAcceleration()));
        this.date = date;
    }

    public TimeStampedFieldPVCoordinates(AbsoluteDate date, double a1, FieldPVCoordinates<T> pv1, double a2, FieldPVCoordinates<T> pv2) {
        this((FieldAbsoluteDate<double>)new FieldAbsoluteDate(pv1.getPosition().getX().getField(), date), a1, (FieldPVCoordinates<double>)pv1, a2, (FieldPVCoordinates<double>)pv2);
    }

    public TimeStampedFieldPVCoordinates(FieldAbsoluteDate<T> date, double a1, FieldPVCoordinates<T> pv1, double a2, FieldPVCoordinates<T> pv2) {
        super(new FieldVector3D(a1, pv1.getPosition(), a2, pv2.getPosition()), new FieldVector3D(a1, pv1.getVelocity(), a2, pv2.getVelocity()), new FieldVector3D(a1, pv1.getAcceleration(), a2, pv2.getAcceleration()));
        this.date = date;
    }

    public TimeStampedFieldPVCoordinates(AbsoluteDate date, T a1, FieldPVCoordinates<T> pv1, T a2, FieldPVCoordinates<T> pv2) {
        this(new FieldAbsoluteDate(a1.getField(), date), a1, pv1, a2, pv2);
    }

    public TimeStampedFieldPVCoordinates(FieldAbsoluteDate<T> date, T a1, FieldPVCoordinates<T> pv1, T a2, FieldPVCoordinates<T> pv2) {
        super(new FieldVector3D(a1, pv1.getPosition(), a2, pv2.getPosition()), new FieldVector3D(a1, pv1.getVelocity(), a2, pv2.getVelocity()), new FieldVector3D(a1, pv1.getAcceleration(), a2, pv2.getAcceleration()));
        this.date = date;
    }

    public TimeStampedFieldPVCoordinates(AbsoluteDate date, T a1, PVCoordinates pv1, T a2, PVCoordinates pv2) {
        this(new FieldAbsoluteDate(a1.getField(), date), a1, pv1, a2, pv2);
    }

    public TimeStampedFieldPVCoordinates(FieldAbsoluteDate<T> date, T a1, PVCoordinates pv1, T a2, PVCoordinates pv2) {
        super(new FieldVector3D(a1, pv1.getPosition(), a2, pv2.getPosition()), new FieldVector3D(a1, pv1.getVelocity(), a2, pv2.getVelocity()), new FieldVector3D(a1, pv1.getAcceleration(), a2, pv2.getAcceleration()));
        this.date = date;
    }

    public TimeStampedFieldPVCoordinates(AbsoluteDate date, double a1, FieldPVCoordinates<T> pv1, double a2, FieldPVCoordinates<T> pv2, double a3, FieldPVCoordinates<T> pv3) {
        this((FieldAbsoluteDate<double>)new FieldAbsoluteDate(pv1.getPosition().getX().getField(), date), a1, (FieldPVCoordinates<double>)pv1, a2, (FieldPVCoordinates<double>)pv2, a3, (FieldPVCoordinates<double>)pv3);
    }

    public TimeStampedFieldPVCoordinates(FieldAbsoluteDate<T> date, double a1, FieldPVCoordinates<T> pv1, double a2, FieldPVCoordinates<T> pv2, double a3, FieldPVCoordinates<T> pv3) {
        super(new FieldVector3D(a1, pv1.getPosition(), a2, pv2.getPosition(), a3, pv3.getPosition()), new FieldVector3D(a1, pv1.getVelocity(), a2, pv2.getVelocity(), a3, pv3.getVelocity()), new FieldVector3D(a1, pv1.getAcceleration(), a2, pv2.getAcceleration(), a3, pv3.getAcceleration()));
        this.date = date;
    }

    public TimeStampedFieldPVCoordinates(AbsoluteDate date, T a1, FieldPVCoordinates<T> pv1, T a2, FieldPVCoordinates<T> pv2, T a3, FieldPVCoordinates<T> pv3) {
        this(new FieldAbsoluteDate(a1.getField(), date), a1, pv1, a2, pv2, a3, pv3);
    }

    public TimeStampedFieldPVCoordinates(FieldAbsoluteDate<T> date, T a1, FieldPVCoordinates<T> pv1, T a2, FieldPVCoordinates<T> pv2, T a3, FieldPVCoordinates<T> pv3) {
        super(new FieldVector3D(a1, pv1.getPosition(), a2, pv2.getPosition(), a3, pv3.getPosition()), new FieldVector3D(a1, pv1.getVelocity(), a2, pv2.getVelocity(), a3, pv3.getVelocity()), new FieldVector3D(a1, pv1.getAcceleration(), a2, pv2.getAcceleration(), a3, pv3.getAcceleration()));
        this.date = date;
    }

    public TimeStampedFieldPVCoordinates(AbsoluteDate date, T a1, PVCoordinates pv1, T a2, PVCoordinates pv2, T a3, PVCoordinates pv3) {
        this(new FieldAbsoluteDate(a1.getField(), date), a1, pv1, a2, pv2, a3, pv3);
    }

    public TimeStampedFieldPVCoordinates(FieldAbsoluteDate<T> date, T a1, PVCoordinates pv1, T a2, PVCoordinates pv2, T a3, PVCoordinates pv3) {
        super(new FieldVector3D(a1, pv1.getPosition(), a2, pv2.getPosition(), a3, pv3.getPosition()), new FieldVector3D(a1, pv1.getVelocity(), a2, pv2.getVelocity(), a3, pv3.getVelocity()), new FieldVector3D(a1, pv1.getAcceleration(), a2, pv2.getAcceleration(), a3, pv3.getAcceleration()));
        this.date = date;
    }

    public TimeStampedFieldPVCoordinates(AbsoluteDate date, double a1, FieldPVCoordinates<T> pv1, double a2, FieldPVCoordinates<T> pv2, double a3, FieldPVCoordinates<T> pv3, double a4, FieldPVCoordinates<T> pv4) {
        this((FieldAbsoluteDate<double>)new FieldAbsoluteDate(pv1.getPosition().getX().getField(), date), a1, (FieldPVCoordinates<double>)pv1, a2, (FieldPVCoordinates<double>)pv2, a3, (FieldPVCoordinates<double>)pv3, a4, (FieldPVCoordinates<double>)pv4);
    }

    public TimeStampedFieldPVCoordinates(FieldAbsoluteDate<T> date, double a1, FieldPVCoordinates<T> pv1, double a2, FieldPVCoordinates<T> pv2, double a3, FieldPVCoordinates<T> pv3, double a4, FieldPVCoordinates<T> pv4) {
        super(new FieldVector3D(a1, pv1.getPosition(), a2, pv2.getPosition(), a3, pv3.getPosition(), a4, pv4.getPosition()), new FieldVector3D(a1, pv1.getVelocity(), a2, pv2.getVelocity(), a3, pv3.getVelocity(), a4, pv4.getVelocity()), new FieldVector3D(a1, pv1.getAcceleration(), a2, pv2.getAcceleration(), a3, pv3.getAcceleration(), a4, pv4.getAcceleration()));
        this.date = date;
    }

    public TimeStampedFieldPVCoordinates(AbsoluteDate date, T a1, FieldPVCoordinates<T> pv1, T a2, FieldPVCoordinates<T> pv2, T a3, FieldPVCoordinates<T> pv3, T a4, FieldPVCoordinates<T> pv4) {
        this(new FieldAbsoluteDate(a1.getField(), date), a1, pv1, a2, pv2, a3, pv3, a4, pv4);
    }

    public TimeStampedFieldPVCoordinates(FieldAbsoluteDate<T> date, T a1, FieldPVCoordinates<T> pv1, T a2, FieldPVCoordinates<T> pv2, T a3, FieldPVCoordinates<T> pv3, T a4, FieldPVCoordinates<T> pv4) {
        super(new FieldVector3D(a1, pv1.getPosition(), a2, pv2.getPosition(), a3, pv3.getPosition(), a4, pv4.getPosition()), new FieldVector3D(a1, pv1.getVelocity(), a2, pv2.getVelocity(), a3, pv3.getVelocity(), a4, pv4.getVelocity()), new FieldVector3D(a1, pv1.getAcceleration(), a2, pv2.getAcceleration(), a3, pv3.getAcceleration(), a4, pv4.getAcceleration()));
        this.date = date;
    }

    public TimeStampedFieldPVCoordinates(AbsoluteDate date, T a1, PVCoordinates pv1, T a2, PVCoordinates pv2, T a3, PVCoordinates pv3, T a4, PVCoordinates pv4) {
        this(new FieldAbsoluteDate(a1.getField(), date), a1, pv1, a2, pv2, a3, pv3, a4, pv4);
    }

    public TimeStampedFieldPVCoordinates(FieldAbsoluteDate<T> date, T a1, PVCoordinates pv1, T a2, PVCoordinates pv2, T a3, PVCoordinates pv3, T a4, PVCoordinates pv4) {
        super(new FieldVector3D(a1, pv1.getPosition(), a2, pv2.getPosition(), a3, pv3.getPosition(), a4, pv4.getPosition()), new FieldVector3D(a1, pv1.getVelocity(), a2, pv2.getVelocity(), a3, pv3.getVelocity(), a4, pv4.getVelocity()), new FieldVector3D(a1, pv1.getAcceleration(), a2, pv2.getAcceleration(), a3, pv3.getAcceleration(), a4, pv4.getAcceleration()));
        this.date = date;
    }

    public <U extends FieldDerivative<T, U>> TimeStampedFieldPVCoordinates(FieldAbsoluteDate<T> date, FieldVector3D<U> p) {
        super(p);
        this.date = date;
    }

    @Override
    public FieldAbsoluteDate<T> getDate() {
        return this.date;
    }

    @Override
    public TimeStampedFieldPVCoordinates<T> shiftedBy(double dt) {
        TimeShiftable spv = super.shiftedBy(dt);
        return new TimeStampedFieldPVCoordinates(this.date.shiftedBy(dt), ((FieldPVCoordinates)spv).getPosition(), ((FieldPVCoordinates)spv).getVelocity(), ((FieldPVCoordinates)spv).getAcceleration());
    }

    @Override
    public TimeStampedFieldPVCoordinates<T> shiftedBy(T dt) {
        FieldTimeShiftable spv = super.shiftedBy((CalculusFieldElement)dt);
        return new TimeStampedFieldPVCoordinates(this.date.shiftedBy((CalculusFieldElement)dt), ((FieldPVCoordinates)spv).getPosition(), ((FieldPVCoordinates)spv).getVelocity(), ((FieldPVCoordinates)spv).getAcceleration());
    }

    public TimeStampedPVCoordinates toTimeStampedPVCoordinates() {
        return new TimeStampedPVCoordinates(this.date.toAbsoluteDate(), this.getPosition().toVector3D(), this.getVelocity().toVector3D(), this.getAcceleration().toVector3D());
    }

    @Override
    @DefaultDataContext
    public String toString() {
        return this.toTimeStampedPVCoordinates().toString();
    }

    public String toString(TimeScale utc) {
        return this.toTimeStampedPVCoordinates().toString(utc);
    }
}

