/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.utils;

import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.analysis.interpolation.FieldHermiteInterpolator;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.RotationConvention;
import org.hipparchus.util.FastMath;
import org.orekit.errors.OrekitInternalError;
import org.orekit.time.AbstractFieldTimeInterpolator;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.AngularDerivativesFilter;
import org.orekit.utils.FieldAngularCoordinates;
import org.orekit.utils.TimeStampedFieldAngularCoordinates;

public class TimeStampedFieldAngularCoordinatesHermiteInterpolator<KK extends CalculusFieldElement<KK>>
extends AbstractFieldTimeInterpolator<TimeStampedFieldAngularCoordinates<KK>, KK> {
    private final AngularDerivativesFilter filter;

    public TimeStampedFieldAngularCoordinatesHermiteInterpolator() {
        this(2);
    }

    public TimeStampedFieldAngularCoordinatesHermiteInterpolator(int interpolationPoints) {
        this(interpolationPoints, AngularDerivativesFilter.USE_RR);
    }

    public TimeStampedFieldAngularCoordinatesHermiteInterpolator(int interpolationPoints, AngularDerivativesFilter filter) {
        this(interpolationPoints, 0.001, filter);
    }

    public TimeStampedFieldAngularCoordinatesHermiteInterpolator(int interpolationPoints, double extrapolationThreshold, AngularDerivativesFilter filter) {
        super(interpolationPoints, extrapolationThreshold);
        this.filter = filter;
    }

    public AngularDerivativesFilter getFilter() {
        return this.filter;
    }

    @Override
    protected TimeStampedFieldAngularCoordinates<KK> interpolate(AbstractFieldTimeInterpolator.InterpolationData interpolationData) {
        FieldVector3D meanRate;
        FieldAbsoluteDate interpolationDate = interpolationData.getInterpolationDate();
        List sample = interpolationData.getNeighborList();
        double epsilon = Math.PI * 2 / (double)sample.size();
        double threshold = FastMath.min((double)-0.9999, (double)(-FastMath.cos((double)(epsilon / 4.0))));
        Field field = interpolationData.getField();
        FieldVector3D sum = FieldVector3D.getZero(field);
        if (this.filter != AngularDerivativesFilter.USE_R) {
            for (Object datedAC : sample) {
                sum = sum.add(((FieldAngularCoordinates)datedAC).getRotationRate());
            }
            meanRate = new FieldVector3D(1.0 / (double)sample.size(), sum);
        } else {
            TimeStampedFieldAngularCoordinates previous = null;
            for (TimeStampedFieldAngularCoordinates datedAC : sample) {
                if (previous != null) {
                    sum = sum.add(TimeStampedFieldAngularCoordinates.estimateRate(previous.getRotation(), datedAC.getRotation(), datedAC.getDate().durationFrom(previous.getDate())));
                }
                previous = datedAC;
            }
            meanRate = new FieldVector3D(1.0 / (double)(sample.size() - 1), sum);
        }
        FieldAngularCoordinates offset = new TimeStampedFieldAngularCoordinates(interpolationDate, FieldRotation.getIdentity(field), meanRate, FieldVector3D.getZero(field));
        boolean restart = true;
        for (int i = 0; restart && i < sample.size() + 2; ++i) {
            restart = false;
            FieldHermiteInterpolator interpolator = new FieldHermiteInterpolator();
            Object one = interpolationData.getOne();
            double sign = 1.0;
            FieldRotation previous = FieldRotation.getIdentity(field);
            block8: for (TimeStampedFieldAngularCoordinates ac : sample) {
                Object dt = ac.getDate().durationFrom(interpolationDate);
                FieldAngularCoordinates fixed = ac.subtractOffset(offset.shiftedBy((CalculusFieldElement)dt));
                double dot = ((CalculusFieldElement)one.linearCombination((FieldElement)fixed.getRotation().getQ0(), (FieldElement)previous.getQ0(), (FieldElement)fixed.getRotation().getQ1(), (FieldElement)previous.getQ1(), (FieldElement)fixed.getRotation().getQ2(), (FieldElement)previous.getQ2(), (FieldElement)fixed.getRotation().getQ3(), (FieldElement)previous.getQ3())).getReal();
                sign = FastMath.copySign((double)1.0, (double)(dot * sign));
                previous = fixed.getRotation();
                if (fixed.getRotation().getQ0().getReal() * sign < threshold) {
                    restart = true;
                    break;
                }
                CalculusFieldElement[][] rodrigues = fixed.getModifiedRodrigues(sign);
                switch (this.filter) {
                    case USE_RRA: {
                        interpolator.addSamplePoint(dt, (FieldElement[][])new CalculusFieldElement[][]{rodrigues[0], rodrigues[1], rodrigues[2]});
                        continue block8;
                    }
                    case USE_RR: {
                        interpolator.addSamplePoint(dt, (FieldElement[][])new CalculusFieldElement[][]{rodrigues[0], rodrigues[1]});
                        continue block8;
                    }
                    case USE_R: {
                        interpolator.addSamplePoint(dt, (FieldElement[][])new CalculusFieldElement[][]{rodrigues[0]});
                        continue block8;
                    }
                }
                throw new OrekitInternalError(null);
            }
            if (!restart) {
                Object zero = interpolationData.getZero();
                CalculusFieldElement[][] p = (CalculusFieldElement[][])interpolator.derivatives(zero, 2);
                FieldAngularCoordinates ac = FieldAngularCoordinates.createFromModifiedRodrigues((CalculusFieldElement[][])p);
                return new TimeStampedFieldAngularCoordinates(offset.getDate(), ac.getRotation(), ac.getRotationRate(), ac.getRotationAcceleration()).addOffset(offset);
            }
            offset = offset.addOffset(new FieldAngularCoordinates(new FieldRotation(FieldVector3D.getPlusI(field), (CalculusFieldElement)one.newInstance(epsilon), RotationConvention.VECTOR_OPERATOR), FieldVector3D.getZero(field), FieldVector3D.getZero(field)));
        }
        throw new OrekitInternalError(null);
    }
}

