/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.utils;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.analysis.differentiation.FieldDerivative;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.RotationConvention;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.FieldTimeShiftable;
import org.orekit.time.FieldTimeStamped;
import org.orekit.utils.FieldAngularCoordinates;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.TimeStampedAngularCoordinates;

public class TimeStampedFieldAngularCoordinates<T extends CalculusFieldElement<T>>
extends FieldAngularCoordinates<T>
implements FieldTimeStamped<T> {
    private final FieldAbsoluteDate<T> date;

    public TimeStampedFieldAngularCoordinates(AbsoluteDate date, FieldPVCoordinates<T> u1, FieldPVCoordinates<T> u2, FieldPVCoordinates<T> v1, FieldPVCoordinates<T> v2, double tolerance) {
        this(new FieldAbsoluteDate(u1.getPosition().getX().getField(), date), u1, u2, v1, v2, tolerance);
    }

    public TimeStampedFieldAngularCoordinates(FieldAbsoluteDate<T> date, FieldPVCoordinates<T> u1, FieldPVCoordinates<T> u2, FieldPVCoordinates<T> v1, FieldPVCoordinates<T> v2, double tolerance) {
        super(u1, u2, v1, v2, tolerance);
        this.date = date;
    }

    public TimeStampedFieldAngularCoordinates(AbsoluteDate date, FieldRotation<T> rotation, FieldVector3D<T> rotationRate, FieldVector3D<T> rotationAcceleration) {
        this(new FieldAbsoluteDate(rotation.getQ0().getField(), date), rotation, rotationRate, rotationAcceleration);
    }

    public TimeStampedFieldAngularCoordinates(FieldAbsoluteDate<T> date, FieldRotation<T> rotation, FieldVector3D<T> rotationRate, FieldVector3D<T> rotationAcceleration) {
        super(rotation, rotationRate, rotationAcceleration);
        this.date = date;
    }

    public TimeStampedFieldAngularCoordinates(Field<T> field, TimeStampedAngularCoordinates ac) {
        this(new FieldAbsoluteDate<T>(field, ac.getDate()), new FieldRotation(field, ac.getRotation()), new FieldVector3D(field, ac.getRotationRate()), new FieldVector3D(field, ac.getRotationAcceleration()));
    }

    public <U extends FieldDerivative<T, U>> TimeStampedFieldAngularCoordinates(FieldAbsoluteDate<T> date, FieldRotation<U> r) {
        super(r);
        this.date = date;
    }

    @Override
    public TimeStampedFieldAngularCoordinates<T> revert() {
        return new TimeStampedFieldAngularCoordinates<T>(this.date, this.getRotation().revert(), this.getRotation().applyInverseTo(this.getRotationRate().negate()), this.getRotation().applyInverseTo(this.getRotationAcceleration().negate()));
    }

    @Override
    public FieldAbsoluteDate<T> getDate() {
        return this.date;
    }

    @Override
    public TimeStampedFieldAngularCoordinates<T> shiftedBy(double dt) {
        return this.shiftedBy((CalculusFieldElement)((CalculusFieldElement)this.getDate().getField().getZero()).newInstance(dt));
    }

    @Override
    public TimeStampedFieldAngularCoordinates<T> shiftedBy(T dt) {
        FieldTimeShiftable sac = super.shiftedBy((CalculusFieldElement)dt);
        return new TimeStampedFieldAngularCoordinates(this.date.shiftedBy((CalculusFieldElement)dt), ((FieldAngularCoordinates)sac).getRotation(), ((FieldAngularCoordinates)sac).getRotationRate(), ((FieldAngularCoordinates)sac).getRotationAcceleration());
    }

    @Override
    public TimeStampedFieldAngularCoordinates<T> addOffset(FieldAngularCoordinates<T> offset) {
        FieldVector3D rOmega = this.getRotation().applyTo(offset.getRotationRate());
        FieldVector3D rOmegaDot = this.getRotation().applyTo(offset.getRotationAcceleration());
        return new TimeStampedFieldAngularCoordinates<T>(this.date, this.getRotation().compose(offset.getRotation(), RotationConvention.VECTOR_OPERATOR), this.getRotationRate().add(rOmega), new FieldVector3D(1.0, this.getRotationAcceleration(), 1.0, rOmegaDot, -1.0, FieldVector3D.crossProduct(this.getRotationRate(), (FieldVector3D)rOmega)));
    }

    @Override
    public TimeStampedFieldAngularCoordinates<T> subtractOffset(FieldAngularCoordinates<T> offset) {
        return this.addOffset((FieldAngularCoordinates)offset.revert());
    }
}

