/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.utils;

import java.util.List;
import org.hipparchus.analysis.interpolation.HermiteInterpolator;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.RotationConvention;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.orekit.errors.OrekitInternalError;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.AbstractTimeInterpolator;
import org.orekit.utils.AngularCoordinates;
import org.orekit.utils.AngularDerivativesFilter;
import org.orekit.utils.TimeStampedAngularCoordinates;

public class TimeStampedAngularCoordinatesHermiteInterpolator
extends AbstractTimeInterpolator<TimeStampedAngularCoordinates> {
    private final AngularDerivativesFilter filter;

    public TimeStampedAngularCoordinatesHermiteInterpolator() {
        this(2);
    }

    public TimeStampedAngularCoordinatesHermiteInterpolator(int interpolationPoints) {
        this(interpolationPoints, AngularDerivativesFilter.USE_RR);
    }

    public TimeStampedAngularCoordinatesHermiteInterpolator(int interpolationPoints, AngularDerivativesFilter filter) {
        this(interpolationPoints, 0.001, filter);
    }

    public TimeStampedAngularCoordinatesHermiteInterpolator(int interpolationPoints, double extrapolationThreshold, AngularDerivativesFilter filter) {
        super(interpolationPoints, extrapolationThreshold);
        this.filter = filter;
    }

    public AngularDerivativesFilter getFilter() {
        return this.filter;
    }

    @Override
    protected TimeStampedAngularCoordinates interpolate(AbstractTimeInterpolator.InterpolationData interpolationData) {
        Vector3D meanRate;
        AbsoluteDate date = interpolationData.getInterpolationDate();
        List sample = interpolationData.getNeighborList();
        double epsilon = Math.PI * 2 / (double)sample.size();
        double threshold = FastMath.min((double)-0.9999, (double)(-FastMath.cos((double)(epsilon / 4.0))));
        Vector3D sum = Vector3D.ZERO;
        if (this.filter != AngularDerivativesFilter.USE_R) {
            for (Object datedAC : sample) {
                sum = sum.add((Vector)((AngularCoordinates)datedAC).getRotationRate());
            }
            meanRate = new Vector3D(1.0 / (double)sample.size(), sum);
        } else {
            TimeStampedAngularCoordinates previous = null;
            for (TimeStampedAngularCoordinates datedAC : sample) {
                if (previous != null) {
                    sum = sum.add((Vector)TimeStampedAngularCoordinates.estimateRate(previous.getRotation(), datedAC.getRotation(), datedAC.getDate().durationFrom(previous.getDate())));
                }
                previous = datedAC;
            }
            meanRate = new Vector3D(1.0 / (double)(sample.size() - 1), sum);
        }
        TimeStampedAngularCoordinates offset = new TimeStampedAngularCoordinates(date, Rotation.IDENTITY, meanRate, Vector3D.ZERO);
        boolean restart = true;
        for (int i = 0; restart && i < sample.size() + 2; ++i) {
            restart = false;
            HermiteInterpolator interpolator = new HermiteInterpolator();
            double sign = 1.0;
            Rotation previous = Rotation.IDENTITY;
            block8: for (AngularCoordinates ac : sample) {
                double dt = ((TimeStampedAngularCoordinates)ac).getDate().durationFrom(date);
                TimeStampedAngularCoordinates fixed = ((TimeStampedAngularCoordinates)ac).subtractOffset(offset.shiftedBy(dt));
                double dot = MathArrays.linearCombination((double)fixed.getRotation().getQ0(), (double)previous.getQ0(), (double)fixed.getRotation().getQ1(), (double)previous.getQ1(), (double)fixed.getRotation().getQ2(), (double)previous.getQ2(), (double)fixed.getRotation().getQ3(), (double)previous.getQ3());
                sign = FastMath.copySign((double)1.0, (double)(dot * sign));
                previous = fixed.getRotation();
                if (fixed.getRotation().getQ0() * sign < threshold) {
                    restart = true;
                    break;
                }
                double[][] rodrigues = fixed.getModifiedRodrigues(sign);
                switch (this.filter) {
                    case USE_RRA: {
                        interpolator.addSamplePoint(dt, (double[][])new double[][]{rodrigues[0], rodrigues[1], rodrigues[2]});
                        continue block8;
                    }
                    case USE_RR: {
                        interpolator.addSamplePoint(dt, (double[][])new double[][]{rodrigues[0], rodrigues[1]});
                        continue block8;
                    }
                    case USE_R: {
                        interpolator.addSamplePoint(dt, (double[][])new double[][]{rodrigues[0]});
                        continue block8;
                    }
                }
                throw new OrekitInternalError(null);
            }
            if (!restart) {
                AngularCoordinates ac;
                double[][] p = interpolator.derivatives(0.0, 2);
                ac = AngularCoordinates.createFromModifiedRodrigues(p);
                return new TimeStampedAngularCoordinates(offset.getDate(), ac.getRotation(), ac.getRotationRate(), ac.getRotationAcceleration()).addOffset(offset);
            }
            offset = offset.addOffset(new AngularCoordinates(new Rotation(Vector3D.PLUS_I, epsilon, RotationConvention.VECTOR_OPERATOR), Vector3D.ZERO, Vector3D.ZERO));
        }
        throw new OrekitInternalError(null);
    }
}

