/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.utils;

import org.hipparchus.analysis.differentiation.Derivative;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.RotationConvention;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeStamped;
import org.orekit.utils.AngularCoordinates;
import org.orekit.utils.PVCoordinates;

public class TimeStampedAngularCoordinates
extends AngularCoordinates
implements TimeStamped {
    private static final long serialVersionUID = 20140723L;
    private final AbsoluteDate date;

    public TimeStampedAngularCoordinates(AbsoluteDate date, Rotation rotation, Vector3D rotationRate, Vector3D rotationAcceleration) {
        super(rotation, rotationRate, rotationAcceleration);
        this.date = date;
    }

    public TimeStampedAngularCoordinates(AbsoluteDate date, PVCoordinates u1, PVCoordinates u2, PVCoordinates v1, PVCoordinates v2, double tolerance) {
        super(u1, u2, v1, v2, tolerance);
        this.date = date;
    }

    public TimeStampedAngularCoordinates(AbsoluteDate date, PVCoordinates u, PVCoordinates v) {
        super(u, v);
        this.date = date;
    }

    public <U extends Derivative<U>> TimeStampedAngularCoordinates(AbsoluteDate date, FieldRotation<U> r) {
        super(r);
        this.date = date;
    }

    @Override
    public AbsoluteDate getDate() {
        return this.date;
    }

    @Override
    public TimeStampedAngularCoordinates revert() {
        return new TimeStampedAngularCoordinates(this.date, this.getRotation().revert(), this.getRotation().applyInverseTo(this.getRotationRate().negate()), this.getRotation().applyInverseTo(this.getRotationAcceleration().negate()));
    }

    @Override
    public TimeStampedAngularCoordinates shiftedBy(double dt) {
        AngularCoordinates sac = super.shiftedBy(dt);
        return new TimeStampedAngularCoordinates(this.date.shiftedBy(dt), sac.getRotation(), sac.getRotationRate(), sac.getRotationAcceleration());
    }

    @Override
    public TimeStampedAngularCoordinates addOffset(AngularCoordinates offset) {
        Vector3D rOmega = this.getRotation().applyTo(offset.getRotationRate());
        Vector3D rOmegaDot = this.getRotation().applyTo(offset.getRotationAcceleration());
        return new TimeStampedAngularCoordinates(this.date, this.getRotation().compose(offset.getRotation(), RotationConvention.VECTOR_OPERATOR), this.getRotationRate().add((Vector)rOmega), new Vector3D(1.0, this.getRotationAcceleration(), 1.0, rOmegaDot, -1.0, Vector3D.crossProduct((Vector3D)this.getRotationRate(), (Vector3D)rOmega)));
    }

    @Override
    public TimeStampedAngularCoordinates subtractOffset(AngularCoordinates offset) {
        return this.addOffset(offset.revert());
    }
}

