/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.utils;

import java.util.List;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.util.FastMath;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.errors.OrekitMessages;
import org.orekit.errors.TimeStampedCacheException;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeStamped;

public class SortedListTrimmer {
    private final int neighborsSize;

    public SortedListTrimmer(int neighborsSize) {
        if (neighborsSize < 1) {
            throw new OrekitIllegalArgumentException((Localizable)LocalizedCoreFormats.NUMBER_TOO_SMALL, neighborsSize, 1);
        }
        this.neighborsSize = neighborsSize;
    }

    public int getNeighborsSize() {
        return this.neighborsSize;
    }

    public <T extends TimeStamped> List<T> getNeighborsSubList(AbsoluteDate central, List<T> data) {
        if (this.neighborsSize > data.size()) {
            throw new OrekitException((Localizable)OrekitMessages.NOT_ENOUGH_DATA, data.size());
        }
        int i = this.findIndex(central, data);
        if (i < 0) {
            AbsoluteDate earliest = ((TimeStamped)data.get(0)).getDate();
            throw new TimeStampedCacheException((Localizable)OrekitMessages.UNABLE_TO_GENERATE_NEW_DATA_BEFORE, earliest, central, earliest.durationFrom(central));
        }
        if (i >= data.size()) {
            AbsoluteDate latest = ((TimeStamped)data.get(data.size() - 1)).getDate();
            throw new TimeStampedCacheException((Localizable)OrekitMessages.UNABLE_TO_GENERATE_NEW_DATA_AFTER, latest, central, central.durationFrom(latest));
        }
        int start = FastMath.max((int)0, (int)(i - (this.neighborsSize - 1) / 2));
        int end = FastMath.min((int)data.size(), (int)(start + this.neighborsSize));
        start = end - this.neighborsSize;
        return data.subList(start, end);
    }

    private <T extends TimeStamped> int findIndex(AbsoluteDate t, List<T> data) {
        int iInf = 0;
        double dtInf = t.durationFrom((TimeStamped)data.get(0));
        if (dtInf < 0.0) {
            return -1;
        }
        int iSup = data.size() - 1;
        double dtSup = t.durationFrom((TimeStamped)data.get(data.size() - 1));
        if (dtSup > 0.0) {
            return data.size();
        }
        while (iSup - iInf > 1) {
            int iInterp = (int)FastMath.rint((double)(((double)iInf * dtSup - (double)iSup * dtInf) / (dtSup - dtInf)));
            int iMed = FastMath.max((int)(iInf + 1), (int)FastMath.min((int)iInterp, (int)(iSup - 1)));
            double dtMed = t.durationFrom(((TimeStamped)data.get(iMed)).getDate());
            if (dtMed < 0.0) {
                iSup = iMed;
                dtSup = dtMed;
                continue;
            }
            iInf = iMed;
            dtInf = dtMed;
        }
        if (dtSup == 0.0) {
            return iSup;
        }
        return iInf;
    }
}

