/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.utils;

import org.orekit.frames.Frame;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.PVCoordinatesProvider;
import org.orekit.utils.TimeStampedPVCoordinates;

public class ShiftingPVCoordinatesProvider
implements PVCoordinatesProvider {
    private final TimeStampedPVCoordinates referencePV;
    private final Frame referenceFrame;

    public ShiftingPVCoordinatesProvider(TimeStampedPVCoordinates referencePV, Frame referenceFrame) {
        this.referencePV = referencePV;
        this.referenceFrame = referenceFrame;
    }

    @Override
    public TimeStampedPVCoordinates getPVCoordinates(AbsoluteDate date, Frame frame) {
        TimeStampedPVCoordinates shifted = this.referencePV.shiftedBy(date.durationFrom(this.referencePV));
        return this.referenceFrame.getTransformTo(frame, date).transformPVCoordinates(shifted);
    }
}

