/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.utils;

import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.util.MathArrays;
import org.orekit.errors.UnsupportedParameterException;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TimeSpanMap;

public interface ParameterDriversProvider {
    public List<ParameterDriver> getParametersDrivers();

    default public int getNbParametersDriversValue() {
        int totalSpan = 0;
        List<ParameterDriver> allParameters = this.getParametersDrivers();
        for (ParameterDriver driver : allParameters) {
            totalSpan += driver.getNbOfValues();
        }
        return totalSpan;
    }

    default public double[] getParameters() {
        List<ParameterDriver> drivers = this.getParametersDrivers();
        double[] parameters = new double[drivers.size()];
        for (int i = 0; i < drivers.size(); ++i) {
            parameters[i] = drivers.get(i).getValue();
        }
        return parameters;
    }

    default public double[] getParameters(AbsoluteDate date) {
        List<ParameterDriver> drivers = this.getParametersDrivers();
        double[] parameters = new double[drivers.size()];
        for (int i = 0; i < drivers.size(); ++i) {
            parameters[i] = drivers.get(i).getValue(date);
        }
        return parameters;
    }

    default public double[] getParametersAllValues() {
        List<ParameterDriver> drivers = this.getParametersDrivers();
        int nbParametersValues = this.getNbParametersDriversValue();
        double[] parameters = new double[nbParametersValues];
        int paramIndex = 0;
        for (int i = 0; i < drivers.size(); ++i) {
            for (TimeSpanMap.Span<Double> span = drivers.get(i).getValueSpanMap().getFirstSpan(); span != null; span = span.next()) {
                parameters[paramIndex++] = span.getData();
            }
        }
        return parameters;
    }

    default public <T extends CalculusFieldElement<T>> T[] getParametersAllValues(Field<T> field) {
        List<ParameterDriver> drivers = this.getParametersDrivers();
        int nbParametersValues = this.getNbParametersDriversValue();
        CalculusFieldElement[] parameters = (CalculusFieldElement[])MathArrays.buildArray(field, (int)nbParametersValues);
        int paramIndex = 0;
        for (int i = 0; i < drivers.size(); ++i) {
            for (TimeSpanMap.Span<Double> span = drivers.get(i).getValueSpanMap().getFirstSpan(); span != null; span = span.next()) {
                parameters[paramIndex++] = (CalculusFieldElement)((CalculusFieldElement)field.getZero()).newInstance(span.getData().doubleValue());
            }
        }
        return parameters;
    }

    default public <T extends CalculusFieldElement<T>> T[] getParameters(Field<T> field) {
        List<ParameterDriver> drivers = this.getParametersDrivers();
        CalculusFieldElement[] parameters = (CalculusFieldElement[])MathArrays.buildArray(field, (int)drivers.size());
        for (int i = 0; i < drivers.size(); ++i) {
            parameters[i] = (CalculusFieldElement)((CalculusFieldElement)field.getZero()).newInstance(drivers.get(i).getValue());
        }
        return parameters;
    }

    default public <T extends CalculusFieldElement<T>> T[] getParameters(Field<T> field, FieldAbsoluteDate<T> date) {
        List<ParameterDriver> drivers = this.getParametersDrivers();
        CalculusFieldElement[] parameters = (CalculusFieldElement[])MathArrays.buildArray(field, (int)drivers.size());
        for (int i = 0; i < drivers.size(); ++i) {
            parameters[i] = (CalculusFieldElement)((CalculusFieldElement)field.getZero()).newInstance(drivers.get(i).getValue(date.toAbsoluteDate()));
        }
        return parameters;
    }

    default public ParameterDriver getParameterDriver(String name) {
        for (ParameterDriver driver : this.getParametersDrivers()) {
            if (!name.equals(driver.getName())) continue;
            return driver;
        }
        throw new UnsupportedParameterException(name, this.getParametersDrivers());
    }

    default public boolean isSupported(String name) {
        for (ParameterDriver driver : this.getParametersDrivers()) {
            if (!name.equals(driver.getName())) continue;
            return true;
        }
        return false;
    }
}

