/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.ParameterObserver;
import org.orekit.utils.TimeSpanMap;

public class ParameterDriversList {
    private final List<DelegatingDriver> delegating = new ArrayList<DelegatingDriver>();

    public void add(ParameterDriver driver) {
        DelegatingDriver existingHere = this.findByName(driver.getName());
        DelegatingDriver alreadyBound = this.getAssociatedDelegatingDriver(driver);
        if (existingHere != null) {
            if (alreadyBound != null) {
                existingHere.merge(alreadyBound);
            } else {
                existingHere.add(driver);
            }
        } else if (alreadyBound != null) {
            this.delegating.add(alreadyBound);
            alreadyBound.addOwner(this);
        } else {
            this.delegating.add(new DelegatingDriver(this, driver));
        }
    }

    private DelegatingDriver getAssociatedDelegatingDriver(ParameterDriver driver) {
        for (ParameterObserver observer : driver.getObservers()) {
            if (!(observer instanceof ChangesForwarder)) continue;
            return ((ChangesForwarder)observer).getDelegatingDriver();
        }
        return null;
    }

    private void replaceDelegating(DelegatingDriver oldDelegating, DelegatingDriver newDelegating) {
        for (int i = 0; i < this.delegating.size(); ++i) {
            if (this.delegating.get(i) != oldDelegating) continue;
            this.delegating.set(i, newDelegating);
        }
    }

    public DelegatingDriver findByName(String name) {
        for (DelegatingDriver d : this.delegating) {
            if (!d.getName().equals(name)) continue;
            return d;
        }
        return null;
    }

    public String findDelegatingSpanNameBySpanName(String name) {
        for (DelegatingDriver d : this.delegating) {
            for (TimeSpanMap.Span<String> span = d.getNamesSpanMap().getFirstSpan(); span != null; span = span.next()) {
                if (!span.getData().equals(name)) continue;
                return span.getData();
            }
        }
        return null;
    }

    public void sort() {
        Collections.sort(this.delegating, new Comparator<DelegatingDriver>(){

            @Override
            public int compare(DelegatingDriver d1, DelegatingDriver d2) {
                return d1.getName().compareTo(d2.getName());
            }
        });
    }

    public void filter(boolean selected) {
        Iterator<DelegatingDriver> iterator = this.delegating.iterator();
        while (iterator.hasNext()) {
            DelegatingDriver delegatingDriver = iterator.next();
            if (delegatingDriver.isSelected() == selected) continue;
            iterator.remove();
            delegatingDriver.removeOwner(this);
        }
    }

    public int getNbParams() {
        return this.delegating.size();
    }

    public int getNbValuesToEstimate() {
        int nbValuesToEstimate = 0;
        for (DelegatingDriver driver : this.delegating) {
            nbValuesToEstimate += driver.getNbOfValues();
        }
        return nbValuesToEstimate;
    }

    public List<DelegatingDriver> getDrivers() {
        return Collections.unmodifiableList(this.delegating);
    }

    @FunctionalInterface
    private static interface Updater {
        public void update(ParameterDriver var1);
    }

    private static class ChangesForwarder
    implements ParameterObserver {
        private final DelegatingDriver delegating;
        private final List<ParameterDriver> drivers;
        private ParameterDriver root;
        private int depth;

        ChangesForwarder(DelegatingDriver delegating, ParameterDriver driver) {
            this.delegating = delegating;
            this.drivers = new ArrayList<ParameterDriver>();
            this.drivers.add(driver);
        }

        DelegatingDriver getDelegatingDriver() {
            return this.delegating;
        }

        void add(ParameterDriver driver) {
            this.drivers.add(driver);
        }

        public List<ParameterDriver> getDrivers() {
            return this.drivers;
        }

        @Override
        public void valueSpanMapChanged(TimeSpanMap<Double> previousValueSpanMap, ParameterDriver driver) {
            this.updateAll(driver, d -> d.setValueSpanMap(driver));
        }

        @Override
        public void valueChanged(double previousValue, ParameterDriver driver, AbsoluteDate date) {
            this.updateAll(driver, d -> d.setValue(driver.getValue(date), date));
        }

        @Override
        public void referenceDateChanged(AbsoluteDate previousReferenceDate, ParameterDriver driver) {
            this.updateAll(driver, d -> d.setReferenceDate(driver.getReferenceDate()));
        }

        @Override
        public void nameChanged(String previousName, ParameterDriver driver) {
            this.updateAll(driver, d -> d.setName(driver.getName()));
        }

        @Override
        public void selectionChanged(boolean previousSelection, ParameterDriver driver) {
            this.updateAll(driver, d -> d.setSelected(driver.isSelected()));
        }

        @Override
        public void estimationTypeChanged(boolean previousSelection, ParameterDriver driver) {
            this.updateAll(driver, d -> d.setContinuousEstimation(driver.isContinuousEstimation()));
        }

        @Override
        public void referenceValueChanged(double previousReferenceValue, ParameterDriver driver) {
            this.updateAll(driver, d -> d.setReferenceValue(driver.getReferenceValue()));
        }

        @Override
        public void minValueChanged(double previousMinValue, ParameterDriver driver) {
            this.updateAll(driver, d -> d.setMinValue(driver.getMinValue()));
        }

        @Override
        public void maxValueChanged(double previousMaxValue, ParameterDriver driver) {
            this.updateAll(driver, d -> d.setMaxValue(driver.getMaxValue()));
        }

        @Override
        public void scaleChanged(double previousScale, ParameterDriver driver) {
            this.updateAll(driver, d -> d.setScale(driver.getScale()));
        }

        private void updateAll(ParameterDriver driver, Updater updater) {
            boolean firstCall;
            boolean bl = firstCall = this.depth++ == 0;
            if (firstCall) {
                this.root = driver;
            }
            if (driver == this.getDelegatingDriver()) {
                for (ParameterDriver d : this.drivers) {
                    if (d == this.root) continue;
                    updater.update(d);
                }
            } else if (firstCall) {
                updater.update(this.getDelegatingDriver());
            }
            if (--this.depth == 0) {
                this.root = null;
            }
        }
    }

    public static class DelegatingDriver
    extends ParameterDriver {
        private final List<ParameterDriversList> owners = new ArrayList<ParameterDriversList>();
        private ChangesForwarder forwarder;

        DelegatingDriver(ParameterDriversList owner, ParameterDriver driver) {
            super(driver.getName(), driver.getNamesSpanMap(), driver.getValueSpanMap(), driver.getReferenceValue(), driver.getScale(), driver.getMinValue(), driver.getMaxValue());
            this.addOwner(owner);
            this.setValueSpanMap(driver);
            this.setReferenceDate(driver.getReferenceDate());
            this.setSelected(driver.isSelected());
            this.forwarder = new ChangesForwarder(this, driver);
            this.addObserver(this.forwarder);
            driver.addObserver(this.forwarder);
        }

        void addOwner(ParameterDriversList owner) {
            this.owners.add(owner);
        }

        private void removeOwner(ParameterDriversList owner) {
            Iterator<ParameterDriversList> iterator = this.owners.iterator();
            while (iterator.hasNext()) {
                if (iterator.next() != owner) continue;
                iterator.remove();
            }
        }

        private void add(ParameterDriver driver) {
            this.setValueSpanMap(driver);
            this.setReferenceDate(driver.getReferenceDate());
            if (this.isSelected()) {
                driver.setSelected(true);
            } else {
                this.setSelected(driver.isSelected());
            }
            driver.addObserver(this.forwarder);
            this.forwarder.add(driver);
        }

        private void merge(DelegatingDriver other) {
            if (other.forwarder == this.forwarder) {
                return;
            }
            this.setValueSpanMap(other);
            this.setReferenceDate(other.getReferenceDate());
            if (this.isSelected()) {
                other.setSelected(true);
            } else {
                this.setSelected(other.isSelected());
            }
            for (ParameterDriver otherDriver : other.forwarder.getDrivers()) {
                this.forwarder.add(otherDriver);
                otherDriver.replaceObserver(other.forwarder, this.forwarder);
            }
            other.replaceObserver(other.forwarder, this.forwarder);
            other.forwarder = this.forwarder;
            for (ParameterDriversList otherOwner : other.owners) {
                this.owners.add(otherOwner);
                otherOwner.replaceDelegating(other, this);
            }
        }

        public List<ParameterDriver> getRawDrivers() {
            return Collections.unmodifiableList(this.forwarder.getDrivers());
        }
    }
}

