/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hipparchus.analysis.differentiation.Gradient;
import org.hipparchus.exception.Localizable;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.Precision;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitIllegalStateException;
import org.orekit.errors.OrekitMessages;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.ParameterObserver;
import org.orekit.utils.TimeSpanMap;

public class ParameterDriver {
    public static final String SPAN = "Span";
    private String name;
    private TimeSpanMap<String> nameSpanMap;
    private double referenceValue;
    private double scale;
    private double minValue;
    private double maxValue;
    private AbsoluteDate referenceDate;
    private boolean isEstimationContinuous;
    private TimeSpanMap<Double> valueSpanMap;
    private boolean selected;
    private final List<ParameterObserver> observers;

    public ParameterDriver(String name, TimeSpanMap<String> namesSpanMap, TimeSpanMap<Double> valuesSpanMap, double referenceValue, double scale, double minValue, double maxValue) {
        if (FastMath.abs((double)scale) <= Precision.SAFE_MIN) {
            throw new OrekitException((Localizable)OrekitMessages.TOO_SMALL_SCALE_FOR_PARAMETER, name, scale);
        }
        this.name = name;
        this.nameSpanMap = namesSpanMap;
        this.referenceValue = referenceValue;
        this.scale = scale;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.referenceDate = null;
        this.valueSpanMap = valuesSpanMap;
        this.selected = false;
        this.observers = new ArrayList<ParameterObserver>();
        this.isEstimationContinuous = false;
    }

    public ParameterDriver(String name, double referenceValue, double scale, double minValue, double maxValue) {
        if (FastMath.abs((double)scale) <= Precision.SAFE_MIN) {
            throw new OrekitException((Localizable)OrekitMessages.TOO_SMALL_SCALE_FOR_PARAMETER, name, scale);
        }
        this.name = name;
        this.nameSpanMap = new TimeSpanMap<String>(SPAN + name + Integer.toString(0));
        this.referenceValue = referenceValue;
        this.scale = scale;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.referenceDate = null;
        this.valueSpanMap = new TimeSpanMap<Double>(referenceValue);
        this.selected = false;
        this.observers = new ArrayList<ParameterObserver>();
        this.isEstimationContinuous = false;
    }

    public TimeSpanMap<String> getNamesSpanMap() {
        return this.nameSpanMap;
    }

    public TimeSpanMap<Double> getValueSpanMap() {
        return this.valueSpanMap;
    }

    public void setValueSpanMap(ParameterDriver driver) {
        TimeSpanMap<Double> previousValueSpanMap = driver.getValueSpanMap();
        this.valueSpanMap = driver.getValueSpanMap();
        this.nameSpanMap = driver.getNamesSpanMap();
        for (ParameterObserver observer : this.observers) {
            observer.valueSpanMapChanged(previousValueSpanMap, this);
        }
    }

    public int getNbOfValues() {
        return this.valueSpanMap.getSpansNumber();
    }

    public AbsoluteDate[] getTransitionDates() {
        ArrayList<AbsoluteDate> listDates = new ArrayList<AbsoluteDate>();
        for (TimeSpanMap.Transition<Double> transition = this.getValueSpanMap().getFirstSpan().getEndTransition(); transition != null; transition = transition.next()) {
            listDates.add(transition.getDate());
        }
        return listDates.toArray(new AbsoluteDate[0]);
    }

    public double[] getValues() {
        double[] chronologicalValues = new double[this.getNbOfValues()];
        TimeSpanMap.Span<Double> currentSpan = this.valueSpanMap.getFirstSpan();
        for (int i = 0; i < this.getNbOfValues() - 1; ++i) {
            chronologicalValues[i] = currentSpan.getData();
            currentSpan = currentSpan.next();
        }
        chronologicalValues[this.getNbOfValues() - 1] = currentSpan.getData();
        return chronologicalValues;
    }

    public void addObserver(ParameterObserver observer) {
        this.observers.add(observer);
        observer.valueSpanMapChanged(this.getValueSpanMap(), this);
    }

    public void removeObserver(ParameterObserver observer) {
        Iterator<ParameterObserver> iterator = this.observers.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() != observer) continue;
            iterator.remove();
            return;
        }
    }

    public void replaceObserver(ParameterObserver oldObserver, ParameterObserver newObserver) {
        for (int i = 0; i < this.observers.size(); ++i) {
            if (this.observers.get(i) != oldObserver) continue;
            this.observers.set(i, newObserver);
        }
    }

    public List<ParameterObserver> getObservers() {
        return Collections.unmodifiableList(this.observers);
    }

    public String getName() {
        return this.name;
    }

    public String getNameSpan(AbsoluteDate date) {
        return this.nameSpanMap.get(date);
    }

    public void setName(String name) {
        String previousName = this.name;
        this.name = name;
        for (ParameterObserver observer : this.observers) {
            observer.nameChanged(previousName, this);
        }
        if (this.nameSpanMap.getSpansNumber() > 1) {
            TimeSpanMap.Span<String> currentNameSpan = this.nameSpanMap.getFirstSpan();
            this.nameSpanMap.addValidBefore(SPAN + name + Integer.toString(0), currentNameSpan.getEnd(), false);
            for (int spanNumber = 1; spanNumber < this.nameSpanMap.getSpansNumber(); ++spanNumber) {
                currentNameSpan = this.nameSpanMap.getSpan(currentNameSpan.getEnd());
                this.nameSpanMap.addValidAfter(SPAN + name + Integer.toString(spanNumber), currentNameSpan.getStart(), false);
            }
        } else {
            this.nameSpanMap = new TimeSpanMap<String>(SPAN + name + Integer.toString(0));
        }
    }

    public void addSpans(AbsoluteDate orbitDeterminationStartDate, AbsoluteDate orbitDeterminationEndDate, double validityPeriodForDriver) {
        if (this.getNbOfValues() != 1) {
            throw new OrekitIllegalStateException(OrekitMessages.PARAMETER_PERIODS_HAS_ALREADY_BEEN_SET, this.name);
        }
        int spanNumber = 1;
        AbsoluteDate currentDate = orbitDeterminationStartDate.shiftedBy(validityPeriodForDriver);
        while (currentDate.isBefore(orbitDeterminationEndDate) && orbitDeterminationEndDate.durationFrom(currentDate) > validityPeriodForDriver / 3.0) {
            this.valueSpanMap.addValidAfter(this.getValue(currentDate), currentDate, false);
            this.nameSpanMap.addValidAfter(SPAN + this.getName() + Integer.toString(spanNumber++), currentDate, false);
            currentDate = currentDate.shiftedBy(validityPeriodForDriver);
        }
    }

    public void addSpanAtDate(AbsoluteDate spanStartDate) {
        this.valueSpanMap.addValidAfter(this.getValue(spanStartDate), spanStartDate, false);
        this.nameSpanMap.addValidAfter(this.name, spanStartDate, false);
        TimeSpanMap.Span<String> currentNameSpan = this.nameSpanMap.getFirstSpan();
        this.nameSpanMap.addValidBefore(SPAN + this.name + Integer.toString(0), currentNameSpan.getEnd(), false);
        for (int spanNumber = 1; spanNumber < this.nameSpanMap.getSpansNumber(); ++spanNumber) {
            currentNameSpan = this.nameSpanMap.getSpan(currentNameSpan.getEnd());
            this.nameSpanMap.addValidAfter(SPAN + this.name + Integer.toString(spanNumber), currentNameSpan.getStart(), false);
        }
    }

    public double getReferenceValue() {
        return this.referenceValue;
    }

    public void setReferenceValue(double referenceValue) {
        double previousReferenceValue = this.referenceValue;
        this.referenceValue = referenceValue;
        for (ParameterObserver observer : this.observers) {
            observer.referenceValueChanged(previousReferenceValue, this);
        }
    }

    public double getMinValue() {
        return this.minValue;
    }

    public void setMinValue(double minValue) {
        double previousMinValue = this.minValue;
        this.minValue = minValue;
        for (ParameterObserver observer : this.observers) {
            observer.minValueChanged(previousMinValue, this);
        }
        for (TimeSpanMap.Span<Double> span = this.valueSpanMap.getFirstSpan(); span != null; span = span.next()) {
            this.setValue(this.getValue(span.getStart()), span.getStart());
        }
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(double maxValue) {
        double previousMaxValue = this.maxValue;
        this.maxValue = maxValue;
        for (ParameterObserver observer : this.observers) {
            observer.maxValueChanged(previousMaxValue, this);
        }
        for (TimeSpanMap.Span<Double> span = this.valueSpanMap.getFirstSpan(); span != null; span = span.next()) {
            this.setValue(this.getValue(span.getStart()), span.getStart());
        }
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) {
        double previousScale = this.scale;
        this.scale = scale;
        for (ParameterObserver observer : this.observers) {
            observer.scaleChanged(previousScale, this);
        }
    }

    public double getNormalizedValue(AbsoluteDate date) {
        return (this.getValue(date) - this.getReferenceValue()) / this.scale;
    }

    public double getNormalizedValue() {
        return (this.getValue() - this.getReferenceValue()) / this.scale;
    }

    public void setNormalizedValue(double normalized, AbsoluteDate date) {
        this.setValue(this.getReferenceValue() + this.scale * normalized, date);
    }

    public void setNormalizedValue(double normalized) {
        this.setValue(this.getReferenceValue() + this.scale * normalized);
    }

    public AbsoluteDate getReferenceDate() {
        return this.referenceDate;
    }

    public void setReferenceDate(AbsoluteDate newReferenceDate) {
        AbsoluteDate previousReferenceDate = this.getReferenceDate();
        this.referenceDate = newReferenceDate;
        for (ParameterObserver observer : this.observers) {
            observer.referenceDateChanged(previousReferenceDate, this);
        }
    }

    public double getValue() {
        if (this.getNbOfValues() > 1) {
            throw new OrekitIllegalStateException(OrekitMessages.PARAMETER_WITH_SEVERAL_ESTIMATED_VALUES, this.name, "getValue(date)");
        }
        return this.valueSpanMap.getFirstSpan().getData();
    }

    public double getValue(AbsoluteDate date) {
        return this.isEstimationContinuous ? this.getValueContinuousEstimation(date) : this.getValueStepEstimation(date);
    }

    public double getValueStepEstimation(AbsoluteDate date) {
        return this.getNbOfValues() == 1 ? this.valueSpanMap.getFirstSpan().getData() : this.valueSpanMap.get(date);
    }

    public double getValueContinuousEstimation(AbsoluteDate date) {
        throw new UnsupportedOperationException();
    }

    public Gradient getValue(int freeParameters, Map<String, Integer> indices) {
        Integer index = null;
        for (TimeSpanMap.Span<String> span = this.nameSpanMap.getFirstSpan(); span != null && (index = indices.get(span.getData())) == null; span = span.next()) {
        }
        return index == null ? Gradient.constant((int)freeParameters, (double)this.getValue()) : Gradient.variable((int)freeParameters, (int)index, (double)this.getValue());
    }

    public Gradient getValue(int freeParameters, Map<String, Integer> indices, AbsoluteDate date) {
        Integer index = null;
        for (TimeSpanMap.Span<String> span = this.nameSpanMap.getFirstSpan(); span != null && (index = indices.get(span.getData())) == null; span = span.next()) {
        }
        return index == null ? Gradient.constant((int)freeParameters, (double)this.getValue(date)) : Gradient.variable((int)freeParameters, (int)index, (double)this.getValue(date));
    }

    public void setValue(double newValue, AbsoluteDate date) {
        double previousValue = Double.NaN;
        AbsoluteDate referenceDateSpan = AbsoluteDate.ARBITRARY_EPOCH;
        if (this.getNbOfValues() == 1) {
            previousValue = this.getValue(referenceDateSpan);
            this.valueSpanMap = new TimeSpanMap<Double>(FastMath.max((double)this.minValue, (double)FastMath.min((double)this.maxValue, (double)newValue)));
        } else {
            TimeSpanMap.Span<Double> valueSpan = this.valueSpanMap.getSpan(date);
            previousValue = valueSpan.getData();
            referenceDateSpan = valueSpan.getStart();
            if (referenceDateSpan.equals(AbsoluteDate.PAST_INFINITY)) {
                referenceDateSpan = valueSpan.getEnd();
                this.valueSpanMap.addValidBefore(FastMath.max((double)this.minValue, (double)FastMath.min((double)this.maxValue, (double)newValue)), referenceDateSpan, false);
            } else {
                this.valueSpanMap.addValidAfter(FastMath.max((double)this.minValue, (double)FastMath.min((double)this.maxValue, (double)newValue)), referenceDateSpan, false);
            }
        }
        for (ParameterObserver observer : this.observers) {
            observer.valueChanged(previousValue, this, date);
        }
    }

    public void setValue(double newValue) {
        if (this.getNbOfValues() == 1) {
            AbsoluteDate referenceDateSpan = AbsoluteDate.ARBITRARY_EPOCH;
            double previousValue = this.getValue(referenceDateSpan);
            this.valueSpanMap = new TimeSpanMap<Double>(FastMath.max((double)this.minValue, (double)FastMath.min((double)this.maxValue, (double)newValue)));
            for (ParameterObserver observer : this.observers) {
                observer.valueChanged(previousValue, this, referenceDateSpan);
            }
        } else {
            throw new OrekitIllegalStateException(OrekitMessages.PARAMETER_WITH_SEVERAL_ESTIMATED_VALUES, this.name, "setValue(date)");
        }
    }

    public void setSelected(boolean selected) {
        boolean previousSelection = this.isSelected();
        this.selected = selected;
        for (ParameterObserver observer : this.observers) {
            observer.selectionChanged(previousSelection, this);
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setContinuousEstimation(boolean continuous) {
        boolean previousEstimation = this.isContinuousEstimation();
        this.isEstimationContinuous = continuous;
        for (ParameterObserver observer : this.observers) {
            observer.estimationTypeChanged(previousEstimation, this);
        }
    }

    public boolean isContinuousEstimation() {
        return this.isEstimationContinuous;
    }

    public String toString() {
        return this.name + " = " + this.valueSpanMap.get(AbsoluteDate.ARBITRARY_EPOCH);
    }
}

