/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.utils;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.bodies.OneAxisEllipsoid;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.utils.ExtendedPVCoordinatesProvider;

public class OccultationEngine {
    private final OneAxisEllipsoid occulting;
    private final ExtendedPVCoordinatesProvider occulted;
    private final double occultedRadius;

    public OccultationEngine(ExtendedPVCoordinatesProvider occulted, double occultedRadius, OneAxisEllipsoid occulting) {
        this.occulted = occulted;
        this.occultedRadius = FastMath.abs((double)occultedRadius);
        this.occulting = occulting;
    }

    public OneAxisEllipsoid getOcculting() {
        return this.occulting;
    }

    public ExtendedPVCoordinatesProvider getOcculted() {
        return this.occulted;
    }

    public double getOccultedRadius() {
        return this.occultedRadius;
    }

    public OccultationAngles angles(SpacecraftState state) {
        Vector3D psat = state.getPosition(this.occulting.getBodyFrame());
        Vector3D pted = this.occulted.getPosition(state.getDate(), this.occulting.getBodyFrame());
        Vector3D plimb = this.occulting.pointOnLimb(psat, pted);
        Vector3D ps = psat.subtract((Vector)pted);
        Vector3D pi = psat.subtract((Vector)plimb);
        double angle = Vector3D.angle((Vector3D)ps, (Vector3D)psat);
        double rs = FastMath.asin((double)(this.occultedRadius / ps.getNorm()));
        double ro = Vector3D.angle((Vector3D)pi, (Vector3D)psat);
        if (Double.isNaN(rs)) {
            return new OccultationAngles(Math.PI, 0.0, 0.0);
        }
        return new OccultationAngles(angle, ro, rs);
    }

    public <T extends CalculusFieldElement<T>> FieldOccultationAngles<T> angles(FieldSpacecraftState<T> state) {
        FieldVector3D<T> psat = state.getPosition(this.occulting.getBodyFrame());
        FieldVector3D<T> pted = this.occulted.getPosition(state.getDate(), this.occulting.getBodyFrame());
        FieldVector3D<T> plimb = this.occulting.pointOnLimb(psat, pted);
        FieldVector3D ps = psat.subtract(pted);
        FieldVector3D pi = psat.subtract(plimb);
        CalculusFieldElement angle = FieldVector3D.angle((FieldVector3D)ps, psat);
        CalculusFieldElement rs = FastMath.asin((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)ps.getNorm().reciprocal()).multiply(this.occultedRadius)));
        CalculusFieldElement ro = FieldVector3D.angle((FieldVector3D)pi, psat);
        if (rs.isNaN()) {
            CalculusFieldElement zero = (CalculusFieldElement)rs.getField().getZero();
            return new FieldOccultationAngles<CalculusFieldElement>((CalculusFieldElement)zero.newInstance(Math.PI), zero, zero);
        }
        return new FieldOccultationAngles<CalculusFieldElement>(angle, ro, rs);
    }

    public static class FieldOccultationAngles<T extends CalculusFieldElement<T>> {
        private final T separation;
        private final T limbRadius;
        private final T occultedApparentRadius;

        FieldOccultationAngles(T separation, T limbRadius, T occultedApparentRadius) {
            this.separation = separation;
            this.limbRadius = limbRadius;
            this.occultedApparentRadius = occultedApparentRadius;
        }

        public T getSeparation() {
            return this.separation;
        }

        public T getLimbRadius() {
            return this.limbRadius;
        }

        public T getOccultedApparentRadius() {
            return this.occultedApparentRadius;
        }
    }

    public static class OccultationAngles {
        private final double separation;
        private final double limbRadius;
        private final double occultedApparentRadius;

        OccultationAngles(double separation, double limbRadius, double occultedApparentRadius) {
            this.separation = separation;
            this.limbRadius = limbRadius;
            this.occultedApparentRadius = occultedApparentRadius;
        }

        public double getSeparation() {
            return this.separation;
        }

        public double getLimbRadius() {
            return this.limbRadius;
        }

        public double getOccultedApparentRadius() {
            return this.occultedApparentRadius;
        }
    }
}

