/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.utils;

import java.util.List;
import java.util.Map;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.numerical.EpochDerivativesEquations;
import org.orekit.propagation.numerical.NumericalPropagator;
import org.orekit.utils.AbstractMultipleShooting;

public class MultipleShooter
extends AbstractMultipleShooting {
    private static final String DERIVATIVES = "derivatives";
    private final List<EpochDerivativesEquations> epochEquations;

    public MultipleShooter(List<SpacecraftState> initialGuessList, List<NumericalPropagator> propagatorList, List<EpochDerivativesEquations> epochEquations, double tolerance, int maxIter) {
        super(initialGuessList, propagatorList, tolerance, maxIter, false, DERIVATIVES);
        this.epochEquations = epochEquations;
    }

    @Override
    protected SpacecraftState getAugmentedInitialState(int i) {
        return this.epochEquations.get(i).setInitialJacobians(this.getPatchPoint(i));
    }

    @Override
    protected double[][] computeAdditionalJacobianMatrix(List<SpacecraftState> propagatedSP) {
        Map<Integer, Double> mapConstraints = this.getConstraintsMap();
        double[][] M = new double[mapConstraints.size()][this.getNumberOfFreeComponents()];
        int k = 0;
        for (int index : mapConstraints.keySet()) {
            M[k][index] = 1.0;
            ++k;
        }
        return M;
    }

    @Override
    protected double[] computeAdditionalConstraints(List<SpacecraftState> propagatedSP) {
        double[] fxAdditional = new double[this.getConstraintsMap().size()];
        this.updateAdditionalConstraints(0, fxAdditional);
        return fxAdditional;
    }
}

