/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.errors.OrekitIllegalStateException;
import org.orekit.errors.OrekitMessages;
import org.orekit.errors.TimeStampedCacheException;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.ChronologicalComparator;
import org.orekit.time.TimeStamped;
import org.orekit.utils.SortedListTrimmer;
import org.orekit.utils.TimeStampedCache;

public class ImmutableTimeStampedCache<T extends TimeStamped>
implements TimeStampedCache<T> {
    private static final ImmutableTimeStampedCache EMPTY_CACHE = new EmptyTimeStampedCache();
    private final List<T> data;
    private final int maxNeighborsSize;

    public ImmutableTimeStampedCache(int maxNeighborsSize, Collection<? extends T> data) {
        if (maxNeighborsSize > data.size()) {
            throw new OrekitIllegalArgumentException(OrekitMessages.NOT_ENOUGH_CACHED_NEIGHBORS, data.size(), maxNeighborsSize);
        }
        if (maxNeighborsSize < 1) {
            throw new OrekitIllegalArgumentException((Localizable)LocalizedCoreFormats.NUMBER_TOO_SMALL, maxNeighborsSize, 1);
        }
        this.maxNeighborsSize = maxNeighborsSize;
        this.data = new ArrayList<T>(data);
        this.data.sort(new ChronologicalComparator());
    }

    private ImmutableTimeStampedCache() {
        this.data = null;
        this.maxNeighborsSize = 0;
    }

    @Override
    public Stream<T> getNeighbors(AbsoluteDate central, int n) {
        if (n > this.maxNeighborsSize) {
            throw new OrekitException((Localizable)OrekitMessages.NOT_ENOUGH_DATA, this.maxNeighborsSize);
        }
        return new SortedListTrimmer(n).getNeighborsSubList(central, this.data).stream();
    }

    @Override
    public int getMaxNeighborsSize() {
        return this.maxNeighborsSize;
    }

    @Override
    public T getEarliest() {
        return (T)((TimeStamped)this.data.get(0));
    }

    @Override
    public T getLatest() {
        return (T)((TimeStamped)this.data.get(this.data.size() - 1));
    }

    public List<T> getAll() {
        return Collections.unmodifiableList(this.data);
    }

    public String toString() {
        return "Immutable cache with " + this.data.size() + " entries";
    }

    public static <TS extends TimeStamped> ImmutableTimeStampedCache<TS> emptyCache() {
        return EMPTY_CACHE;
    }

    private static class EmptyTimeStampedCache<T extends TimeStamped>
    extends ImmutableTimeStampedCache<T> {
        private EmptyTimeStampedCache() {
        }

        @Override
        public Stream<T> getNeighbors(AbsoluteDate central) {
            throw new TimeStampedCacheException((Localizable)OrekitMessages.NO_CACHED_ENTRIES, new Object[0]);
        }

        @Override
        public int getMaxNeighborsSize() {
            return 0;
        }

        @Override
        public T getEarliest() {
            throw new OrekitIllegalStateException(OrekitMessages.NO_CACHED_ENTRIES, new Object[0]);
        }

        @Override
        public T getLatest() {
            throw new OrekitIllegalStateException(OrekitMessages.NO_CACHED_ENTRIES, new Object[0]);
        }

        @Override
        public List<T> getAll() {
            return Collections.emptyList();
        }

        @Override
        public String toString() {
            return "Empty immutable cache";
        }
    }
}

