/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.errors.OrekitIllegalStateException;
import org.orekit.errors.OrekitMessages;
import org.orekit.errors.TimeStampedCacheException;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.FieldChronologicalComparator;
import org.orekit.time.FieldTimeStamped;
import org.orekit.utils.FieldSortedListTrimmer;
import org.orekit.utils.FieldTimeStampedCache;

public class ImmutableFieldTimeStampedCache<T extends FieldTimeStamped<KK>, KK extends CalculusFieldElement<KK>>
implements FieldTimeStampedCache<T, KK> {
    private static final ImmutableFieldTimeStampedCache EMPTY_CACHE = new EmptyFieldTimeStampedCache();
    private final List<T> data;
    private final int maxNeighborsSize;

    public ImmutableFieldTimeStampedCache(int maxNeighborsSize, Collection<? extends T> data) {
        if (maxNeighborsSize > data.size()) {
            throw new OrekitIllegalArgumentException(OrekitMessages.NOT_ENOUGH_CACHED_NEIGHBORS, data.size(), maxNeighborsSize);
        }
        if (maxNeighborsSize < 1) {
            throw new OrekitIllegalArgumentException((Localizable)LocalizedCoreFormats.NUMBER_TOO_SMALL, maxNeighborsSize, 1);
        }
        this.maxNeighborsSize = maxNeighborsSize;
        this.data = new ArrayList<T>(data);
        this.data.sort(new FieldChronologicalComparator());
    }

    private ImmutableFieldTimeStampedCache() {
        this.data = null;
        this.maxNeighborsSize = 0;
    }

    @Deprecated
    public static <TS extends FieldTimeStamped<CFE>, CFE extends CalculusFieldElement<CFE>> ImmutableFieldTimeStampedCache<TS, CFE> emptyCache(Field<CFE> ignored) {
        return ImmutableFieldTimeStampedCache.emptyCache();
    }

    public static <TS extends FieldTimeStamped<CFE>, CFE extends CalculusFieldElement<CFE>> ImmutableFieldTimeStampedCache<TS, CFE> emptyCache() {
        return EMPTY_CACHE;
    }

    @Override
    public Stream<T> getNeighbors(FieldAbsoluteDate<KK> central, int n) {
        if (n > this.maxNeighborsSize) {
            throw new OrekitException((Localizable)OrekitMessages.NOT_ENOUGH_DATA, this.maxNeighborsSize);
        }
        return new FieldSortedListTrimmer(n).getNeighborsSubList(central, this.data).stream();
    }

    @Override
    public int getMaxNeighborsSize() {
        return this.maxNeighborsSize;
    }

    @Override
    public T getEarliest() {
        return (T)((FieldTimeStamped)this.data.get(0));
    }

    @Override
    public T getLatest() {
        return (T)((FieldTimeStamped)this.data.get(this.data.size() - 1));
    }

    public List<T> getAll() {
        return Collections.unmodifiableList(this.data);
    }

    public String toString() {
        return "Immutable cache with " + this.data.size() + " entries";
    }

    private static class EmptyFieldTimeStampedCache<T extends FieldTimeStamped<KK>, KK extends CalculusFieldElement<KK>>
    extends ImmutableFieldTimeStampedCache<T, KK> {
        private EmptyFieldTimeStampedCache() {
        }

        @Override
        public Stream<T> getNeighbors(FieldAbsoluteDate<KK> central) {
            throw new TimeStampedCacheException((Localizable)OrekitMessages.NO_CACHED_ENTRIES, new Object[0]);
        }

        @Override
        public int getMaxNeighborsSize() {
            return 0;
        }

        @Override
        public T getEarliest() {
            throw new OrekitIllegalStateException(OrekitMessages.NO_CACHED_ENTRIES, new Object[0]);
        }

        @Override
        public T getLatest() {
            throw new OrekitIllegalStateException(OrekitMessages.NO_CACHED_ENTRIES, new Object[0]);
        }

        @Override
        public List<T> getAll() {
            return Collections.emptyList();
        }

        @Override
        public String toString() {
            return "Empty immutable cache";
        }
    }
}

