/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.utils;

import org.hipparchus.CalculusFieldElement;
import org.orekit.frames.Frame;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.ExtendedPVCoordinatesProvider;
import org.orekit.utils.PVCoordinates;
import org.orekit.utils.TimeStampedFieldPVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public class FrameAdapter
implements ExtendedPVCoordinatesProvider {
    private final Frame originFrame;

    public FrameAdapter(Frame originFrame) {
        this.originFrame = originFrame;
    }

    @Override
    public TimeStampedPVCoordinates getPVCoordinates(AbsoluteDate date, Frame frame) {
        return new TimeStampedPVCoordinates(date, this.originFrame.getTransformTo(frame, date).transformPVCoordinates(PVCoordinates.ZERO));
    }

    @Override
    public <T extends CalculusFieldElement<T>> TimeStampedFieldPVCoordinates<T> getPVCoordinates(FieldAbsoluteDate<T> date, Frame frame) {
        return new TimeStampedFieldPVCoordinates<T>(date, this.originFrame.getTransformTo(frame, date).transformPVCoordinates(PVCoordinates.ZERO));
    }
}

