/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.utils;

import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.FieldElement;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.util.FastMath;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.errors.OrekitMessages;
import org.orekit.errors.TimeStampedCacheException;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.FieldTimeStamped;

public class FieldSortedListTrimmer {
    private final int neighborsSize;

    public FieldSortedListTrimmer(int neighborsSize) {
        if (neighborsSize < 1) {
            throw new OrekitIllegalArgumentException((Localizable)LocalizedCoreFormats.NUMBER_TOO_SMALL, neighborsSize, 1);
        }
        this.neighborsSize = neighborsSize;
    }

    public int getNeighborsSize() {
        return this.neighborsSize;
    }

    public <T extends FieldTimeStamped<K>, K extends CalculusFieldElement<K>> List<T> getNeighborsSubList(FieldAbsoluteDate<K> central, List<T> data) {
        if (this.neighborsSize > data.size()) {
            throw new OrekitException((Localizable)OrekitMessages.NOT_ENOUGH_DATA, data.size());
        }
        int i = this.findIndex(central, data);
        if (i < 0) {
            FieldAbsoluteDate<K> earliest = ((FieldTimeStamped)data.get(0)).getDate();
            throw new TimeStampedCacheException((Localizable)OrekitMessages.UNABLE_TO_GENERATE_NEW_DATA_BEFORE, earliest, central, earliest.durationFrom(central).getReal());
        }
        if (i >= data.size()) {
            FieldAbsoluteDate latest = ((FieldTimeStamped)data.get(data.size() - 1)).getDate();
            throw new TimeStampedCacheException((Localizable)OrekitMessages.UNABLE_TO_GENERATE_NEW_DATA_AFTER, latest, central, central.durationFrom(latest).getReal());
        }
        int start = FastMath.max((int)0, (int)(i - (this.neighborsSize - 1) / 2));
        int end = FastMath.min((int)data.size(), (int)(start + this.neighborsSize));
        start = end - this.neighborsSize;
        return data.subList(start, end);
    }

    private <T extends FieldTimeStamped<K>, K extends CalculusFieldElement<K>> int findIndex(FieldAbsoluteDate<K> t, List<T> data) {
        int iInf = 0;
        Object dtInf = t.durationFrom((FieldTimeStamped)data.get(0));
        if (dtInf.getReal() < 0.0) {
            return -1;
        }
        int iSup = data.size() - 1;
        Object dtSup = t.durationFrom((FieldTimeStamped)data.get(data.size() - 1));
        if (dtSup.getReal() > 0.0) {
            return data.size();
        }
        while (iSup - iInf > 1) {
            int iInterp = (int)FastMath.rint((double)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)dtSup.multiply(iInf)).subtract((FieldElement)((CalculusFieldElement)dtInf.multiply(iSup)))).divide((FieldElement)((CalculusFieldElement)dtSup.subtract(dtInf)))).getReal());
            int iMed = FastMath.max((int)(iInf + 1), (int)FastMath.min((int)iInterp, (int)(iSup - 1)));
            K dtMed = t.durationFrom(((FieldTimeStamped)data.get(iMed)).getDate());
            if (dtMed.getReal() < 0.0) {
                iSup = iMed;
                dtSup = dtMed;
                continue;
            }
            iInf = iMed;
            dtInf = dtMed;
        }
        if (dtSup.getReal() == 0.0) {
            return iSup;
        }
        return iInf;
    }
}

