/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.utils;

import org.hipparchus.CalculusFieldElement;
import org.orekit.frames.Frame;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.FieldPVCoordinatesProvider;
import org.orekit.utils.TimeStampedFieldPVCoordinates;

public class FieldShiftingPVCoordinatesProvider<T extends CalculusFieldElement<T>>
implements FieldPVCoordinatesProvider<T> {
    private final TimeStampedFieldPVCoordinates<T> referencePV;
    private final Frame referenceFrame;

    public FieldShiftingPVCoordinatesProvider(TimeStampedFieldPVCoordinates<T> referencePV, Frame referenceFrame) {
        this.referencePV = referencePV;
        this.referenceFrame = referenceFrame;
    }

    @Override
    public TimeStampedFieldPVCoordinates<T> getPVCoordinates(FieldAbsoluteDate<T> date, Frame frame) {
        FieldPVCoordinates shifted = this.referencePV.shiftedBy((CalculusFieldElement)date.durationFrom(this.referencePV));
        return this.referenceFrame.getTransformTo(frame, date).transformPVCoordinates((TimeStampedFieldPVCoordinates<T>)shifted);
    }
}

