/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.utils;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.util.CombinatoricsUtils;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;

public class FieldLegendrePolynomials<T extends CalculusFieldElement<T>> {
    private T[][] pCoef;

    public FieldLegendrePolynomials(int degree, int order, T t) {
        Field field = t.getField();
        this.pCoef = (CalculusFieldElement[][])MathArrays.buildArray((Field)field, (int)(degree + 1), (int)(order + 1));
        CalculusFieldElement t2 = (CalculusFieldElement)t.square();
        for (int n = 0; n <= degree; ++n) {
            for (int m = 0; m <= FastMath.min((int)n, (int)order); ++m) {
                int r = (n - m) / 2;
                CalculusFieldElement sum = (CalculusFieldElement)field.getZero();
                for (int k = 0; k <= r; ++k) {
                    CalculusFieldElement term = (CalculusFieldElement)FastMath.pow(t, (int)(n - m - 2 * k)).multiply(FastMath.pow((double)-1.0, (int)k) * CombinatoricsUtils.factorialDouble((int)(2 * n - 2 * k)) / (CombinatoricsUtils.factorialDouble((int)k) * CombinatoricsUtils.factorialDouble((int)(n - k)) * CombinatoricsUtils.factorialDouble((int)(n - m - 2 * k))));
                    sum = (CalculusFieldElement)sum.add((FieldElement)term);
                }
                this.pCoef[n][m] = (CalculusFieldElement)((CalculusFieldElement)FastMath.pow((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)t2.negate()).add(1.0)), (double)(0.5 * (double)m)).multiply(FastMath.pow((double)2.0, (int)(-n)))).multiply((FieldElement)sum);
            }
        }
    }

    public T getPnm(int n, int m) {
        return this.pCoef[n][m];
    }
}

