/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.util.MathArrays;

public class FieldArrayDictionary<T extends CalculusFieldElement<T>> {
    private static final int DEFAULT_INITIAL_CAPACITY = 4;
    private final Field<T> field;
    private final List<Entry> data;

    public FieldArrayDictionary(Field<T> field) {
        this(field, 4);
    }

    public FieldArrayDictionary(Field<T> field, int initialCapacity) {
        this.field = field;
        this.data = new ArrayList<Entry>(initialCapacity);
    }

    public FieldArrayDictionary(FieldArrayDictionary<T> dictionary) {
        this(dictionary.getField(), 4 + dictionary.getData().size());
        for (Entry entry : dictionary.getData()) {
            this.data.add(new Entry(this, entry.getKey(), entry.getValue()));
        }
    }

    public FieldArrayDictionary(Field<T> field, Map<String, T[]> map) {
        this(field, map.size());
        for (Map.Entry<String, T[]> entry : map.entrySet()) {
            this.data.add(new Entry(this, entry.getKey(), (CalculusFieldElement[])entry.getValue()));
        }
    }

    public Field<T> getField() {
        return this.field;
    }

    public List<Entry> getData() {
        return Collections.unmodifiableList(this.data);
    }

    public int size() {
        return this.data.size();
    }

    public Map<String, T[]> toMap() {
        HashMap<String, T[]> map = new HashMap<String, T[]>(this.data.size());
        for (Entry entry : this.data) {
            map.put(entry.getKey(), entry.getValue());
        }
        return map;
    }

    public void clear() {
        this.data.clear();
    }

    public void put(String key, T[] value) {
        this.remove(key);
        this.data.add(new Entry(this, key, value));
    }

    public void put(String key, double[] value) {
        CalculusFieldElement[] converted = (CalculusFieldElement[])MathArrays.buildArray(this.field, (int)value.length);
        for (int i = 0; i < value.length; ++i) {
            converted[i] = (CalculusFieldElement)((CalculusFieldElement)this.field.getZero()).newInstance(value[i]);
        }
        this.put(key, converted);
    }

    public void putAll(Map<String, T[]> map) {
        for (Map.Entry<String, T[]> entry : map.entrySet()) {
            this.put(entry.getKey(), (CalculusFieldElement[])entry.getValue());
        }
    }

    public void putAll(FieldArrayDictionary<T> dictionary) {
        for (Entry entry : dictionary.data) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public T[] get(String key) {
        Entry entry = this.getEntry(key);
        return entry == null ? null : entry.getValue();
    }

    public Entry getEntry(String key) {
        for (Entry entry : this.data) {
            if (!entry.getKey().equals(key)) continue;
            return entry;
        }
        return null;
    }

    public boolean remove(String key) {
        Iterator<Entry> iterator = this.data.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().getKey().equals(key)) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    public FieldArrayDictionary<T> unmodifiableView() {
        return new View(this.field);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append('{');
        for (int i = 0; i < this.data.size(); ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(this.data.get(i).getKey());
            builder.append('[');
            builder.append(this.data.get(i).getValue().length);
            builder.append(']');
        }
        builder.append('}');
        return builder.toString();
    }

    private class View
    extends FieldArrayDictionary<T> {
        View(Field<T> field) {
            super(field);
        }

        @Override
        public List<Entry> getData() {
            return FieldArrayDictionary.this.getData();
        }

        @Override
        public int size() {
            return FieldArrayDictionary.this.size();
        }

        @Override
        public Map<String, T[]> toMap() {
            return FieldArrayDictionary.this.toMap();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void put(String key, T[] value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void put(String key, double[] value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(Map<String, T[]> map) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(FieldArrayDictionary<T> dictionary) {
            throw new UnsupportedOperationException();
        }

        @Override
        public T[] get(String key) {
            return FieldArrayDictionary.this.get(key);
        }

        @Override
        public Entry getEntry(String key) {
            return FieldArrayDictionary.this.getEntry(key);
        }

        @Override
        public boolean remove(String key) {
            throw new UnsupportedOperationException();
        }
    }

    public static class Entry {
        private final String key;
        private final T[] value;
        final /* synthetic */ FieldArrayDictionary this$0;

        Entry(String key, T[] value) {
            this.this$0 = this$0;
            this.key = key;
            this.value = (CalculusFieldElement[])value.clone();
        }

        public String getKey() {
            return this.key;
        }

        public T[] getValue() {
            return (CalculusFieldElement[])this.value.clone();
        }

        public int size() {
            return this.value.length;
        }

        public void increment(T[] increment) {
            for (int i = 0; i < increment.length; ++i) {
                this.value[i] = (CalculusFieldElement)this.value[i].add(increment[i]);
            }
        }

        public void increment(double[] increment) {
            for (int i = 0; i < increment.length; ++i) {
                this.value[i] = (CalculusFieldElement)this.value[i].add(increment[i]);
            }
        }

        public void scaledIncrement(T factor, Entry raw) {
            for (int i = 0; i < raw.value.length; ++i) {
                this.value[i] = (CalculusFieldElement)this.value[i].add((FieldElement)((CalculusFieldElement)raw.value[i].multiply(factor)));
            }
        }

        public void scaledIncrement(double factor, Entry raw) {
            for (int i = 0; i < raw.value.length; ++i) {
                this.value[i] = (CalculusFieldElement)this.value[i].add((FieldElement)((CalculusFieldElement)raw.value[i].multiply(factor)));
            }
        }

        public void zero() {
            Arrays.fill(this.value, this.this$0.field.getZero());
        }
    }
}

